/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.print.renderer;

import com.google.common.net.MediaType;
import com.googlecode.htmlcompressor.compressor.HtmlCompressor;
import java.awt.Color;
import java.awt.Font;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.apache.ecs.ConcreteElement;
import org.apache.ecs.Element;
import org.apache.ecs.MultiPartElement;
import org.apache.ecs.XhtmlDocument;
import org.apache.ecs.xhtml.a;
import org.apache.ecs.xhtml.script;
import org.apache.ecs.xhtml.span;
import org.apache.ecs.xhtml.style;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.tbody;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.th;
import org.apache.ecs.xhtml.thead;
import org.apache.ecs.xhtml.tr;
import org.compiere.model.MColumn;
import org.compiere.model.MQuery;
import org.compiere.model.MRole;
import org.compiere.model.MStyle;
import org.compiere.model.MStyleLine;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.print.IHTMLExtension;
import org.compiere.print.MPrintColor;
import org.compiere.print.MPrintFont;
import org.compiere.print.MPrintFormat;
import org.compiere.print.MPrintFormatItem;
import org.compiere.print.MPrintTableFormat;
import org.compiere.print.PrintData;
import org.compiere.print.PrintDataElement;
import org.compiere.print.ReportEngine;
import org.compiere.print.layout.InstanceAttributeColumn;
import org.compiere.print.layout.InstanceAttributeData;
import org.compiere.print.layout.LayoutEngine;
import org.compiere.print.layout.PrintDataEvaluatee;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Evaluator;
import org.compiere.util.Ini;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.idempiere.print.renderer.HTMLReportRendererConfiguration;
import org.idempiere.print.renderer.IReportRenderer;
import org.osgi.service.component.annotations.Component;

@Component(service={IReportRenderer.class}, immediate=true)
public class HTMLReportRenderer
implements IReportRenderer<HTMLReportRendererConfiguration> {
    private static final CLogger log = CLogger.getCLogger(HTMLReportRenderer.class);

    @Override
    public String getId() {
        return "HTML";
    }

    @Override
    public String getName() {
        return Msg.getMsg(Env.getCtx(), "FileHTML");
    }

    @Override
    public String getContentType() {
        return MediaType.HTML_UTF_8.toString();
    }

    @Override
    public String getFileExtension() {
        return "html";
    }

    @Override
    public void renderReport(ReportEngine reportEngine, HTMLReportRendererConfiguration configuration) {
        try {
            Language lang = configuration.getLanguage();
            if (lang == null) {
                lang = Language.getLoginLanguage();
            }
            Writer fw = null;
            fw = configuration.getOutputFile() != null ? new OutputStreamWriter((OutputStream)new FileOutputStream(configuration.getOutputFile(), false), Ini.getCharset()) : configuration.getOutputWriter();
            this.createHTML(reportEngine, new BufferedWriter(fw), configuration.isOnlyTable(), lang, configuration.getExtension(), configuration.isExport());
        }
        catch (FileNotFoundException fnfe) {
            log.log(Level.SEVERE, "(f) - " + fnfe.toString());
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "(f)", e);
            throw new AdempiereException(e);
        }
    }

    @Override
    public boolean isBinary() {
        return false;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createHTML(ReportEngine reportEngine, Writer writer, boolean onlyTable, Language language, IHTMLExtension extension, boolean isExport) {
        MPrintFormat printFormat = reportEngine.getPrintFormat();
        PrintData printData = reportEngine.getPrintData();
        MQuery reportEngineQuery = reportEngine.getQuery();
        LayoutEngine layout = reportEngine.getLayout();
        HashMap<CSSInfo, List<ColumnInfo>> mapCssInfo = new HashMap<CSSInfo, List<ColumnInfo>>();
        try {
            td td2;
            String cssPrefix;
            ArrayList<Object> columns = new ArrayList<Object>();
            ArrayList<Object> asiElements = new ArrayList<Object>();
            int columnCount = 0;
            int col = 0;
            while (col < printFormat.getItemCount()) {
                MPrintFormatItem mPrintFormatItem = printFormat.getItem(col);
                if (mPrintFormatItem.isPrinted()) {
                    if (mPrintFormatItem.isTypeField() && mPrintFormatItem.isPrintInstanceAttributes()) {
                        InstanceAttributeData asiElement = new InstanceAttributeData(mPrintFormatItem, columnCount);
                        asiElement.readAttributesData(printData);
                        asiElements.add(asiElement);
                    } else {
                        columns.add(mPrintFormatItem);
                        ++columnCount;
                    }
                }
                ++col;
            }
            if (asiElements.size() > 0) {
                int columnCreated = 0;
                for (InstanceAttributeData instanceAttributeData : asiElements) {
                    List<InstanceAttributeColumn> instanceColumns = instanceAttributeData.getColumns();
                    int index = instanceAttributeData.getColumnIndex() + columnCreated;
                    for (InstanceAttributeColumn c : instanceColumns) {
                        columns.add(index, c);
                        ++index;
                        ++columnCreated;
                    }
                }
            }
            String string = cssPrefix = extension != null ? extension.getClassPrefix() : null;
            if (cssPrefix != null && cssPrefix.trim().length() == 0) {
                cssPrefix = null;
            }
            Object var16_21 = null;
            if (!printFormat.isForm() && reportEngineQuery != null && reportEngineQuery.isActive()) {
                int rows;
                int n = rows = reportEngineQuery.getReportProcessQuery() != null ? reportEngineQuery.getReportProcessQuery().getRestrictionCount() : reportEngineQuery.getRestrictionCount();
                if (rows > 0) {
                    table table2 = new table();
                    if (cssPrefix != null) {
                        table2.setClass(cssPrefix + "-parameter-table");
                    } else {
                        table2.setClass("parameter-table");
                    }
                    table2.setNeedClosingTag(false);
                }
            }
            table table3 = new table();
            if (cssPrefix != null) {
                table3.setClass(cssPrefix + "-table");
            }
            table3.setNeedClosingTag(false);
            PrintWriter w = new PrintWriter(writer);
            XhtmlDocument doc = null;
            boolean minify = MSysConfig.getBooleanValue("HTML_REPORT_MINIFY", true, Env.getAD_Client_ID(Env.getCtx()));
            if (onlyTable) {
                w.print(HTMLReportRenderer.compress(table3.toString(), minify));
            } else {
                doc = new XhtmlDocument();
                doc.getHtml().setNeedClosingTag(false);
                doc.getBody().setNeedClosingTag(false);
                doc.appendHead("<meta charset=\"UTF-8\" />");
                if (extension != null && !Util.isEmpty(extension.getWebFontLinks(), true)) {
                    doc.appendHead(extension.getWebFontLinks());
                }
                if (extension != null && extension.getStyleURL() != null) {
                    String pathStyleFile = extension.getFullPathStyle();
                    Path path = Paths.get(pathStyleFile, new String[0]);
                    List<String> styleLines = Files.readAllLines(path, Ini.getCharset());
                    Files.delete(path);
                    StringBuilder styleBuild = new StringBuilder();
                    for (String styleLine : styleLines) {
                        styleBuild.append(styleLine);
                    }
                    HTMLReportRenderer.appendInlineCss(doc, styleBuild);
                }
                if (extension != null && extension.getScriptURL() != null && !isExport) {
                    script jslink = new script();
                    jslink.setLanguage("javascript");
                    jslink.setSrc(extension.getScriptURL());
                    doc.appendHead((Element)jslink);
                }
                if (extension != null && !isExport) {
                    extension.setWebAttribute(doc.getBody());
                }
            }
            if (doc != null) {
                void var16_23;
                MPrintFormatItem item = null;
                int printColIndex = -1;
                int col2 = 0;
                while (col2 < columns.size()) {
                    Object colobj = columns.get(col2);
                    if (colobj instanceof MPrintFormatItem) {
                        item = (MPrintFormatItem)colobj;
                    } else if (colobj instanceof InstanceAttributeColumn) {
                        item = ((InstanceAttributeColumn)colobj).getPrintFormatItem();
                    }
                    if (item != null) {
                        HTMLReportRenderer.addCssInfo(printFormat, item, ++printColIndex, mapCssInfo);
                    }
                    ++col2;
                }
                HTMLReportRenderer.appendInlineCss(doc, mapCssInfo);
                StringBuilder styleBuild = new StringBuilder();
                MPrintTableFormat tf = printFormat.getTableFormat();
                CSSInfo cssInfo = new CSSInfo(tf.getPageHeader_Font(), tf.getPageHeaderFG_Color());
                if (cssPrefix != null) {
                    if (var16_23 != null) {
                        styleBuild.append("." + cssPrefix + "-parameter-table th").append(cssInfo.getCssRule());
                    }
                    styleBuild.append("." + cssPrefix + "-table th").append(cssInfo.getCssRule());
                } else {
                    if (var16_23 != null) {
                        styleBuild.append("parameter-table th").append(cssInfo.getCssRule());
                    }
                    styleBuild.append("table th").append(cssInfo.getCssRule());
                }
                cssInfo = new CSSInfo(tf.getParameter_Font(), tf.getParameter_Color());
                styleBuild.append(".tr-parameter td").append(cssInfo.getCssRule());
                cssInfo = new CSSInfo(tf.getFunct_Font(), tf.getFunctFG_Color());
                styleBuild.append(".tr-function td").append(cssInfo.getCssRule());
                MPrintFont printFont = MPrintFont.get(printFormat.getAD_PrintFont_ID());
                Font base = printFont.getFont();
                Font newFont = new Font(base.getName(), 0, base.getSize() - 1);
                cssInfo = new CSSInfo(newFont, null);
                styleBuild.append(".tr-level-1 td").append(cssInfo.getCssRule());
                newFont = new Font(base.getName(), 0, base.getSize() - 2);
                cssInfo = new CSSInfo(newFont, null);
                styleBuild.append(".tr-level-2 td").append(cssInfo.getCssRule());
                styleBuild = new StringBuilder(styleBuild.toString().replaceAll(";", "!important;"));
                HTMLReportRenderer.appendInlineCss(doc, styleBuild);
                w.print(HTMLReportRenderer.compress(doc.toString(), minify));
                w.print("<div class='" + cssPrefix + "-flex-container'>");
                String paraWrapId = null;
                if (var16_23 != null) {
                    paraWrapId = cssPrefix + "-para-table-wrap";
                    w.print("<details id='" + paraWrapId + "' open=true style='cursor:pointer'>");
                    w.print("<summary style='cursor:pointer'>" + Msg.getMsg(Env.getCtx(), "Parameter") + "</summary>");
                    w.print(HTMLReportRenderer.compress(var16_23.toString(), minify));
                    tr tr2 = new tr();
                    tr2.setClass("tr-parameter");
                    MQuery query = reportEngineQuery;
                    if (reportEngineQuery.getReportProcessQuery() != null) {
                        query = reportEngineQuery.getReportProcessQuery();
                    }
                    int r = 0;
                    while (r < query.getRestrictionCount()) {
                        if (r > 0) {
                            tr2 = new tr();
                            tr2.setClass("tr-parameter");
                        }
                        td2 = new td();
                        tr2.addElement((Element)td2);
                        td2.addElement(query.getInfoName(r));
                        td2 = new td();
                        tr2.addElement((Element)td2);
                        td2.addElement(query.getInfoOperator(r));
                        td2 = new td();
                        tr2.addElement((Element)td2);
                        td2.addElement(query.getInfoDisplayAll(r));
                        w.print(HTMLReportRenderer.compress(tr2.toString(), minify));
                        ++r;
                    }
                    w.print("</table>");
                    w.print("</details>");
                }
                StringBuilder tableWrapDiv = new StringBuilder();
                tableWrapDiv.append("<div class='").append(cssPrefix).append("-table-wrap' ");
                if (paraWrapId != null) {
                    String paraWrapGet = "document.getElementById(\"" + paraWrapId + "\")";
                    tableWrapDiv.append("onscroll='setTimeout(() => {if (this.scrollTop > 0) ").append(" if(").append(paraWrapGet).append(".open) ").append(paraWrapGet).append(".open=false;}, 100)'");
                }
                tableWrapDiv.append(" >");
                w.print(HTMLReportRenderer.compress(tableWrapDiv.toString(), minify));
                w.print(HTMLReportRenderer.compress(table3.toString(), minify));
            }
            thead thead2 = new thead();
            tbody tbody2 = new tbody();
            tbody2.setNeedClosingTag(false);
            Boolean[] colSuppressRepeats = layout == null || layout.colSuppressRepeats == null ? LayoutEngine.getColSuppressRepeats(printFormat) : layout.colSuppressRepeats;
            Object[] preValues = null;
            if (colSuppressRepeats != null) {
                preValues = new Object[colSuppressRepeats.length];
            }
            int printColIndex = -1;
            HashMap<Integer, th> suppressMap = new HashMap<Integer, th>();
            int row = -1;
            while (row < printData.getRowCount()) {
                tr tr3;
                block84: {
                    block83: {
                        tr3 = new tr();
                        if (row == -1) break block83;
                        printData.setRowIndex(row);
                        if (extension != null && !isExport) {
                            extension.extendRowElement((ConcreteElement)tr3, printData);
                        }
                        if (printData.isFunctionRow()) {
                            tr3.setClass(cssPrefix + "-functionrow");
                            break block84;
                        } else if (row < printData.getRowCount() && printData.isFunctionRow(row + 1)) {
                            tr3.setClass(cssPrefix + "-lastgrouprow");
                        }
                        break block84;
                    }
                    thead2.addElement((Element)tr3);
                }
                printColIndex = -1;
                int col3 = 0;
                while (col3 < columns.size()) {
                    block82: {
                        Object obj;
                        block87: {
                            PrintDataElement pde;
                            block81: {
                                String value;
                                MStyle style2;
                                block90: {
                                    boolean isZoom;
                                    block92: {
                                        block91: {
                                            MPrintFormatItem item;
                                            block88: {
                                                block89: {
                                                    block86: {
                                                        InstanceAttributeColumn instanceAttributeColumn;
                                                        block85: {
                                                            MColumn column;
                                                            Object colObj = columns.get(col3);
                                                            item = null;
                                                            instanceAttributeColumn = null;
                                                            if (colObj instanceof MPrintFormatItem) {
                                                                item = (MPrintFormatItem)colObj;
                                                            } else if (colObj instanceof InstanceAttributeColumn) {
                                                                instanceAttributeColumn = (InstanceAttributeColumn)colObj;
                                                                item = instanceAttributeColumn.getPrintFormatItem();
                                                            }
                                                            if (item == null) break block82;
                                                            ++printColIndex;
                                                            if (row != -1) break block85;
                                                            th th2 = new th();
                                                            tr3.addElement((Element)th2);
                                                            String columnHeader = instanceAttributeColumn != null ? instanceAttributeColumn.getName() : item.getPrintName(language);
                                                            th2.addElement(Util.maskHTML(columnHeader));
                                                            if (cssPrefix != null && instanceAttributeColumn == null && (column = MColumn.get(Env.getCtx(), item.getAD_Column_ID())) != null && column.getAD_Column_ID() > 0 && DisplayType.isNumeric(column.getAD_Reference_ID())) {
                                                                th2.setClass(cssPrefix + "-number");
                                                            }
                                                            if (item.isSuppressNull()) {
                                                                suppressMap.put(printColIndex, th2);
                                                                th2.setID("report-th-" + printColIndex);
                                                            }
                                                            break block82;
                                                        }
                                                        td2 = new td();
                                                        tr3.addElement((Element)td2);
                                                        style2 = item.getAD_FieldStyle_ID() > 0 ? MStyle.get(Env.getCtx(), item.getAD_FieldStyle_ID()) : null;
                                                        Object object = obj = instanceAttributeColumn != null ? instanceAttributeColumn.getPrintDataElement(row) : printData.getNodeByPrintFormatItemId(item.getAD_PrintFormatItem_ID());
                                                        if (obj != null && ReportEngine.isDisplayPFItem(printData, item)) break block86;
                                                        td2.addElement("&nbsp;");
                                                        if (colSuppressRepeats != null && colSuppressRepeats[printColIndex].booleanValue()) {
                                                            preValues[printColIndex] = null;
                                                        }
                                                        if (item.isSuppressNull() && obj != null && suppressMap.containsKey(printColIndex)) {
                                                            suppressMap.remove(printColIndex);
                                                        }
                                                        break block82;
                                                    }
                                                    if (!(obj instanceof PrintDataElement)) break block87;
                                                    pde = (PrintDataElement)obj;
                                                    value = pde.getValueDisplay(language);
                                                    if (colSuppressRepeats == null || !colSuppressRepeats[printColIndex].booleanValue()) break block88;
                                                    if (!value.equals(preValues[printColIndex])) break block89;
                                                    td2.addElement("&nbsp;");
                                                    break block82;
                                                }
                                                preValues[printColIndex] = value;
                                            }
                                            if (item.isSuppressNull() && obj != null && suppressMap.containsKey(printColIndex)) {
                                                suppressMap.remove(printColIndex);
                                            }
                                            if (!pde.getColumnName().endsWith("_ID") || extension == null || isExport) break block90;
                                            isZoom = false;
                                            if (!item.getColumnName().equals("Record_ID")) break block91;
                                            Object tablePDE = printData.getNode("AD_Table_ID");
                                            if (tablePDE != null && tablePDE instanceof PrintDataElement) {
                                                int tableID = -1;
                                                try {
                                                    tableID = Integer.parseInt(((PrintDataElement)tablePDE).getValueAsString());
                                                }
                                                catch (Exception exception) {
                                                    tableID = -1;
                                                }
                                                if (tableID > 0) {
                                                    MTable mTable = MTable.get(Env.getCtx(), tableID);
                                                    String tableName = mTable.getTableName();
                                                    value = reportEngine.getIdentifier(mTable, tableName, Integer.parseInt(value));
                                                    String foreignColumnName = tableName + "_ID";
                                                    pde.setForeignColumnName(foreignColumnName);
                                                    isZoom = true;
                                                }
                                            }
                                            break block92;
                                        }
                                        isZoom = true;
                                    }
                                    if (isZoom) {
                                        MTable mTable = MTable.get(Env.getCtx(), pde.getForeignColumnName().substring(0, pde.getForeignColumnName().length() - 3));
                                        int Record_ID = -1;
                                        try {
                                            Record_ID = Integer.parseInt(pde.getValueAsString());
                                        }
                                        catch (Exception exception) {
                                            Record_ID = -1;
                                        }
                                        Boolean canAccess = null;
                                        if (Record_ID >= 0 && mTable != null) {
                                            int AD_Window_ID = Env.getZoomWindowID(mTable.get_ID(), Record_ID);
                                            canAccess = MRole.getDefault().getWindowAccess(AD_Window_ID);
                                        }
                                        if (canAccess == null) {
                                            isZoom = false;
                                        }
                                    }
                                    if (isZoom) {
                                        a href = new a("javascript:void(0)");
                                        href.setID(pde.getColumnName() + "_" + row + "_a");
                                        td2.addElement((Element)href);
                                        href.addElement(Util.maskHTML(value));
                                        if (cssPrefix != null) {
                                            href.setClass(cssPrefix + "-href");
                                        }
                                        if (style2 != null && style2.isWrapWithSpan()) {
                                            HTMLReportRenderer.setStyle(printData, (MultiPartElement)href, style2);
                                        } else {
                                            HTMLReportRenderer.setStyle(printData, (MultiPartElement)td2, style2);
                                        }
                                        extension.extendIDColumn(row, (ConcreteElement)td2, href, pde);
                                        break block81;
                                    } else if (style2 != null && style2.isWrapWithSpan()) {
                                        span span2 = new span();
                                        HTMLReportRenderer.setStyle(printData, (MultiPartElement)span2, style2);
                                        span2.addElement(Util.maskHTML(value));
                                        td2.addElement((Element)span2);
                                        break block81;
                                    } else {
                                        HTMLReportRenderer.setStyle(printData, (MultiPartElement)td2, style2);
                                        td2.addElement(Util.maskHTML(value));
                                    }
                                    break block81;
                                }
                                if (style2 != null && style2.isWrapWithSpan()) {
                                    span span3 = new span();
                                    HTMLReportRenderer.setStyle(printData, (MultiPartElement)span3, style2);
                                    span3.addElement(Util.maskHTML(value));
                                    td2.addElement((Element)span3);
                                } else {
                                    HTMLReportRenderer.setStyle(printData, (MultiPartElement)td2, style2);
                                    td2.addElement(Util.maskHTML(value));
                                }
                            }
                            if (cssPrefix == null) break block82;
                            if (DisplayType.isNumeric(pde.getDisplayType())) {
                                td2.setClass(cssPrefix + "-number");
                                break block82;
                            } else if (DisplayType.isDate(pde.getDisplayType())) {
                                td2.setClass(cssPrefix + "-date");
                                break block82;
                            } else {
                                td2.setClass(cssPrefix + "-text");
                            }
                            break block82;
                        }
                        if (!(obj instanceof PrintData)) {
                            log.log(Level.SEVERE, "Element not PrintData(Element) " + String.valueOf(obj.getClass()));
                        }
                    }
                    ++col3;
                }
                if (row == -1) {
                    w.print(HTMLReportRenderer.compress(thead2.toString(), minify));
                    w.print(HTMLReportRenderer.compress(tbody2.toString(), minify));
                } else {
                    w.print(HTMLReportRenderer.compress(tr3.toString(), minify));
                }
                ++row;
            }
            w.print("</tbody>");
            w.print("</table>");
            if (suppressMap.size() > 0) {
                StringBuilder st = new StringBuilder();
                for (th t : suppressMap.values()) {
                    if (st.length() > 0) {
                        st.append(",");
                    }
                    st.append("#").append(t.getAttribute("id"));
                }
                st.append(" {\n\t\tdisplay:none;\n\t}");
                style styleTag = new style();
                styleTag.addElement(st.toString());
                w.print(HTMLReportRenderer.compress(styleTag.toString(), minify));
            }
            if (!onlyTable) {
                w.print("</div>");
                w.print("</div>");
                w.print("</body>");
                w.print("</html>");
            }
            w.flush();
            w.close();
            return;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "(w)", e);
            throw new AdempiereException(e);
        }
    }

    public static String compress(String src, boolean minify) {
        if (minify) {
            HtmlCompressor compressor = new HtmlCompressor();
            compressor.setEnabled(true);
            compressor.setCompressCss(true);
            compressor.setCompressJavaScript(true);
            compressor.setRemoveComments(true);
            compressor.setRemoveMultiSpaces(true);
            compressor.setRemoveIntertagSpaces(true);
            return compressor.compress(src);
        }
        return src;
    }

    public static void appendInlineCss(XhtmlDocument doc, Map<CSSInfo, List<ColumnInfo>> mapCssInfo) {
        StringBuilder buildCssInline = new StringBuilder();
        for (Map.Entry<CSSInfo, List<ColumnInfo>> cssClassInfo : mapCssInfo.entrySet()) {
            int i = 0;
            while (i < cssClassInfo.getValue().size()) {
                if (i > 0) {
                    buildCssInline.append(",");
                }
                buildCssInline.append(cssClassInfo.getValue().get(i).getCssSelector());
                ++i;
            }
            buildCssInline.append(cssClassInfo.getKey().getCssRule());
            buildCssInline.append("\n");
        }
        HTMLReportRenderer.appendInlineCss(doc, buildCssInline);
    }

    public static void appendInlineCss(XhtmlDocument doc, StringBuilder buildCssInline) {
        if (buildCssInline.length() > 0) {
            buildCssInline.insert(0, "<style>");
            buildCssInline.append("</style>");
            doc.appendHead(buildCssInline.toString());
        }
    }

    public static void addCssInfo(MPrintFormat printFormat, MPrintFormatItem formatItem, int index, Map<CSSInfo, List<ColumnInfo>> mapCssInfo) {
        CSSInfo cadidateCss = new CSSInfo(printFormat, formatItem);
        if (mapCssInfo.containsKey(cadidateCss)) {
            mapCssInfo.get(cadidateCss).add(new ColumnInfo(index, formatItem));
        } else {
            ArrayList<ColumnInfo> newColumnList = new ArrayList<ColumnInfo>();
            newColumnList.add(new ColumnInfo(index, formatItem));
            mapCssInfo.put(cadidateCss, newColumnList);
        }
    }

    private static String getCSSFontFamily(String fontFamily) {
        if ("Dialog".equals(fontFamily) || "DialogInput".equals(fontFamily) || "Monospaced".equals(fontFamily)) {
            return "monospace";
        }
        if ("SansSerif".equals(fontFamily)) {
            return "sans-serif";
        }
        if ("Serif".equals(fontFamily)) {
            return "serif";
        }
        return null;
    }

    public static void setStyle(PrintData printData, MultiPartElement element, MStyle style2) {
        if (style2 == null || style2.getAD_Style_ID() == 0) {
            return;
        }
        MStyleLine[] lines = style2.getStyleLines();
        StringBuilder styleBuilder = new StringBuilder();
        MStyleLine[] mStyleLineArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            MStyleLine line = mStyleLineArray[n2];
            String inlineStyle = line.getInlineStyle().trim();
            String displayLogic = line.getDisplayLogic();
            if (Util.isEmpty(displayLogic) || Evaluator.evaluateLogic(new PrintDataEvaluatee(null, printData), displayLogic)) {
                if (styleBuilder.length() > 0 && styleBuilder.charAt(styleBuilder.length() - 1) != ';') {
                    styleBuilder.append("; ");
                }
                styleBuilder.append(inlineStyle);
            }
            ++n2;
        }
        if (styleBuilder.length() > 0) {
            element.setStyle(styleBuilder.toString());
        }
    }

    @Override
    public Class<HTMLReportRendererConfiguration> getConfigurationType() {
        return HTMLReportRendererConfiguration.class;
    }

    public static class CSSInfo {
        private Font font;
        private Color color;
        private String cssStr;

        public CSSInfo(MPrintFormat printFormat, MPrintFormatItem item) {
            MPrintFont mPrintFont = null;
            if (item.getAD_PrintFont_ID() > 0) {
                mPrintFont = MPrintFont.get(item.getAD_PrintFont_ID());
            } else if (printFormat.getAD_PrintFont_ID() > 0) {
                mPrintFont = MPrintFont.get(printFormat.getAD_PrintFont_ID());
            }
            if (mPrintFont != null && mPrintFont.getAD_PrintFont_ID() > 0) {
                this.font = mPrintFont.getFont();
            }
            MPrintColor mPrintColor = null;
            if (item.getAD_PrintColor_ID() > 0) {
                mPrintColor = MPrintColor.get(Env.getCtx(), item.getAD_PrintColor_ID());
            } else if (printFormat.getAD_PrintColor_ID() > 0) {
                mPrintColor = MPrintColor.get(Env.getCtx(), printFormat.getAD_PrintColor_ID());
            }
            if (mPrintColor != null && mPrintColor.getAD_PrintColor_ID() > 0) {
                this.color = mPrintColor.getColor();
            }
        }

        public CSSInfo(Font font, Color color) {
            this.font = font;
            this.color = color;
        }

        public int hashCode() {
            return (this.color == null ? 0 : this.color.hashCode()) + (this.font == null ? 0 : this.font.hashCode());
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof CSSInfo) || obj.hashCode() != this.hashCode()) {
                return false;
            }
            CSSInfo compareObj = (CSSInfo)obj;
            return this.compareObj(compareObj.color, this.color) && this.compareObj(compareObj.font, this.font);
        }

        protected boolean compareObj(Object obj1, Object obj2) {
            if (obj1 == null && obj2 != null) {
                return false;
            }
            if (obj1 == null && obj2 == null) {
                return true;
            }
            return obj1.equals(obj2);
        }

        protected void addCssRule(StringBuilder cssBuild, String ruleName, String ruleValue) {
            cssBuild.append(ruleName);
            cssBuild.append(":");
            cssBuild.append(ruleValue);
            cssBuild.append(";");
        }

        public String getCssRule() {
            if (this.cssStr != null) {
                return this.cssStr;
            }
            StringBuilder cssBuild = new StringBuilder();
            cssBuild.append("{");
            if (this.font != null) {
                String fontFamily = this.font.getFamily();
                if ((fontFamily = HTMLReportRenderer.getCSSFontFamily(fontFamily)) != null) {
                    this.addCssRule(cssBuild, "font-family", fontFamily);
                }
                if (this.font.isBold()) {
                    this.addCssRule(cssBuild, "font-weight", "bold");
                }
                if (this.font.isItalic()) {
                    this.addCssRule(cssBuild, "font-style", "italic");
                }
                int size = this.font.getSize();
                this.addCssRule(cssBuild, "font-size", size + "pt");
            }
            if (this.color != null) {
                cssBuild.append("color:rgb(");
                cssBuild.append(this.color.getRed());
                cssBuild.append(",");
                cssBuild.append(this.color.getGreen());
                cssBuild.append(",");
                cssBuild.append(this.color.getBlue());
                cssBuild.append(");");
            }
            cssBuild.append("}");
            this.cssStr = cssBuild.toString();
            return this.cssStr;
        }
    }

    public static class ColumnInfo {
        protected static String CSS_SELECTOR_TEMPLATE = "table > tbody > tr > td:nth-child(%1$s)";
        int index = -1;

        public ColumnInfo(int index, MPrintFormatItem formatItem) {
            this.index = index;
        }

        public String getCssSelector() {
            return String.format(CSS_SELECTOR_TEMPLATE, this.index + 1);
        }
    }
}

