/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.wf;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.adempiere.exceptions.DBException;
import org.compiere.model.MColumn;
import org.compiere.model.MMenu;
import org.compiere.model.MProduct;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_AD_Workflow;
import org.compiere.process.DocAction;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ServerProcessCtl;
import org.compiere.process.StateEngine;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.compiere.wf.MWFNode;
import org.compiere.wf.MWFNodeNext;
import org.compiere.wf.MWFProcess;
import org.compiere.wf.MWorkflowAccess;
import org.idempiere.cache.ImmutablePOCache;
import org.idempiere.cache.ImmutablePOSupport;

public class MWorkflow
extends X_AD_Workflow
implements ImmutablePOSupport {
    private static final long serialVersionUID = 727250581144217545L;
    private static ImmutablePOCache<String, MWorkflow> s_cache = new ImmutablePOCache("AD_Workflow", "AD_Workflow", 20);
    private static final CCache<Integer, Map<Integer, MWorkflow[]>> s_cacheDocValue = new CCache<Integer, Map<Integer, MWorkflow[]>>("AD_Workflow", "AD_Workflow|DocumentValue", 5){
        private static final long serialVersionUID = 2548097748351277269L;

        @Override
        public int reset(int recordId) {
            return this.reset();
        }
    };
    private static CLogger s_log = CLogger.getCLogger(MWorkflow.class);
    private List<MWFNode> m_nodes = new ArrayList<MWFNode>();
    private String m_name_trl = null;
    private String m_description_trl = null;
    private String m_help_trl = null;
    private boolean m_translated = false;

    public static MWorkflow get(int AD_Workflow_ID) {
        return MWorkflow.get(Env.getCtx(), AD_Workflow_ID);
    }

    public static MWorkflow get(Properties ctx, int AD_Workflow_ID) {
        String key = Env.getAD_Language(ctx) + "_" + Env.getAD_Client_ID(ctx) + "_" + AD_Workflow_ID;
        MWorkflow retValue = s_cache.get(ctx, key, e -> new MWorkflow(ctx, (MWorkflow)e));
        if (retValue != null) {
            return retValue;
        }
        retValue = new MWorkflow(ctx, AD_Workflow_ID, null);
        if (retValue.get_ID() == AD_Workflow_ID) {
            s_cache.put(key, retValue, e -> new MWorkflow(Env.getCtx(), (MWorkflow)e));
            return retValue;
        }
        return null;
    }

    public static MWorkflow getCopy(Properties ctx, int AD_Workflow_ID, String trxName) {
        MWorkflow wf = MWorkflow.get(AD_Workflow_ID);
        if (wf != null) {
            wf = new MWorkflow(ctx, wf, trxName);
        }
        return wf;
    }

    public static synchronized MWorkflow[] getDocValue(Properties ctx, int AD_Client_ID, int AD_Table_ID, String trxName) {
        MWorkflow[] retValue;
        Map<Integer, MWorkflow[]> cachedMap = s_cacheDocValue.get(AD_Client_ID);
        if (cachedMap == null) {
            List workflows = new Query(ctx, "AD_Workflow", "WorkflowType=? AND IsValid=? AND AD_Client_ID=?", trxName).setParameters("V", true, Env.getAD_Client_ID(ctx)).setOnlyActiveRecords(true).setOrderBy("AD_Table_ID").list();
            cachedMap = new HashMap<Integer, MWorkflow[]>();
            s_cacheDocValue.put(AD_Client_ID, cachedMap);
            ArrayList<MWorkflow> list = new ArrayList<MWorkflow>();
            int previousTableId = -1;
            int currentTableId = -1;
            for (MWorkflow wf : workflows) {
                currentTableId = wf.getAD_Table_ID();
                if (currentTableId != previousTableId && list.size() > 0) {
                    cachedMap.put(previousTableId, (MWorkflow[])list.stream().map(e -> new MWorkflow(Env.getCtx(), (MWorkflow)e)).toArray(MWorkflow[]::new));
                    list = new ArrayList();
                }
                previousTableId = currentTableId;
                list.add(wf);
            }
            if (list.size() > 0) {
                cachedMap.put(previousTableId, (MWorkflow[])list.stream().map(e -> new MWorkflow(Env.getCtx(), (MWorkflow)e)).toArray(MWorkflow[]::new));
            }
            if (s_log.isLoggable(Level.CONFIG)) {
                s_log.config("#" + cachedMap.size());
            }
        }
        return (retValue = cachedMap.get(AD_Table_ID)) != null ? (MWorkflow[])Arrays.stream(retValue).map(e -> new MWorkflow(ctx, (MWorkflow)e, trxName)).toArray(MWorkflow[]::new) : null;
    }

    public MWorkflow(Properties ctx, String AD_Workflow_UU, String trxName) {
        super(ctx, AD_Workflow_UU, trxName);
        if (Util.isEmpty(AD_Workflow_UU)) {
            this.setInitialDefaults();
        }
        this.loadTrl();
        this.loadNodes();
    }

    public MWorkflow(Properties ctx, int AD_Workflow_ID, String trxName) {
        super(ctx, AD_Workflow_ID, trxName);
        if (AD_Workflow_ID == 0) {
            this.setInitialDefaults();
        }
        this.loadTrl();
        this.loadNodes();
    }

    private void setInitialDefaults() {
        this.setAccessLevel("1");
        this.setAuthor("ComPiere, Inc.");
        this.setDurationUnit("D");
        this.setDuration(1);
        this.setEntityType("U");
        this.setIsDefault(false);
        this.setPublishStatus("U");
        this.setVersion(0);
        this.setCost(Env.ZERO);
        this.setWaitingTime(0);
        this.setWorkingTime(0);
        this.setIsBetaFunctionality(false);
    }

    public MWorkflow(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
        this.loadTrl();
        this.loadNodes();
    }

    public MWorkflow(MWorkflow copy) {
        this(Env.getCtx(), copy);
    }

    public MWorkflow(Properties ctx, MWorkflow copy) {
        this(ctx, copy, null);
    }

    public MWorkflow(Properties ctx, MWorkflow copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
        this.m_description_trl = copy.m_description_trl;
        this.m_help_trl = copy.m_help_trl;
        this.m_name_trl = copy.m_name_trl;
        this.m_nodes = copy.m_nodes != null ? (List)copy.m_nodes.stream().map(e -> new MWFNode(ctx, (MWFNode)e, trxName)).collect(Collectors.toCollection(ArrayList::new)) : null;
        this.m_translated = copy.m_translated;
    }

    private void loadTrl() {
        if (Env.isBaseLanguage(this.getCtx(), "AD_Workflow") || this.get_ID() == 0) {
            return;
        }
        String sql = "SELECT Name, Description, Help FROM AD_Workflow_Trl WHERE AD_Workflow_ID=? AND AD_Language=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, this.get_ID());
                pstmt.setString(2, Env.getAD_Language(this.getCtx()));
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    this.m_name_trl = rs.getString(1);
                    this.m_description_trl = rs.getString(2);
                    this.m_help_trl = rs.getString(3);
                    this.m_translated = true;
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sql);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Translated=" + this.m_translated);
        }
    }

    private void loadNodes() {
        this.m_nodes = new Query(this.getCtx(), "AD_WF_Node", "AD_WorkFlow_ID=? AND AD_Client_ID IN (0, ?)", this.get_TrxName()).setParameters(this.get_ID(), Env.getAD_Client_ID(Env.getCtx())).setOnlyActiveRecords(true).list();
        if (this.m_nodes.size() > 0 && this.is_Immutable()) {
            this.m_nodes.stream().forEach(e -> {
                MWFNode mWFNode = e.markImmutable();
            });
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("#" + this.m_nodes.size());
        }
    }

    public int getNodeCount() {
        return this.m_nodes.size();
    }

    public MWFNode[] getNodes(boolean ordered, int AD_Client_ID) {
        if (ordered) {
            return this.getNodesInOrder(AD_Client_ID);
        }
        ArrayList<MWFNode> list = new ArrayList<MWFNode>();
        int i2 = 0;
        while (i2 < this.m_nodes.size()) {
            MWFNode node = this.m_nodes.get(i2);
            if (node.isActive() && (node.getAD_Client_ID() == 0 || node.getAD_Client_ID() == AD_Client_ID)) {
                list.add(node);
            }
            ++i2;
        }
        MWFNode[] retValue = new MWFNode[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public void reloadNodes() {
        this.m_nodes = null;
        this.loadNodes();
    }

    public MWFNode getFirstNode() {
        return this.getNode(this.getAD_WF_Node_ID());
    }

    protected MWFNode getNode(int AD_WF_Node_ID) {
        int i2 = 0;
        while (i2 < this.m_nodes.size()) {
            MWFNode node = this.m_nodes.get(i2);
            if (node.getAD_WF_Node_ID() == AD_WF_Node_ID) {
                return node;
            }
            ++i2;
        }
        return null;
    }

    public MWFNode[] getNextNodes(int AD_WF_Node_ID, int AD_Client_ID) {
        MWFNode node = this.getNode(AD_WF_Node_ID);
        if (node == null || node.getNextNodeCount() == 0) {
            return null;
        }
        MWFNodeNext[] nexts = node.getTransitions(AD_Client_ID);
        ArrayList<MWFNode> list = new ArrayList<MWFNode>();
        int i2 = 0;
        while (i2 < nexts.length) {
            MWFNode next = this.getNode(nexts[i2].getAD_WF_Next_ID());
            if (next != null) {
                list.add(next);
            }
            ++i2;
        }
        MWFNode[] retValue = new MWFNode[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MWFNode[] getNodesInOrder(int AD_Client_ID) {
        ArrayList<MWFNode> list = new ArrayList<MWFNode>();
        this.addNodesSF(list, this.getAD_WF_Node_ID(), AD_Client_ID);
        if (this.m_nodes.size() != list.size()) {
            int n = 0;
            while (n < this.m_nodes.size()) {
                MWFNode node = this.m_nodes.get(n);
                if (node.isActive() && (node.getAD_Client_ID() == 0 || node.getAD_Client_ID() == AD_Client_ID)) {
                    boolean found = false;
                    int i2 = 0;
                    while (i2 < list.size()) {
                        MWFNode existing = list.get(i2);
                        if (existing.getAD_WF_Node_ID() == node.getAD_WF_Node_ID()) {
                            found = true;
                            break;
                        }
                        ++i2;
                    }
                    if (!found) {
                        this.log.log(Level.WARNING, "Added Node w/o transition: " + String.valueOf(node));
                        list.add(node);
                    }
                }
                ++n;
            }
        }
        MWFNode[] nodeArray = new MWFNode[list.size()];
        list.toArray(nodeArray);
        return nodeArray;
    }

    private void addNodesSF(ArrayList<MWFNode> list, int AD_WF_Node_ID, int AD_Client_ID) {
        ArrayList<MWFNode> tmplist = new ArrayList<MWFNode>();
        MWFNode node = this.getNode(AD_WF_Node_ID);
        if (node != null && (node.getAD_Client_ID() == 0 || node.getAD_Client_ID() == AD_Client_ID)) {
            if (!list.contains(node)) {
                list.add(node);
            }
            MWFNodeNext[] nexts = node.getTransitions(AD_Client_ID);
            int i2 = 0;
            while (i2 < nexts.length) {
                MWFNode child = this.getNode(nexts[i2].getAD_WF_Next_ID());
                if (child != null && child.isActive() && (child.getAD_Client_ID() == 0 || child.getAD_Client_ID() == AD_Client_ID) && !list.contains(child)) {
                    list.add(child);
                    tmplist.add(child);
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < tmplist.size()) {
                this.addNodesSF(list, ((MWFNode)tmplist.get(i2)).get_ID(), AD_Client_ID);
                ++i2;
            }
        }
    }

    public int getNext(int AD_WF_Node_ID, int AD_Client_ID) {
        MWFNode[] nodes = this.getNodesInOrder(AD_Client_ID);
        int i2 = 0;
        while (i2 < nodes.length) {
            if (nodes[i2].getAD_WF_Node_ID() == AD_WF_Node_ID) {
                MWFNodeNext[] nexts = nodes[i2].getTransitions(AD_Client_ID);
                if (nexts.length > 0) {
                    return nexts[0].getAD_WF_Next_ID();
                }
                return 0;
            }
            ++i2;
        }
        return 0;
    }

    public MWFNodeNext[] getNodeNexts(int AD_WF_Node_ID, int AD_Client_ID) {
        MWFNode[] nodes = this.getNodesInOrder(AD_Client_ID);
        int i2 = 0;
        while (i2 < nodes.length) {
            if (nodes[i2].getAD_WF_Node_ID() == AD_WF_Node_ID) {
                return nodes[i2].getTransitions(AD_Client_ID);
            }
            ++i2;
        }
        return null;
    }

    public int getPrevious(int AD_WF_Node_ID, int AD_Client_ID) {
        MWFNode[] nodes = this.getNodesInOrder(AD_Client_ID);
        int i2 = 0;
        while (i2 < nodes.length) {
            if (nodes[i2].getAD_WF_Node_ID() == AD_WF_Node_ID) {
                if (i2 > 0) {
                    return nodes[i2 - 1].getAD_WF_Node_ID();
                }
                return 0;
            }
            ++i2;
        }
        return 0;
    }

    public int getLast(int AD_WF_Node_ID, int AD_Client_ID) {
        MWFNode[] nodes = this.getNodesInOrder(AD_Client_ID);
        if (nodes.length > 0) {
            return nodes[nodes.length - 1].getAD_WF_Node_ID();
        }
        return 0;
    }

    public boolean isFirst(int AD_WF_Node_ID, int AD_Client_ID) {
        return AD_WF_Node_ID == this.getAD_WF_Node_ID();
    }

    public boolean isLast(int AD_WF_Node_ID, int AD_Client_ID) {
        MWFNode[] nodes = this.getNodesInOrder(AD_Client_ID);
        return AD_WF_Node_ID == nodes[nodes.length - 1].getAD_WF_Node_ID();
    }

    public String getName(boolean translated) {
        if (translated && this.m_translated) {
            return this.m_name_trl;
        }
        return this.getName();
    }

    public String getDescription(boolean translated) {
        if (translated && this.m_translated) {
            return this.m_description_trl;
        }
        return this.getDescription();
    }

    public String getHelp(boolean translated) {
        if (translated && this.m_translated) {
            return this.m_help_trl;
        }
        return this.getHelp();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MWorkflow[");
        sb.append(this.get_ID()).append("-").append(this.getName()).append("]");
        return sb.toString();
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        this.validate();
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        int i2;
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Success=" + success);
        }
        if (!success) {
            return false;
        }
        if (newRecord) {
            MWFNode[] nodes = this.getNodesInOrder(0);
            i2 = 0;
            while (i2 < nodes.length) {
                nodes[i2].saveEx(this.get_TrxName());
                ++i2;
            }
        }
        if (newRecord) {
            int AD_Role_ID = Env.getAD_Role_ID(this.getCtx());
            MWorkflowAccess wa = new MWorkflowAccess(this, AD_Role_ID);
            wa.saveEx();
        } else if (this.is_ValueChanged("IsActive") || this.is_ValueChanged("Name") || this.is_ValueChanged("Description")) {
            MMenu[] menues = MMenu.get(this.getCtx(), "AD_Workflow_ID=" + this.getAD_Workflow_ID(), this.get_TrxName());
            i2 = 0;
            while (i2 < menues.length) {
                menues[i2].setIsActive(this.isActive());
                menues[i2].setName(this.getName());
                menues[i2].setDescription(this.getDescription());
                menues[i2].saveEx();
                ++i2;
            }
        }
        return success;
    }

    public MWFProcess start(ProcessInfo pi) {
        return this.start(pi, null);
    }

    public MWFProcess start(ProcessInfo pi, String trxName) {
        MWFProcess retValue;
        block15: {
            retValue = null;
            Trx localTrx = null;
            if (trxName == null) {
                localTrx = Trx.get(Trx.createTrxName("WFP"), true);
                localTrx.setDisplayName(this.getClass().getName() + "_start");
            }
            try {
                try {
                    retValue = new MWFProcess(this, pi, trxName != null ? trxName : localTrx.getTrxName());
                    retValue.saveEx();
                    pi.setSummary(Msg.getMsg(this.getCtx(), "Processing"));
                    retValue.startWork();
                    if (localTrx != null) {
                        localTrx.commit(true);
                    }
                    retValue.checkCloseActivities(trxName != null ? trxName : localTrx.getTrxName());
                }
                catch (Exception e) {
                    if (localTrx != null) {
                        localTrx.rollback();
                    }
                    this.log.log(Level.SEVERE, e.getLocalizedMessage(), e);
                    StringBuilder msg = new StringBuilder();
                    if (retValue != null) {
                        StateEngine state = retValue.getState();
                        if (!Util.isEmpty(retValue.getProcessMsg()) && (state.isTerminated() || state.isAborted())) {
                            msg.append(retValue.getProcessMsg());
                            msg.append("\n");
                        }
                    }
                    msg.append(e.getMessage());
                    pi.setSummary(msg.toString(), true);
                    retValue = null;
                    if (localTrx != null) {
                        localTrx.close();
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (localTrx != null) {
                    localTrx.close();
                }
                throw throwable;
            }
            if (localTrx != null) {
                localTrx.close();
            }
        }
        if (retValue != null) {
            String summary = retValue.getProcessMsg();
            StateEngine state = retValue.getState();
            if (summary == null || summary.trim().length() == 0) {
                summary = state.toString();
            }
            pi.setSummary(summary, state.isTerminated() || state.isAborted());
        }
        return retValue;
    }

    @Deprecated
    public MWFProcess startWait(ProcessInfo pi) {
        MWFProcess process = this.start(pi, pi.getTransactionName());
        if (process == null) {
            return null;
        }
        Thread.yield();
        StateEngine state = process.getState();
        int loops = 0;
        while (!state.isClosed() && !state.isSuspended()) {
            if (loops > 30) {
                this.log.warning("Timeout after sec 15");
                pi.setSummary(Msg.getMsg(this.getCtx(), "ProcessRunning"));
                pi.setIsTimeout(true);
                return process;
            }
            try {
                Thread.sleep(500L);
                ++loops;
            }
            catch (InterruptedException e) {
                this.log.log(Level.SEVERE, "startWait interrupted", e);
                pi.setSummary("Interrupted");
                return process;
            }
            Thread.yield();
            state = process.getState();
        }
        String summary = process.getProcessMsg();
        if (summary == null || summary.trim().length() == 0) {
            summary = state.toString();
        }
        pi.setSummary(summary, state.isTerminated() || state.isAborted());
        this.log.fine(summary);
        return process;
    }

    public long getDurationBaseSec() {
        if (this.getDurationUnit() == null) {
            return 0L;
        }
        if ("s".equals(this.getDurationUnit())) {
            return 1L;
        }
        if ("m".equals(this.getDurationUnit())) {
            return 60L;
        }
        if ("h".equals(this.getDurationUnit())) {
            return 3600L;
        }
        if ("D".equals(this.getDurationUnit())) {
            return 86400L;
        }
        if ("M".equals(this.getDurationUnit())) {
            return 2592000L;
        }
        if ("Y".equals(this.getDurationUnit())) {
            return 31536000L;
        }
        return 0L;
    }

    public int getDurationCalendarField() {
        if (this.getDurationUnit() == null) {
            return 12;
        }
        if ("s".equals(this.getDurationUnit())) {
            return 13;
        }
        if ("m".equals(this.getDurationUnit())) {
            return 12;
        }
        if ("h".equals(this.getDurationUnit())) {
            return 10;
        }
        if ("D".equals(this.getDurationUnit())) {
            return 6;
        }
        if ("M".equals(this.getDurationUnit())) {
            return 2;
        }
        if ("Y".equals(this.getDurationUnit())) {
            return 1;
        }
        return 12;
    }

    public String validate() {
        StringBuilder errors = new StringBuilder();
        if (this.getAD_WF_Node_ID() == 0) {
            errors.append(" - No Start Node");
        }
        if ("V".equals(this.getWorkflowType()) && (this.getDocValueLogic() == null || this.getDocValueLogic().length() == 0)) {
            errors.append(" - No Document Value Logic");
        }
        if (this.getWorkflowType().equals("M")) {
            this.setAD_Table_ID(0);
        }
        boolean valid = errors.length() == 0;
        this.setIsValid(valid);
        if (!valid && this.log.isLoggable(Level.INFO)) {
            this.log.info("validate: " + String.valueOf(errors));
        }
        return errors.toString();
    }

    public static int getWorkflowSearchKey(MProduct product) {
        int AD_Client_ID = Env.getAD_Client_ID(product.getCtx());
        String sql = "SELECT AD_Workflow_ID FROM AD_Workflow  WHERE Value = ? AND AD_Client_ID = ?";
        return DB.getSQLValueEx(null, sql, product.getValue(), AD_Client_ID);
    }

    public boolean isValidFromTo(Timestamp date) {
        Timestamp validFrom = this.getValidFrom();
        Timestamp validTo = this.getValidTo();
        if (validFrom != null && date.before(validFrom)) {
            return false;
        }
        return validTo == null || !date.after(validTo);
    }

    @Override
    public MWorkflow markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        if (this.m_nodes != null && this.m_nodes.size() > 0) {
            this.m_nodes.stream().forEach(e -> {
                MWFNode mWFNode = e.markImmutable();
            });
        }
        return this;
    }

    public static ProcessInfo runDocumentActionWorkflow(PO po, String docAction) {
        int AD_Table_ID = po.get_Table_ID();
        MTable table2 = MTable.get(Env.getCtx(), AD_Table_ID);
        MColumn column = table2.getColumn("DocAction");
        if (column == null) {
            return null;
        }
        if (!docAction.equals(po.get_Value(column.getColumnName()))) {
            po.set_ValueOfColumn(column.getColumnName(), (Object)docAction);
            po.saveEx();
        }
        ProcessInfo processInfo = new ProcessInfo(((DocAction)((Object)po)).getDocumentInfo(), column.getAD_Process_ID(), po.get_Table_ID(), po.get_ID());
        processInfo.setTransactionName(po.get_TrxName());
        processInfo.setPO(po);
        ServerProcessCtl.process(processInfo, !Util.isEmpty(processInfo.getTransactionName(), true) ? Trx.get(processInfo.getTransactionName(), false) : null);
        return processInfo;
    }
}

