/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.wf;

import java.sql.ResultSet;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_AD_WF_NodeNext;
import org.compiere.process.DocAction;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.compiere.wf.MWFActivity;
import org.compiere.wf.MWFNextCondition;
import org.compiere.wf.MWFNode;
import org.idempiere.cache.ImmutablePOSupport;

public class MWFNodeNext
extends X_AD_WF_NodeNext
implements ImmutablePOSupport {
    private static final long serialVersionUID = 5965306487040965994L;
    private MWFNextCondition[] m_conditions = null;
    public Boolean m_fromSplitAnd = null;
    public Boolean m_toJoinAnd = null;

    public MWFNodeNext(Properties ctx, String AD_WF_NodeNext_UU, String trxName) {
        super(ctx, AD_WF_NodeNext_UU, trxName);
        if (Util.isEmpty(AD_WF_NodeNext_UU)) {
            this.setInitialDefaults();
        }
    }

    public MWFNodeNext(Properties ctx, int AD_WF_NodeNext_ID, String trxName) {
        super(ctx, AD_WF_NodeNext_ID, trxName);
        if (AD_WF_NodeNext_ID == 0) {
            this.setInitialDefaults();
        }
    }

    private void setInitialDefaults() {
        this.setEntityType("U");
        this.setIsStdUserWorkflow(false);
        this.setSeqNo(10);
    }

    public MWFNodeNext(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MWFNodeNext(MWFNode parent, int AD_WF_Next_ID) {
        this(parent.getCtx(), 0, parent.get_TrxName());
        this.setClientOrg(parent);
        this.setAD_WF_Node_ID(parent.getAD_WF_Node_ID());
        this.setAD_WF_Next_ID(AD_WF_Next_ID);
    }

    public MWFNodeNext(MWFNodeNext copy) {
        this(Env.getCtx(), copy);
    }

    public MWFNodeNext(Properties ctx, MWFNodeNext copy) {
        this(ctx, copy, null);
    }

    public MWFNodeNext(Properties ctx, MWFNodeNext copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
        this.m_conditions = copy.m_conditions != null ? (MWFNextCondition[])Arrays.stream(copy.m_conditions).map(e -> new MWFNextCondition(ctx, (MWFNextCondition)e, trxName)).toArray(MWFNextCondition[]::new) : null;
        this.m_fromSplitAnd = copy.m_fromSplitAnd;
        this.m_toJoinAnd = copy.m_toJoinAnd;
    }

    @Override
    public void setClientOrg(int AD_Client_ID, int AD_Org_ID) {
        super.setClientOrg(AD_Client_ID, AD_Org_ID);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MWFNodeNext[");
        sb.append(this.getSeqNo()).append(":Node=").append(this.getAD_WF_Node_ID()).append("->Next=").append(this.getAD_WF_Next_ID());
        if (this.m_conditions != null) {
            sb.append(",#").append(this.m_conditions.length);
        }
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(",").append(this.getDescription());
        }
        sb.append("]");
        return sb.toString();
    }

    public MWFNextCondition[] getConditions(boolean requery) {
        if (!requery && this.m_conditions != null) {
            return this.m_conditions;
        }
        List<MWFNextCondition> list = new Query(this.getCtx(), "AD_WF_NextCondition", "AD_WF_NodeNext_ID=? AND AD_Client_ID IN (0,?)", this.get_TrxName()).setParameters(this.getAD_WF_NodeNext_ID(), Env.getAD_Client_ID(Env.getCtx())).setOnlyActiveRecords(true).setOrderBy("SeqNo").list();
        if (this.is_Immutable() && list.size() > 0) {
            list.stream().forEach(e -> {
                MWFNextCondition mWFNextCondition = e.markImmutable();
            });
        }
        this.m_conditions = new MWFNextCondition[list.size()];
        list.toArray(this.m_conditions);
        return this.m_conditions;
    }

    public boolean isUnconditional() {
        return !this.isStdUserWorkflow() && this.getConditions(false).length == 0;
    }

    public boolean isValidFor(MWFActivity activity) {
        PO po;
        if (this.isStdUserWorkflow() && (po = activity.getPO()) instanceof DocAction) {
            DocAction da = (DocAction)((Object)po);
            String docStatus = da.getDocStatus();
            String docAction = da.getDocAction();
            if (!"CO".equals(docAction) || "CO".equals(docStatus) || "WC".equals(docStatus) || "WP".equals(docStatus) || "VO".equals(docStatus) || "CL".equals(docStatus) || "RE".equals(docStatus)) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("isValidFor =NO= StdUserWF - Status=" + docStatus + " - Action=" + docAction);
                }
                return false;
            }
        }
        if (this.getConditions(false).length == 0) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("#0 " + this.toString());
            }
            return true;
        }
        boolean ok = this.m_conditions[0].evaluate(activity);
        int i2 = 1;
        while (i2 < this.m_conditions.length) {
            ok = this.m_conditions[i2].isOr() ? ok || this.m_conditions[i2].evaluate(activity) : ok && this.m_conditions[i2].evaluate(activity);
            ++i2;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("isValidFor (" + ok + ") " + this.toString());
        }
        return ok;
    }

    public boolean isFromSplitAnd() {
        if (this.m_fromSplitAnd != null) {
            return this.m_fromSplitAnd;
        }
        return false;
    }

    public void setFromSplitAnd(boolean fromSplitAnd) {
        this.m_fromSplitAnd = fromSplitAnd;
    }

    public boolean isToJoinAnd() {
        if (this.m_toJoinAnd == null && this.getAD_WF_Next_ID() != 0) {
            MWFNode next = MWFNode.get(this.getCtx(), this.getAD_WF_Next_ID());
            this.setToJoinAnd("A".equals(next.getJoinElement()));
        }
        if (this.m_toJoinAnd != null) {
            return this.m_toJoinAnd;
        }
        return false;
    }

    private void setToJoinAnd(boolean toJoinAnd) {
        this.m_toJoinAnd = toJoinAnd;
    }

    @Override
    public MWFNodeNext markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        if (this.m_conditions != null && this.m_conditions.length > 0) {
            Arrays.stream(this.m_conditions).forEach(e -> {
                MWFNextCondition mWFNextCondition = e.markImmutable();
            });
        }
        return this;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getSeqNo() == 0) {
            String sql = "SELECT COALESCE(MAX(SeqNo),0)+10 FROM AD_WF_NodeNext WHERE AD_WF_Node_ID=?";
            int ii = DB.getSQLValue(this.get_TrxName(), sql, this.getAD_WF_Node_ID());
            this.setSeqNo(ii);
        }
        return true;
    }
}

