/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import org.compiere.util.AmtInWords;

public class AmtInWords_CA
implements AmtInWords {
    private static final String[] majorNames = new String[]{"", " MIL", " MILI\u00d3", " BILI\u00d3", " TRILI\u00d3", " QUATRILI\u00d3", " QUINTILI\u00d3N"};
    private static final String[] tensNames = new String[]{"", " DEU", " VINT", " TRENTA", " QUARANTA", " CINQUANTA", " SEIXANTA", " SETANTA", " VUITANTA", " NORANTA"};
    private static final String[] numNames = new String[]{"", " UN", " DOS", " TRES", " QUATRE", " CINC", " SIS", " SET", " VUIT", " NOU", " DEU", " ONZE", " DOTZE", " TRETZE", " CATORZE", " QUINZE", " SETZE", " DISSET", " DIVUIT", " DINOU"};

    private String convertLessThanOneThousand(int number) {
        Object soFar;
        if (number % 100 < 20) {
            soFar = numNames[number % 100];
            number /= 100;
        } else {
            soFar = numNames[number % 10];
            String s = Integer.toString(number /= 10);
            soFar = s.endsWith("2") && !((String)soFar).equals("") ? " VINT-I-" + ((String)soFar).trim() : (((String)soFar).equals("") ? tensNames[number % 10] + (String)soFar : tensNames[number % 10] + "-" + (String)soFar);
            number /= 10;
        }
        if (number == 0) {
            return tensNames[number % 10] + (String)soFar;
        }
        if (number > 1) {
            soFar = "S" + (String)soFar;
        }
        if (number == 1 && !((String)soFar).equals("")) {
            number = 0;
        }
        return numNames[number] + " CENT" + (String)soFar;
    }

    private String convert(int number) {
        if (number == 0) {
            return "ZERO";
        }
        String prefix = "";
        if (number < 0) {
            number = -number;
            prefix = "MENYS";
        }
        Object soFar = "";
        int place = 0;
        do {
            int n;
            if ((n = number % 1000) != 0) {
                String s = this.convertLessThanOneThousand(n);
                if (s.startsWith("DOS CENTS", 1)) {
                    s = s.replaceFirst("DOS CENTS", "DOS-CENTS");
                }
                if (s.startsWith("TRES CENTS", 1)) {
                    s = s.replaceFirst("TRES CENTS", "TRES-CENTS");
                }
                if (s.startsWith("QUATRE CENTS", 1)) {
                    s = s.replaceFirst("QUATRE CENTS", "QUATRE-CENTS");
                }
                if (s.startsWith("CINC CENTS", 1)) {
                    s = s.replaceFirst("CINC CENTS", "CINC-CENTS");
                }
                if (s.startsWith("SIS CENTS", 1)) {
                    s = s.replaceFirst("SIS CENTS", "SIS-CENTS");
                }
                if (s.startsWith("SET CENTS", 1)) {
                    s = s.replaceFirst("SET CENTS", "SET-CENTS");
                }
                if (s.startsWith("VUIT CENTS", 1)) {
                    s = s.replaceFirst("VUIT CENTS", "VUIT-CENTS");
                }
                if (s.startsWith("NOU CENTS", 1)) {
                    s = s.replaceFirst("NOU CENTS", "NOU-CENTS");
                }
                soFar = s.equals(" UN") ? majorNames[place] + (String)soFar : s + majorNames[place] + (String)soFar;
            }
            ++place;
        } while ((number /= 1000) > 0);
        return (prefix + (String)soFar).trim();
    }

    @Override
    public String getAmtInWords(String amount) throws Exception {
        if (amount == null) {
            return amount;
        }
        StringBuilder sb = new StringBuilder();
        int pos = amount.lastIndexOf(44);
        int pos2 = amount.lastIndexOf(46);
        if (pos2 > pos) {
            pos = pos2;
        }
        String oldamt = amount;
        amount = amount.replaceAll("\\.", "");
        int newpos = amount.lastIndexOf(44);
        int pesos = Integer.parseInt(amount.substring(0, newpos));
        sb.append(this.convert(pesos));
        int i2 = 0;
        while (i2 < oldamt.length()) {
            if (pos == i2) {
                String cents = oldamt.substring(i2 + 1);
                sb.append(' ').append(cents).append("/100");
                break;
            }
            ++i2;
        }
        return sb.toString();
    }
}

