/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MTable;
import org.compiere.model.MViewColumn;
import org.compiere.model.Query;
import org.compiere.model.X_AD_ViewColumn;
import org.compiere.model.X_AD_ViewComponent;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.idempiere.cache.ImmutablePOSupport;

public class MViewComponent
extends X_AD_ViewComponent
implements ImmutablePOSupport {
    private static final long serialVersionUID = 1580063310233871896L;
    private MViewColumn[] m_columns = null;

    public MViewComponent(Properties ctx, String AD_ViewComponent_UU, String trxName) {
        super(ctx, AD_ViewComponent_UU, trxName);
    }

    public MViewComponent(Properties ctx, int AD_ViewComponent_ID, String trxName) {
        super(ctx, AD_ViewComponent_ID, trxName);
    }

    public MViewComponent(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MViewComponent(MTable parent) {
        this(parent.getCtx(), 0, parent.get_TrxName());
        this.setClientOrg(parent);
        this.setAD_Table_ID(parent.getAD_Table_ID());
    }

    public MViewComponent(MViewComponent copy) {
        this(Env.getCtx(), copy);
    }

    public MViewComponent(Properties ctx, MViewComponent copy) {
        this(ctx, copy, null);
    }

    public MViewComponent(Properties ctx, MViewComponent copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
        this.m_columns = copy.m_columns != null ? (MViewColumn[])Arrays.stream(copy.m_columns).map(e -> new MViewColumn(ctx, (MViewColumn)e, trxName)).toArray(MViewColumn[]::new) : null;
    }

    public MViewColumn[] getColumns(boolean reload) {
        if (this.m_columns != null && !reload) {
            return this.m_columns;
        }
        Query query = new Query(this.getCtx(), "AD_ViewColumn", "AD_ViewComponent_ID=?", this.get_TrxName());
        query.setParameters(this.getAD_ViewComponent_ID());
        query.setOnlyActiveRecords(true);
        query.setOrderBy("SeqNo, AD_ViewColumn_ID");
        List<MViewColumn> list = query.list();
        if (list.size() > 0) {
            list.stream().forEach(e -> {
                MViewColumn mViewColumn = e.markImmutable();
            });
        }
        this.m_columns = new MViewColumn[list.size()];
        list.toArray(this.m_columns);
        return this.m_columns;
    }

    public String getSelect(boolean requery, MViewColumn[] vCols) {
        this.getColumns(requery);
        if (this.m_columns == null || this.m_columns.length == 0) {
            return null;
        }
        if (vCols == null) {
            vCols = this.m_columns;
        }
        StringBuilder sb = new StringBuilder("SELECT ");
        if (this.isDistinct()) {
            sb.append("DISTINCT ");
        }
        int i = 0;
        while (i < vCols.length) {
            String colSQL;
            String colName = vCols[i].getColumnName();
            X_AD_ViewColumn vc = null;
            MViewColumn[] mViewColumnArray = this.m_columns;
            int n = this.m_columns.length;
            int n2 = 0;
            while (n2 < n) {
                MViewColumn element = mViewColumnArray[n2];
                if (element.getColumnName().equals(colName)) {
                    vc = element;
                    break;
                }
                ++n2;
            }
            if (vc == null) {
                throw new AdempiereException("Cannot find element for " + colName + ".  Tip: all components must have the same number and names of columns");
            }
            if (i > 0) {
                sb.append(", ");
            }
            if ((colSQL = vc.getColumnSQL()) == null || colSQL.toUpperCase().equals("NULL")) {
                String dt = vc.getDBDataType();
                if (dt != null) {
                    if (dt.equals("C") || dt.equals("V")) {
                        colSQL = "NULLIF('a','a')";
                    } else if (dt.equals("I")) {
                        colSQL = "NULLIF(1,1)";
                    } else if (dt.equals("D") || dt.equals("N")) {
                        colSQL = "NULLIF(1.0,1.0)";
                    } else if (dt.equals("T")) {
                        colSQL = "NULL";
                    }
                } else {
                    colSQL = "NULL";
                }
            }
            sb.append(DB.getDatabase().quoteColumnName(colSQL));
            if (!colName.equals("*")) {
                sb.append(" AS ").append(DB.getDatabase().quoteColumnName(colName));
            }
            ++i;
        }
        sb.append(" ").append(this.getFromClause());
        String t = this.getWhereClause();
        if (t != null && t.length() > 0) {
            sb.append(" ").append(t);
        }
        if ((t = this.getOtherClause()) != null && t.length() > 0) {
            sb.append(" ").append(t);
        }
        return sb.toString();
    }

    @Override
    public MViewComponent markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        if (this.m_columns != null && this.m_columns.length > 0) {
            Arrays.stream(this.m_columns).forEach(e -> {
                MViewColumn mViewColumn = e.markImmutable();
            });
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MViewComponent[").append(this.get_ID()).append("-").append(this.getName());
        sb.append("]");
        return sb.toString();
    }
}

