/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Properties;
import org.compiere.model.MInvoice;
import org.compiere.model.MJournalBatch;
import org.compiere.model.MOrder;
import org.compiere.model.MPayment;
import org.compiere.model.MProject;
import org.compiere.model.MRecurringRun;
import org.compiere.model.PO;
import org.compiere.model.X_C_Recurring;
import org.compiere.util.DB;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class MRecurring
extends X_C_Recurring {
    private static final long serialVersionUID = 6053691462050896981L;
    private volatile PO lastPO;

    public MRecurring(Properties ctx, String C_Recurring_UU, String trxName) {
        super(ctx, C_Recurring_UU, trxName);
        if (Util.isEmpty(C_Recurring_UU)) {
            this.setInitialDefaults();
        }
    }

    public MRecurring(Properties ctx, int C_Recurring_ID, String trxName) {
        super(ctx, C_Recurring_ID, trxName);
        if (C_Recurring_ID == 0) {
            this.setInitialDefaults();
        }
    }

    private void setInitialDefaults() {
        this.setDateNextRun(new Timestamp(System.currentTimeMillis()));
        this.setFrequencyType("M");
        this.setFrequency(1);
        this.setRunsMax(1);
        this.setRunsRemaining(0);
    }

    public MRecurring(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MRecurring[").append(this.get_ID()).append("-").append(this.getName());
        if (this.getRecurringType().equals("O")) {
            sb.append(",C_Order_ID=").append(this.getC_Order_ID());
        } else if (this.getRecurringType().equals("I")) {
            sb.append(",C_Invoice_ID=").append(this.getC_Invoice_ID());
        } else if (this.getRecurringType().equals("J")) {
            sb.append(",C_Project_ID=").append(this.getC_Project_ID());
        } else if (this.getRecurringType().equals("G")) {
            sb.append(",GL_JournalBatch_ID=").append(this.getGL_JournalBatch_ID());
        }
        sb.append(",Frequency=").append(this.getFrequencyType()).append("*").append(this.getFrequency());
        sb.append("]");
        return sb.toString();
    }

    public String executeRun() {
        Timestamp dateDoc = this.getDateNextRun();
        if (!this.calculateRuns()) {
            throw new IllegalStateException("No Runs Left");
        }
        MRecurringRun run = new MRecurringRun(this.getCtx(), this);
        Object msg = "@Created@ ";
        if (this.getRecurringType().equals("O")) {
            MOrder from = new MOrder(this.getCtx(), this.getC_Order_ID(), this.get_TrxName());
            MOrder order = MOrder.copyFrom(from, dateDoc, from.getC_DocType_ID(), from.isSOTrx(), false, false, this.get_TrxName());
            run.setC_Order_ID(order.getC_Order_ID());
            msg = (String)msg + order.getDocumentNo();
            this.setLastPO(order);
        } else if (this.getRecurringType().equals("I")) {
            MInvoice from = new MInvoice(this.getCtx(), this.getC_Invoice_ID(), this.get_TrxName());
            MInvoice invoice = MInvoice.copyFrom(from, dateDoc, dateDoc, from.getC_DocType_ID(), from.isSOTrx(), false, this.get_TrxName(), false);
            run.setC_Invoice_ID(invoice.getC_Invoice_ID());
            msg = (String)msg + invoice.getDocumentNo();
            this.setLastPO(invoice);
        } else if (this.getRecurringType().equals("J")) {
            MProject project = MProject.copyFrom(this.getCtx(), this.getC_Project_ID(), dateDoc, this.get_TrxName());
            run.setC_Project_ID(project.getC_Project_ID());
            msg = (String)msg + project.getValue();
            this.setLastPO(project);
        } else if (this.getRecurringType().equals("G")) {
            MJournalBatch journal = MJournalBatch.copyFrom(this.getCtx(), this.getGL_JournalBatch_ID(), dateDoc, this.get_TrxName());
            run.setGL_JournalBatch_ID(journal.getGL_JournalBatch_ID());
            msg = (String)msg + journal.getDocumentNo();
            this.setLastPO(journal);
        } else if (this.getRecurringType().equals("P")) {
            MPayment from = new MPayment(this.getCtx(), this.getC_Payment_ID(), this.get_TrxName());
            MPayment to = new MPayment(this.getCtx(), 0, this.get_TrxName());
            MRecurring.copyValues(from, to);
            to.setAD_Org_ID(from.getAD_Org_ID());
            to.setIsReconciled(false);
            to.setDateAcct(dateDoc);
            to.setDateTrx(dateDoc);
            to.setDocumentNo("");
            to.setProcessed(false);
            to.setPosted(false);
            to.setDocStatus("DR");
            to.setDocAction("CO");
            to.saveEx();
            run.setC_Payment_ID(to.getC_Payment_ID());
            msg = (String)msg + to.getDocumentNo();
            this.setLastPO(to);
        } else {
            return "Invalid @RecurringType@ = " + this.getRecurringType();
        }
        run.saveEx(this.get_TrxName());
        this.setDateLastRun(run.getUpdated());
        this.setRunsRemaining(this.getRunsRemaining() - 1);
        this.setDateNextRun();
        this.saveEx(this.get_TrxName());
        return msg;
    }

    private boolean calculateRuns() {
        String sql = "SELECT COUNT(*) FROM C_Recurring_Run WHERE C_Recurring_ID=?";
        int current = DB.getSQLValue(this.get_TrxName(), sql, this.getC_Recurring_ID());
        int remaining = this.getRunsMax() - current;
        this.setRunsRemaining(remaining);
        this.saveEx();
        return remaining > 0;
    }

    private void setDateNextRun() {
        if (this.getFrequency() < 1) {
            this.setFrequency(1);
        }
        int frequency = this.getFrequency();
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.getDateNextRun());
        if (this.getFrequencyType().equals("D")) {
            cal.add(6, frequency);
        } else if (this.getFrequencyType().equals("W")) {
            cal.add(3, frequency);
        } else if (this.getFrequencyType().equals("M")) {
            cal.add(2, frequency);
        } else if (this.getFrequencyType().equals("Q")) {
            cal.add(2, 3 * frequency);
        }
        Timestamp next = new Timestamp(cal.getTimeInMillis());
        this.setDateNextRun(next);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        String rt = this.getRecurringType();
        if (rt == null) {
            this.log.saveError("FillMandatory", Msg.getElement(this.getCtx(), "RecurringType"));
            return false;
        }
        if (rt.equals("O") && this.getC_Order_ID() == 0) {
            this.log.saveError("FillMandatory", Msg.getElement(this.getCtx(), "C_Order_ID"));
            return false;
        }
        if (rt.equals("I") && this.getC_Invoice_ID() == 0) {
            this.log.saveError("FillMandatory", Msg.getElement(this.getCtx(), "C_Invoice_ID"));
            return false;
        }
        if (rt.equals("G") && this.getGL_JournalBatch_ID() == 0) {
            this.log.saveError("FillMandatory", Msg.getElement(this.getCtx(), "GL_JournalBatch_ID"));
            return false;
        }
        if (rt.equals("J") && this.getC_Project_ID() == 0) {
            this.log.saveError("FillMandatory", Msg.getElement(this.getCtx(), "C_Project_ID"));
            return false;
        }
        return true;
    }

    public PO getLastPO() {
        return this.lastPO;
    }

    public void setLastPO(PO lastPO) {
        this.lastPO = lastPO;
    }
}

