/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MProject;
import org.compiere.model.MProjectLine;
import org.compiere.model.MProjectTask;
import org.compiere.model.MProjectTypePhase;
import org.compiere.model.MProjectTypeTask;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_C_ProjectPhase;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class MProjectPhase
extends X_C_ProjectPhase {
    private static final long serialVersionUID = 5824045445920353065L;

    public MProjectPhase(Properties ctx, String C_ProjectPhase_UU, String trxName) {
        super(ctx, C_ProjectPhase_UU, trxName);
        if (Util.isEmpty(C_ProjectPhase_UU)) {
            this.setInitialDefaults();
        }
    }

    public MProjectPhase(Properties ctx, int C_ProjectPhase_ID, String trxName) {
        super(ctx, C_ProjectPhase_ID, trxName);
        if (C_ProjectPhase_ID == 0) {
            this.setInitialDefaults();
        }
    }

    private void setInitialDefaults() {
        this.setCommittedAmt(Env.ZERO);
        this.setIsCommitCeiling(false);
        this.setIsComplete(false);
        this.setSeqNo(0);
        this.setQty(Env.ZERO);
    }

    public MProjectPhase(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MProjectPhase(MProject project) {
        this(project.getCtx(), 0, project.get_TrxName());
        this.setClientOrg(project);
        this.setC_Project_ID(project.getC_Project_ID());
    }

    public MProjectPhase(MProject project, MProjectTypePhase phase) {
        this(project);
        this.setC_Phase_ID(phase.getC_Phase_ID());
        this.setName(phase.getName());
        this.setSeqNo(phase.getSeqNo());
        this.setDescription(phase.getDescription());
        this.setHelp(phase.getHelp());
        if (phase.getM_Product_ID() != 0) {
            this.setM_Product_ID(phase.getM_Product_ID());
        }
        this.setQty(phase.getStandardQty());
    }

    public MProjectTask[] getTasks() {
        ArrayList<MProjectTask> list;
        block6: {
            list = new ArrayList<MProjectTask>();
            String sql = "SELECT * FROM C_ProjectTask WHERE C_ProjectPhase_ID=? ORDER BY SeqNo";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    pstmt.setInt(1, this.getC_ProjectPhase_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MProjectTask(this.getCtx(), rs, this.get_TrxName()));
                    }
                }
                catch (SQLException ex) {
                    this.log.log(Level.SEVERE, sql, ex);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        MProjectTask[] retValue = new MProjectTask[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public int copyLinesFrom(MProjectPhase fromPhase) {
        if (fromPhase == null) {
            return 0;
        }
        int count = 0;
        MProjectLine[] fromLines = fromPhase.getLines();
        int i = 0;
        while (i < fromLines.length) {
            if (fromLines[i].getC_ProjectTask_ID() == 0) {
                MProjectLine toLine = new MProjectLine(this.getCtx(), 0, this.get_TrxName());
                PO.copyValues(fromLines[i], toLine, this.getAD_Client_ID(), this.getAD_Org_ID());
                toLine.setC_Project_ID(this.getC_Project_ID());
                toLine.setC_ProjectPhase_ID(this.getC_ProjectPhase_ID());
                toLine.saveEx();
                ++count;
            }
            ++i;
        }
        if (fromLines.length != count) {
            this.log.warning("Count difference - ProjectLine=" + fromLines.length + " <> Saved=" + count);
        }
        return count;
    }

    public int copyTasksFrom(MProjectPhase fromPhase) {
        if (fromPhase == null) {
            return 0;
        }
        int count = 0;
        int countLine = 0;
        MProjectTask[] myTasks = this.getTasks();
        MProjectTask[] fromTasks = fromPhase.getTasks();
        int i = 0;
        while (i < fromTasks.length) {
            int C_Task_ID = fromTasks[i].getC_Task_ID();
            boolean exists = false;
            if (C_Task_ID == 0) {
                exists = false;
            } else {
                int ii = 0;
                while (ii < myTasks.length) {
                    if (myTasks[ii].getC_Task_ID() == C_Task_ID) {
                        exists = true;
                        break;
                    }
                    ++ii;
                }
            }
            if (exists) {
                if (this.log.isLoggable(Level.INFO)) {
                    this.log.info("Task already exists here, ignored - " + String.valueOf(fromTasks[i]));
                }
            } else {
                MProjectTask toTask = new MProjectTask(this.getCtx(), 0, this.get_TrxName());
                PO.copyValues(fromTasks[i], toTask, this.getAD_Client_ID(), this.getAD_Org_ID());
                toTask.setC_ProjectPhase_ID(this.getC_ProjectPhase_ID());
                toTask.saveEx();
                ++count;
                countLine += toTask.copyLinesFrom(fromTasks[i]);
            }
            ++i;
        }
        if (fromTasks.length != count) {
            this.log.warning("Count difference - ProjectPhase=" + fromTasks.length + " <> Saved=" + count);
        }
        return count + countLine;
    }

    public int copyTasksFrom(MProjectTypePhase fromPhase) {
        if (fromPhase == null) {
            return 0;
        }
        int count = 0;
        MProjectTypeTask[] fromTasks = fromPhase.getTasks();
        int i = 0;
        while (i < fromTasks.length) {
            MProjectTask toTask = new MProjectTask(this, fromTasks[i]);
            if (toTask.save()) {
                ++count;
            }
            ++i;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("#" + count + " - " + String.valueOf(fromPhase));
        }
        if (fromTasks.length != count) {
            this.log.log(Level.SEVERE, "Count difference - TypePhase=" + fromTasks.length + " <> Saved=" + count);
        }
        return count;
    }

    public MProjectLine[] getLines() {
        List<MProjectLine> list = new Query(this.getCtx(), "C_ProjectLine", "C_Project_ID=? and C_ProjectPhase_ID=?", this.get_TrxName()).setParameters(this.getC_Project_ID(), this.getC_ProjectPhase_ID()).setOrderBy("Line,C_ProjectLine_ID").list();
        MProjectLine[] retValue = new MProjectLine[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MProjectPhase[");
        sb.append(this.get_ID()).append("-").append(this.getSeqNo()).append("-").append(this.getName()).append("]");
        return sb.toString();
    }
}

