/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoicePaySchedule;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderPaySchedule;
import org.compiere.model.MPaySchedule;
import org.compiere.model.Query;
import org.compiere.model.X_C_InvoicePaySchedule;
import org.compiere.model.X_C_OrderPaySchedule;
import org.compiere.model.X_C_PaymentTerm;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class MPaymentTerm
extends X_C_PaymentTerm {
    private static final long serialVersionUID = -4506224598566445450L;
    private MPaySchedule[] m_schedule;

    public MPaymentTerm(Properties ctx, String C_PaymentTerm_UU, String trxName) {
        super(ctx, C_PaymentTerm_UU, trxName);
        if (Util.isEmpty(C_PaymentTerm_UU)) {
            this.setInitialDefaults();
        }
    }

    public MPaymentTerm(Properties ctx, int C_PaymentTerm_ID, String trxName) {
        super(ctx, C_PaymentTerm_ID, trxName);
        if (C_PaymentTerm_ID == 0) {
            this.setInitialDefaults();
        }
    }

    private void setInitialDefaults() {
        this.setAfterDelivery(false);
        this.setNetDays(0);
        this.setDiscount(Env.ZERO);
        this.setDiscount2(Env.ZERO);
        this.setDiscountDays(0);
        this.setDiscountDays2(0);
        this.setGraceDays(0);
        this.setIsDueFixed(false);
        this.setIsValid(false);
    }

    public MPaymentTerm(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MPaySchedule[] getSchedule(boolean requery) {
        ArrayList<MPaySchedule> list;
        block7: {
            if (this.m_schedule != null && !requery) {
                return this.m_schedule;
            }
            String sql = "SELECT * FROM C_PaySchedule WHERE C_PaymentTerm_ID=? AND IsActive='Y' ORDER BY NetDays";
            list = new ArrayList<MPaySchedule>();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    pstmt.setInt(1, this.getC_PaymentTerm_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        MPaySchedule ps = new MPaySchedule(this.getCtx(), rs, this.get_TrxName());
                        ps.setParent(this);
                        list.add(ps);
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "getSchedule", e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        this.m_schedule = new MPaySchedule[list.size()];
        list.toArray(this.m_schedule);
        return this.m_schedule;
    }

    public String validate() {
        boolean valid;
        String validMsg = Msg.parseTranslation(this.getCtx(), "@OK@");
        this.getSchedule(true);
        if (this.m_schedule.length == 0) {
            if (!this.isValid()) {
                this.setIsValid(true);
            }
            return validMsg;
        }
        BigDecimal total = Env.ZERO;
        int i = 0;
        while (i < this.m_schedule.length) {
            BigDecimal percent = this.m_schedule[i].getPercentage();
            if (percent != null) {
                total = total.add(percent);
            }
            ++i;
        }
        boolean bl = valid = total.compareTo(Env.ONEHUNDRED) == 0;
        if (this.isValid() != valid) {
            this.setIsValid(valid);
        }
        int i2 = 0;
        while (i2 < this.m_schedule.length) {
            if (this.m_schedule[i2].isValid() != valid) {
                this.m_schedule[i2].setIsValid(valid);
                this.m_schedule[i2].saveEx();
            }
            ++i2;
        }
        if (valid) {
            return validMsg;
        }
        return "@Total@ = " + String.valueOf(total) + " - @Difference@ = " + String.valueOf(Env.ONEHUNDRED.subtract(total));
    }

    public boolean apply(int C_Invoice_ID) {
        MInvoice invoice = new MInvoice(this.getCtx(), C_Invoice_ID, this.get_TrxName());
        if (invoice == null || invoice.get_ID() == 0) {
            this.log.log(Level.SEVERE, "apply - Not valid C_Invoice_ID=" + C_Invoice_ID);
            return false;
        }
        return this.apply(invoice);
    }

    public boolean apply(MInvoice invoice) {
        if (invoice == null || invoice.get_ID() == 0) {
            this.log.log(Level.SEVERE, "No valid invoice - " + String.valueOf(invoice));
            return false;
        }
        if (!"P".equals(invoice.getPaymentRule()) && !"D".equals(invoice.getPaymentRule()) || invoice.getGrandTotal().signum() == 0) {
            return false;
        }
        if (!this.isValid()) {
            return this.applyNoSchedule(invoice);
        }
        this.getSchedule(true);
        if (this.m_schedule.length <= 0) {
            return this.applyNoSchedule(invoice);
        }
        return this.applySchedule(invoice);
    }

    private boolean applyNoSchedule(MInvoice invoice) {
        this.deleteInvoicePaySchedule(invoice.getC_Invoice_ID(), invoice.get_TrxName());
        if (invoice.getC_PaymentTerm_ID() != this.getC_PaymentTerm_ID()) {
            invoice.setC_PaymentTerm_ID(this.getC_PaymentTerm_ID());
        }
        if (invoice.isPayScheduleValid()) {
            invoice.setIsPayScheduleValid(false);
        }
        return false;
    }

    private boolean applySchedule(MInvoice invoice) {
        this.deleteInvoicePaySchedule(invoice.getC_Invoice_ID(), invoice.get_TrxName());
        X_C_InvoicePaySchedule ips = null;
        BigDecimal remainder = invoice.getGrandTotal();
        int i = 0;
        while (i < this.m_schedule.length) {
            ips = new MInvoicePaySchedule(invoice, this.m_schedule[i]);
            ips.saveEx(invoice.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(((MInvoicePaySchedule)ips).toString());
            }
            remainder = remainder.subtract(ips.getDueAmt());
            ++i;
        }
        if (remainder.compareTo(Env.ZERO) != 0 && ips != null) {
            ips.setDueAmt(ips.getDueAmt().add(remainder));
            ips.saveEx(invoice.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Remainder=" + String.valueOf(remainder) + " - " + String.valueOf(ips));
            }
        }
        if (invoice.getC_PaymentTerm_ID() != this.getC_PaymentTerm_ID()) {
            invoice.setC_PaymentTerm_ID(this.getC_PaymentTerm_ID());
        }
        return invoice.validatePaySchedule();
    }

    private void deleteInvoicePaySchedule(int C_Invoice_ID, String trxName) {
        Query query = new Query(Env.getCtx(), "C_InvoicePaySchedule", "C_Invoice_ID=?", trxName);
        List ipsList = query.setParameters(C_Invoice_ID).list();
        for (MInvoicePaySchedule ips : ipsList) {
            ips.deleteEx(true);
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("C_Invoice_ID=" + C_Invoice_ID + " - #" + ipsList.size());
        }
    }

    public boolean applyOrder(int C_Order_ID) {
        MOrder order = new MOrder(this.getCtx(), C_Order_ID, this.get_TrxName());
        if (order == null || order.get_ID() == 0) {
            this.log.log(Level.SEVERE, "apply - Not valid C_Order_ID=" + C_Order_ID);
            return false;
        }
        return this.applyOrder(order);
    }

    public boolean applyOrder(MOrder order) {
        if (order == null || order.get_ID() == 0) {
            this.log.log(Level.SEVERE, "No valid order - " + String.valueOf(order));
            return false;
        }
        if (!"P".equals(order.getPaymentRule()) && !"D".equals(order.getPaymentRule()) || order.getGrandTotal().signum() == 0) {
            return false;
        }
        if (!this.isValid()) {
            return this.applyOrderNoSchedule(order);
        }
        this.getSchedule(true);
        if (this.m_schedule.length <= 0) {
            return this.applyOrderNoSchedule(order);
        }
        return this.applyOrderSchedule(order);
    }

    private boolean applyOrderNoSchedule(MOrder order) {
        this.deleteOrderPaySchedule(order.getC_Order_ID(), order.get_TrxName());
        if (order.getC_PaymentTerm_ID() != this.getC_PaymentTerm_ID()) {
            order.setC_PaymentTerm_ID(this.getC_PaymentTerm_ID());
        }
        if (order.isPayScheduleValid()) {
            order.setIsPayScheduleValid(false);
        }
        return false;
    }

    private boolean applyOrderSchedule(MOrder order) {
        this.deleteOrderPaySchedule(order.getC_Order_ID(), order.get_TrxName());
        X_C_OrderPaySchedule ops = null;
        BigDecimal remainder = order.getGrandTotal();
        int i = 0;
        while (i < this.m_schedule.length) {
            ops = new MOrderPaySchedule(order, this.m_schedule[i]);
            ops.saveEx(order.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(((MOrderPaySchedule)ops).toString());
            }
            remainder = remainder.subtract(ops.getDueAmt());
            ++i;
        }
        if (remainder.compareTo(Env.ZERO) != 0 && ops != null) {
            ops.setDueAmt(ops.getDueAmt().add(remainder));
            ops.saveEx(order.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Remainder=" + String.valueOf(remainder) + " - " + String.valueOf(ops));
            }
        }
        if (order.getC_PaymentTerm_ID() != this.getC_PaymentTerm_ID()) {
            order.setC_PaymentTerm_ID(this.getC_PaymentTerm_ID());
        }
        return order.validatePaySchedule();
    }

    private void deleteOrderPaySchedule(int C_Order_ID, String trxName) {
        Query query = new Query(Env.getCtx(), "C_OrderPaySchedule", "C_Order_ID=?", trxName);
        List opsList = query.setParameters(C_Order_ID).list();
        for (MOrderPaySchedule ops : opsList) {
            ops.deleteEx(true);
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("C_Order_ID=" + C_Order_ID + " - #" + opsList.size());
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MPaymentTerm[");
        sb.append(this.get_ID()).append("-").append(this.getName()).append(",Valid=").append(this.isValid()).append("]");
        return sb.toString();
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.isDueFixed()) {
            int dd = this.getFixMonthDay();
            if (dd < 1 || dd > 31) {
                this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), "@Invalid@ @FixMonthDay@"));
                return false;
            }
            dd = this.getFixMonthCutoff();
            if (dd < 1 || dd > 31) {
                this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), "@Invalid@ @FixMonthCutoff@"));
                return false;
            }
        }
        if (Integer.signum(this.getNetDays()) < 0) {
            throw new AdempiereException(Msg.parseTranslation(this.getCtx(), "@NetDays@") + " " + Msg.parseTranslation(this.getCtx(), "@positive.number@"));
        }
        if (!newRecord || !this.isValid()) {
            this.validate();
        }
        return true;
    }
}

