/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLandedCostAllocation;
import org.compiere.model.MOrderLine;
import org.compiere.model.Query;
import org.compiere.model.X_C_OrderLandedCost;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class MOrderLandedCost
extends X_C_OrderLandedCost {
    private static final long serialVersionUID = 2629138678703667123L;

    public MOrderLandedCost(Properties ctx, String C_OrderLandedCost_UU, String trxName) {
        super(ctx, C_OrderLandedCost_UU, trxName);
    }

    public MOrderLandedCost(Properties ctx, int C_OrderLandedCost_ID, String trxName) {
        super(ctx, C_OrderLandedCost_ID, trxName);
    }

    public MOrderLandedCost(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MOrderLandedCost[] getOfOrder(int C_Order_ID, String trxName) {
        StringBuilder whereClause = new StringBuilder("C_Order_ID").append("=?");
        List<MOrderLandedCost> list = new Query(Env.getCtx(), "C_OrderLandedCost", whereClause.toString(), trxName).setParameters(C_Order_ID).list();
        return list.toArray(new MOrderLandedCost[list.size()]);
    }

    public MOrderLandedCostAllocation[] getLines(String whereClause) {
        StringBuilder whereClauseFinal = new StringBuilder("C_OrderLandedCost_ID").append("=?");
        if (!Util.isEmpty(whereClause)) {
            whereClauseFinal.append(" ").append(whereClause);
        }
        List<MOrderLandedCostAllocation> list = new Query(this.getCtx(), "C_OrderLandedCostAllocation", whereClauseFinal.toString(), this.get_TrxName()).setParameters(this.getC_OrderLandedCost_ID()).list();
        return list.toArray(new MOrderLandedCostAllocation[list.size()]);
    }

    public String distributeLandedCost() {
        MOrder order;
        MOrderLine[] orderLines;
        MOrderLandedCostAllocation[] lines = this.getLines("");
        if (lines.length == 0 && (orderLines = (order = (MOrder)this.getC_Order()).getLines()).length > 0) {
            ArrayList<MOrderLandedCostAllocation> list = new ArrayList<MOrderLandedCostAllocation>();
            MOrderLine[] mOrderLineArray = orderLines;
            int n = orderLines.length;
            int n2 = 0;
            while (n2 < n) {
                MOrderLine line = mOrderLineArray[n2];
                if (line.getM_Product_ID() > 0) {
                    MOrderLandedCostAllocation allocation = new MOrderLandedCostAllocation(this.getCtx(), 0, this.get_TrxName());
                    allocation.setC_OrderLandedCost_ID(this.getC_OrderLandedCost_ID());
                    allocation.setC_OrderLine_ID(line.getC_OrderLine_ID());
                    allocation.setClientOrg(this.getAD_Client_ID(), this.getAD_Org_ID());
                    allocation.setAmt(BigDecimal.ZERO);
                    allocation.setBase(BigDecimal.ZERO);
                    allocation.setQty(BigDecimal.ZERO);
                    allocation.saveEx();
                    list.add(allocation);
                }
                ++n2;
            }
            if (list.size() > 0) {
                lines = list.toArray(lines);
            }
        }
        if (lines.length == 1) {
            MOrderLine orderLine = (MOrderLine)lines[0].getC_OrderLine();
            BigDecimal base = orderLine.getBase(this.getLandedCostDistribution());
            if (base.signum() == 0) {
                StringBuilder msgreturn = new StringBuilder("Total of Base values is 0 - ").append(this.getLandedCostDistribution());
                return msgreturn.toString();
            }
            lines[0].setBase(base);
            lines[0].setQty(orderLine.getQtyOrdered());
            lines[0].setAmt(this.getAmt());
            lines[0].saveEx();
        } else if (lines.length > 1) {
            MOrderLandedCostAllocation allocation;
            BigDecimal total = Env.ZERO;
            MOrderLandedCostAllocation[] mOrderLandedCostAllocationArray = lines;
            int n = lines.length;
            int n3 = 0;
            while (n3 < n) {
                allocation = mOrderLandedCostAllocationArray[n3];
                MOrderLine orderLine = (MOrderLine)allocation.getC_OrderLine();
                total = total.add(orderLine.getBase(this.getLandedCostDistribution()));
                ++n3;
            }
            if (total.signum() == 0) {
                StringBuilder msgreturn = new StringBuilder("Total of Base values is 0 - ").append(this.getLandedCostDistribution());
                return msgreturn.toString();
            }
            mOrderLandedCostAllocationArray = lines;
            n = lines.length;
            n3 = 0;
            while (n3 < n) {
                allocation = mOrderLandedCostAllocationArray[n3];
                MOrderLine orderLine = (MOrderLine)allocation.getC_OrderLine();
                BigDecimal base = orderLine.getBase(this.getLandedCostDistribution());
                allocation.setBase(base);
                allocation.setQty(orderLine.getQtyOrdered());
                if (base.signum() != 0) {
                    BigDecimal result = this.getAmt().multiply(base);
                    result = result.divide(total, orderLine.getParent().getC_Currency().getCostingPrecision(), RoundingMode.HALF_UP);
                    allocation.setAmt(result.doubleValue(), orderLine.getParent().getC_Currency().getCostingPrecision());
                }
                allocation.saveEx();
                ++n3;
            }
            this.allocateLandedCostRounding(lines);
        }
        return "";
    }

    private void allocateLandedCostRounding(MOrderLandedCostAllocation[] lines) {
        MOrderLandedCostAllocation largestAmtAllocation = null;
        BigDecimal allocationAmt = Env.ZERO;
        MOrderLandedCostAllocation[] mOrderLandedCostAllocationArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            MOrderLandedCostAllocation allocation = mOrderLandedCostAllocationArray[n2];
            if (largestAmtAllocation == null || allocation.getAmt().compareTo(largestAmtAllocation.getAmt()) > 0) {
                largestAmtAllocation = allocation;
            }
            allocationAmt = allocationAmt.add(allocation.getAmt());
            ++n2;
        }
        BigDecimal difference = this.getAmt().subtract(allocationAmt);
        if (difference.signum() != 0) {
            largestAmtAllocation.setAmt(largestAmtAllocation.getAmt().add(difference));
            largestAmtAllocation.saveEx();
            if (this.log.isLoggable(Level.CONFIG)) {
                this.log.config("Difference=" + String.valueOf(difference) + ", C_OrderLandedCostAllocation_ID=" + largestAmtAllocation.getC_OrderLandedCostAllocation_ID() + ", Amt" + String.valueOf(largestAmtAllocation.getAmt()));
            }
        }
    }
}

