/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.I_M_Movement;
import org.compiere.model.I_M_MovementLine;
import org.compiere.model.MMovementLine;
import org.compiere.model.MStorageOnHand;
import org.compiere.model.Query;
import org.compiere.model.X_M_MovementLineMA;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class MMovementLineMA
extends X_M_MovementLineMA {
    private static final long serialVersionUID = -155379485409000271L;
    private static CLogger s_log = CLogger.getCLogger(MMovementLineMA.class);

    public static MMovementLineMA[] get(Properties ctx, int M_MovementLine_ID, String trxName) {
        ArrayList<MMovementLineMA> list;
        block6: {
            list = new ArrayList<MMovementLineMA>();
            String sql = "SELECT * FROM M_MovementLineMA WHERE M_MovementLine_ID=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, trxName);
                    pstmt.setInt(1, M_MovementLine_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MMovementLineMA(ctx, rs, trxName));
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        MMovementLineMA[] retValue = new MMovementLineMA[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static int deleteMovementMA(int M_Movement_ID, String trxName) {
        String sql = "DELETE FROM M_MovementLineMA ma WHERE EXISTS (SELECT * FROM M_MovementLine l WHERE l.M_MovementLine_ID=ma.M_MovementLine_ID AND M_Movement_ID=" + M_Movement_ID + ")";
        return DB.executeUpdate(sql, trxName);
    }

    public static int deleteMovementLineMA(int M_MovementLine_ID, String trxName) {
        String sql = "DELETE FROM M_MovementLineMA WHERE M_MovementLine_ID=? AND IsAutoGenerated='Y' ";
        return DB.executeUpdate(sql, M_MovementLine_ID, trxName);
    }

    public MMovementLineMA(Properties ctx, String M_MovementLineMA_UU, String trxName) {
        super(ctx, M_MovementLineMA_UU, trxName);
    }

    public MMovementLineMA(Properties ctx, int M_MovementLineMA_ID, String trxName) {
        super(ctx, M_MovementLineMA_ID, trxName);
        if (M_MovementLineMA_ID != 0) {
            throw new IllegalArgumentException("Multi-Key");
        }
    }

    public MMovementLineMA(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MMovementLineMA(MMovementLine parent, int M_AttributeSetInstance_ID, BigDecimal MovementQty, Timestamp DateMaterialPolicy) {
        this(parent, M_AttributeSetInstance_ID, MovementQty, DateMaterialPolicy, true);
    }

    public MMovementLineMA(MMovementLine parent, int M_AttributeSetInstance_ID, BigDecimal MovementQty, Timestamp DateMaterialPolicy, boolean isAutoGenerated) {
        this(parent.getCtx(), 0, parent.get_TrxName());
        this.setClientOrg(parent);
        this.setM_MovementLine_ID(parent.getM_MovementLine_ID());
        this.setM_AttributeSetInstance_ID(M_AttributeSetInstance_ID);
        this.setMovementQty(MovementQty);
        if (DateMaterialPolicy == null) {
            if (M_AttributeSetInstance_ID > 0) {
                DateMaterialPolicy = MStorageOnHand.getDateMaterialPolicy(parent.getM_Product_ID(), M_AttributeSetInstance_ID, parent.get_TrxName());
            }
            if (DateMaterialPolicy == null) {
                DateMaterialPolicy = parent.getParent().getMovementDate();
            }
        }
        this.setDateMaterialPolicy(DateMaterialPolicy);
        this.setIsAutoGenerated(isAutoGenerated);
    }

    @Override
    public void setDateMaterialPolicy(Timestamp DateMaterialPolicy) {
        if (DateMaterialPolicy != null) {
            DateMaterialPolicy = Util.removeTime(DateMaterialPolicy);
        }
        super.setDateMaterialPolicy(DateMaterialPolicy);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MMovementLineMA[");
        sb.append("M_MovementLine_ID=").append(this.getM_MovementLine_ID()).append(",M_AttributeSetInstance_ID=").append(this.getM_AttributeSetInstance_ID()).append(", Qty=").append(this.getMovementQty()).append("]");
        return sb.toString();
    }

    public static MMovementLineMA addOrCreate(MMovementLine line, int M_AttributeSetInstance_ID, BigDecimal MovementQty, Timestamp DateMaterialPolicy) {
        return MMovementLineMA.addOrCreate(line, M_AttributeSetInstance_ID, MovementQty, DateMaterialPolicy, true);
    }

    public static MMovementLineMA addOrCreate(MMovementLine line, int M_AttributeSetInstance_ID, BigDecimal MovementQty, Timestamp DateMaterialPolicy, boolean isAutoGenerated) {
        Query query = new Query(Env.getCtx(), "M_MovementLineMA", "M_MovementLine_ID=? AND M_AttributeSetInstance_ID=? AND DateMaterialPolicy=trunc(cast(? as date))", line.get_TrxName());
        MMovementLineMA po = (MMovementLineMA)query.setParameters(line.getM_MovementLine_ID(), M_AttributeSetInstance_ID, DateMaterialPolicy).first();
        if (po == null) {
            po = new MMovementLineMA(line, M_AttributeSetInstance_ID, MovementQty, DateMaterialPolicy, isAutoGenerated);
        } else {
            po.setMovementQty(po.getMovementQty().add(MovementQty));
        }
        return po;
    }

    public static BigDecimal getManualQty(int M_MovementLine_ID, String trxName) {
        String sql = "SELECT SUM(movementqty) FROM M_MovementLineMA ma WHERE ma.M_MovementLine_ID=?  AND ma.IsAutoGenerated='N'";
        BigDecimal totalQty = DB.getSQLValueBD(trxName, sql, M_MovementLine_ID);
        return totalQty == null ? Env.ZERO : totalQty;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        MMovementLine parentline = new MMovementLine(this.getCtx(), this.getM_MovementLine_ID(), this.get_TrxName());
        if (newRecord && parentline.getParent().isProcessed()) {
            this.log.saveError("ParentComplete", Msg.translate(this.getCtx(), "M_Movement_ID"));
            return false;
        }
        if (!newRecord && this.is_ValueChanged("M_AttributeSetInstance_ID")) {
            I_M_MovementLine line = this.getM_MovementLine();
            Timestamp dateMPolicy = null;
            if (this.getM_AttributeSetInstance_ID() > 0) {
                dateMPolicy = MStorageOnHand.getDateMaterialPolicy(line.getM_Product_ID(), this.getM_AttributeSetInstance_ID(), this.get_TrxName());
            }
            if (dateMPolicy == null) {
                I_M_Movement movement = line.getM_Movement();
                dateMPolicy = movement.getMovementDate();
            }
            this.setDateMaterialPolicy(dateMPolicy);
        }
        return true;
    }
}

