/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.Lookup;
import org.compiere.model.MLocator;
import org.compiere.model.MRole;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.NamePair;
import org.compiere.util.Util;

public final class MLocatorLookup
extends Lookup
implements Serializable {
    private static final long serialVersionUID = -6041455174391573888L;
    private Properties m_ctx;
    protected int C_Locator_ID;
    private Loader m_loader;
    private String m_validationCode;
    private String m_parsedValidation;
    private int m_warehouseActiveCount;
    private int m_only_Warehouse_ID = 0;
    private int m_only_Product_ID = 0;
    private volatile LinkedHashMap<Integer, MLocator> m_lookup = new LinkedHashMap();

    public MLocatorLookup(Properties ctx, int WindowNo) {
        this(ctx, WindowNo, null);
    }

    public MLocatorLookup(Properties ctx, int WindowNo, String validationCode) {
        super(19, WindowNo);
        this.m_ctx = ctx;
        this.m_validationCode = validationCode;
    }

    @Override
    public void dispose() {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("C_Locator_ID=" + this.C_Locator_ID);
        }
        if (this.m_loader != null) {
            while (this.m_loader.isAlive()) {
                this.m_loader.interrupt();
            }
        }
        this.m_loader = null;
        if (this.m_lookup != null) {
            this.m_lookup.clear();
        }
        this.m_lookup = null;
        super.dispose();
    }

    public void setOnly_Warehouse_ID(int only_Warehouse_ID) {
        this.m_only_Warehouse_ID = only_Warehouse_ID;
    }

    public int getOnly_Warehouse_ID() {
        return this.m_only_Warehouse_ID;
    }

    public void setOnly_Product_ID(int only_Product_ID) {
        this.m_only_Product_ID = only_Product_ID;
    }

    public int getOnly_Product_ID() {
        return this.m_only_Product_ID;
    }

    @Override
    public void loadComplete() {
        if (this.m_loader != null) {
            try {
                this.m_loader.join();
            }
            catch (InterruptedException ie) {
                this.log.log(Level.SEVERE, "Join interrupted", ie);
            }
        }
    }

    @Override
    public NamePair get(Object key) {
        if (key == null) {
            return null;
        }
        MLocator loc = this.m_lookup.get(key);
        if (loc != null) {
            return new KeyNamePair(loc.getM_Locator_ID(), loc.toString());
        }
        if (this.m_loader != null && this.m_loader.isAlive()) {
            this.log.fine("Waiting for Loader");
            this.loadComplete();
            loc = this.m_lookup.get(key);
        }
        if (loc != null) {
            return new KeyNamePair(loc.getM_Locator_ID(), loc.toString());
        }
        return this.getDirect(key, true, null);
    }

    @Override
    public String getDisplay(Object key) {
        if (key == null) {
            return "";
        }
        NamePair display = this.get(key);
        if (display == null) {
            StringBuilder msgreturn = new StringBuilder("<").append(key.toString()).append(">");
            return msgreturn.toString();
        }
        return display.toString();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.m_lookup.containsKey(key);
    }

    @Override
    public boolean containsKeyNoDirect(Object key) {
        return this.containsKey(key);
    }

    public NamePair getDirect(Object keyValue, boolean saveInCache, String trxName) {
        MLocator loc = this.getMLocator(keyValue, trxName);
        if (loc == null) {
            return null;
        }
        int key = loc.getM_Locator_ID();
        if (saveInCache) {
            this.m_lookup.put(key, loc);
        }
        KeyNamePair retValue = new KeyNamePair(key, loc.toString());
        return retValue;
    }

    public MLocator getMLocator(Object keyValue, String trxName) {
        int M_Locator_ID = -1;
        try {
            M_Locator_ID = Integer.parseInt(keyValue.toString());
        }
        catch (Exception exception) {}
        if (M_Locator_ID == -1) {
            this.log.log(Level.SEVERE, "Invalid key=" + String.valueOf(keyValue));
            return null;
        }
        return MLocator.getCopy(this.m_ctx, M_Locator_ID, trxName);
    }

    public String toString() {
        StringBuilder msgreturn = new StringBuilder("MLocatorLookup[Size=").append(this.m_lookup.size()).append("]");
        return msgreturn.toString();
    }

    public boolean isValid(Object key) {
        if (key == null) {
            return true;
        }
        MLocator loc = this.m_lookup.get(key);
        if (loc == null) {
            loc = this.getMLocator(key, null);
        }
        return this.isValid(loc);
    }

    public boolean isValid(MLocator locator) {
        if (locator == null || this.getOnly_Warehouse_ID() == 0) {
            return true;
        }
        if (this.getOnly_Warehouse_ID() == locator.getM_Warehouse_ID()) {
            return locator.isCanStoreProduct(this.getOnly_Product_ID());
        }
        return false;
    }

    private boolean isNeedRefresh() {
        int activeCount;
        if (!Util.isEmpty(this.m_validationCode)) {
            Properties ctx = new Properties(this.m_ctx);
            Env.setContext(ctx, this.getWindowNo(), "M_Product_ID", this.getOnly_Product_ID());
            Env.setContext(ctx, this.getWindowNo(), "M_Warehouse_ID", this.getOnly_Warehouse_ID());
            String parseValidation = Env.parseContext(ctx, this.getWindowNo(), this.m_validationCode, false, false);
            if (!Util.isEmpty(parseValidation) && !parseValidation.equals(this.m_parsedValidation) || !Util.isEmpty(this.m_parsedValidation) && !this.m_parsedValidation.equals(parseValidation)) {
                return true;
            }
        } else if (!Util.isEmpty(this.m_parsedValidation)) {
            this.m_parsedValidation = null;
            return true;
        }
        if (this.m_only_Warehouse_ID == 0 && this.m_warehouseActiveCount != (activeCount = DB.getSQLValue(null, "SELECT Count(*) FROM M_Warehouse WHERE IsActive='Y' AND AD_Client_ID=?", Env.getAD_Client_ID(this.m_ctx)))) {
            this.m_warehouseActiveCount = activeCount;
            return true;
        }
        return false;
    }

    public Collection<MLocator> getData() {
        if (this.m_loader == null) {
            this.refresh();
        } else if (this.m_loader.isAlive()) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Waiting for Loader");
            }
            try {
                this.m_loader.join();
            }
            catch (InterruptedException ie) {
                this.log.severe("Join interrupted - " + ie.getMessage());
            }
        }
        return this.m_lookup.values();
    }

    @Override
    public ArrayList<Object> getData(boolean mandatory, boolean onlyValidated, boolean onlyActive, boolean temporary, boolean shortlist) {
        Collection<MLocator> collection = this.getData();
        ArrayList<Object> list = new ArrayList<Object>(collection.size());
        for (MLocator loc : collection) {
            if (!this.isValid(loc)) continue;
            list.add(loc);
        }
        return list;
    }

    @Override
    public int refresh() {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("start");
        }
        this.m_loader = new Loader();
        this.m_loader.start();
        try {
            this.m_loader.join();
        }
        catch (InterruptedException interruptedException) {}
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("#" + this.m_lookup.size());
        }
        return this.m_lookup.size();
    }

    public int refreshIfNeeded() {
        if (this.m_loader != null && this.m_loader.isAlive()) {
            return this.m_lookup.size();
        }
        if (this.isNeedRefresh()) {
            return this.refresh();
        }
        return this.m_lookup.size();
    }

    @Override
    public String getColumnName() {
        return "M_Locator.M_Locator_ID";
    }

    public void dynamicDisplay(Properties ctx) {
        this.m_ctx = ctx;
        this.m_parsedValidation = null;
    }

    public void setValidationCode(String validationCode) {
        this.m_validationCode = validationCode;
    }

    class Loader
    extends Thread
    implements Serializable {
        private static final long serialVersionUID = 3472186635409000236L;

        public Loader() {
            super("MLocatorLookup");
        }

        @Override
        public void run() {
            String finalSql;
            block17: {
                int local_only_warehouse_id = MLocatorLookup.this.getOnly_Warehouse_ID();
                int local_only_product_id = MLocatorLookup.this.getOnly_Product_ID();
                StringBuilder sql = new StringBuilder("SELECT M_Locator.* FROM M_Locator ").append(" INNER JOIN M_Warehouse wh ON (wh.M_Warehouse_ID=M_Locator.M_Warehouse_ID) ").append(" WHERE M_Locator.IsActive='Y' ").append(" AND wh.IsActive='Y'");
                if (local_only_warehouse_id != 0) {
                    sql.append(" AND M_Locator.M_Warehouse_ID=?");
                } else {
                    MLocatorLookup.this.m_warehouseActiveCount = DB.getSQLValue(null, "SELECT Count(*) FROM M_Warehouse WHERE IsActive='Y' AND AD_Client_ID=?", Env.getAD_Client_ID(MLocatorLookup.this.m_ctx));
                }
                if (local_only_product_id != 0) {
                    sql.append(" AND (M_Locator.IsDefault='Y' ").append("OR EXISTS (SELECT * FROM M_Product p ").append("WHERE p.M_Locator_ID=M_Locator.M_Locator_ID AND p.M_Product_ID=?) ").append("OR EXISTS (SELECT * FROM M_Storage s ").append("WHERE s.M_Locator_ID=M_Locator.M_Locator_ID AND s.M_Product_ID=?))");
                }
                MLocatorLookup.this.m_parsedValidation = null;
                if (!Util.isEmpty(MLocatorLookup.this.m_validationCode)) {
                    String parseValidation;
                    Properties ctx = new Properties(MLocatorLookup.this.m_ctx);
                    Env.setContext(ctx, MLocatorLookup.this.getWindowNo(), "M_Product_ID", MLocatorLookup.this.getOnly_Product_ID());
                    Env.setContext(ctx, MLocatorLookup.this.getWindowNo(), "M_Warehouse_ID", MLocatorLookup.this.getOnly_Warehouse_ID());
                    MLocatorLookup.this.m_parsedValidation = parseValidation = Env.parseContext(ctx, MLocatorLookup.this.getWindowNo(), MLocatorLookup.this.m_validationCode, false, false);
                    if (!Util.isEmpty(parseValidation)) {
                        sql.append(" AND ( ").append(parseValidation).append(" ) ");
                    }
                }
                sql.append(" ORDER BY ");
                if (local_only_warehouse_id == 0) {
                    sql.append("wh.Name,");
                }
                sql.append("M_Locator.Value");
                finalSql = MRole.getDefault(MLocatorLookup.this.m_ctx, false).addAccessSQL(sql.toString(), "M_Locator", true, false);
                if (this.isInterrupted()) {
                    MLocatorLookup.this.log.log(Level.SEVERE, "Interrupted");
                    return;
                }
                MLocatorLookup.this.m_lookup.clear();
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement(finalSql, null);
                        int index = 1;
                        if (local_only_warehouse_id != 0) {
                            pstmt.setInt(index++, MLocatorLookup.this.getOnly_Warehouse_ID());
                        }
                        if (local_only_product_id != 0) {
                            pstmt.setInt(index++, MLocatorLookup.this.getOnly_Product_ID());
                            pstmt.setInt(index++, MLocatorLookup.this.getOnly_Product_ID());
                        }
                        rs = pstmt.executeQuery();
                        while (rs.next()) {
                            MLocator loc = new MLocator(Env.getCtx(), rs, null);
                            int M_Locator_ID = loc.getM_Locator_ID();
                            MLocatorLookup.this.m_lookup.put(M_Locator_ID, loc);
                        }
                    }
                    catch (SQLException e) {
                        MLocatorLookup.this.log.log(Level.SEVERE, finalSql, e);
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
            if (MLocatorLookup.this.log.isLoggable(Level.FINE)) {
                MLocatorLookup.this.log.fine("Complete #" + MLocatorLookup.this.m_lookup.size());
            }
            if (MLocatorLookup.this.m_lookup.size() == 0) {
                MLocatorLookup.this.log.finer(finalSql);
            }
        }
    }
}

