/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MProductCategoryAcct;
import org.compiere.model.MRefList;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_M_CostElement;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.idempiere.cache.ImmutableIntPOCache;
import org.idempiere.cache.ImmutablePOSupport;

public class MCostElement
extends X_M_CostElement
implements ImmutablePOSupport {
    private static final long serialVersionUID = 4914952212171251715L;
    protected static ImmutableIntPOCache<Integer, MCostElement> s_cache = new ImmutableIntPOCache("M_CostElement", 20);
    private static CLogger s_log = CLogger.getCLogger(MCostElement.class);

    public static MCostElement getMaterialCostElement(PO po, String CostingMethod) {
        if (CostingMethod == null || CostingMethod.length() == 0) {
            s_log.severe("No CostingMethod");
            return null;
        }
        MCostElement retValue = (MCostElement)new Query(po.getCtx(), "M_CostElement", "AD_Client_ID=? AND CostingMethod=? AND CostElementType=?", po.get_TrxName()).setParameters(po.getAD_Client_ID(), CostingMethod, "M").setOrderBy("AD_Org_ID").firstOnly();
        if (retValue != null) {
            return retValue;
        }
        retValue = new MCostElement(po.getCtx(), 0, po.get_TrxName());
        retValue.setClientOrg(po.getAD_Client_ID(), 0);
        String name = MRefList.getListName(po.getCtx(), 122, CostingMethod);
        if (name == null || name.length() == 0) {
            name = CostingMethod;
        }
        retValue.setName(name);
        retValue.setCostElementType("M");
        retValue.setCostingMethod(CostingMethod);
        retValue.saveEx();
        return retValue;
    }

    public static MCostElement getMaterialCostElement(Properties ctx, String CostingMethod) {
        List list = new Query(ctx, "M_CostElement", "AD_Client_ID=? AND CostingMethod=? AND CostElementType=?", null).setParameters(Env.getAD_Client_ID(ctx), CostingMethod, "M").setOrderBy("AD_Org_ID").list();
        MCostElement retValue = null;
        if (list.size() > 0) {
            retValue = (MCostElement)list.get(0);
        }
        if (list.size() > 1 && s_log.isLoggable(Level.INFO)) {
            s_log.info("More then one Material Cost Element for CostingMethod=" + CostingMethod);
        }
        return retValue;
    }

    public static MCostElement getMaterialCostElement(Properties ctx, String CostingMethod, int AD_Org_ID) {
        List list = new Query(ctx, "M_CostElement", "AD_Client_ID=? AND CostingMethod=? AND CostElementType=? AND AD_Org_ID In (0, ?)", null).setParameters(Env.getAD_Client_ID(ctx), CostingMethod, "M", AD_Org_ID).setOrderBy("AD_Org_ID Desc").list();
        MCostElement retValue = null;
        if (list.size() > 0) {
            retValue = (MCostElement)list.get(0);
        }
        if (list.size() > 1 && s_log.isLoggable(Level.INFO)) {
            s_log.info("More then one Material Cost Element for CostingMethod=" + CostingMethod);
        }
        return retValue;
    }

    public static List<MCostElement> getCostElementsWithCostingMethods(PO po) {
        return new Query(po.getCtx(), "M_CostElement", "AD_Client_ID=? AND CostingMethod IS NOT NULL", po.get_TrxName()).setParameters(po.getAD_Client_ID()).setOnlyActiveRecords(true).list();
    }

    public static MCostElement[] getCostingMethods(PO po) {
        List<MCostElement> list = new Query(po.getCtx(), "M_CostElement", "AD_Client_ID=? AND CostElementType=? AND CostingMethod IS NOT NULL", po.get_TrxName()).setParameters(po.getAD_Client_ID(), "M").setOnlyActiveRecords(true).list();
        MCostElement[] retValue = new MCostElement[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static MCostElement[] getNonCostingMethods(PO po) {
        List<MCostElement> list = new Query(po.getCtx(), "M_CostElement", "AD_Client_ID=? AND CostingMethod IS NULL", po.get_TrxName()).setParameters(po.getAD_Client_ID()).setOnlyActiveRecords(true).list();
        MCostElement[] retValue = new MCostElement[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static MCostElement get(int M_CostElement_ID) {
        return MCostElement.get(Env.getCtx(), M_CostElement_ID);
    }

    public static MCostElement get(Properties ctx, int M_CostElement_ID) {
        Integer key = M_CostElement_ID;
        MCostElement retValue = s_cache.get(ctx, key, e -> new MCostElement(ctx, (MCostElement)e));
        if (retValue != null) {
            return retValue;
        }
        retValue = new MCostElement(ctx, M_CostElement_ID, null);
        if (retValue.get_ID() == M_CostElement_ID) {
            s_cache.put(key, retValue, e -> new MCostElement(Env.getCtx(), (MCostElement)e));
            return retValue;
        }
        return null;
    }

    public static MCostElement getCopy(Properties ctx, int M_CostElement_ID, String trxName) {
        MCostElement ce = MCostElement.get(M_CostElement_ID);
        if (ce != null) {
            ce = new MCostElement(ctx, ce, trxName);
        }
        return ce;
    }

    public static MCostElement[] getElements(Properties ctx, String trxName) {
        int AD_Org_ID = 0;
        List<MCostElement> list = new Query(ctx, "M_CostElement", "AD_Client_ID = ? AND AD_Org_ID=?", trxName).setParameters(Env.getAD_Client_ID(ctx), AD_Org_ID).list();
        MCostElement[] retValue = new MCostElement[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static List<MCostElement> getByCostingMethod(Properties ctx, String CostingMethod) {
        return new Query(ctx, "M_CostElement", "AD_Client_ID = ? AND CostingMethod=?", null).setOnlyActiveRecords(true).setParameters(Env.getAD_Client_ID(ctx), CostingMethod).list();
    }

    public MCostElement(Properties ctx, String M_CostElement_UU, String trxName) {
        super(ctx, M_CostElement_UU, trxName);
        if (Util.isEmpty(M_CostElement_UU)) {
            this.setInitialDefaults();
        }
    }

    public MCostElement(Properties ctx, int M_CostElement_ID, String trxName) {
        super(ctx, M_CostElement_ID, trxName);
        if (M_CostElement_ID == 0) {
            this.setInitialDefaults();
        }
    }

    private void setInitialDefaults() {
        this.setCostElementType("M");
        this.setIsCalculated(false);
    }

    public MCostElement(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MCostElement(MCostElement copy) {
        this(Env.getCtx(), copy);
    }

    public MCostElement(Properties ctx, MCostElement copy) {
        this(ctx, copy, null);
    }

    public MCostElement(Properties ctx, MCostElement copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (("M".equals(this.getCostElementType()) || "X".equals(this.getCostElementType())) && (newRecord || this.is_ValueChanged("CostingMethod"))) {
            String sql = "SELECT  COALESCE(MAX(M_CostElement_ID),0) FROM M_CostElement WHERE AD_Client_ID=? AND CostingMethod=? AND CostElementType=?";
            int id = DB.getSQLValue(this.get_TrxName(), sql, this.getAD_Client_ID(), this.getCostingMethod(), this.getCostElementType());
            if (id > 0 && id != this.get_ID()) {
                this.log.saveError("AlreadyExists", Msg.getElement(this.getCtx(), "CostingMethod"));
                return false;
            }
        }
        if (this.getAD_Org_ID() != 0) {
            this.setAD_Org_ID(0);
        }
        return true;
    }

    @Override
    protected boolean beforeDelete() {
        String cm = this.getCostingMethod();
        if (cm == null || !"M".equals(this.getCostElementType())) {
            return true;
        }
        MAcctSchema[] ass = MAcctSchema.getClientAcctSchema(this.getCtx(), this.getAD_Client_ID());
        int i = 0;
        while (i < ass.length) {
            if (ass[i].getCostingMethod().equals(this.getCostingMethod())) {
                this.log.saveError("CannotDeleteUsed", Msg.getElement(this.getCtx(), "C_AcctSchema_ID") + " - " + ass[i].getName());
                return false;
            }
            ++i;
        }
        int M_Product_Category_ID = 0;
        MProductCategoryAcct retValue = (MProductCategoryAcct)new Query(this.getCtx(), "M_Product_Category_Acct", "AD_Client_ID=? AND CostingMethod=?", null).setParameters(this.getAD_Client_ID(), this.getCostingMethod()).first();
        if (retValue != null) {
            M_Product_Category_ID = retValue.getM_Product_Category_ID();
        }
        if (M_Product_Category_ID != 0) {
            this.log.saveError("CannotDeleteUsed", Msg.getElement(this.getCtx(), "M_Product_Category_ID") + " (ID=" + M_Product_Category_ID + ")");
            return false;
        }
        return true;
    }

    public boolean isCostingMethod() {
        return "M".equals(this.getCostElementType()) && this.getCostingMethod() != null;
    }

    public boolean isAverageInvoice() {
        String cm = this.getCostingMethod();
        return cm != null && cm.equals("I") && "M".equals(this.getCostElementType());
    }

    public boolean isAveragePO() {
        String cm = this.getCostingMethod();
        return cm != null && cm.equals("A") && "M".equals(this.getCostElementType());
    }

    public boolean isFifo() {
        String cm = this.getCostingMethod();
        return cm != null && cm.equals("F") && "M".equals(this.getCostElementType());
    }

    public boolean isLastInvoice() {
        String cm = this.getCostingMethod();
        return cm != null && cm.equals("i") && "M".equals(this.getCostElementType());
    }

    public boolean isLastPOPrice() {
        String cm = this.getCostingMethod();
        return cm != null && cm.equals("p") && "M".equals(this.getCostElementType());
    }

    public boolean isLifo() {
        String cm = this.getCostingMethod();
        return cm != null && cm.equals("L") && "M".equals(this.getCostElementType());
    }

    public boolean isStandardCosting() {
        String cm = this.getCostingMethod();
        return cm != null && cm.equals("S") && "M".equals(this.getCostElementType());
    }

    public boolean isUserDefined() {
        String cm = this.getCostingMethod();
        return cm != null && cm.equals("U") && "M".equals(this.getCostElementType());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MCostElement[");
        sb.append(this.get_ID()).append("-").append(this.getName()).append(",Type=").append(this.getCostElementType()).append(",Method=").append(this.getCostingMethod()).append("]");
        return sb.toString();
    }

    @Override
    public MCostElement markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        return this;
    }
}

