/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.X_C_BP_Group;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.idempiere.cache.ImmutableIntPOCache;
import org.idempiere.cache.ImmutablePOSupport;
import org.idempiere.cache.IntPOCopyCache;

public class MBPGroup
extends X_C_BP_Group
implements ImmutablePOSupport {
    private static final long serialVersionUID = 1155912422087010656L;
    private static ImmutableIntPOCache<Integer, MBPGroup> s_cache = new ImmutableIntPOCache("C_BP_Group", 10);
    private static IntPOCopyCache<Integer, MBPGroup> s_cacheDefault = new IntPOCopyCache("C_BP_Group", MBPGroup.class.getName() + ".Default", 5);
    private static CLogger s_log = CLogger.getCLogger(MBPGroup.class);

    public static MBPGroup get(int C_BP_Group_ID) {
        return MBPGroup.get(Env.getCtx(), C_BP_Group_ID);
    }

    public static MBPGroup get(Properties ctx, int C_BP_Group_ID) {
        return MBPGroup.get(ctx, C_BP_Group_ID, null);
    }

    public static MBPGroup get(Properties ctx, int C_BP_Group_ID, String trxName) {
        Integer key = C_BP_Group_ID;
        MBPGroup retValue = s_cache.get(ctx, key, e -> new MBPGroup(ctx, (MBPGroup)e));
        if (retValue != null) {
            return retValue;
        }
        retValue = new MBPGroup(ctx, C_BP_Group_ID, trxName);
        if (retValue.get_ID() == C_BP_Group_ID) {
            s_cache.put(key, retValue, e -> new MBPGroup(Env.getCtx(), (MBPGroup)e));
            return retValue;
        }
        return null;
    }

    public static MBPGroup getCopy(Properties ctx, int C_BP_Group_ID, String trxName) {
        MBPGroup group = MBPGroup.get(ctx, C_BP_Group_ID, trxName);
        if (group != null) {
            group = new MBPGroup(ctx, group, trxName);
        }
        return group;
    }

    public static MBPGroup getDefault(Properties ctx) {
        MBPGroup retValue;
        int AD_Client_ID;
        block8: {
            AD_Client_ID = Env.getAD_Client_ID(ctx);
            Integer key = AD_Client_ID;
            retValue = s_cacheDefault.get(key, e -> new MBPGroup(ctx, (MBPGroup)e));
            if (retValue != null) {
                return retValue;
            }
            String sql = "SELECT * FROM C_BP_Group g WHERE IsDefault='Y' AND AD_Client_ID=? ORDER BY IsActive DESC";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, AD_Client_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next() && (retValue = new MBPGroup(ctx, rs, null)).get_ID() != 0) {
                        s_cacheDefault.put(key, retValue, e -> new MBPGroup(Env.getCtx(), (MBPGroup)e));
                    }
                }
                catch (Exception e2) {
                    s_log.log(Level.SEVERE, sql, e2);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (retValue == null) {
            s_log.warning("No Default BP Group for AD_Client_ID=" + AD_Client_ID);
        }
        return retValue;
    }

    public static MBPGroup getOfBPartner(Properties ctx, int C_BPartner_ID) {
        MBPGroup retValue;
        block7: {
            retValue = null;
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            String sql = "SELECT * FROM C_BP_Group g WHERE EXISTS (SELECT * FROM C_BPartner p WHERE p.C_BPartner_ID=? AND p.C_BP_Group_ID=g.C_BP_Group_ID)";
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, C_BPartner_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        retValue = new MBPGroup(ctx, rs, null);
                        Integer key = retValue.getC_BP_Group_ID();
                        if (retValue.get_ID() != 0) {
                            s_cache.put(key, retValue);
                        }
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return retValue;
    }

    public MBPGroup(Properties ctx, String C_BP_Group_UU, String trxName) {
        super(ctx, C_BP_Group_UU, trxName);
        if (Util.isEmpty(C_BP_Group_UU)) {
            this.setInitialDefaults();
        }
    }

    public MBPGroup(Properties ctx, int C_BP_Group_ID, String trxName) {
        super(ctx, C_BP_Group_ID, trxName);
        if (C_BP_Group_ID == 0) {
            this.setInitialDefaults();
        }
    }

    private void setInitialDefaults() {
        this.setIsConfidentialInfo(false);
        this.setIsDefault(false);
        this.setPriorityBase("S");
    }

    public MBPGroup(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MBPGroup(MBPGroup copy) {
        this(Env.getCtx(), copy);
    }

    public MBPGroup(Properties ctx, MBPGroup copy) {
        this(ctx, copy, null);
    }

    public MBPGroup(Properties ctx, MBPGroup copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
    }

    public MBPGroup(Properties ctx, int C_BP_Group_ID, String trxName, String ... virtualColumns) {
        super(ctx, C_BP_Group_ID, trxName, virtualColumns);
    }

    @Override
    public BigDecimal getCreditWatchPercent() {
        BigDecimal bd = super.getCreditWatchPercent();
        if (bd != null) {
            return bd;
        }
        return new BigDecimal(90);
    }

    public BigDecimal getCreditWatchRatio() {
        BigDecimal bd = super.getCreditWatchPercent();
        if (bd.compareTo(Env.ZERO) != 0) {
            return bd.divide(Env.ONEHUNDRED, 2, RoundingMode.HALF_UP);
        }
        return BigDecimal.valueOf(0.9);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (newRecord && success) {
            return this.insert_Accounting("C_BP_Group_Acct", "C_AcctSchema_Default", null);
        }
        return success;
    }

    @Override
    public MBPGroup markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        return this;
    }
}

