/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import javax.script.ScriptEngine;
import javax.swing.Icon;
import javax.swing.event.EventListenerList;
import org.adempiere.base.Core;
import org.adempiere.base.IColumnCallout;
import org.adempiere.model.MTabCustomization;
import org.adempiere.util.ContextRunnable;
import org.adempiere.util.ICalloutUI;
import org.compiere.Adempiere;
import org.compiere.model.Callout;
import org.compiere.model.DataStatusEvent;
import org.compiere.model.DataStatusListener;
import org.compiere.model.GridField;
import org.compiere.model.GridFieldVO;
import org.compiere.model.GridTabVO;
import org.compiere.model.GridTable;
import org.compiere.model.GridWindow;
import org.compiere.model.MAttachment;
import org.compiere.model.MChat;
import org.compiere.model.MColumn;
import org.compiere.model.MDocType;
import org.compiere.model.MImage;
import org.compiere.model.MImportTemplate;
import org.compiere.model.MLabelAssignment;
import org.compiere.model.MLookup;
import org.compiere.model.MPostIt;
import org.compiere.model.MPrivateAccess;
import org.compiere.model.MQuery;
import org.compiere.model.MRole;
import org.compiere.model.MRule;
import org.compiere.model.MStatusLine;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.model.MultiMap;
import org.compiere.model.PO;
import org.compiere.model.StateChangeEvent;
import org.compiere.model.StateChangeListener;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DefaultEvaluatee;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Evaluatee;
import org.compiere.util.Evaluator;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;

public class GridTab
implements DataStatusListener,
Evaluatee,
Serializable {
    private static final long serialVersionUID = 3039046293468517959L;
    public static final String DEFAULT_STATUS_MESSAGE = "NavigateOrUpdate";
    private ICalloutUI calloutUI;
    private GridTabVO m_vo;
    private GridWindow m_window;
    private GridTable m_mTable = null;
    private String m_keyColumnName = "";
    private String m_linkColumnName = "";
    private String m_parentColumnName = "";
    private String m_extendedWhere;
    private ArrayList<Integer> m_Lock = null;
    private int m_currentRow = -1;
    private PropertyChangeSupport m_propertyChangeSupport = new PropertyChangeSupport(this);
    public static final String PROPERTY = "CurrentRow";
    protected EventListenerList m_listenerList = new EventListenerList();
    private volatile DataStatusEvent m_DataStatusEvent = null;
    private MQuery m_query = new MQuery();
    private String m_oldQuery = "0=9";
    private String m_linkValue = "999999";
    private String[] m_OrderBys = new String[3];
    private ArrayList<String> m_parents = new ArrayList(2);
    private MultiMap<String, GridField> m_depOnField = new MultiMap();
    private Loader m_loader = null;
    private Future<?> m_loaderFuture = null;
    private volatile boolean m_loadComplete = false;
    private boolean m_included = false;
    private boolean m_includedAlreadyCalc = false;
    protected CLogger log = CLogger.getCLogger(this.getClass());
    private boolean m_parentNeedSave = false;
    private long m_lastDataStatusEventTime;
    private DataStatusEvent m_lastDataStatusEvent;
    private ArrayList<Integer> selection = null;
    public boolean isQuickForm = false;
    public static final String CTX_KeyColumnName = "_TabInfo_KeyColumnName";
    public static final String CTX_LinkColumnName = "_TabInfo_LinkColumnName";
    public static final String CTX_TabLevel = "_TabInfo_TabLevel";
    public static final String CTX_AccessLevel = "_TabInfo_AccessLevel";
    public static final String CTX_AD_Tab_ID = "_TabInfo_AD_Tab_ID";
    public static final String CTX_AD_Tab_UU = "_TabInfo_AD_Tab_UU";
    public static final String CTX_Name = "_TabInfo_Name";
    public static final String CTX_AD_Table_ID = "_TabInfo_AD_Table_ID";
    public static final String CTX_AD_Table_UU = "_TabInfo_AD_Table_UU";
    public static final String CTX_FindSQL = "_TabInfo_FindSQL";
    public static final String CTX_SQL = "_TabInfo_SQL";
    public static final String CTX_IsSortTab = "_TabInfo_IsSortTab";
    public static final String CTX_Record_ID = "_TabInfo_Record_ID";
    public static final String CTX_IsLookupOnlySelection = "_TabInfo_IsLookupOnlySelection";
    public static final String CTX_IsAllowAdvancedLookup = "_TabInfo_IsAllowAdvancedLookup";
    public static final int DEFAULT_GLOBAL_MAX_QUERY_RECORDS = 100000;
    private List<String> activeCallouts = new ArrayList<String>();
    private List<Callout> activeCalloutInstance = new ArrayList<Callout>();
    private boolean m_updateWindowContext = true;
    private int m_parentTabNo = -1;

    public GridTab(GridTabVO vo, GridWindow w) {
        this(vo, w, false);
    }

    public GridTab(GridTabVO vo, GridWindow w, boolean virtual) {
        this.m_window = w;
        this.m_vo = vo;
        this.m_mTable = new GridTable(this.m_vo.ctx, this.m_vo.AD_Table_ID, this.m_vo.TableName, this.m_vo.WindowNo, this.m_vo.TabNo, true, virtual);
        this.m_mTable.setReadOnly(this.m_vo.IsReadOnly || this.m_vo.IsView);
        this.m_mTable.setDeleteable(this.m_vo.IsDeleteable);
        this.selection = new ArrayList();
    }

    private void waitLoadCompete() {
        if (this.m_loaderFuture == null || this.m_loadComplete) {
            return;
        }
        this.log.config("");
        try {
            this.m_loaderFuture.get();
        }
        catch (InterruptedException e) {
            this.m_loaderFuture = null;
            this.log.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        catch (ExecutionException e) {
            this.m_loaderFuture = null;
            this.log.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        this.log.config("fini");
    }

    public boolean isLoadComplete() {
        return this.m_loadComplete;
    }

    public boolean initTab(boolean async) {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("#" + this.m_vo.TabNo + " - Async=" + async + " - Where=" + this.m_vo.WhereClause);
        }
        if (this.isLoadComplete()) {
            return true;
        }
        if (this.m_loaderFuture != null && this.m_loaderFuture.isDone()) {
            this.waitLoadCompete();
            if (this.isLoadComplete()) {
                return true;
            }
        }
        if (async) {
            this.m_loader = new Loader();
            this.m_loaderFuture = Adempiere.getThreadPoolExecutor().submit(this.m_loader);
            return false;
        }
        this.m_loaderFuture = null;
        return this.loadTab();
    }

    protected boolean loadTab() {
        this.m_extendedWhere = this.m_vo.WhereClause;
        if (!this.loadFields()) {
            this.m_loadComplete = true;
            return false;
        }
        this.m_mTable.setOrderClause(this.getOrderByClause(this.m_vo.onlyCurrentRows));
        this.m_loadComplete = true;
        return true;
    }

    protected void dispose() {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("#" + this.m_vo.TabNo);
        }
        this.m_OrderBys = null;
        this.m_parents.clear();
        this.m_parents = null;
        this.m_mTable.close(true);
        this.m_mTable = null;
        this.m_depOnField.clear();
        this.m_depOnField = null;
        if (this.m_vo.isInitFields()) {
            this.m_vo.getFields().clear();
        }
        this.m_vo = null;
        if (this.m_loader != null) {
            if (this.m_loaderFuture != null && !this.m_loaderFuture.isDone()) {
                this.m_loaderFuture.cancel(true);
            }
            this.m_loader = null;
            this.m_loaderFuture = null;
        }
    }

    private boolean loadFields() {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("#" + this.m_vo.TabNo);
        }
        if (this.m_vo.getFields() == null) {
            return false;
        }
        String uuidExpectedCol = PO.getUUIDColumnName(this.getTableName());
        String uuidColumnName = null;
        int f = 0;
        while (f < this.m_vo.getFields().size()) {
            GridFieldVO voF = this.m_vo.getFields().get(f);
            if (voF != null) {
                int sortNo;
                GridField field = new GridField(voF);
                field.setGridTab(this);
                String columnName = field.getColumnName();
                if (field.isKey()) {
                    this.setKeyColumnName(columnName);
                }
                if (uuidExpectedCol.equals(columnName)) {
                    uuidColumnName = columnName;
                }
                if (field.isParentColumn()) {
                    this.m_parents.add(columnName);
                }
                if ((sortNo = field.getSortNo()) != 0) {
                    if (Math.abs(sortNo) == 1) {
                        this.m_OrderBys[0] = columnName;
                        if (sortNo < 0) {
                            this.m_OrderBys[0] = String.valueOf(this.m_OrderBys[0]) + " DESC";
                        }
                    } else if (Math.abs(sortNo) == 2) {
                        this.m_OrderBys[1] = columnName;
                        if (sortNo < 0) {
                            this.m_OrderBys[1] = String.valueOf(this.m_OrderBys[1]) + " DESC";
                        }
                    } else if (Math.abs(sortNo) == 3) {
                        this.m_OrderBys[2] = columnName;
                        if (sortNo < 0) {
                            this.m_OrderBys[2] = String.valueOf(this.m_OrderBys[2]) + " DESC";
                        }
                    }
                }
                this.m_mTable.addField(field);
                ArrayList<String> list = field.getDependentOn();
                int i2 = 0;
                while (i2 < list.size()) {
                    this.m_depOnField.put(list.get(i2), field);
                    ++i2;
                }
                if (columnName.equals("IsActive") || columnName.equals("Processed") || columnName.equals("Processing")) {
                    this.m_depOnField.put(columnName, null);
                }
            }
            ++f;
        }
        if (Util.isEmpty(this.getKeyColumnName()) && this.getParentColumnNames().size() == 0 && uuidColumnName != null) {
            this.setKeyColumnName(uuidColumnName);
        }
        if (!this.m_mTable.getTableName().equals("AD_PInstance_Log")) {
            if (this.m_mTable.getField("Created") == null) {
                GridField created = new GridField(GridFieldVO.createStdField(this.m_vo.ctx, this.m_vo.WindowNo, this.m_vo.TabNo, this.m_vo.AD_Window_ID, this.m_vo.AD_Tab_ID, false, true, true));
                this.m_mTable.addField(created);
            }
            if (this.m_mTable.getField("CreatedBy") == null) {
                GridField createdBy = new GridField(GridFieldVO.createStdField(this.m_vo.ctx, this.m_vo.WindowNo, this.m_vo.TabNo, this.m_vo.AD_Window_ID, this.m_vo.AD_Tab_ID, false, true, false));
                this.m_mTable.addField(createdBy);
            }
            if (this.m_mTable.getField("Updated") == null) {
                GridField updated = new GridField(GridFieldVO.createStdField(this.m_vo.ctx, this.m_vo.WindowNo, this.m_vo.TabNo, this.m_vo.AD_Window_ID, this.m_vo.AD_Tab_ID, false, false, true));
                this.m_mTable.addField(updated);
            }
            if (this.m_mTable.getField("UpdatedBy") == null) {
                GridField updatedBy = new GridField(GridFieldVO.createStdField(this.m_vo.ctx, this.m_vo.WindowNo, this.m_vo.TabNo, this.m_vo.AD_Window_ID, this.m_vo.AD_Tab_ID, false, false, false));
                this.m_mTable.addField(updatedBy);
            }
        }
        return true;
    }

    public ArrayList<String> getDependentOn() {
        ArrayList<String> list = new ArrayList<String>();
        Evaluator.parseDepends(list, this.m_vo.DisplayLogic);
        if (list.size() > 0 && CLogMgt.isLevelFiner()) {
            StringBuilder sb = new StringBuilder();
            int i2 = 0;
            while (i2 < list.size()) {
                sb.append(list.get(i2)).append(" ");
                ++i2;
            }
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer("(" + this.m_vo.Name + ") " + sb.toString());
            }
        }
        return list;
    }

    public String getDisplayLogic() {
        return this.m_vo.DisplayLogic;
    }

    public GridTable getTableModel() {
        if (!this.m_loadComplete) {
            this.initTab(false);
        }
        return this.m_mTable;
    }

    public Icon getIcon() {
        if (this.m_vo.AD_Image_ID == 0) {
            return null;
        }
        MImage mImage = MImage.get(this.m_vo.ctx, this.m_vo.AD_Image_ID);
        return mImage.getIcon();
    }

    public boolean hasDependants(String columnName) {
        return this.m_depOnField.containsKey(columnName);
    }

    public ArrayList<GridField> getDependantFields(String columnName) {
        return this.m_depOnField.getValues(columnName);
    }

    public void setQuery(MQuery query) {
        this.m_query = query == null ? new MQuery() : query;
    }

    public MQuery getQuery() {
        return this.m_query;
    }

    public boolean isQueryActive() {
        if (this.m_query != null) {
            return this.m_query.isActive();
        }
        return false;
    }

    public boolean isQueryNewRecord() {
        if (this.m_query != null) {
            return this.m_query.isNewRecordQuery();
        }
        return false;
    }

    public void enableEvents() {
        this.m_mTable.addDataStatusListener(this);
    }

    public String getTabType() {
        return this.m_vo.AD_TabType;
    }

    public void query(boolean onlyCurrentRows) {
        this.query(onlyCurrentRows, 0, 0);
    }

    public void query(boolean onlyCurrentRows, int onlyCurrentDays, int maxRows) {
        String q;
        if (!this.m_loadComplete) {
            this.initTab(false);
        }
        Env.clearTabContext(this.m_vo.ctx, this.m_vo.WindowNo, this.m_vo.TabNo);
        this.selection.clear();
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("#" + this.m_vo.TabNo + " - Only Current Rows=" + onlyCurrentRows + ", Days=" + onlyCurrentDays + ", Detail=" + this.isDetail());
        }
        this.m_oldQuery = this.m_query.getWhereClause();
        this.m_vo.onlyCurrentRows = onlyCurrentRows;
        this.m_vo.onlyCurrentDays = onlyCurrentDays;
        StringBuilder where = new StringBuilder(this.m_vo.WhereClause);
        if (this.m_vo.onlyCurrentDays > 0) {
            if (where.length() > 0) {
                where.append(" AND ");
            }
            where.append("Created >= ");
            where.append("getDate()-").append(this.m_vo.onlyCurrentDays);
        }
        if (this.isDetail()) {
            this.m_parentNeedSave = false;
            String lc = this.getLinkColumnName();
            if (lc.equals("")) {
                this.log.warning("No link column");
                where.append(" 2=3");
            } else {
                String value = null;
                if (this.m_parentColumnName.length() > 0) {
                    value = Env.getContext(this.m_vo.ctx, this.m_vo.WindowNo, this.getParentTabNo(), this.m_parentColumnName, true);
                    if (value == null || value.length() == 0) {
                        value = Env.getContext(this.m_vo.ctx, this.m_vo.WindowNo, this.m_parentColumnName, true);
                    }
                } else {
                    value = Env.getContext(this.m_vo.ctx, this.m_vo.WindowNo, this.getParentTabNo(), lc, true);
                    if (value == null || value.length() == 0) {
                        value = Env.getContext(this.m_vo.ctx, this.m_vo.WindowNo, lc, true);
                    }
                }
                if (!this.m_linkValue.equals(value)) {
                    this.setQuery(null);
                }
                this.m_linkValue = value;
                if (value.length() == 0) {
                    this.m_parentNeedSave = true;
                    if (where.length() != 0) {
                        where.append(" AND ");
                    }
                    where.append(" 2=3");
                } else {
                    if (where.length() != 0) {
                        where.append(" AND ");
                    }
                    where.append(this.getTableName()).append(".").append(lc).append("=");
                    if (lc.endsWith("_ID")) {
                        where.append(DB.TO_NUMBER(new BigDecimal(value), 13));
                    } else {
                        where.append(DB.TO_STRING(value));
                    }
                }
            }
        }
        this.m_extendedWhere = where.toString();
        if (this.m_query.isActive() && (q = this.validateQuery(this.m_query)) != null) {
            if (where.length() > 0) {
                where.append(" AND ");
            }
            where.append(" (").append(q).append(")");
        }
        this.m_currentRow = -1;
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("#" + this.m_vo.TabNo + " - " + String.valueOf(where));
        }
        if (this.m_mTable.isOpen()) {
            this.m_mTable.dataRequery(where.toString(), this.m_vo.onlyCurrentRows && !this.isDetail(), onlyCurrentDays);
        } else {
            this.m_mTable.setSelectWhereClause(where.toString(), this.m_vo.onlyCurrentRows && !this.isDetail(), onlyCurrentDays);
            this.m_mTable.open(maxRows);
        }
        this.setCurrentRow(0, true);
        this.fireStateChangeEvent(new StateChangeEvent(this, 6));
    }

    public void resetDetailForNewParentRecord() {
        if (this.m_mTable.isOpen()) {
            String where;
            this.m_extendedWhere = where = "2=3";
            this.m_oldQuery = where;
            this.m_parentNeedSave = true;
            this.m_currentRow = -1;
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("#" + this.m_vo.TabNo + " - " + where);
            }
            this.m_mTable.dataRequery(where, this.m_vo.onlyCurrentRows && !this.isDetail(), 0);
            this.setCurrentRow(0, true);
        }
    }

    private String validateQuery(MQuery query) {
        if (query == null || query.getRestrictionCount() == 0) {
            return null;
        }
        if (query.getRestrictionCount() != 1) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Ignored(More than 1 Restriction): " + String.valueOf(query));
            }
            return query.getWhereClause(true);
        }
        String colName = query.getColumnName(0);
        if (colName == null) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Ignored(No Column): " + String.valueOf(query));
            }
            return query.getWhereClause(true);
        }
        if (colName.indexOf(40) != -1) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Ignored(Function): " + colName);
            }
            return query.getWhereClause(true);
        }
        if (this.getField(colName) != null) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Field Found: " + colName);
            }
            return query.getWhereClause(true);
        }
        String refColName = DB.getSQLValueStringEx(null, "SELECT cc.ColumnName FROM AD_Column c INNER JOIN AD_Ref_Table r ON (c.AD_Reference_Value_ID=r.AD_Reference_ID) INNER JOIN AD_Column cc ON (r.AD_Key=cc.AD_Column_ID) WHERE c.AD_Reference_ID IN (?,?,?,?) AND c.ColumnName=?", 18, 30, 200233, 200235, colName);
        if (refColName != null) {
            query.setColumnName(0, refColName);
            if (this.getField(refColName) != null) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Column " + colName + " replaced with " + refColName);
                }
                return query.getWhereClause(true);
            }
            colName = refColName;
        }
        String tabKeyColumn = this.getKeyColumnName();
        String tableName = DB.getSQLValueStringEx(null, "SELECT t.TableName FROM AD_Column c INNER JOIN AD_Table t ON (c.AD_Table_ID=t.AD_Table_ID) WHERE c.ColumnName=? AND IsKey='Y' AND EXISTS (SELECT * FROM AD_Column cc WHERE cc.AD_Table_ID=t.AD_Table_ID AND cc.ColumnName=?)", colName, tabKeyColumn);
        if (tabKeyColumn.equals("AD_Reference_ID")) {
            int AD_Reference_ID = DB.getSQLValueEx(null, "SELECT AD_Reference_ID FROM AD_Column WHERE ColumnName=?", colName);
            return "AD_Reference_ID=" + AD_Reference_ID;
        }
        if (tableName == null) {
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("Not successful - Column=" + colName + ", Key=" + tabKeyColumn + ", Query=" + String.valueOf(query));
            }
            return query.getWhereClause(true);
        }
        query.setTableName("xx");
        StringBuilder result = new StringBuilder(this.getTableName()).append(".").append(tabKeyColumn).append(" IN (SELECT xx.").append(tabKeyColumn).append(" FROM ").append(tableName).append(" xx WHERE ").append(query.getWhereClause(true)).append(")");
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(result.toString());
        }
        return result.toString();
    }

    public void dataRefreshAll() {
        this.dataRefreshAll(true);
    }

    public void dataRefreshAll(boolean fireEvent) {
        this.dataRefreshAll(fireEvent, false);
    }

    public void dataRefreshAll(boolean fireEvent, boolean retainedCurrentRow) {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("#" + this.m_vo.TabNo);
        }
        this.selection.clear();
        int keyNo = this.m_mTable.getKeyID(this.m_currentRow);
        UUID uuid = null;
        if (keyNo == -1) {
            uuid = this.m_mTable.getUUID(this.m_currentRow);
        }
        this.m_mTable.dataRefreshAll(fireEvent, retainedCurrentRow ? this.m_currentRow : -1);
        if ((keyNo != -1 || uuid != null) && (keyNo != -1 && keyNo != this.m_mTable.getKeyID(this.m_currentRow) || uuid != null && this.m_mTable.getUUID(this.m_currentRow) == null || uuid != null && uuid.compareTo(this.m_mTable.getUUID(this.m_currentRow)) != 0)) {
            int size = this.getRowCount();
            int i2 = 0;
            while (i2 < size) {
                if (keyNo != -1 && keyNo == this.m_mTable.getKeyID(i2) || uuid != null && this.m_mTable.getUUID(i2) != null && uuid.compareTo(this.m_mTable.getUUID(i2)) == 0) {
                    this.m_currentRow = i2;
                    break;
                }
                ++i2;
            }
        }
        this.setCurrentRow(this.m_currentRow, fireEvent);
        if (fireEvent) {
            this.fireStateChangeEvent(new StateChangeEvent(this, 0));
        }
    }

    public void dataRefresh() {
        this.dataRefresh(true);
    }

    public void dataRefresh(boolean fireEvent) {
        this.dataRefresh(this.m_currentRow, fireEvent);
    }

    public void dataRefresh(int row) {
        this.dataRefresh(row, true);
    }

    public void dataRefresh(int row, boolean fireEvent) {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("#" + this.m_vo.TabNo + " - row=" + row);
        }
        this.m_mTable.dataRefresh(row, fireEvent);
        this.setCurrentRow(row, fireEvent);
        if (fireEvent) {
            this.fireStateChangeEvent(new StateChangeEvent(this, 1));
        }
    }

    public boolean dataSave(boolean manualCmd) {
        boolean retValue;
        block6: {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("#" + this.m_vo.TabNo + " - row=" + this.m_currentRow);
            }
            try {
                if (!this.hasChangedCurrentTabAndParents()) break block6;
                return false;
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "#" + this.m_vo.TabNo + " - row=" + this.m_currentRow, e);
                return false;
            }
        }
        boolean bl = retValue = this.m_mTable.dataSave(manualCmd) == 'O';
        if (manualCmd) {
            this.setCurrentRow(this.m_currentRow, false);
            if (this.m_lastDataStatusEvent != null && this.m_lastDataStatusEvent.getCurrentRow() == this.m_currentRow && (this.m_lastDataStatusEvent.Record_ID != null && this.m_lastDataStatusEvent.Record_ID instanceof Integer && (Integer)this.m_lastDataStatusEvent.Record_ID == 0 || this.m_lastDataStatusEvent.Record_ID == null)) {
                this.updateDataStatusEventProperties(this.m_lastDataStatusEvent);
            }
        }
        this.fireStateChangeEvent(new StateChangeEvent(this, 4));
        return retValue;
    }

    public boolean isNeedSaveAndMandatoryFill() {
        return this.m_mTable.isNeedSaveAndMandatoryFill();
    }

    public boolean hasChangedCurrentTabAndParents() {
        Object msg = null;
        if (this.m_mTable.hasChanged(this.m_currentRow)) {
            msg = Msg.getMsg(Env.getCtx(), "CurrentRecordModified");
            this.log.saveError("CurrentRecordModified", (String)msg, false);
            return true;
        }
        if (this.isDetail()) {
            int level = this.m_vo.TabLevel;
            int i2 = this.m_window.getTabIndex(this) - 1;
            while (i2 >= 0) {
                GridTab parentTab = this.m_window.getTab(i2);
                if (parentTab.m_vo.TabLevel == level - 1) {
                    if (parentTab.m_mTable.hasChanged(parentTab.m_currentRow)) {
                        msg = Msg.getMsg(Env.getCtx(), "ParentRecordModified") + ": " + parentTab.getName();
                        this.log.saveError("ParentRecordModified", (String)msg, false);
                        return true;
                    }
                    if (!parentTab.isDetail()) break;
                    level = parentTab.m_vo.TabLevel;
                }
                --i2;
            }
        }
        return false;
    }

    public void refreshParentTabs() {
        this.refreshParentTabs(false);
    }

    public void refreshParentTabs(boolean fireParentEvent) {
        if (this.isDetail()) {
            int level = this.m_vo.TabLevel;
            int i2 = this.m_window.getTabIndex(this) - 1;
            while (i2 >= 0) {
                GridTab parentTab = this.m_window.getTab(i2);
                if (parentTab.m_vo.TabLevel == level - 1) {
                    parentTab.dataRefresh(fireParentEvent);
                    if (!parentTab.isDetail()) break;
                    level = parentTab.m_vo.TabLevel;
                }
                --i2;
            }
        }
    }

    public boolean needSave(boolean rowChange, boolean onlyRealChange) {
        if (rowChange) {
            return this.m_mTable.needSave(-2, onlyRealChange);
        }
        if (onlyRealChange) {
            return this.m_mTable.needSave();
        }
        return this.m_mTable.needSave(onlyRealChange);
    }

    public void dataIgnore() {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("#" + this.m_vo.TabNo);
        }
        if (!this.m_mTable.isOpen()) {
            return;
        }
        if (this.m_mTable.isInserting()) {
            --this.m_currentRow;
        }
        this.m_mTable.dataIgnore();
        this.setCurrentRow(this.m_currentRow, false);
        this.fireStateChangeEvent(new StateChangeEvent(this, 5));
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("#" + this.m_vo.TabNo + "- fini");
        }
    }

    public boolean dataNew(boolean copy) {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("#" + this.m_vo.TabNo);
        }
        if (!this.isInsertRecord()) {
            this.log.warning("Insert Not allowed in TabNo=" + this.m_vo.TabNo);
            return false;
        }
        if (this.isDetail() && this.m_parentNeedSave) {
            return false;
        }
        if (!this.selection.isEmpty()) {
            this.clearSelection();
        }
        int oldCurrentRow = this.m_currentRow++;
        boolean retValue = this.m_mTable.dataNew(oldCurrentRow, copy);
        this.m_currentRow = oldCurrentRow;
        if (!retValue) {
            return retValue;
        }
        this.setCurrentRow(this.m_currentRow + 1, true);
        int i2 = 0;
        while (i2 < this.getFieldCount()) {
            this.processCallout(this.getField(i2));
            ++i2;
        }
        this.m_mTable.setChanged(false);
        this.fireStateChangeEvent(new StateChangeEvent(this, 2));
        return retValue;
    }

    public boolean dataDelete() {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("#" + this.m_vo.TabNo + " - row=" + this.m_currentRow);
        }
        boolean retValue = this.m_mTable.dataDelete(this.m_currentRow);
        this.setCurrentRow(this.m_currentRow, true);
        if (!this.selection.isEmpty()) {
            ArrayList<Integer> tmp = new ArrayList<Integer>();
            for (Integer i2 : this.selection) {
                if (i2 == this.m_currentRow) continue;
                if (i2 > this.m_currentRow) {
                    tmp.add(i2 - 1);
                    continue;
                }
                tmp.add(i2);
            }
        }
        this.fireStateChangeEvent(new StateChangeEvent(this, 3));
        return retValue;
    }

    public String getName() {
        return this.m_vo.Name;
    }

    public String getDescription() {
        return this.m_vo.Description;
    }

    public String getHelp() {
        return this.m_vo.Help;
    }

    public int getTabLevel() {
        return this.m_vo.TabLevel;
    }

    public String getCommitWarning() {
        return this.m_vo.CommitWarning;
    }

    protected GridTable getMTable() {
        return this.m_mTable;
    }

    public String getKeyColumnName() {
        return this.m_keyColumnName;
    }

    public int getKeyColumnIndex() {
        return this.m_mTable.getKeyColumnIndex();
    }

    private void setKeyColumnName(String keyColumnName) {
        this.m_keyColumnName = keyColumnName;
        Env.setContext(this.m_vo.ctx, this.m_vo.WindowNo, this.m_vo.TabNo, CTX_KeyColumnName, this.m_keyColumnName);
    }

    public String getLinkColumnName() {
        return this.m_linkColumnName;
    }

    public void setLinkColumnName(String linkColumnName) {
        if (this.m_vo.Parent_Column_ID > 0) {
            this.m_parentColumnName = MColumn.getColumnName(this.m_vo.ctx, this.m_vo.Parent_Column_ID);
        }
        if (this.m_parentColumnName == null) {
            this.m_parentColumnName = "";
        }
        if (linkColumnName != null) {
            this.m_linkColumnName = linkColumnName;
        } else {
            if (this.m_vo.AD_Column_ID == 0) {
                return;
            }
            this.m_linkColumnName = MColumn.getColumnName(this.m_vo.ctx, this.m_vo.AD_Column_ID);
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("AD_Column_ID=" + this.m_vo.AD_Column_ID + " - " + this.m_linkColumnName);
            }
        }
        Env.setContext(this.m_vo.ctx, this.m_vo.WindowNo, this.m_vo.TabNo, CTX_LinkColumnName, this.m_linkColumnName);
    }

    public boolean isCurrent() {
        if (!this.m_mTable.isOpen()) {
            return false;
        }
        if (!this.m_oldQuery.equals(this.m_query.getWhereClause())) {
            return false;
        }
        if (!this.isDetail()) {
            return true;
        }
        String columnName = Util.isEmpty(this.m_parentColumnName) ? this.getLinkColumnName() : this.m_parentColumnName;
        String value = Env.getContext(this.m_vo.ctx, this.m_vo.WindowNo, this.getParentTabNo(), columnName);
        return this.m_linkValue.equals(value);
    }

    public boolean isOpen() {
        if (this.m_mTable != null) {
            return this.m_mTable.isOpen();
        }
        return false;
    }

    @Deprecated
    public boolean isIncluded() {
        if (!this.m_includedAlreadyCalc) {
            this.m_included = false;
            if (this.getParentTab() != null) {
                for (GridTab tab : this.getParentTab().getIncludedTabs()) {
                    if (!tab.equals(this)) continue;
                    this.m_included = true;
                    break;
                }
            }
            this.m_includedAlreadyCalc = true;
        }
        return this.m_included;
    }

    @Deprecated
    public void setIncluded(boolean isIncluded) {
        this.m_included = isIncluded;
    }

    public boolean isOnlyCurrentRows() {
        return this.m_vo.onlyCurrentRows;
    }

    public ArrayList<String> getParentColumnNames() {
        return this.m_parents;
    }

    public boolean isDetail() {
        if (this.m_vo.TabLevel == 0) {
            return false;
        }
        return this.m_parents.size() > 0 || this.m_vo.AD_Column_ID != 0;
    }

    public boolean isPrinted() {
        return this.m_vo.AD_Process_ID != 0;
    }

    public int getWindowNo() {
        return this.m_vo.WindowNo;
    }

    public int getTabNo() {
        return this.m_vo.TabNo;
    }

    public int getAD_Process_ID() {
        return this.m_vo.AD_Process_ID;
    }

    public boolean isHighVolume() {
        return this.m_vo.IsHighVolume;
    }

    public boolean IsLookupOnlySelection() {
        return this.m_vo.IsLookupOnlySelection;
    }

    public boolean IsAllowAdvancedLookup() {
        return this.m_vo.IsAllowAdvancedLookup;
    }

    public boolean isReadOnly() {
        if (this.m_vo.IsReadOnly) {
            return true;
        }
        if (this.m_parentNeedSave) {
            return true;
        }
        if (this.m_vo.ReadOnlyLogic == null || this.m_vo.ReadOnlyLogic.equals("")) {
            return this.m_vo.IsReadOnly;
        }
        boolean retValue = Evaluator.evaluateLogic(this, this.m_vo.ReadOnlyLogic);
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest(this.m_vo.Name + " (" + this.m_vo.ReadOnlyLogic + ") => " + retValue);
        }
        return retValue;
    }

    public boolean isAlwaysUpdateField() {
        int i2 = 0;
        while (i2 < this.m_mTable.getColumnCount()) {
            GridField field = this.m_mTable.getField(i2);
            if (field.isAlwaysUpdateable()) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public boolean isInsertRecord() {
        if (this.isReadOnly()) {
            return false;
        }
        return this.m_vo.IsInsertRecord;
    }

    public boolean isDeleteRecord() {
        if (this.isReadOnly()) {
            return false;
        }
        return this.m_vo.IsDeleteable;
    }

    public boolean isDisplayed() {
        String dl = this.m_vo.DisplayLogic;
        if (dl == null || dl.equals("")) {
            return true;
        }
        boolean retValue = Evaluator.evaluateLogic(this, dl);
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config(this.m_vo.Name + " (" + dl + ") => " + retValue);
        }
        return retValue;
    }

    @Override
    public String get_ValueAsString(String variableName) {
        return this.get_ValueAsString(this.m_vo.ctx, variableName);
    }

    public String get_ValueAsString(Properties ctx, String variableName) {
        return new DefaultEvaluatee(this, this.m_vo.WindowNo, this.m_vo.TabNo).get_ValueAsString(ctx, variableName);
    }

    public boolean isSingleRow() {
        MTabCustomization tabcust = MTabCustomization.get(Env.getCtx(), Env.getAD_User_ID(Env.getCtx()), this.getAD_Tab_ID(), null);
        if (tabcust != null && tabcust.getIsDisplayedGrid() != null) {
            return "N".equals(tabcust.getIsDisplayedGrid());
        }
        return this.m_vo.IsSingleRow;
    }

    public void setSingleRow(boolean isSingleRow) {
        this.m_vo.IsSingleRow = isSingleRow;
    }

    public boolean isTreeTab() {
        return this.m_vo.HasTree;
    }

    public String getTreeDisplayedOn() {
        return this.m_vo.TreeDisplayedOn;
    }

    public int getAD_Tab_ID() {
        return this.m_vo.AD_Tab_ID;
    }

    public int getAD_Table_ID() {
        return this.m_vo.AD_Table_ID;
    }

    public int getAD_Window_ID() {
        return this.m_vo.AD_Window_ID;
    }

    @Deprecated
    public int getIncluded_Tab_ID() {
        return this.m_vo.Included_Tab_ID;
    }

    public String getTableName() {
        return this.m_vo.TableName;
    }

    public String getWhereClause() {
        return this.m_vo.WhereClause;
    }

    public boolean isSortTab() {
        return this.m_vo.IsSortTab;
    }

    public int getAD_ColumnSortOrder_ID() {
        return this.m_vo.AD_ColumnSortOrder_ID;
    }

    public int getAD_ColumnSortYesNo_ID() {
        return this.m_vo.AD_ColumnSortYesNo_ID;
    }

    public String getWhereExtended() {
        return this.m_extendedWhere;
    }

    private String getOrderByClause(boolean onlyCurrentRows) {
        if (this.m_vo.OrderByClause.length() > 0) {
            String orderBy = Env.parseContext(this.m_vo.ctx, this.m_vo.WindowNo, this.m_vo.OrderByClause, false, false);
            return orderBy;
        }
        this.m_vo.OrderByClause = "";
        int i2 = 0;
        while (i2 < 3) {
            String order = this.m_OrderBys[i2];
            if (order != null && order.length() > 0) {
                if (this.m_vo.OrderByClause.length() > 0) {
                    this.m_vo.OrderByClause = String.valueOf(this.m_vo.OrderByClause) + ",";
                }
                this.m_vo.OrderByClause = String.valueOf(this.m_vo.OrderByClause) + order;
            }
            ++i2;
        }
        if (this.m_vo.OrderByClause.length() > 0) {
            return this.m_vo.OrderByClause;
        }
        this.m_vo.OrderByClause = "Created";
        if (onlyCurrentRows && !this.isDetail()) {
            this.m_vo.OrderByClause = String.valueOf(this.m_vo.OrderByClause) + " DESC";
        }
        return this.m_vo.OrderByClause;
    }

    public String getTrxInfo() {
        if (this.m_vo.TableName.startsWith("C_InvoiceBatch")) {
            boolean filled;
            Object[] arguments;
            MessageFormat mf;
            block36: {
                int Record_ID = Env.getContextAsInt(this.m_vo.ctx, this.m_vo.WindowNo, "C_InvoiceBatch_ID");
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine(this.m_vo.TableName + " - " + Record_ID);
                }
                mf = null;
                try {
                    mf = new MessageFormat(Msg.getMsg(Env.getAD_Language(this.m_vo.ctx), "InvoiceBatchSummary"), Env.getLanguage(this.m_vo.ctx).getLocale());
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "InvoiceBatchSummary=" + Msg.getMsg(Env.getAD_Language(this.m_vo.ctx), "InvoiceBatchSummary"), e);
                }
                if (mf == null) {
                    return " ";
                }
                arguments = new Object[3];
                filled = false;
                String sql = "SELECT COUNT(*), NVL(SUM(LineNetAmt),0), NVL(SUM(LineTotalAmt),0) FROM C_InvoiceBatchLine WHERE C_InvoiceBatch_ID=? AND IsActive='Y'";
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement(sql, null);
                        pstmt.setInt(1, Record_ID);
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            Integer lines = rs.getInt(1);
                            arguments[0] = lines;
                            Double net = rs.getDouble(2);
                            arguments[1] = net;
                            Double total = rs.getDouble(3);
                            arguments[2] = total;
                            filled = true;
                        }
                    }
                    catch (SQLException e) {
                        this.log.log(Level.SEVERE, this.m_vo.TableName + "\nSQL=" + sql, e);
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                        break block36;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
            if (filled) {
                return mf.format(arguments);
            }
            return " ";
        }
        if (this.m_vo.TableName.startsWith("C_Order") || this.m_vo.TableName.startsWith("C_Invoice")) {
            boolean filled;
            Object[] arguments;
            MessageFormat mf;
            block38: {
                int Record_ID;
                boolean isOrder = this.m_vo.TableName.startsWith("C_Order");
                StringBuilder sql = new StringBuilder("SELECT COUNT(*) AS Lines,c.ISO_Code,o.TotalLines,o.GrandTotal,currencyBase(o.GrandTotal,o.C_Currency_ID,o.DateAcct, o.AD_Client_ID,o.AD_Org_ID) AS ConvAmt ");
                if (isOrder) {
                    Record_ID = Env.getContextAsInt(this.m_vo.ctx, this.m_vo.WindowNo, "C_Order_ID");
                    sql.append("FROM C_Order o INNER JOIN C_Currency c ON (o.C_Currency_ID=c.C_Currency_ID) INNER JOIN C_OrderLine l ON (o.C_Order_ID=l.C_Order_ID) WHERE o.C_Order_ID=? ");
                } else {
                    Record_ID = Env.getContextAsInt(this.m_vo.ctx, this.m_vo.WindowNo, "C_Invoice_ID");
                    sql.append("FROM C_Invoice o INNER JOIN C_Currency c ON (o.C_Currency_ID=c.C_Currency_ID) INNER JOIN C_InvoiceLine l ON (o.C_Invoice_ID=l.C_Invoice_ID) WHERE o.C_Invoice_ID=? ");
                }
                sql.append(" GROUP BY o.C_Currency_ID, c.ISO_Code, o.TotalLines, o.GrandTotal, o.DateAcct, o.AD_Client_ID, o.AD_Org_ID");
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine(this.m_vo.TableName + " - " + Record_ID);
                }
                mf = null;
                try {
                    mf = new MessageFormat(Msg.getMsg(Env.getAD_Language(this.m_vo.ctx), "OrderSummary"), Env.getLanguage(this.m_vo.ctx).getLocale());
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "OrderSummary=" + Msg.getMsg(Env.getAD_Language(this.m_vo.ctx), "OrderSummary"), e);
                }
                if (mf == null) {
                    return " ";
                }
                arguments = new Object[5];
                filled = false;
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement(sql.toString(), null);
                        pstmt.setInt(1, Record_ID);
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            Integer lines = rs.getInt(1);
                            arguments[0] = lines;
                            Double lineTotal = rs.getDouble(3);
                            arguments[1] = lineTotal;
                            Double grandTotal = rs.getDouble(4);
                            arguments[2] = grandTotal;
                            String currency = rs.getString(2);
                            arguments[3] = currency;
                            Double grandEuro = rs.getDouble(5);
                            arguments[4] = grandEuro;
                            filled = true;
                        }
                    }
                    catch (SQLException e) {
                        this.log.log(Level.SEVERE, this.m_vo.TableName + "\nSQL=" + String.valueOf(sql), e);
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                        break block38;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
            if (filled) {
                return mf.format(arguments);
            }
            return " ";
        }
        if (this.m_vo.TableName.startsWith("S_TimeExpense") && this.m_vo.TabNo == 0) {
            boolean filled;
            Object[] arguments;
            MessageFormat mf;
            block40: {
                int Record_ID = Env.getContextAsInt(this.m_vo.ctx, this.m_vo.WindowNo, "S_TimeExpense_ID");
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine(this.m_vo.TableName + " - " + Record_ID);
                }
                mf = null;
                try {
                    mf = new MessageFormat(Msg.getMsg(Env.getAD_Language(this.m_vo.ctx), "ExpenseSummary"), Env.getLanguage(this.m_vo.ctx).getLocale());
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "ExpenseSummary=" + Msg.getMsg(Env.getAD_Language(this.m_vo.ctx), "ExpenseSummary"), e);
                }
                if (mf == null) {
                    return " ";
                }
                arguments = new Object[3];
                filled = false;
                String SQL = "SELECT COUNT(*) AS Lines, SUM(ConvertedAmt*Qty) FROM S_TimeExpenseLine WHERE S_TimeExpense_ID=?";
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement(SQL, null);
                        pstmt.setInt(1, Record_ID);
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            Integer lines = rs.getInt(1);
                            arguments[0] = lines;
                            Double total = rs.getDouble(2);
                            arguments[1] = total;
                            arguments[2] = " ";
                            filled = true;
                        }
                    }
                    catch (SQLException e) {
                        this.log.log(Level.SEVERE, this.m_vo.TableName + "\nSQL=" + SQL, e);
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                        break block40;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
            if (filled) {
                return mf.format(arguments);
            }
            return " ";
        }
        return null;
    }

    public String getStatusLine() {
        MStatusLine sl = MStatusLine.getSL(this.getAD_Window_ID(), this.getAD_Tab_ID(), this.getAD_Table_ID());
        if (sl != null) {
            String line = sl.parseLine(this.getWindowNo());
            return line;
        }
        return null;
    }

    public String getStatusLinesWidget() {
        MStatusLine[] wls = MStatusLine.getStatusLinesWidget(this.getAD_Window_ID(), this.getAD_Tab_ID(), this.getAD_Table_ID());
        if (wls != null && wls.length > 0) {
            StringBuilder lines = new StringBuilder();
            MStatusLine[] mStatusLineArray = wls;
            int n = wls.length;
            int n2 = 0;
            while (n2 < n) {
                MStatusLine wl = mStatusLineArray[n2];
                String line = wl.parseLine(this.getWindowNo());
                if (line != null) {
                    lines.append(line).append("<br>");
                }
                ++n2;
            }
            if (lines.length() > 0) {
                return lines.toString();
            }
        }
        return null;
    }

    private void loadDependentInfo() {
        block19: {
            if (this.m_vo.TableName.equals("C_Order")) {
                int C_DocTyp_ID = 0;
                Integer target = (Integer)this.getValue("C_DocTypeTarget_ID");
                if (target != null) {
                    C_DocTyp_ID = target;
                }
                if (C_DocTyp_ID == 0) {
                    return;
                }
                String sql = "SELECT DocSubTypeSO FROM C_DocType WHERE C_DocType_ID=?";
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement(sql, null);
                        pstmt.setInt(1, C_DocTyp_ID);
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            Env.setContext(this.m_vo.ctx, this.m_vo.WindowNo, "OrderType", rs.getString(1));
                        }
                    }
                    catch (SQLException e) {
                        this.log.log(Level.SEVERE, sql, e);
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                        break block19;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
        }
        if (this.m_vo.TableName.equals("C_BPartner_Location")) {
            Integer location_int = (Integer)this.getValue("C_Location_ID");
            String phone_frm = null;
            if (location_int != null) {
                phone_frm = DB.getSQLValueString(null, "SELECT ExpressionPhone FROM C_Country c, C_Location l WHERE c.C_Country_ID = l.C_Country_ID AND l.C_location_ID = ?", location_int);
            }
            GridField fPhone = this.getField("Phone");
            MColumn colPhone = null;
            if (fPhone != null) {
                colPhone = MColumn.get(Env.getCtx(), fPhone.getAD_Column_ID());
            }
            GridField fPhone2 = this.getField("Phone2");
            MColumn colPhone2 = null;
            if (fPhone2 != null) {
                colPhone2 = MColumn.get(Env.getCtx(), fPhone2.getAD_Column_ID());
            }
            GridField fFax = this.getField("Fax");
            MColumn colFax = null;
            if (fFax != null) {
                colFax = MColumn.get(Env.getCtx(), fFax.getAD_Column_ID());
            }
            if (colPhone != null && (colPhone.getVFormat() == null || colPhone.getVFormat().length() == 0)) {
                fPhone.setVFormat(phone_frm);
            }
            if (colPhone2 != null && (colPhone2.getVFormat() == null || colPhone2.getVFormat().length() == 0)) {
                fPhone2.setVFormat(phone_frm);
            }
            if (colFax != null && (colFax.getVFormat() == null || colFax.getVFormat().length() == 0)) {
                fFax.setVFormat(phone_frm);
            }
        }
        GridField[] gridFieldArray = this.getFields();
        int n = gridFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            GridField field = gridFieldArray[n2];
            if (field.isVirtualUIColumn()) {
                field.processUIVirtualColumn();
            }
            ++n2;
        }
    }

    public boolean canHaveAttachment() {
        return this.getKeyColumnName().endsWith("_ID") || this.getKeyColumnName().endsWith("_UU");
    }

    public boolean hasAttachment() {
        return this.getAD_AttachmentID() > 0;
    }

    public int getAD_AttachmentID() {
        if (!this.canHaveAttachment()) {
            return 0;
        }
        String recordUU = this.m_mTable.getKeyUUID(this.m_currentRow);
        int recordID = this.m_mTable.getKeyID(this.m_currentRow);
        return MAttachment.getID(this.m_vo.AD_Table_ID, recordID, recordUU);
    }

    public boolean hasChat() {
        return this.getCM_ChatID() > 0;
    }

    public int getCM_ChatID() {
        if (!this.canHaveAttachment()) {
            return 0;
        }
        String recordUU = this.m_mTable.getKeyUUID(this.m_currentRow);
        int recordID = this.m_mTable.getKeyID(this.m_currentRow);
        return MChat.getID(this.m_vo.AD_Table_ID, recordID, recordUU);
    }

    public boolean hasPostIt() {
        return this.getAD_PostIt_ID() > 0;
    }

    public int getAD_PostIt_ID() {
        if (!this.canHaveAttachment()) {
            return 0;
        }
        String recordUU = this.m_mTable.getKeyUUID(this.m_currentRow);
        int recordID = this.m_mTable.getKeyID(this.m_currentRow);
        return MPostIt.getID(this.m_vo.AD_Table_ID, recordID, recordUU);
    }

    public boolean hasLabel() {
        if (!this.canHaveAttachment()) {
            return false;
        }
        String recordUU = this.m_mTable.getKeyUUID(this.m_currentRow);
        int recordID = this.m_mTable.getKeyID(this.m_currentRow);
        return MLabelAssignment.hasAnyAssignment(this.m_vo.AD_Table_ID, recordID, recordUU);
    }

    public boolean hasTemplate() {
        return MImportTemplate.getTemplates(Env.getAD_Role_ID(Env.getCtx()), this.getAD_Tab_ID()).size() > 0;
    }

    public void loadLocks() {
        block11: {
            int AD_User_ID = Env.getContextAsInt(Env.getCtx(), "#AD_User_ID");
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("#" + this.m_vo.TabNo + " - AD_User_ID=" + AD_User_ID);
            }
            if (!this.canHaveAttachment()) {
                return;
            }
            String sql = "SELECT Record_ID FROM AD_Private_Access WHERE AD_User_ID=? AND AD_Table_ID=? AND IsActive='Y' ORDER BY Record_ID";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    if (this.m_Lock == null) {
                        this.m_Lock = new ArrayList();
                    } else {
                        this.m_Lock.clear();
                    }
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, AD_User_ID);
                    pstmt.setInt(2, this.m_vo.AD_Table_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        Integer key = rs.getInt(1);
                        this.m_Lock.add(key);
                    }
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block11;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("#" + this.m_Lock.size());
        }
    }

    public boolean isLocked() {
        if (!MRole.getDefault(this.m_vo.ctx, false).isPersonalLock()) {
            return false;
        }
        if (this.m_Lock == null) {
            this.loadLocks();
        }
        if (this.m_Lock == null || this.m_Lock.isEmpty()) {
            return false;
        }
        Integer key = this.m_mTable.getKeyID(this.m_currentRow);
        return this.m_Lock.contains(key);
    }

    public void lock(Properties ctx, int Record_ID, boolean lock) {
        MPrivateAccess access;
        int AD_User_ID = Env.getContextAsInt(ctx, "#AD_User_ID");
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Lock=" + lock + ", AD_User_ID=" + AD_User_ID + ", AD_Table_ID=" + this.m_vo.AD_Table_ID + ", Record_ID=" + Record_ID);
        }
        if ((access = MPrivateAccess.get(ctx, AD_User_ID, this.m_vo.AD_Table_ID, Record_ID)) == null) {
            access = new MPrivateAccess(ctx, AD_User_ID, this.m_vo.AD_Table_ID, Record_ID);
        }
        access.setIsActive(lock);
        access.saveEx();
        this.loadLocks();
    }

    @Override
    public void dataStatusChanged(DataStatusEvent e) {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("#" + this.m_vo.TabNo + " - " + e.toString());
        }
        int oldCurrentRow = e.getCurrentRow();
        this.m_DataStatusEvent = e;
        String msg = this.m_DataStatusEvent.getAD_Message();
        if (msg != null && msg.equals("Sorted")) {
            oldCurrentRow = this.m_currentRow;
            if (e.getCurrentRow() >= 0) {
                this.setCurrentRow(e.getCurrentRow());
            } else {
                this.setCurrentRow(0, true);
            }
        }
        this.m_DataStatusEvent = e;
        this.m_DataStatusEvent.setCurrentRow(this.m_currentRow);
        if (oldCurrentRow == this.m_currentRow) {
            GridField field = this.m_mTable.getField(e.getChangedColumn());
            if (field != null) {
                Object value = this.m_mTable.getValueAt(this.m_currentRow, e.getChangedColumn());
                field.setValue(value, this.m_mTable.isInserting());
            }
        } else {
            boolean fire = true;
            if (this.m_lastDataStatusEvent != null && System.currentTimeMillis() - this.m_lastDataStatusEventTime < 200L && this.m_lastDataStatusEvent.isEqual(this.m_DataStatusEvent)) {
                fire = false;
            }
            if (fire) {
                this.fireDataStatusChanged(this.m_DataStatusEvent);
            }
        }
        this.m_lastDataStatusEventTime = System.currentTimeMillis();
        this.m_lastDataStatusEvent = this.m_DataStatusEvent;
        this.m_DataStatusEvent = null;
    }

    private void fireDataStatusChanged(DataStatusEvent e) {
        if (e == null) {
            this.log.warning("IDEMPIERE-2449 - event must not arrive null here -> " + String.valueOf(Thread.currentThread().getStackTrace()));
            return;
        }
        DataStatusListener[] listeners = (DataStatusListener[])this.m_listenerList.getListeners(DataStatusListener.class);
        if (listeners.length == 0 || e == null) {
            return;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(e.toString());
        }
        if (e.getCurrentRow() >= 0) {
            this.updateDataStatusEventProperties(e);
        }
        e.setInserting(this.m_mTable.isInserting());
        int i2 = 0;
        while (i2 < listeners.length) {
            listeners[i2].dataStatusChanged(e);
            ++i2;
        }
    }

    public void updateDataStatusEventProperties(DataStatusEvent e) {
        e.Created = (Timestamp)this.getValue("Created");
        e.CreatedBy = (Integer)this.getValue("CreatedBy");
        e.Updated = (Timestamp)this.getValue("Updated");
        e.UpdatedBy = (Integer)this.getValue("UpdatedBy");
        e.Record_ID = e.AD_Table_ID == 228 || e.AD_Table_ID == 227 || e.AD_Table_ID == 103 || e.AD_Table_ID == 315 || e.AD_Table_ID == 266 ? this.getValue(this.m_parents.get(0)) : this.getValue(this.m_keyColumnName);
        StringBuilder info = new StringBuilder(this.getTableName());
        if (this.m_keyColumnName != null && this.m_keyColumnName.length() > 0) {
            info.append("\n ").append(this.m_keyColumnName).append("=").append(e.Record_ID);
        } else {
            int i2 = 0;
            while (i2 < this.m_parents.size()) {
                String keyCol = this.m_parents.get(i2);
                info.append(i2 == 0 ? "\n " : " - ").append(keyCol).append("=").append(this.getValue(keyCol));
                ++i2;
            }
        }
        e.Info = info.toString();
    }

    public void fireDataStatusEEvent(String AD_Message, String info, boolean isError) {
        this.m_mTable.fireDataStatusEEvent(AD_Message, info, isError);
    }

    public void fireDataStatusEEvent(ValueNamePair errorLog) {
        if (errorLog != null) {
            this.m_mTable.fireDataStatusEEvent(errorLog);
        }
    }

    public int getCurrentRow() {
        return this.m_currentRow;
    }

    public int getRecord_ID() {
        return this.m_mTable.getKeyID(this.m_currentRow);
    }

    public String getRecord_UU() {
        UUID uuid = this.m_mTable.getUUID(this.m_currentRow);
        return uuid == null ? null : uuid.toString();
    }

    public int getKeyID(int row) {
        return this.m_mTable.getKeyID(row);
    }

    public String getKeyUUID(int row) {
        return this.m_mTable.getKeyUUID(row);
    }

    public int navigate(int targetRow) {
        int newRow;
        if (targetRow == this.m_currentRow) {
            return this.m_currentRow;
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Row=" + targetRow);
        }
        if (!this.m_mTable.dataSave(newRow = this.verifyRow(targetRow), false)) {
            return this.m_currentRow;
        }
        if (this.m_mTable.isInserting()) {
            if (newRow > this.m_currentRow) {
                --newRow;
            }
            this.dataIgnore();
        }
        return this.setCurrentRow(newRow, true);
    }

    public int navigateRelative(int rowChange) {
        return this.navigate(this.m_currentRow + rowChange);
    }

    public int navigateCurrent() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Row=" + this.m_currentRow);
        }
        return this.setCurrentRow(this.m_currentRow, true);
    }

    private int verifyRow(int targetRow) {
        int newRow = targetRow;
        if (!this.m_mTable.isOpen()) {
            if (targetRow >= 0) {
                this.log.log(Level.SEVERE, "Table not open", new Exception("Table not open"));
            }
            return -1;
        }
        int rows = this.getRowCount();
        if (rows == 0 && !this.m_mTable.isLoading()) {
            this.log.fine("No Rows");
            return -1;
        }
        if (newRow >= rows) {
            if (!this.m_mTable.isLoading()) {
                newRow = rows - 1;
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set to max Row: " + newRow);
                }
            }
        } else if (newRow < 0) {
            newRow = 0;
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Set to first Row");
            }
        }
        this.m_mTable.waitLoadingForRow(newRow);
        return newRow;
    }

    public int setCurrentRow(int newCurrentRow, boolean fireEvents) {
        boolean changingRow = this.m_currentRow != newCurrentRow;
        int oldCurrentRow = this.m_currentRow;
        this.m_currentRow = this.verifyRow(newCurrentRow);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Row=" + this.m_currentRow + " - fire=" + fireEvents);
        }
        int size = this.m_mTable.getColumnCount();
        GridField keyCalloutDelayed = null;
        int i2 = 0;
        while (i2 < size) {
            GridField mField = this.m_mTable.getField(i2);
            if (this.m_currentRow >= 0) {
                Object value = this.m_mTable.getValueAt(this.m_currentRow, i2);
                mField.setValue(value, this.m_mTable.isInserting());
                if (mField.isKey()) {
                    keyCalloutDelayed = mField;
                }
            } else if (mField.isKey()) {
                mField.setValueAndUpdateContext();
            } else {
                mField.setValue();
            }
            ++i2;
        }
        if (changingRow && keyCalloutDelayed != null) {
            this.processCallout(keyCalloutDelayed);
        }
        if (changingRow) {
            this.setIsSOTrxContext();
        }
        this.loadDependentInfo();
        if (!fireEvents) {
            return this.m_currentRow;
        }
        this.m_propertyChangeSupport.firePropertyChange(PROPERTY, oldCurrentRow, this.m_currentRow);
        long since = System.currentTimeMillis() - this.m_lastDataStatusEventTime;
        if (since <= 500L && this.m_lastDataStatusEvent != null) {
            this.m_DataStatusEvent = this.m_lastDataStatusEvent;
        }
        if (this.m_DataStatusEvent == null) {
            this.m_DataStatusEvent = new DataStatusEvent(this, this.getRowCount(), this.m_mTable.isInserting(), Env.isAutoCommit(Env.getCtx(), this.m_vo.WindowNo), this.m_mTable.isInserting());
            this.m_DataStatusEvent.AD_Table_ID = this.m_vo.AD_Table_ID;
        }
        this.m_DataStatusEvent.setCurrentRow(this.m_currentRow);
        String status = this.m_DataStatusEvent.getAD_Message();
        if (status == null || status.length() == 0) {
            this.m_DataStatusEvent.setInfo(DEFAULT_STATUS_MESSAGE, null, false, false);
        }
        this.fireDataStatusChanged(this.m_DataStatusEvent);
        this.m_DataStatusEvent = null;
        this.m_mTable.setCurrentRow(this.m_currentRow);
        return this.m_currentRow;
    }

    private void setIsSOTrxContext() {
        if (this.getField("IsSOTrx") != null || this.getField("C_DocType_ID") != null || this.getField("C_DocTypeTarget_ID") != null) {
            int docTypeId;
            int docTypeId2;
            String isSOTrx = null;
            GridField field = this.getField("IsSOTrx");
            if (field != null && field.getValue() != null) {
                Object value = field.getValue();
                if (value instanceof Boolean) {
                    isSOTrx = (Boolean)value != false ? "Y" : "N";
                } else if (value instanceof String) {
                    isSOTrx = (String)value;
                }
            }
            if (isSOTrx == null && (field = this.getField("C_DocType_ID")) != null && field.getValue() != null && (docTypeId2 = ((Number)field.getValue()).intValue()) > 0) {
                String string = isSOTrx = MDocType.get(docTypeId2).isSOTrx() ? "Y" : "N";
            }
            if (isSOTrx == null && (field = this.getField("C_DocTypeTarget_ID")) != null && field.getValue() != null && (docTypeId = ((Number)field.getValue()).intValue()) > 0) {
                String string = isSOTrx = MDocType.get(docTypeId).isSOTrx() ? "Y" : "N";
            }
            if (isSOTrx != null) {
                Env.setContext(Env.getCtx(), this.getWindowNo(), this.getTabNo(), "IsSOTrx", isSOTrx);
                if (this.m_vo.TabNo == 0) {
                    Env.setContext(Env.getCtx(), this.getWindowNo(), "IsSOTrx", isSOTrx);
                }
            }
        }
    }

    public void setCurrentRow(int row) {
        this.setCurrentRow(row, false);
    }

    public int getRowCount() {
        int count = this.m_mTable.getRowCount();
        if (count == 0 && this.m_mTable.isLoading()) {
            try {
                this.m_mTable.waitLoading(100L);
            }
            catch (Exception exception) {}
            count = this.m_mTable.getRowCount();
        }
        return count;
    }

    public int getFieldCount() {
        return this.m_mTable.getColumnCount();
    }

    public GridField getField(int index) {
        return index >= 0 ? this.m_mTable.getField(index) : null;
    }

    public GridField getField(String columnName) {
        return this.m_mTable.getField(columnName);
    }

    public GridField[] getFields() {
        return this.m_mTable.getFields();
    }

    public String setValue(String columnName, Object value) {
        if (columnName == null) {
            return "NoColumn";
        }
        return this.setValue(this.m_mTable.getField(columnName), value);
    }

    public String setValue(GridField field, Object value) {
        if (field == null) {
            return "NoField";
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(field.getColumnName() + "=" + String.valueOf(value) + " - Row=" + this.m_currentRow);
        }
        if (value instanceof Integer) {
            MColumn column;
            if ((Integer)value < 0 && DisplayType.isID(field.getDisplayType())) {
                value = null;
            } else if ((Integer)value == 0 && field.isLookup() && !MTable.isZeroIDTable((column = MColumn.get(field.getAD_Column_ID())).getReferenceTableName())) {
                value = null;
            }
        }
        int col = this.m_mTable.findColumn(field.getColumnName());
        this.m_mTable.setValueAt(value, this.m_currentRow, col, false);
        return "";
    }

    public boolean isProcessed() {
        return this.getValueAsBoolean("Processed");
    }

    public boolean isActive() {
        return this.getValueAsBoolean("IsActive");
    }

    public String processFieldChange(GridField changedField) {
        this.processDependencies(changedField);
        return this.processCallout(changedField);
    }

    private void processDependencies(GridField changedField) {
        String columnName = changedField.getColumnName();
        if (!this.hasDependants(columnName)) {
            return;
        }
        for (GridField dependentField : this.getDependantFields(columnName)) {
            MLookup mLookup;
            if (dependentField == null || dependentField.isLookupEditorSettingValue()) continue;
            if (dependentField.getLookup() instanceof MLookup && ((mLookup = (MLookup)dependentField.getLookup()).getValidation().indexOf("@" + columnName + "@") != -1 || mLookup.getValidation().matches(".*[@]" + this.getTabNo() + "[|]" + columnName + "([:].+)?[@].*") || mLookup.getValidation().matches(".*[@][~]?" + columnName + "([:].+)?[@].*"))) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine(columnName + " changed - " + dependentField.getColumnName() + " set to null");
                }
                mLookup.refresh();
                Object currentValue = dependentField.getValue();
                this.setValue(dependentField, null);
                if (currentValue != null && mLookup.containsKeyNoDirect(currentValue)) {
                    this.setValue(dependentField, currentValue);
                }
            }
            if (!dependentField.isVirtualUIColumn()) continue;
            dependentField.processUIVirtualColumn();
        }
    }

    public String[] getActiveCallouts() {
        String[] list = new String[this.activeCallouts.size()];
        return this.activeCallouts.toArray(list);
    }

    public Callout[] getActiveCalloutInstance() {
        Callout[] list = new Callout[this.activeCalloutInstance.size()];
        return this.activeCalloutInstance.toArray(list);
    }

    public String processCallout(GridField field) {
        List<IColumnCallout> callouts;
        Object object;
        if (this.isProcessed() && !field.isAlwaysUpdateable() && !field.isKey()) {
            return "";
        }
        Object value = field.getValue();
        Object oldValue = field.getOldValue();
        String callout = field.getCallout();
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(field.getColumnName() + "=" + String.valueOf(value) + " (" + callout + ") - old=" + String.valueOf(oldValue));
        }
        if (callout.length() > 0) {
            StringTokenizer st = new StringTokenizer(callout, ";,", false);
            while (st.hasMoreTokens()) {
                Object retValue;
                block29: {
                    String cmd = st.nextToken().trim();
                    if (this.activeCallouts.contains(cmd)) continue;
                    retValue = "";
                    if (cmd.toLowerCase().startsWith("@script:")) {
                        MRule rule = MRule.get(this.m_vo.ctx, cmd.substring("@script:".length()));
                        if (rule == null) {
                            retValue = "Callout " + cmd + " not found";
                            this.log.log(Level.SEVERE, (String)retValue);
                            return retValue;
                        }
                        if (!rule.getEventType().equals("C") || !rule.getRuleType().equals("S")) {
                            retValue = "Callout " + cmd + " must be of type JSR 223 and event Callout";
                            this.log.log(Level.SEVERE, (String)retValue);
                            return retValue;
                        }
                        ScriptEngine engine = rule.getScriptEngine();
                        if (engine == null) {
                            retValue = "Callout Invalid, engine not found: " + rule.getEngineName();
                            this.log.log(Level.SEVERE, (String)retValue);
                            return retValue;
                        }
                        MRule.setContext(engine, this.m_vo.ctx, this.m_vo.WindowNo);
                        engine.put("A_WindowNo", this.m_vo.WindowNo);
                        engine.put("A_Tab", this);
                        engine.put("A_Field", field);
                        engine.put("A_Value", value);
                        engine.put("A_OldValue", oldValue);
                        engine.put("A_Ctx", this.m_vo.ctx);
                        try {
                            try {
                                this.activeCallouts.add(cmd);
                                retValue = engine.eval(rule.getScript()).toString();
                                break block29;
                            }
                            catch (Exception e) {
                                this.log.log(Level.SEVERE, "", e);
                                object = retValue = "Callout Invalid: " + e.toString();
                                this.activeCallouts.remove(cmd);
                                return object;
                            }
                        }
                        finally {
                            this.activeCallouts.remove(cmd);
                        }
                    }
                    Callout call = null;
                    String method = null;
                    int methodStart = cmd.lastIndexOf(46);
                    try {
                        String className;
                        if (methodStart != -1 && (call = Core.getCallout(className = cmd.substring(0, methodStart), method = cmd.substring(methodStart + 1))) == null) {
                            Class<?> cClass = Class.forName(className);
                            call = (Callout)cClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        }
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, "class", e);
                        return "Callout Invalid: " + cmd + " (" + e.toString() + ")";
                    }
                    if (call == null || method == null || method.length() == 0) {
                        return "Callout Invalid: " + method;
                    }
                    try {
                        try {
                            this.activeCallouts.add(cmd);
                            this.activeCalloutInstance.add(call);
                            retValue = call.start(this.m_vo.ctx, method, this.m_vo.WindowNo, this, field, value, oldValue);
                        }
                        catch (Exception e) {
                            this.log.log(Level.SEVERE, "start", e);
                            Object object2 = retValue = "Callout Invalid: " + e.toString();
                            this.activeCallouts.remove(cmd);
                            this.activeCalloutInstance.remove(call);
                            return object2;
                        }
                    }
                    finally {
                        this.activeCallouts.remove(cmd);
                        this.activeCalloutInstance.remove(call);
                    }
                }
                if (Util.isEmpty((String)retValue)) continue;
                this.log.config((String)retValue);
                return retValue;
            }
        }
        if ((callouts = Core.findCallout(this.getTableName(), field.getColumnName())) != null && !callouts.isEmpty()) {
            for (IColumnCallout co : callouts) {
                Object retValue = "";
                String cmd = co.getClass().getName();
                if (this.activeCallouts.contains(cmd)) continue;
                try {
                    try {
                        this.activeCallouts.add(cmd);
                        retValue = co.start(this.m_vo.ctx, this.m_vo.WindowNo, this, field, value, oldValue);
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, "start", e);
                        object = retValue = "Callout Invalid: " + e.toString();
                        this.activeCallouts.remove(cmd);
                        return object;
                    }
                }
                finally {
                    this.activeCallouts.remove(cmd);
                }
                if (Util.isEmpty((String)retValue)) continue;
                this.log.severe((String)retValue);
                return retValue;
            }
        }
        return "";
    }

    public Object getValue(String columnName) {
        if (columnName == null) {
            return null;
        }
        GridField field = this.m_mTable.getField(columnName);
        return this.getValue(field);
    }

    public boolean getValueAsBoolean(String columnName) {
        int index = this.m_mTable.findColumn(columnName);
        if (index != -1) {
            Object oo = this.m_mTable.getValueAt(this.m_currentRow, index);
            if (oo instanceof String) {
                return "Y".equals(oo);
            }
            if (oo instanceof Boolean) {
                return (Boolean)oo;
            }
        }
        return "Y".equals(Env.getContext(this.m_vo.ctx, this.m_vo.WindowNo, columnName));
    }

    public Object getValue(GridField field) {
        if (field == null) {
            return null;
        }
        return field.getValue();
    }

    public Object getValue(int row, String columnName) {
        int col = this.m_mTable.findColumn(columnName);
        if (col == -1) {
            return null;
        }
        return this.m_mTable.getValueAt(row, col);
    }

    public String toString() {
        Object retValue = "MTab #";
        retValue = this.m_vo != null ? (String)retValue + this.m_vo.TabNo + " " + this.m_vo.Name + " (" + this.m_vo.AD_Tab_ID + ")" : (String)retValue + "???";
        return retValue;
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        this.m_propertyChangeSupport.removePropertyChangeListener(l);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        this.m_propertyChangeSupport.addPropertyChangeListener(l);
    }

    public synchronized void removeDataStatusListener(DataStatusListener l) {
        this.m_listenerList.remove(DataStatusListener.class, l);
    }

    public synchronized void addDataStatusListener(DataStatusListener l) {
        this.m_listenerList.add(DataStatusListener.class, l);
    }

    public synchronized void addStateChangeListener(StateChangeListener l) {
        this.m_listenerList.add(StateChangeListener.class, l);
    }

    public synchronized void removeStateChangeListener(StateChangeListener l) {
        this.m_listenerList.remove(StateChangeListener.class, l);
    }

    public void setFieldVFormat(String identifier, String strNewFormat) {
        this.m_mTable.setFieldVFormat(identifier, strNewFormat);
    }

    public void switchRows(int from, int to, int sortColumn, boolean ascending) {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(from + " - " + to + " - " + sortColumn + " - " + ascending);
        }
        if (from == to) {
            this.log.finest("nothing to do - from == to");
            return;
        }
        if (!this.m_mTable.isRowEditable(from) || !this.m_mTable.isRowEditable(to)) {
            this.log.finest("row not editable - return");
            return;
        }
        if ((to = this.verifyRow(to)) == -1) {
            this.log.finest("Row range check - return");
            return;
        }
        this.m_mTable.dataSave(to, false);
        int lineCol = this.m_mTable.findColumn("Line");
        if (lineCol == -1) {
            lineCol = this.m_mTable.findColumn("SeqNo");
        }
        if (lineCol == -1) {
            return;
        }
        Integer lineNoCurrentRow = null;
        Integer lineNoNextRow = null;
        if (this.m_mTable.getValueAt(from, lineCol) instanceof Integer) {
            lineNoCurrentRow = (Integer)this.m_mTable.getValueAt(from, lineCol);
            lineNoNextRow = (Integer)this.m_mTable.getValueAt(to, lineCol);
        } else if (this.m_mTable.getValueAt(from, lineCol) instanceof BigDecimal) {
            lineNoCurrentRow = ((BigDecimal)this.m_mTable.getValueAt(from, lineCol)).intValue();
            lineNoNextRow = ((BigDecimal)this.m_mTable.getValueAt(to, lineCol)).intValue();
        } else {
            this.log.fine("unknown value format - return");
            return;
        }
        if (lineNoCurrentRow >= 9900 || lineNoNextRow >= 9900) {
            this.log.fine("don't sort - might be special lines");
            return;
        }
        this.m_mTable.setValueAt(lineNoCurrentRow, to, lineCol);
        this.setCurrentRow(to, false);
        this.m_mTable.dataSave(true);
        this.m_mTable.setValueAt(lineNoNextRow, from, lineCol);
        this.setCurrentRow(from, false);
        this.m_mTable.dataSave(true);
        if (sortColumn != -1) {
            this.m_mTable.sort(sortColumn, ascending);
        } else {
            this.m_mTable.sort(lineCol, true);
        }
        this.navigate(to);
    }

    private void fireStateChangeEvent(StateChangeEvent e) {
        StateChangeListener[] listeners = (StateChangeListener[])this.m_listenerList.getListeners(StateChangeListener.class);
        if (listeners.length == 0) {
            return;
        }
        int i2 = 0;
        while (i2 < listeners.length) {
            listeners[i2].stateChange(e);
            ++i2;
        }
    }

    public List<GridTab> getIncludedTabs() {
        ArrayList<GridTab> list = new ArrayList<GridTab>(1);
        GridField[] gridFieldArray = this.getFields();
        int n = gridFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            GridField field = gridFieldArray[n2];
            if (field.getIncluded_Tab_ID() > 0) {
                int i2 = 0;
                while (i2 < this.m_window.getTabCount()) {
                    GridTab detailTab = this.m_window.getTab(i2);
                    if (detailTab.getAD_Tab_ID() == field.getIncluded_Tab_ID()) {
                        list.add(detailTab);
                        break;
                    }
                    ++i2;
                }
            }
            ++n2;
        }
        return list;
    }

    /*
     * Unable to fully structure code
     */
    private int getParentTabNo() {
        if (this.m_parentTabNo >= 0) {
            return this.m_parentTabNo;
        }
        tabNo = this.m_vo.TabNo;
        currentLevel = this.m_vo.TabLevel;
        parentLevel = currentLevel - 1;
        if (parentLevel >= 0) ** GOTO lbl11
        this.m_parentTabNo = tabNo;
        return this.m_parentTabNo;
lbl-1000:
        // 1 sources

        {
            currentLevel = Env.getContextAsInt(this.m_vo.ctx, this.m_vo.WindowNo, --tabNo, "_TabInfo_TabLevel");
            if (tabNo == 0) break;
lbl11:
            // 2 sources

            ** while (parentLevel != currentLevel)
        }
lbl12:
        // 2 sources

        this.m_parentTabNo = tabNo;
        return this.m_parentTabNo;
    }

    public GridTab getParentTab() {
        int parentTabNo = this.getParentTabNo();
        if (parentTabNo < 0 || parentTabNo == this.m_vo.TabNo) {
            return null;
        }
        return this.m_window.getTab(parentTabNo);
    }

    public int getNumColumns() {
        int maxcol = 0;
        GridField[] gridFieldArray = this.getFields();
        int n = gridFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            GridField gridField = gridFieldArray[n2];
            if (gridField.isDisplayed() && !gridField.isToolbarOnlyButton()) {
                int col = gridField.getXPosition() + gridField.getColumnSpan();
                if (gridField.isFieldOnly() || gridField.getDisplayType() == 28 || gridField.getDisplayType() == 20) {
                    --col;
                }
                if (col > maxcol) {
                    maxcol = col;
                }
            }
            ++n2;
        }
        return maxcol;
    }

    public boolean isNew() {
        return this.isOpen() && this.getCurrentRow() >= 0 && this.getCurrentRow() == this.m_mTable.getNewRow();
    }

    public String getAD_Tab_UU() {
        return this.m_vo.AD_Tab_UU;
    }

    public String getAD_Process_UU() {
        return this.m_vo.AD_Process_UU;
    }

    public boolean isUpdateWindowContext() {
        return this.m_updateWindowContext;
    }

    public void setUpdateWindowContext(boolean updateWindowContext) {
        this.m_updateWindowContext = updateWindowContext;
    }

    public void addToSelection(int rowIndex) {
        if (!this.selection.contains(rowIndex)) {
            this.selection.add(rowIndex);
        }
    }

    public boolean removeFromSelection(int rowIndex) {
        return this.selection.remove((Object)rowIndex);
    }

    public int[] getSelection() {
        int[] selected = new int[this.selection.size()];
        int i2 = 0;
        for (Integer row : this.selection) {
            selected[i2++] = row;
        }
        return selected;
    }

    public boolean isSelected(int rowIndex) {
        return this.selection.contains(rowIndex);
    }

    public void clearSelection() {
        this.selection.clear();
    }

    public boolean isQuickForm() {
        return this.isQuickForm;
    }

    public void setQuickForm(boolean isQuickForm) {
        this.isQuickForm = isQuickForm;
    }

    public GridWindow getGridWindow() {
        return this.m_window;
    }

    public GridTabVO getVO() {
        return this.m_vo;
    }

    public ICalloutUI getCalloutUI() {
        return this.calloutUI;
    }

    public void setCalloutUI(ICalloutUI calloutUI) {
        this.calloutUI = calloutUI;
    }

    public String getDeleteConfirmationLogic() {
        return this.m_vo.deleteConfirmationLogic;
    }

    public void setDeleteConfirmationLogic(String deleteConfirmationLogic) {
        this.m_vo.deleteConfirmationLogic = deleteConfirmationLogic;
    }

    public int getMaxQueryRecords() {
        int roleMaxQueryRecords = MRole.getDefault().getMaxQueryRecords();
        int tabMaxQueryRecords = this.m_vo.MaxQueryRecords;
        if (roleMaxQueryRecords > 0 && (roleMaxQueryRecords < tabMaxQueryRecords || tabMaxQueryRecords == 0)) {
            tabMaxQueryRecords = roleMaxQueryRecords;
        }
        if (tabMaxQueryRecords == 0) {
            tabMaxQueryRecords = MSysConfig.getIntValue("GLOBAL_MAX_QUERY_RECORDS", 100000, Env.getAD_Client_ID(Env.getCtx()));
        }
        return tabMaxQueryRecords;
    }

    public boolean isQueryRequire(int noRecords) {
        if (noRecords < 2) {
            return false;
        }
        int max = this.getMaxQueryRecords();
        if (max > 0 && noRecords > max) {
            return true;
        }
        int qu = MRole.getDefault().getConfirmQueryRecords();
        return noRecords > qu;
    }

    public boolean isQueryMax(int noRecords) {
        int max = this.getMaxQueryRecords();
        return max > 0 && noRecords > max;
    }

    public void reset() {
        this.m_mTable.reset();
        this.setCurrentRow(0, true);
    }

    protected class Loader
    extends ContextRunnable {
        protected Loader() {
        }

        @Override
        protected void doRun() {
            GridTab.this.loadTab();
        }
    }
}

