/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.compiere.model.IAttachmentStore;
import org.compiere.model.MAttachment;
import org.compiere.model.MAttachmentEntry;
import org.compiere.model.MStorageProvider;
import org.compiere.util.CLogger;

public class AttachmentDBSystem
implements IAttachmentStore {
    public static final String ZIP = "zip";
    private static final CLogger log = CLogger.getCLogger(AttachmentDBSystem.class);

    @Override
    public boolean loadLOBData(MAttachment attach, MStorageProvider prov) {
        attach.m_items = new ArrayList();
        byte[] data = attach.getBinaryData();
        if (data == null) {
            return true;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("ZipSize=" + data.length);
        }
        if (data.length == 0) {
            return true;
        }
        if (!ZIP.equals(attach.getTitle())) {
            attach.m_items.add(new MAttachmentEntry(attach.getTitle(), data, 1));
            return true;
        }
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(data);
            ZipInputStream zip = new ZipInputStream(in);
            ZipEntry entry = zip.getNextEntry();
            while (entry != null) {
                String name = entry.getName();
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                byte[] buffer = new byte[2048];
                int length = zip.read(buffer);
                while (length != -1) {
                    out.write(buffer, 0, length);
                    length = zip.read(buffer);
                }
                byte[] dataEntry = out.toByteArray();
                if (log.isLoggable(Level.FINE)) {
                    log.fine(name + " - size=" + dataEntry.length + " - zip=" + entry.getCompressedSize() + "(" + entry.getSize() + ") " + entry.getCompressedSize() * 100L / entry.getSize() + "%");
                }
                attach.m_items.add(new MAttachmentEntry(name, dataEntry, attach.m_items.size() + 1));
                entry = zip.getNextEntry();
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "loadLOBData", e);
            attach.m_items = null;
            return false;
        }
        return true;
    }

    @Override
    public boolean save(MAttachment attach, MStorageProvider prov) {
        if (attach.m_items == null || attach.m_items.size() == 0) {
            attach.setBinaryData(null);
            return true;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ZipOutputStream zip = new ZipOutputStream(out);
        zip.setMethod(8);
        zip.setLevel(9);
        zip.setComment("iDempiere");
        try {
            int i = 0;
            while (i < attach.m_items.size()) {
                MAttachmentEntry item = attach.getEntry(i);
                ZipEntry entry = new ZipEntry(item.getName());
                entry.setTime(System.currentTimeMillis());
                entry.setMethod(8);
                zip.putNextEntry(entry);
                byte[] data = item.getData();
                zip.write(data, 0, data.length);
                zip.closeEntry();
                if (log.isLoggable(Level.FINE)) {
                    log.fine(entry.getName() + " - " + entry.getCompressedSize() + " (" + entry.getSize() + ") " + entry.getCompressedSize() * 100L / entry.getSize() + "%");
                }
                ++i;
            }
            zip.close();
            byte[] zipData = out.toByteArray();
            if (log.isLoggable(Level.FINE)) {
                log.fine("Length=" + zipData.length);
            }
            attach.setBinaryData(zipData);
            attach.setTitle(ZIP);
            return true;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "saveLOBData", e);
            attach.setBinaryData(null);
            return false;
        }
    }

    @Override
    public boolean delete(MAttachment attach, MStorageProvider prov) {
        return true;
    }

    @Override
    public boolean deleteEntry(MAttachment attach, MStorageProvider provider, int index) {
        attach.m_items.remove(index);
        return true;
    }
}

