/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class Matcher {
    private int m_AD_Client_ID;
    private String m_trxName = null;
    private static final CLogger log = CLogger.getCLogger(Matcher.class);

    public Matcher(int AD_Client_ID, String trxName) {
        this.m_AD_Client_ID = AD_Client_ID;
        this.m_trxName = trxName;
    }

    public int match() {
        int counter;
        block8: {
            counter = 0;
            String sql = "SELECT m1.AD_Client_ID,m2.AD_Org_ID, m1.C_InvoiceLine_ID,m2.M_InOutLine_ID,m1.M_Product_ID, m1.DateTrx,m2.DateTrx, m1.Qty, m2.Qty FROM M_MatchPO m1, M_MatchPO m2 WHERE m1.C_OrderLine_ID=m2.C_OrderLine_ID AND m1.M_InOutLine_ID IS NULL AND m2.C_InvoiceLine_ID IS NULL AND m1.M_Product_ID=m2.M_Product_ID AND m1.AD_Client_ID=?\tAND NOT EXISTS (SELECT * FROM M_MatchInv mi WHERE mi.C_InvoiceLine_ID=m1.C_InvoiceLine_ID AND mi.M_InOutLine_ID=m2.M_InOutLine_ID)";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, this.m_AD_Client_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        int M_Product_ID;
                        BigDecimal qty2;
                        BigDecimal qty1 = rs.getBigDecimal(8);
                        BigDecimal Qty = qty1.min(qty2 = rs.getBigDecimal(9));
                        if (Qty.compareTo(Env.ZERO) == 0) continue;
                        Timestamp dateTrx1 = rs.getTimestamp(6);
                        Timestamp dateTrx2 = rs.getTimestamp(7);
                        Timestamp DateTrx = dateTrx1;
                        if (dateTrx1.before(dateTrx2)) {
                            DateTrx = dateTrx2;
                        }
                        int AD_Client_ID = rs.getInt(1);
                        int AD_Org_ID = rs.getInt(2);
                        int C_InvoiceLine_ID = rs.getInt(3);
                        int M_InOutLine_ID = rs.getInt(4);
                        if (!this.createMatchInv(AD_Client_ID, AD_Org_ID, M_InOutLine_ID, C_InvoiceLine_ID, M_Product_ID = rs.getInt(5), DateTrx, Qty)) continue;
                        ++counter;
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, "match", e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Matcher.match - Client_ID=" + this.m_AD_Client_ID + ", Records created=" + counter);
        }
        return counter;
    }

    private boolean createMatchInv(int AD_Client_ID, int AD_Org_ID, int M_InOutLine_ID, int C_InvoiceLine_ID, int M_Product_ID, Timestamp DateTrx, BigDecimal Qty) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("InvLine=" + C_InvoiceLine_ID + ",Rec=" + M_InOutLine_ID + ", Qty=" + String.valueOf(Qty) + ", " + String.valueOf(DateTrx));
        }
        int M_MatchInv_ID = DB.getNextID(AD_Client_ID, "M_MatchInv", this.m_trxName);
        StringBuilder sql = new StringBuilder("INSERT INTO M_MatchInv (").append("M_MatchInv_ID, ").append("AD_Client_ID,AD_Org_ID,IsActive,Created,CreatedBy,Updated,UpdatedBy, ").append("M_InOutLine_ID,C_InvoiceLine_ID, ").append("M_Product_ID,DateTrx,Qty, ").append("Processing,Processed,Posted) VALUES (").append(M_MatchInv_ID).append(", ").append(AD_Client_ID).append(",").append(AD_Org_ID).append(",'Y',getDate(),0,getDate(),0, ").append(M_InOutLine_ID).append(",").append(C_InvoiceLine_ID).append(", ").append(M_Product_ID).append(",").append(DB.TO_DATE(DateTrx, true)).append(",").append(Qty).append(", 'N','Y','N')");
        int no = DB.executeUpdate(sql.toString(), this.m_trxName);
        return no == 1;
    }
}

