/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.base.event;

import java.util.Properties;
import java.util.UUID;
import org.adempiere.base.event.EventHelper;
import org.adempiere.base.event.IEventManager;
import org.adempiere.util.ServerContext;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfo;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public abstract class AbstractEventHandler
implements EventHandler {
    protected IEventManager eventManager = null;

    public void handleEvent(Event event) {
        Properties context = null;
        try {
            try {
                if (event.containsProperty("event.context")) {
                    Properties eventContext = (Properties)event.getProperty("event.context");
                    context = ServerContext.getCurrentInstance();
                    ServerContext.setCurrentInstance(eventContext);
                }
                this.doHandleEvent(event);
            }
            catch (RuntimeException e) {
                this.addError(event, e);
                throw e;
            }
            catch (Exception e) {
                this.addError(event, e);
                throw new RuntimeException(e);
            }
            catch (Error e) {
                this.addError(event, e);
                throw e;
            }
            catch (Throwable e) {
                this.addError(event, e);
                throw new Error(e);
            }
        }
        catch (Throwable throwable) {
            if (context != null) {
                ServerContext.setCurrentInstance(context);
            }
            throw throwable;
        }
        if (context != null) {
            ServerContext.setCurrentInstance(context);
        }
    }

    public void bindEventManager(IEventManager eventManager) {
        this.eventManager = eventManager;
        this.initialize();
    }

    public void unbindEventManager(IEventManager eventManager) {
        this.eventManager = null;
        eventManager.unregister(this);
    }

    protected abstract void doHandleEvent(Event var1);

    protected abstract void initialize();

    protected void registerEvent(String eventTopic) {
        this.registerEvent(eventTopic, null);
    }

    protected void registerEvent(String topic, String filter) {
        if (filter != null) {
            this.eventManager.register(topic, filter, (EventHandler)this);
        } else {
            this.eventManager.register(topic, (EventHandler)this);
        }
    }

    protected void registerTableEvent(String topic, String tableName) {
        String filter = "(tableName=" + tableName + ")";
        this.registerEvent(topic, filter);
    }

    protected void registerProcessEvent(String topic, String classOrUUID) {
        String prop = "processUUID";
        try {
            UUID.fromString(classOrUUID);
        }
        catch (Exception exception) {
            prop = "className";
        }
        String filter = "(" + prop + "=" + classOrUUID + ")";
        this.registerEvent(topic, filter);
    }

    protected PO getPO(Event event) {
        return EventHelper.getPO(event);
    }

    protected ProcessInfo getProcessInfo(Event event) {
        return EventHelper.getProcessInfo(event);
    }

    protected <T> T getEventData(Event event) {
        return EventHelper.getEventData(event);
    }

    protected <T> T getEventProperty(Event event, String property) {
        return EventHelper.getEventProperty(event, property);
    }

    protected void addError(Event event, Throwable e) {
        EventHelper.addError(event, e);
    }

    protected void addErrorMessage(Event event, String errorMessage) {
        EventHelper.addErrorMessage(event, errorMessage);
    }
}

