/***********************************************************************
 * This file is part of iDempiere ERP Open Source                      *
 * http://www.idempiere.org                                            *
 *                                                                     *
 * Copyright (C) Contributors                                          *
 *                                                                     *
 * This program is free software; you can redistribute it and/or       *
 * modify it under the terms of the GNU General Public License         *
 * as published by the Free Software Foundation; either version 2      *
 * of the License, or (at your option) any later version.              *
 *                                                                     *
 * This program is distributed in the hope that it will be useful,     *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of      *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the        *
 * GNU General Public License for more details.                        *
 *                                                                     *
 * You should have received a copy of the GNU General Public License   *
 * along with this program; if not, write to the Free Software         *
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,          *
 * MA 02110-1301, USA.                                                 *
 **********************************************************************/
package org.idempiere.fa.service.api;

import java.math.BigDecimal;

/**
 * Implement this interface to provide depreciation calculation method
 * @author hieplq
 *
 */
public interface IDepreciationMethod {
	/**
	 * Calculate depreciation for each period
	 * @param depreciationDTO
	 * @return amount depreciation for {@link DepreciationDTO#period}
	 */
	public BigDecimal caclulateDepreciation (DepreciationDTO depreciationDTO);
	
	/**
	 * Get number of period to depreciate
	 * @param depreciationDTO
	 * @return number of period to depreciate
	 */
	public long getCountPeriod (DepreciationDTO depreciationDTO);
	
	/**
	 * Support to move all rounding differences to end period
	 * @return true to adjust for all rounding difference in end period
	*/
	public boolean isPeriodAdjustment ();
}
