/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.compiere.model.MProduction;
import org.compiere.model.MProductionLine;
import org.compiere.model.MProductionPlan;
import org.compiere.model.MStorageOnHand;
import org.compiere.model.MTable;
import org.compiere.model.Query;
import org.compiere.model.X_M_ProductionLineMA;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class MProductionLineMA
extends X_M_ProductionLineMA {
    private static final long serialVersionUID = -2633782218494352620L;

    public MProductionLineMA(Properties ctx, String M_ProductionLineMA_UU, String trxName) {
        super(ctx, M_ProductionLineMA_UU, trxName);
    }

    public MProductionLineMA(Properties ctx, int M_ProductionLineMA_ID, String trxName) {
        super(ctx, M_ProductionLineMA_ID, trxName);
    }

    public MProductionLineMA(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MProductionLineMA(MProductionLine parent, int asi, BigDecimal qty, Timestamp dateMaterialPolicy) {
        super(parent.getCtx(), 0, parent.get_TrxName());
        this.setM_AttributeSetInstance_ID(asi);
        this.setM_ProductionLine_ID(parent.get_ID());
        this.setMovementQty(qty);
        this.setAD_Org_ID(parent.getAD_Org_ID());
        if (dateMaterialPolicy == null) {
            if (asi > 0) {
                dateMaterialPolicy = MStorageOnHand.getDateMaterialPolicy(parent.getM_Product_ID(), asi, parent.get_TrxName());
            }
            if (dateMaterialPolicy == null) {
                dateMaterialPolicy = parent.getM_Production().getMovementDate();
            }
        }
        this.setDateMaterialPolicy(dateMaterialPolicy);
    }

    @Override
    public void setDateMaterialPolicy(Timestamp DateMaterialPolicy) {
        if (DateMaterialPolicy != null) {
            DateMaterialPolicy = Util.removeTime(DateMaterialPolicy);
        }
        super.setDateMaterialPolicy(DateMaterialPolicy);
    }

    public static MProductionLineMA get(MProductionLine parent, int asi, Timestamp dateMPolicy) {
        Object where = " M_ProductionLine_ID = ? AND M_AttributeSetInstance_ID = ? ";
        if (dateMPolicy == null) {
            dateMPolicy = new Timestamp(new Date().getTime());
        }
        where = (String)where + "AND DateMaterialPolicy = trunc(cast(? as date))";
        MProductionLineMA lineMA = (MProductionLineMA)MTable.get(parent.getCtx(), "M_ProductionLineMA").createQuery((String)where, parent.get_TrxName()).setParameters(parent.getM_ProductionLine_ID(), asi, dateMPolicy).first();
        if (lineMA != null) {
            return lineMA;
        }
        return new MProductionLineMA(parent, asi, Env.ZERO, dateMPolicy);
    }

    public static MProductionLineMA[] get(Properties ctx, int M_ProductionLine_ID, String trxName) {
        Query query = MTable.get(ctx, "M_ProductionLineMA").createQuery("M_ProductionLine_ID=?", trxName);
        query.setParameters(M_ProductionLine_ID);
        List<MProductionLineMA> list = query.list();
        MProductionLineMA[] retValue = list.toArray(new MProductionLineMA[0]);
        return retValue;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        MProduction prodParent;
        MProductionLine parentLine = new MProductionLine(this.getCtx(), this.getM_ProductionLine_ID(), this.get_TrxName());
        if (parentLine.getM_Production_ID() > 0) {
            prodParent = new MProduction(this.getCtx(), parentLine.getM_Production_ID(), this.get_TrxName());
        } else {
            MProductionPlan plan = new MProductionPlan(this.getCtx(), parentLine.getM_ProductionPlan_ID(), this.get_TrxName());
            prodParent = new MProduction(this.getCtx(), plan.getM_Production_ID(), this.get_TrxName());
        }
        if (newRecord && prodParent.isProcessed()) {
            this.log.saveError("ParentComplete", Msg.translate(this.getCtx(), "M_Production_ID"));
            return false;
        }
        return true;
    }
}

