/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.compiere.model.MProcessPara;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Msg;

@Process
public class OrgOwnership
extends SvrProcess {
    private int p_AD_Org_ID = -1;
    private int p_M_Warehouse_ID = -1;
    private int p_M_Product_Category_ID = -1;
    private int p_M_Product_ID = -1;
    private int p_C_BP_Group_ID = -1;
    private int p_C_BPartner_ID = -1;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("AD_Org_ID")) {
                    this.p_AD_Org_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("M_Warehouse_ID")) {
                    this.p_M_Warehouse_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("M_Product_Category_ID")) {
                    this.p_M_Product_Category_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("M_Product_ID")) {
                    this.p_M_Product_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("C_BP_Group_ID")) {
                    this.p_C_BP_Group_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("C_BPartner_ID")) {
                    this.p_C_BPartner_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else {
                    MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para[i]);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("doIt - AD_Org_ID=" + this.p_AD_Org_ID);
        }
        if (this.p_AD_Org_ID < 0) {
            throw new IllegalArgumentException("OrgOwnership - invalid AD_Org_ID=" + this.p_AD_Org_ID);
        }
        this.generalOwnership();
        if (this.p_M_Warehouse_ID > 0) {
            return this.warehouseOwnership();
        }
        if (this.p_M_Product_ID > 0 || this.p_M_Product_Category_ID > 0) {
            return this.productOwnership();
        }
        if (this.p_C_BPartner_ID > 0 || this.p_C_BP_Group_ID > 0) {
            return this.bPartnerOwnership();
        }
        return "* Not supported * **";
    }

    private String warehouseOwnership() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("warehouseOwnership - M_Warehouse_ID=" + this.p_M_Warehouse_ID);
        }
        if (this.p_AD_Org_ID == 0) {
            throw new IllegalArgumentException("Warehouse - Org cannot be * (0)");
        }
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE M_Warehouse ").append("SET AD_Org_ID=").append(this.p_AD_Org_ID).append(" WHERE M_Warehouse_ID=").append(this.p_M_Warehouse_ID).append(" AND AD_Client_ID=").append(this.getAD_Client_ID()).append(" AND AD_Org_ID<>").append(this.p_AD_Org_ID);
        int no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), Msg.translate((Properties)this.getCtx(), (String)"M_Warehouse_ID"));
        sql = new StringBuilder();
        sql.append("UPDATE M_Warehouse_Acct ").append("SET AD_Org_ID=").append(this.p_AD_Org_ID).append(" WHERE M_Warehouse_ID=").append(this.p_M_Warehouse_ID).append(" AND AD_Client_ID=").append(this.getAD_Client_ID()).append(" AND AD_Org_ID<>").append(this.p_AD_Org_ID);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), Msg.translate((Properties)this.getCtx(), (String)"C_AcctSchema_ID"));
        sql = new StringBuilder();
        sql.append("UPDATE M_Locator ").append("SET AD_Org_ID=").append(this.p_AD_Org_ID).append(" WHERE M_Warehouse_ID=").append(this.p_M_Warehouse_ID).append(" AND AD_Client_ID=").append(this.getAD_Client_ID()).append(" AND AD_Org_ID<>").append(this.p_AD_Org_ID);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), Msg.translate((Properties)this.getCtx(), (String)"M_Locator_ID"));
        sql = new StringBuilder();
        sql.append("UPDATE M_StorageOnHand\t s ").append("SET AD_Org_ID=").append(this.p_AD_Org_ID).append(" WHERE EXISTS ").append("(SELECT * FROM M_Locator l WHERE l.M_Locator_ID=s.M_Locator_ID").append(" AND l.M_Warehouse_ID=").append(this.p_M_Warehouse_ID).append(") AND AD_Client_ID=").append(this.getAD_Client_ID()).append(" AND AD_Org_ID<>").append(this.p_AD_Org_ID);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), Msg.translate((Properties)this.getCtx(), (String)"Storage"));
        sql = new StringBuilder();
        sql.append("UPDATE M_StorageReservation\t s ").append("SET AD_Org_ID=").append(this.p_AD_Org_ID).append(" WHERE M_Warehouse_ID=").append(this.p_M_Warehouse_ID).append(" AND AD_Client_ID=").append(this.getAD_Client_ID()).append(" AND AD_Org_ID<>").append(this.p_AD_Org_ID);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), Msg.translate((Properties)this.getCtx(), (String)"StorageReservation"));
        return "";
    }

    private String productOwnership() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("productOwnership - M_Product_Category_ID=" + this.p_M_Product_Category_ID + ", M_Product_ID=" + this.p_M_Product_ID);
        }
        StringBuilder set = new StringBuilder(" SET AD_Org_ID=").append(this.p_AD_Org_ID);
        if (this.p_M_Product_Category_ID > 0) {
            set.append(" WHERE EXISTS (SELECT * FROM M_Product p").append(" WHERE p.M_Product_ID=x.M_Product_ID AND p.M_Product_Category_ID=").append(this.p_M_Product_Category_ID).append(")");
        } else {
            set.append(" WHERE M_Product_ID=").append(this.p_M_Product_ID);
        }
        set.append(" AND AD_Client_ID=").append(this.getAD_Client_ID()).append(" AND AD_Org_ID<>").append(this.p_AD_Org_ID);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("productOwnership - " + String.valueOf(set));
        }
        StringBuilder sql = new StringBuilder("UPDATE M_Product x ").append((CharSequence)set);
        int no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), Msg.translate((Properties)this.getCtx(), (String)"M_Product_ID"));
        sql = new StringBuilder("UPDATE M_Product_Acct x ").append((CharSequence)set);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), Msg.translate((Properties)this.getCtx(), (String)"C_AcctSchema_ID"));
        sql = new StringBuilder("UPDATE PP_Product_BOM x ").append((CharSequence)set);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), Msg.translate((Properties)this.getCtx(), (String)"PP_Product_BOM_ID"));
        sql = new StringBuilder("UPDATE PP_Product_BOMLine x ").append((CharSequence)set);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), Msg.translate((Properties)this.getCtx(), (String)"PP_Product_BOMLine_ID"));
        sql = new StringBuilder("UPDATE M_Product_PO x ").append((CharSequence)set);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), Msg.translate((Properties)this.getCtx(), (String)"PO"));
        sql = new StringBuilder("UPDATE M_Product_Trl x ").append((CharSequence)set);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), Msg.translate((Properties)this.getCtx(), (String)"AD_Language"));
        return "";
    }

    private String bPartnerOwnership() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("bPartnerOwnership - C_BP_Group_ID=" + this.p_C_BP_Group_ID + ", C_BPartner_ID=" + this.p_C_BPartner_ID);
        }
        StringBuilder set = new StringBuilder(" SET AD_Org_ID=").append(this.p_AD_Org_ID);
        if (this.p_C_BP_Group_ID > 0) {
            set.append(" WHERE EXISTS (SELECT * FROM C_BPartner bp WHERE bp.C_BPartner_ID=x.C_BPartner_ID AND bp.C_BP_Group_ID=").append(this.p_C_BP_Group_ID).append(")");
        } else {
            set.append(" WHERE C_BPartner_ID=").append(this.p_C_BPartner_ID);
        }
        set.append(" AND AD_Client_ID=").append(this.getAD_Client_ID()).append(" AND AD_Org_ID<>").append(this.p_AD_Org_ID);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("bPartnerOwnership - " + set.toString());
        }
        StringBuilder sql = new StringBuilder("UPDATE C_BPartner x ").append((CharSequence)set);
        int no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), Msg.translate((Properties)this.getCtx(), (String)"C_BPartner_ID"));
        sql = new StringBuilder("UPDATE C_BP_Customer_Acct x ").append((CharSequence)set);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), Msg.translate((Properties)this.getCtx(), (String)"C_AcctSchema_ID"));
        sql = new StringBuilder("UPDATE C_BP_Employee_Acct x ").append((CharSequence)set);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), Msg.translate((Properties)this.getCtx(), (String)"C_AcctSchema_ID"));
        sql = new StringBuilder("UPDATE C_BP_Vendor_Acct x ").append((CharSequence)set);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), Msg.translate((Properties)this.getCtx(), (String)"C_AcctSchema_ID"));
        sql = new StringBuilder("UPDATE C_BPartner_Location x ").append((CharSequence)set);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), Msg.translate((Properties)this.getCtx(), (String)"C_BPartner_Location_ID"));
        sql = new StringBuilder("UPDATE AD_User x ").append((CharSequence)set);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), Msg.translate((Properties)this.getCtx(), (String)"AD_User_ID"));
        sql = new StringBuilder("UPDATE C_BP_BankAccount x ").append((CharSequence)set);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), Msg.translate((Properties)this.getCtx(), (String)"C_BP_BankAccount_ID"));
        return "";
    }

    private void generalOwnership() {
        StringBuilder set = new StringBuilder("SET AD_Org_ID=0 WHERE AD_Client_ID=").append(this.getAD_Client_ID()).append(" AND AD_Org_ID<>0");
        StringBuilder sql = new StringBuilder("UPDATE R_ContactInterest ").append((CharSequence)set);
        int no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0 && this.log.isLoggable(Level.FINE)) {
            this.log.fine("generalOwnership - R_ContactInterest=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE AD_User_Roles ").append((CharSequence)set)).toString(), (String)this.get_TrxName())) != 0 && this.log.isLoggable(Level.FINE)) {
            this.log.fine("generalOwnership - AD_User_Roles=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE C_BPartner_Product ").append((CharSequence)set)).toString(), (String)this.get_TrxName())) != 0 && this.log.isLoggable(Level.FINE)) {
            this.log.fine("generalOwnership - C_BPartner_Product=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE C_BP_Withholding x ").append((CharSequence)set)).toString(), (String)this.get_TrxName())) != 0 && this.log.isLoggable(Level.FINE)) {
            this.log.fine("generalOwnership - C_BP_Withholding=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE M_Replenish ").append((CharSequence)set)).toString(), (String)this.get_TrxName())) != 0 && this.log.isLoggable(Level.FINE)) {
            this.log.fine("generalOwnership - M_Replenish=" + no);
        }
    }
}

