/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.cache;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import java.util.function.UnaryOperator;
import org.compiere.model.PO;
import org.compiere.util.CCache;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.idempiere.cache.ImmutablePOSupport;

public class ImmutablePOCache<K, V extends PO>
extends CCache<K, V> {
    private static final long serialVersionUID = -3342469152066078741L;

    public ImmutablePOCache(String name, int initialCapacity, int expireMinutes, boolean distributed, int maxSize) {
        super(name, initialCapacity, expireMinutes, distributed, maxSize);
    }

    public ImmutablePOCache(String name, int initialCapacity, int expireMinutes, boolean distributed) {
        super(name, initialCapacity, expireMinutes, distributed);
    }

    public ImmutablePOCache(String name, int initialCapacity, int expireMinutes) {
        super(name, initialCapacity, expireMinutes);
    }

    public ImmutablePOCache(String name, int initialCapacity) {
        super(name, initialCapacity);
    }

    public ImmutablePOCache(String tableName, String name, int initialCapacity, boolean distributed) {
        super(tableName, name, initialCapacity, distributed);
    }

    public ImmutablePOCache(String tableName, String name, int initialCapacity, int expireMinutes, boolean distributed, int maxSize) {
        super(tableName, name, initialCapacity, expireMinutes, distributed, maxSize);
    }

    public ImmutablePOCache(String tableName, String name, int initialCapacity, int expireMinutes, boolean distributed) {
        super(tableName, name, initialCapacity, expireMinutes, distributed);
    }

    public ImmutablePOCache(String tableName, String name, int initialCapacity) {
        super(tableName, name, initialCapacity);
    }

    @Override
    public V put(K key, V value) {
        return this.put(key, value, null);
    }

    public V put(K key, V po, UnaryOperator<V> copyOperator) {
        if (po == null) {
            super.put(key, po);
            return null;
        }
        ((ImmutablePOSupport)po).markImmutable();
        if (Util.isEmpty(((PO)po).get_TrxName(), true) && ((PO)po).getCtx() == Env.getCtx()) {
            super.put(key, po);
            return po;
        }
        if (copyOperator == null) {
            try {
                V copy = null;
                try {
                    copy = this.copyOf(Env.getCtx(), po);
                }
                catch (Exception exception) {}
                if (copy == null) {
                    copy = this.copyOf(Env.getCtx(), po, null);
                }
                if (copy != null) {
                    super.put(key, copy);
                    return copy;
                }
                throw new RuntimeException("No copy constructor for " + po.getClass().getName());
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new RuntimeException("Error calling copy constructor for " + po.getClass().getName() + " : " + e.getMessage(), e);
            }
        }
        PO copy = (PO)copyOperator.apply(po);
        ((ImmutablePOSupport)((Object)copy)).markImmutable();
        super.put(key, copy);
        return (V)copy;
    }

    @Override
    public V get(Object key) {
        try {
            return this.get(null, key);
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public V get(Properties ctx, K key) {
        return this.get(ctx, key, null);
    }

    public V get(Properties ctx, K key, UnaryOperator<V> copyOperator) {
        PO value = (PO)super.get(key);
        if (value == null) {
            return null;
        }
        if (ctx == null) {
            ctx = Env.getCtx();
        }
        if (ctx != value.getCtx()) {
            if (copyOperator == null) {
                try {
                    PO copy;
                    try {
                        copy = this.copyOf(ctx, value);
                        if (copy != null) {
                            return (V)copy;
                        }
                    }
                    catch (Exception exception) {}
                    copy = this.copyOf(ctx, value, null);
                    if (copy != null) {
                        return (V)copy;
                    }
                    throw new RuntimeException("No copy constructor for " + value.getClass().getName());
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    throw new RuntimeException("Error calling copy constructor for " + value.getClass().getName() + " : " + e.getMessage(), e);
                }
            }
            PO copy = (PO)copyOperator.apply(value);
            return (V)((ImmutablePOSupport)((Object)copy)).markImmutable();
        }
        return (V)value;
    }

    private V copyOf(Properties ctx, V value, String trxName) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<?> copyConstructor = value.getClass().getDeclaredConstructor(Properties.class, value.getClass(), String.class);
        if (copyConstructor != null) {
            PO copy = (PO)copyConstructor.newInstance(ctx, value, trxName);
            return (V)((ImmutablePOSupport)((Object)copy)).markImmutable();
        }
        return null;
    }

    private V copyOf(Properties ctx, V value) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<?> copyConstructor = value.getClass().getDeclaredConstructor(Properties.class, value.getClass());
        if (copyConstructor != null) {
            PO copy = (PO)copyConstructor.newInstance(ctx, value);
            return (V)((ImmutablePOSupport)((Object)copy)).markImmutable();
        }
        return null;
    }
}

