/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.impexp;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.adempiere.base.IGridTabExporter;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.db.Database;
import org.compiere.model.GridTab;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class GridTabSQLInsertExporter
implements IGridTabExporter {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void export(GridTab gridTab, List<GridTab> childs, boolean isCurrentRowOnly, File file, int indxDetailSelected) {
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try {
                FileOutputStream fos = new FileOutputStream(file);
                try {
                    try (ZipOutputStream zos = new ZipOutputStream(fos);){
                        ZipEntry directoryEntry = new ZipEntry("oracle/");
                        zos.putNextEntry(directoryEntry);
                        zos.closeEntry();
                        directoryEntry = new ZipEntry("postgresql/");
                        zos.putNextEntry(directoryEntry);
                        zos.closeEntry();
                        MTable table2 = MTable.get(gridTab.getAD_Table_ID());
                        ArrayList<String> oracles = new ArrayList<String>();
                        ArrayList<String> pgs = new ArrayList<String>();
                        if (isCurrentRowOnly) {
                            PO po = this.getPO(gridTab, table2, gridTab.getCurrentRow());
                            if (po != null) {
                                this.addSQLInsert(po, oracles, pgs);
                            }
                        } else {
                            int i2 = 0;
                            while (i2 < gridTab.getRowCount()) {
                                PO po = this.getPO(gridTab, table2, i2);
                                if (po != null) {
                                    this.addSQLInsert(po, oracles, pgs);
                                }
                                ++i2;
                            }
                        }
                        ZipEntry fileEntry = new ZipEntry("oracle/" + table2.getTableName() + ".sql");
                        zos.putNextEntry(fileEntry);
                        for (String oracle : oracles) {
                            zos.write((oracle + "\n;\n").getBytes());
                        }
                        zos.closeEntry();
                        fileEntry = new ZipEntry("postgresql/" + table2.getTableName() + ".sql");
                        zos.putNextEntry(fileEntry);
                        for (String pg : pgs) {
                            zos.write((pg + "\n;\n").getBytes());
                        }
                        zos.closeEntry();
                        if (isCurrentRowOnly) {
                            for (GridTab childTab : childs) {
                                if (!childTab.isLoadComplete()) {
                                    childTab.initTab(false);
                                    childTab.query(false, 0, 0);
                                }
                                if (childTab.getRowCount() == 0) continue;
                                table2 = MTable.get(childTab.getAD_Table_ID());
                                oracles = new ArrayList();
                                pgs = new ArrayList();
                                int i3 = 0;
                                while (i3 < childTab.getRowCount()) {
                                    PO po = this.getPO(childTab, table2, i3);
                                    if (po != null) {
                                        this.addSQLInsert(po, oracles, pgs);
                                    }
                                    ++i3;
                                }
                                fileEntry = new ZipEntry("oracle/" + table2.getTableName() + ".sql");
                                zos.putNextEntry(fileEntry);
                                for (String oracle : oracles) {
                                    zos.write((oracle + "\n;\n").getBytes());
                                }
                                zos.closeEntry();
                                fileEntry = new ZipEntry("postgresql/" + table2.getTableName() + ".sql");
                                zos.putNextEntry(fileEntry);
                                for (String pg : pgs) {
                                    zos.write((pg + "\n;\n").getBytes());
                                }
                                zos.closeEntry();
                            }
                        }
                    }
                    if (fos == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (fos == null) throw throwable;
                    fos.close();
                    throw throwable;
                }
                fos.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new AdempiereException(e);
        }
    }

    protected void addSQLInsert(PO po, List<String> oracles, List<String> pgs) {
        String sql = po.toInsertSQL();
        String oracle = Database.getDatabase(Database.DB_ORACLE).convertStatement(sql);
        String pg = Database.getDatabase(Database.DB_POSTGRESQL).convertStatement(sql);
        oracles.add(oracle);
        pgs.add(pg);
    }

    protected PO getPO(GridTab gridTab, MTable table2, int row) {
        int recordId = gridTab.getKeyID(row);
        if (recordId >= 0) {
            return table2.getPO(gridTab.getKeyID(row), null);
        }
        UUID uuid = gridTab.getTableModel().getUUID(row);
        if (uuid != null) {
            return table2.getPOByUU(uuid.toString(), null);
        }
        return null;
    }

    @Override
    public String getFileExtension() {
        return "zip";
    }

    @Override
    public String getFileExtensionLabel() {
        return Msg.getMsg(Env.getCtx(), "FileSQLInsertZip");
    }

    @Override
    public String getContentType() {
        return "application/zip";
    }

    @Override
    public String getSuggestedFileName(GridTab gridTab) {
        return gridTab.getName() + "." + this.getFileExtension();
    }

    @Override
    public boolean isExportableTab(GridTab gridTab) {
        return gridTab.isDisplayed();
    }

    @Override
    public boolean isAdvanced() {
        return true;
    }

    @Override
    public boolean isExportChildTabsForCurrentRowOnly() {
        return true;
    }

    @Override
    public int maxDeepOfChildTab() {
        return 1;
    }
}

