/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import org.adempiere.base.annotation.Process;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MColumn;
import org.compiere.model.MProcessPara;
import org.compiere.model.M_Element;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Msg;
import org.compiere.util.Util;

@Process
public class DatabaseTableColumnRename
extends SvrProcess {
    private int p_AD_Element_ID = 0;
    private int p_AD_Column_ID = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] processInfoParameterArray = this.getParameter();
        int n = processInfoParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessInfoParameter para = processInfoParameterArray[n2];
            String name = para.getParameterName();
            if ("AD_Element_ID".equals(name)) {
                this.p_AD_Element_ID = para.getParameterAsInt();
            } else {
                MProcessPara.validateUnknownParameter(this.getProcessInfo().getAD_Process_ID(), para);
            }
            ++n2;
        }
        this.p_AD_Column_ID = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        MColumn column = new MColumn(this.getCtx(), this.p_AD_Column_ID, this.get_TrxName());
        M_Element element = new M_Element(this.getCtx(), this.p_AD_Element_ID, this.get_TrxName());
        if (column.getAD_Element_ID() == this.p_AD_Element_ID || element.getAD_Element_ID() <= 0) {
            throw new AdempiereException(Util.cleanAmp(Msg.parseTranslation(this.getCtx(), "@NotValid@: @AD_Element_ID@")));
        }
        String newColumnName = element.getColumnName();
        int cnt = DB.getSQLValueEx(this.get_TrxName(), "SELECT COUNT(*) FROM AD_Column WHERE AD_Table_ID=? AND UPPER(ColumnName)=UPPER(?)", column.getAD_Table_ID(), newColumnName);
        if (cnt > 0) {
            throw new AdempiereException(Util.cleanAmp(Msg.parseTranslation(this.getCtx(), "@AlreadyExists@: @ColumnName@ = " + newColumnName)));
        }
        column.setAD_Element_ID(this.p_AD_Element_ID);
        column.setName(element.getName());
        column.setDescription(element.getDescription());
        column.setHelp(element.getHelp());
        column.setPlaceholder(element.getPlaceholder());
        String msg = column.renameDBColumn(newColumnName);
        column.saveEx();
        this.addLog(msg);
        return "@OK@";
    }
}

