/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps;

import java.io.Serializable;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.apps.AbstractProcessDialog;
import org.adempiere.webui.apps.BusyDialog;
import org.adempiere.webui.component.Tabpanel;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.event.DialogEvents;
import org.adempiere.webui.panel.ITabOnCloseHandler;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.model.MPInstance;
import org.compiere.model.MSysConfig;
import org.compiere.print.MPrintFormat;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;

public class ProcessModalDialog
extends AbstractProcessDialog
implements EventListener<Event>,
DialogEvents,
ITabOnCloseHandler {
    private static final long serialVersionUID = -3116200847404416861L;
    private static final String ON_OK_ECHO_EVENT = "onOkEcho";
    private static final CLogger log = CLogger.getCLogger(ProcessModalDialog.class);
    private String orientation;
    private ITabOnCloseHandler originalOnCloseHandler;
    private Tabpanel parentTabPanel;
    private boolean isUseEscForTabClosing = MSysConfig.getBooleanValue((String)"USE_ESC_FOR_TAB_CLOSING", (boolean)false, (int)Env.getAD_Client_ID((Properties)Env.getCtx()));

    public ProcessModalDialog(int WindowNo, ProcessInfo pi, boolean autoStart) {
        this(null, WindowNo, pi, autoStart);
    }

    public ProcessModalDialog(EventListener<Event> listener, int WindowNo, ProcessInfo pi) {
        this(listener, WindowNo, true, pi);
    }

    public ProcessModalDialog(EventListener<Event> listener, int WindowNo, boolean isReRun, ProcessInfo pi) {
        this(WindowNo, pi, false);
        if (isReRun) {
            MPInstance instance = this.getLastRun();
            if (instance != null) {
                this.loadSavedParams(instance);
                this.chooseSaveParameter(this.fSavedName.getRawText(), true);
            }
        } else if (pi != null) {
            this.getParameterPanel().loadParametersFromProcessInfo(pi);
        }
        if (listener != null) {
            this.addEventListener("onWindowClose", listener);
            this.addEventListener("onBeforeRunProcess", listener);
        }
    }

    public ProcessModalDialog(EventListener<Event> listener, int WindowNo, ProcessInfo pi, boolean autoStart) {
        this(listener, WindowNo, 0, pi, autoStart);
    }

    public ProcessModalDialog(EventListener<Event> listener, int WindowNo, int TabNo, ProcessInfo pi, boolean autoStart) {
        if (listener != null) {
            this.addEventListener("onWindowClose", listener);
            this.addEventListener("onBeforeRunProcess", listener);
        }
        log.info("Process=" + pi.getAD_Process_ID());
        try {
            this.init(Env.getCtx(), WindowNo, TabNo, pi.getAD_Process_ID(), pi, autoStart, true);
            if (this.mainParameterLayout != null) {
                this.mainParameterLayout.setStyle("max-height:" + ClientInfo.get().desktopHeight + "px");
                ZKUpdateUtil.setVflex(this.mainParameterLayout, "1");
            }
            if (this.topParameterLayout != null) {
                this.topParameterLayout.setStyle("max-height:" + (ClientInfo.get().desktopHeight - 130) + "px");
                ZKUpdateUtil.setVflex(this.topParameterLayout, "1");
            }
            if (this.bottomParameterLayout != null) {
                for (Component c : this.bottomParameterLayout.getChildren()) {
                    if (!(c instanceof HtmlBasedComponent)) continue;
                    ZKUpdateUtil.setVflex((HtmlBasedComponent)c, "min");
                }
            }
            this.setSclass("popup-dialog process-modal-dialog z-flex z-flex-column");
            this.setSizable(true);
            this.setMaximizable(true);
            if (ClientInfo.isMobile()) {
                this.orientation = ClientInfo.get().orientation;
                ClientInfo.onClientInfo((Component)this, this::onClientInfo);
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "", (Throwable)ex);
        }
        this.addEventListener(ON_OK_ECHO_EVENT, this);
        this.addEventListener("onCancel", e -> this.onCancel());
    }

    public ProcessModalDialog(int WindowNo, int AD_Process_ID, int tableId, int recordId, boolean autoStart) {
        this(null, WindowNo, AD_Process_ID, tableId, recordId, autoStart);
    }

    public ProcessModalDialog(EventListener<Event> listener, int WindowNo, int AD_Process_ID, int tableId, int recordId, boolean autoStart) {
        this(listener, WindowNo, new ProcessInfo("", AD_Process_ID, tableId, recordId), autoStart);
    }

    public ProcessModalDialog(EventListener<Event> listener, int WindowNo, int AD_Process_ID, int tableId, int recordId, String recordUU, boolean autoStart) {
        this(listener, WindowNo, new ProcessInfo("", AD_Process_ID, tableId, recordId, recordUU), autoStart);
    }

    public ProcessModalDialog(Window parent, String title, int WindowNo, int AD_Process_ID, int tableId, int recordId, boolean autoStart) {
        this(WindowNo, AD_Process_ID, tableId, recordId, autoStart);
    }

    public boolean setVisible(boolean visible) {
        return super.setVisible(visible);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.getParameterPanel().restoreContext();
        this.detach();
    }

    @Override
    public void autoStart() {
        this.setBorder("none");
        this.setTitle(null);
        this.getFirstChild().setVisible(false);
        super.autoStart();
    }

    @Override
    public void showBusyDialog() {
        BusyDialog progressWindow = this.createBusyDialog();
        if (this.getParent() != null) {
            this.getParent().appendChild((Component)progressWindow);
            LayoutUtils.openOverlappedWindow(this.getParent(), progressWindow, "middle_center");
        }
        this.setVisible(false);
    }

    @Override
    public void updateUI() {
        if (this.parentTabPanel != null) {
            this.parentTabPanel.setOnCloseHandler(this.originalOnCloseHandler);
            this.originalOnCloseHandler = null;
            this.parentTabPanel = null;
        }
    }

    @Override
    public void hideBusyDialog() {
        this.closeBusyDialog();
    }

    public void onPageAttached(Page newpage, Page oldpage) {
        super.onPageAttached(newpage, oldpage);
        Component parent = this.getParent();
        while (parent != null) {
            if (parent instanceof Tabpanel) {
                this.parentTabPanel = (Tabpanel)parent;
                this.originalOnCloseHandler = this.parentTabPanel.getOnCloseHandler();
                this.parentTabPanel.setOnCloseHandler(this);
                break;
            }
            parent = parent.getParent();
        }
    }

    @Override
    public void onPageDetached(Page page) {
        super.onPageDetached(page);
        if (this.parentTabPanel != null && this.isCancel()) {
            this.parentTabPanel.setOnCloseHandler(this.originalOnCloseHandler);
            this.originalOnCloseHandler = null;
            this.parentTabPanel = null;
        }
    }

    @Override
    public void onEvent(Event event) {
        Component component = event.getTarget();
        if (component.equals((Object)this.bOK)) {
            super.onEvent(event);
            this.onOk();
        } else if (event.getName().equals(ON_OK_ECHO_EVENT)) {
            this.onOk();
        } else if (component.equals((Object)this.bCancel)) {
            super.onEvent(event);
            this.onCancel();
        } else {
            super.onEvent(event);
        }
    }

    private void onCancel() {
        if (this.isUseEscForTabClosing) {
            SessionManager.getAppDesktop().setCloseTabWithShortcut(false);
        }
        this.cancelProcess();
    }

    private void onOk() {
        MPrintFormat format;
        if (this.getParameterPanel().isWaitingForDialog()) {
            Events.echoEvent((String)ON_OK_ECHO_EVENT, (Component)this, null);
            return;
        }
        if (this.fPrintFormat != null && this.fPrintFormat.getValue() != null && (format = new MPrintFormat(Env.getCtx(), ((Integer)this.fPrintFormat.getValue()).intValue(), null)) != null) {
            this.getProcessInfo().setSerializableObject((Serializable)format);
        }
        if (this.freportType != null && this.freportType.getSelectedItem() != null) {
            this.getProcessInfo().setReportType(this.freportType.getSelectedItem().getValue().toString());
        }
        this.startProcess();
    }

    protected void onClientInfo() {
        String newOrientation;
        if (this.getPage() != null && !(newOrientation = ClientInfo.get().orientation).equals(this.orientation)) {
            this.orientation = newOrientation;
            if (this.mainParameterLayout != null) {
                this.mainParameterLayout.setStyle("max-height:" + ClientInfo.get().desktopHeight + "px");
            }
            if (this.topParameterLayout != null) {
                this.topParameterLayout.setStyle("max-height:" + (ClientInfo.get().desktopHeight - 130) + "px");
            }
            this.invalidate();
        }
    }

    @Override
    public void onClose(Tabpanel tabPanel) {
    }
}

