/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.model;

import java.util.Properties;
import org.compiere.model.MTestUU;
import org.compiere.model.X_TestUUDet;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.idempiere.test.AbstractTestCase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@Execution(value=ExecutionMode.SAME_THREAD)
public class MTestUUTest
extends AbstractTestCase {
    private static final String TestRecordInGardenWorld = "8858ecc2-cf1d-405f-987f-793536037e76";
    private static final String TestRecordInSystem = "4e148b89-bdd9-48a6-8a8a-7609092f965c";

    @Test
    public void testReadingUpdatingTestUU() {
        Properties ctx = Env.getCtx();
        String trxName = this.getTrxName();
        MTestUU testuu = new MTestUU(ctx, TestRecordInGardenWorld, trxName);
        testuu.setDescription("Test setting description");
        testuu.saveEx();
        testuu.load(trxName, new String[0]);
        Assertions.assertEquals((Object)"Test setting description", (Object)testuu.getDescription());
    }

    @Test
    public void testInsertingTestUU() {
        Properties ctx = Env.getCtx();
        String trxName = this.getTrxName();
        MTestUU testuu = new MTestUU(ctx, "", trxName);
        testuu.setName("Test UU record created on JUnit test");
        testuu.saveEx();
        testuu.load(trxName, new String[0]);
        Assertions.assertEquals((Object)"Test UU record created on JUnit test", (Object)testuu.getName());
        String uukey = testuu.getTestUU_UU();
        String uuid = testuu.get_UUID();
        Assertions.assertTrue((boolean)Util.isUUID((String)uukey));
        Assertions.assertEquals((Object)uukey, (Object)uuid);
    }

    @Test
    public void testDeletingTestUU() {
        Properties ctx = Env.getCtx();
        String trxName = this.getTrxName();
        MTestUU testuu = new MTestUU(ctx, TestRecordInGardenWorld, trxName);
        testuu.deleteEx(true);
        MTestUU testuu2 = new MTestUU(ctx, TestRecordInGardenWorld, trxName);
        Assertions.assertFalse((boolean)testuu2.get_UUID().equals(TestRecordInGardenWorld));
    }

    @Test
    public void testInsertingTestUUDet() {
        Properties ctx = Env.getCtx();
        String trxName = this.getTrxName();
        X_TestUUDet testuudet = new X_TestUUDet(ctx, "", trxName);
        testuudet.setName("Test UU Det record created on JUnit test");
        testuudet.setTestUU_UU(TestRecordInGardenWorld);
        testuudet.setAltTestUU_UU(TestRecordInSystem);
        Assertions.assertTrue((boolean)testuudet.validForeignKeys());
        testuudet.saveEx();
        testuudet.load(trxName, new String[0]);
        Assertions.assertEquals((Object)"Test UU Det record created on JUnit test", (Object)testuudet.getName());
        String uukey = testuudet.getTestUUDet_UU();
        String uuid = testuudet.get_UUID();
        Assertions.assertTrue((boolean)Util.isUUID((String)uukey));
        Assertions.assertEquals((Object)uukey, (Object)uuid);
        Assertions.assertEquals((Object)testuudet.getAltTestUU_UU(), (Object)TestRecordInSystem);
        Assertions.assertEquals((Object)testuudet.getTestUU_UU(), (Object)TestRecordInGardenWorld);
    }
}

