/*
 * Decompiled with CFR 0.152.
 */
package org.passay;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;

public class RuleResultDetail {
    protected final String[] errorCodes;
    protected final Map<String, Object> parameters;

    public RuleResultDetail(String code, Map<String, Object> params) {
        if (code == null || code.length() == 0) {
            throw new IllegalArgumentException("Code cannot be null or empty.");
        }
        this.errorCodes = new String[]{code};
        this.parameters = params == null ? new LinkedHashMap<String, Object>() : new LinkedHashMap<String, Object>(params);
    }

    public RuleResultDetail(String[] codes, Map<String, Object> params) {
        if (codes == null || codes.length == 0) {
            throw new IllegalArgumentException("Must specify at least one error code.");
        }
        for (String code : codes) {
            if (code != null && code.length() != 0) continue;
            throw new IllegalArgumentException("Code cannot be null or empty.");
        }
        this.errorCodes = codes;
        this.parameters = params == null ? new LinkedHashMap<String, Object>() : new LinkedHashMap<String, Object>(params);
    }

    public String getErrorCode() {
        return this.errorCodes[this.errorCodes.length - 1];
    }

    public String[] getErrorCodes() {
        return this.errorCodes;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public Object[] getValues() {
        return this.parameters.values().toArray();
    }

    public String toString() {
        return String.format("%s:%s", Arrays.toString(this.errorCodes), this.parameters);
    }
}

