/*
 * Decompiled with CFR 0.152.
 */
package com.trekglobal.idempiere.rest.api.v1.resource.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.trekglobal.idempiere.rest.api.json.IDempiereRestException;
import com.trekglobal.idempiere.rest.api.json.IPOSerializer;
import com.trekglobal.idempiere.rest.api.json.ResponseUtils;
import com.trekglobal.idempiere.rest.api.json.filter.ConvertedQuery;
import com.trekglobal.idempiere.rest.api.json.filter.IQueryConverter;
import com.trekglobal.idempiere.rest.api.util.ErrorBuilder;
import com.trekglobal.idempiere.rest.api.v1.resource.StatusLineResource;
import java.util.List;
import java.util.logging.Level;
import javax.ws.rs.core.Response;
import org.compiere.model.MStatusLine;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class StatusLineResourceImpl
implements StatusLineResource {
    private static final CLogger log = CLogger.getCLogger(StatusLineResourceImpl.class);

    @Override
    public Response getStatusLines(String filter, boolean includeMsg) {
        IQueryConverter converter = IQueryConverter.getQueryConverter("DEFAULT");
        try {
            ConvertedQuery convertedStatement = converter.convertStatement("AD_StatusLine", filter);
            if (log.isLoggable(Level.INFO)) {
                log.info("Where Clause: " + convertedStatement.getWhereClause());
            }
            JsonArray statusLineArray = new JsonArray();
            Query query = new Query(Env.getCtx(), "AD_StatusLine", convertedStatement.getWhereClause(), null);
            query.setApplyAccessFilter(true).setOnlyActiveRecords(true).setOrderBy("Name");
            query.setParameters(convertedStatement.getParameters());
            List statusLines = query.list();
            IPOSerializer serializer = IPOSerializer.getPOSerializer("AD_StatusLine", MTable.getClass((String)"AD_StatusLine"));
            for (MStatusLine statusLine : statusLines) {
                JsonObject jsonObject = serializer.toJson((PO)statusLine, new String[]{"AD_StatusLine_ID", "AD_StatusLine_UU", "Name", "EntityType"}, null);
                if (includeMsg) {
                    this.addMessageToJsonObject(jsonObject, statusLine);
                }
                statusLineArray.add((JsonElement)jsonObject);
            }
            JsonObject json = new JsonObject();
            json.add("statusLines", (JsonElement)statusLineArray);
            return Response.ok((Object)json.toString()).build();
        }
        catch (Exception ex) {
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            if (ex instanceof IDempiereRestException) {
                status = ((IDempiereRestException)((Object)ex)).getErrorResponseStatus();
            }
            log.log(Level.SEVERE, ex.getMessage(), (Throwable)ex);
            return Response.status((Response.Status)status).entity((Object)new ErrorBuilder().status(status).title("GET Error").append("Get status lines with exception: ").append(ex.getMessage()).build().toString()).build();
        }
    }

    @Override
    public Response getStatusLineValue(String id) {
        try {
            boolean isUUID = Util.isUUID((String)id);
            int statusLineId = isUUID ? this.getStatusLineID(id) : Integer.valueOf(id).intValue();
            MStatusLine statusLine = new MStatusLine(Env.getCtx(), statusLineId, null);
            if (statusLine.getSQLStatement() != null) {
                JsonObject json = new JsonObject();
                this.addMessageToJsonObject(json, statusLine);
                return Response.ok((Object)json.toString()).build();
            }
            return ResponseUtils.getResponseError(Response.Status.NOT_FOUND, "Status Line not found", "No valid status line with the given id = ", String.valueOf(statusLineId));
        }
        catch (Exception ex) {
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            if (ex instanceof IDempiereRestException) {
                status = ((IDempiereRestException)((Object)ex)).getErrorResponseStatus();
            }
            log.log(Level.SEVERE, ex.getMessage(), (Throwable)ex);
            return Response.status((Response.Status)status).entity((Object)new ErrorBuilder().status(status).title("GET Error").append("Get status line with exception: ").append(ex.getMessage()).build().toString()).build();
        }
    }

    private int getStatusLineID(String uuid) {
        String sql = "SELECT AD_StatusLine_ID FROM AD_StatusLine WHERE AD_StatusLine_UU = ?";
        return DB.getSQLValue(null, (String)sql, (String)uuid);
    }

    private void addMessageToJsonObject(JsonObject json, MStatusLine statusLine) {
        String line = statusLine.parseLine(0);
        json.addProperty("message", line);
    }
}

