/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print;

import java.sql.ResultSet;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.print.MPrintFormat;
import org.compiere.print.MPrintFormatItem;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class PrintFormatUtil {
    private CLogger log = CLogger.getCLogger(this.getClass());
    private Properties m_ctx;

    public PrintFormatUtil(Properties ctx) {
        this.m_ctx = ctx;
    }

    @Deprecated
    public void addMissingColumns() {
        this.addMissingColumns((String)null);
    }

    public void addMissingColumns(String trxName) {
        int total;
        block7: {
            total = 0;
            String sql = "SELECT * FROM AD_PrintFormat pf ORDER BY Name";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, trxName);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        total += this.addMissingColumns(new MPrintFormat(this.m_ctx, rs, trxName));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Total = " + total);
        }
    }

    public int addMissingColumns(MPrintFormat pf) {
        int counter;
        block12: {
            if (this.log.isLoggable(Level.CONFIG)) {
                this.log.config(pf.toString());
            }
            String sql = "SELECT c.AD_Column_ID, c.ColumnName FROM AD_Column c WHERE NOT EXISTS (SELECT * FROM AD_PrintFormatItem pfi INNER JOIN AD_PrintFormat pf ON (pfi.AD_PrintFormat_ID=pf.AD_PrintFormat_ID) WHERE pf.AD_Table_ID=c.AD_Table_ID AND pfi.AD_Column_ID=c.AD_Column_ID AND pfi.AD_PrintFormat_ID=?) AND c.AD_Table_ID=? ORDER BY c.AD_Column_ID";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            counter = 0;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, pf.get_TrxName());
                    pstmt.setInt(1, pf.getAD_PrintFormat_ID());
                    pstmt.setInt(2, pf.getAD_Table_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        int AD_Column_ID = rs.getInt(1);
                        String ColumnName = rs.getString(2);
                        MPrintFormatItem pfi = MPrintFormatItem.createFromColumn(pf, AD_Column_ID, 0);
                        if (pfi.get_ID() != 0) {
                            if (!this.log.isLoggable(Level.FINE)) continue;
                            this.log.fine("#" + ++counter + " - added " + ColumnName);
                            continue;
                        }
                        this.log.warning("Not added: " + ColumnName);
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block12;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (counter == 0) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("None");
            }
        } else if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Added=" + counter);
        }
        return counter;
    }
}

