/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.awt.Color;
import java.util.Enumeration;
import java.util.logging.Level;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class MTreeNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = -6871590404494812487L;
    private int m_node_ID;
    private int m_seqNo;
    private String m_name;
    private String m_description;
    private int m_parent_ID;
    private boolean m_isSummary;
    private String m_imageIndicator;
    private int m_imageIndex = 0;
    private boolean m_onBar;
    private Color m_color;
    private int m_menu_ID;
    private boolean m_iscollapsible;
    private static CLogger log = CLogger.getCLogger(MTreeNode.class);
    public static int TYPE_WINDOW = 1;
    public static int TYPE_REPORT = 2;
    public static int TYPE_PROCESS = 3;
    public static int TYPE_WORKFLOW = 4;
    public static int TYPE_WORKBENCH = 5;
    public static int TYPE_SETVARIABLE = 6;
    public static int TYPE_USERCHOICE = 7;
    public static int TYPE_DOCACTION = 8;
    public static int TYPE_INFO = 9;
    public static String[] PATHS;
    public static Icon[] IMAGES;
    private int m_lastID = -1;
    private MTreeNode m_lastNode = null;

    static {
        String[] stringArray = new String[9];
        stringArray[1] = "mWindow.png";
        stringArray[2] = "mReport.png";
        stringArray[3] = "mProcess.png";
        stringArray[4] = "mWorkFlow.png";
        stringArray[5] = "mWorkbench.png";
        stringArray[6] = "mSetVariable.png";
        stringArray[7] = "mUserChoice.png";
        stringArray[8] = "mDocAction.png";
        PATHS = stringArray;
        Icon[] iconArray = new Icon[9];
        iconArray[1] = Env.getImageIcon("mWindow.png");
        iconArray[2] = Env.getImageIcon("mReport.png");
        iconArray[3] = Env.getImageIcon("mProcess.png");
        iconArray[4] = Env.getImageIcon("mWorkFlow.png");
        iconArray[5] = Env.getImageIcon("mWorkbench.png");
        iconArray[6] = Env.getImageIcon("mSetVariable.png");
        iconArray[7] = Env.getImageIcon("mUserChoice.png");
        iconArray[8] = Env.getImageIcon("mDocAction.png");
        IMAGES = iconArray;
    }

    public MTreeNode(int node_ID, int seqNo, String name, String description, int parent_ID, boolean isSummary, String imageIndicator, boolean onBar, Color color) {
        this.m_node_ID = node_ID;
        this.m_seqNo = seqNo;
        this.m_name = name;
        this.m_description = description;
        if (this.m_description == null) {
            this.m_description = "";
        }
        this.m_parent_ID = parent_ID;
        this.setSummary(isSummary);
        this.setImageIndicator(imageIndicator);
        this.m_onBar = onBar;
        this.m_color = color;
    }

    public MTreeNode(int node_ID, int seqNo, String name, String description, int parent_ID, int menu_ID, String img2, boolean isSummary, boolean isCollapsible, boolean isFavourite) {
        this(node_ID, seqNo, name, description, parent_ID, isSummary, img2, isFavourite, null);
        this.setMenu_ID(menu_ID);
        this.setCollapsible(isCollapsible);
    }

    public int getNode_ID() {
        return this.m_node_ID;
    }

    public void setName(String name) {
        this.m_name = name == null ? "" : name;
    }

    public String getName() {
        return this.m_name;
    }

    public String getSeqNo() {
        Object retValue = "0000" + this.m_seqNo;
        if (this.m_seqNo > 99999) {
            log.log(Level.SEVERE, "MTreeNode.getIndex - TreeNode Index is higher than 99999");
        }
        if (((String)retValue).length() > 5) {
            retValue = ((String)retValue).substring(((String)retValue).length() - 5);
        }
        return retValue;
    }

    public int getParent_ID() {
        return this.m_parent_ID;
    }

    public void setParent_ID(int parent_ID) {
        this.m_parent_ID = parent_ID;
    }

    @Override
    public String toString() {
        return this.m_name;
    }

    public String getDescription() {
        return this.m_description;
    }

    public void setDescription(String description) {
        this.m_description = description == null ? "" : description;
    }

    public void setSummary(boolean isSummary) {
        this.m_isSummary = isSummary;
        super.setAllowsChildren(isSummary);
    }

    @Override
    public void setAllowsChildren(boolean isSummary) {
        super.setAllowsChildren(isSummary);
        this.m_isSummary = isSummary;
    }

    public boolean isSummary() {
        return this.m_isSummary;
    }

    public int getMenu_ID() {
        return this.m_menu_ID;
    }

    public void setMenu_ID(int m_menu_ID) {
        this.m_menu_ID = m_menu_ID;
    }

    public boolean isCollapsible() {
        return this.m_iscollapsible;
    }

    public void setCollapsible(boolean m_iscollapsible) {
        this.m_iscollapsible = m_iscollapsible;
    }

    public static int getImageIndex(String imageIndicator) {
        int imageIndex = 0;
        if (imageIndicator != null) {
            if (imageIndicator.equals("W") || imageIndicator.equals("X") || imageIndicator.equals("I")) {
                imageIndex = TYPE_WINDOW;
            } else if (imageIndicator.equals("R")) {
                imageIndex = TYPE_REPORT;
            } else if (imageIndicator.equals("P") || imageIndicator.equals("T")) {
                imageIndex = TYPE_PROCESS;
            } else if (imageIndicator.equals("F")) {
                imageIndex = TYPE_WORKFLOW;
            } else if (imageIndicator.equals("V")) {
                imageIndex = TYPE_SETVARIABLE;
            } else if (imageIndicator.equals("C")) {
                imageIndex = TYPE_USERCHOICE;
            } else if (imageIndicator.equals("D")) {
                imageIndex = TYPE_DOCACTION;
            } else if (imageIndicator.equals("Z")) {
                // empty if block
            }
        }
        return imageIndex;
    }

    public void setImageIndicator(String imageIndicator) {
        if (imageIndicator != null) {
            this.m_imageIndicator = imageIndicator;
            this.m_imageIndex = MTreeNode.getImageIndex(this.m_imageIndicator);
        }
    }

    public String getImageIndiactor() {
        return this.m_imageIndicator;
    }

    public String getImagePath() {
        if (this.m_imageIndex == 0 || PATHS == null || this.m_imageIndex > PATHS.length) {
            return "/images/Folder16.png";
        }
        return "/images/" + PATHS[this.m_imageIndex];
    }

    public static Icon getIcon(int index) {
        if (index == 0 || IMAGES == null || index > IMAGES.length) {
            return null;
        }
        return IMAGES[index];
    }

    public Icon getIcon() {
        return MTreeNode.getIcon(this.m_imageIndex);
    }

    public boolean isOnBar() {
        return this.m_onBar;
    }

    public boolean isProcess() {
        return "P".equals(this.m_imageIndicator);
    }

    public boolean isReport() {
        return "R".equals(this.m_imageIndicator);
    }

    public boolean isWindow() {
        return "W".equals(this.m_imageIndicator);
    }

    @Deprecated
    public boolean isWorkbench() {
        return "B".equals(this.m_imageIndicator);
    }

    public boolean isWorkFlow() {
        return "F".equals(this.m_imageIndicator);
    }

    public boolean isForm() {
        return "X".equals(this.m_imageIndicator);
    }

    public boolean isTask() {
        return "T".equals(this.m_imageIndicator);
    }

    public boolean isInfo() {
        return "I".equals(this.m_imageIndicator);
    }

    public Color getColor() {
        if (this.m_color != null) {
            return this.m_color;
        }
        return Color.black;
    }

    public MTreeNode findNode(int ID) {
        if (this.m_node_ID == ID) {
            return this;
        }
        if (ID == this.m_lastID && this.m_lastNode != null) {
            return this.m_lastNode;
        }
        Enumeration<TreeNode> en = this.preorderEnumeration();
        while (en.hasMoreElements()) {
            MTreeNode nd = (MTreeNode)en.nextElement();
            if (ID != nd.getNode_ID()) continue;
            this.m_lastID = ID;
            this.m_lastNode = nd;
            return nd;
        }
        return null;
    }
}

