/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.model.IInfoColumn;
import org.compiere.db.Database;
import org.compiere.model.AccessSqlParser;
import org.compiere.model.I_AD_Val_Rule;
import org.compiere.model.MColumn;
import org.compiere.model.MInfoWindow;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.model.MValRule;
import org.compiere.model.M_Element;
import org.compiere.model.PO;
import org.compiere.model.X_AD_InfoColumn;
import org.compiere.util.DB;
import org.compiere.util.DefaultEvaluatee;
import org.compiere.util.Env;
import org.compiere.util.Evaluatee;
import org.compiere.util.Evaluator;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.idempiere.cache.ImmutablePOSupport;

public class MInfoColumn
extends X_AD_InfoColumn
implements IInfoColumn,
ImmutablePOSupport {
    private static final long serialVersionUID = 3909164419255524834L;
    private MInfoWindow m_parent = null;

    public MInfoColumn(Properties ctx, String AD_InfoColumn_UU, String trxName) {
        super(ctx, AD_InfoColumn_UU, trxName);
    }

    public MInfoColumn(Properties ctx, int AD_InfoColumn_ID, String trxName) {
        super(ctx, AD_InfoColumn_ID, trxName);
    }

    public MInfoColumn(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MInfoColumn(MInfoWindow targetInfoWindow) {
        this(targetInfoWindow.getCtx(), 0, targetInfoWindow.get_TrxName());
        this.m_parent = targetInfoWindow;
        this.setAD_InfoWindow_ID(targetInfoWindow.getAD_InfoWindow_ID());
        this.setEntityType(targetInfoWindow.getEntityType());
    }

    public MInfoColumn(MInfoColumn copy) {
        this(Env.getCtx(), 0, null);
        this.copyPO(copy);
        this.m_parent = copy.m_parent != null ? new MInfoWindow(copy.m_parent) : null;
    }

    public MInfoWindow getParent() {
        if (this.m_parent == null) {
            this.m_parent = new MInfoWindow(this.getCtx(), this.getAD_InfoWindow_ID(), this.get_TrxName());
        }
        return this.m_parent;
    }

    public boolean isColumnAccess(AccessSqlParser.TableInfo[] tableInfos) {
        String synonym = null;
        String column = null;
        int index = this.getSelectClause().indexOf(".");
        if (index == this.getSelectClause().lastIndexOf(".") && index >= 0) {
            synonym = this.getSelectClause().substring(0, index);
            column = this.getSelectClause().substring(index + 1);
        } else if (tableInfos.length == 1) {
            synonym = Util.isEmpty(tableInfos[0].getSynonym(), true) ? tableInfos[0].getTableName() : tableInfos[0].getSynonym();
            column = this.getSelectClause();
        }
        if (!Util.isEmpty(synonym, true) && !Util.isEmpty(column, true)) {
            AccessSqlParser.TableInfo[] tableInfoArray = tableInfos;
            int n = tableInfos.length;
            int n2 = 0;
            while (n2 < n) {
                AccessSqlParser.TableInfo tableInfo = tableInfoArray[n2];
                if (!Util.isEmpty(tableInfo.getSynonym(), true) && tableInfo.getSynonym().equals(synonym) || Util.isEmpty(tableInfo.getSynonym(), true) && tableInfo.getTableName().equals(synonym)) {
                    MColumn mColumn;
                    String tableName = tableInfo.getTableName();
                    MTable mTable = MTable.get(Env.getCtx(), tableName);
                    if (mTable != null && (mColumn = mTable.getColumn(column)) != null && !MRole.getDefault().isColumnAccess(mTable.getAD_Table_ID(), mColumn.getAD_Column_ID(), true)) {
                        return false;
                    }
                }
                ++n2;
            }
        }
        return true;
    }

    public boolean isDisplayed(Properties ctx, int windowNo) {
        if (!this.isDisplayed()) {
            return false;
        }
        if (this.getDisplayLogic() == null || this.getDisplayLogic().trim().length() == 0) {
            return true;
        }
        DefaultEvaluatee de = new DefaultEvaluatee(null, windowNo, -1, true);
        Evaluatee evaluatee = variableName -> de.get_ValueAsString(ctx, variableName);
        boolean retValue = Evaluator.evaluateLogic(evaluatee, this.getDisplayLogic());
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest(this.getName() + " (" + this.getDisplayLogic() + ") => " + retValue);
        }
        return retValue;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        String error = Database.isValidIdentifier(this.getColumnName());
        if (!Util.isEmpty(error)) {
            this.log.saveError("Error", Msg.getMsg(this.getCtx(), error) + " [ColumnName]");
            return false;
        }
        if ((newRecord || this.is_ValueChanged("AD_Element_ID")) && this.getAD_Element_ID() != 0 && this.isCentrallyMaintained()) {
            M_Element element = new M_Element(this.getCtx(), this.getAD_Element_ID(), this.get_TrxName());
            this.setName(element.getName());
        }
        if (this.isQueryCriteria() && this.getSeqNoSelection() <= 0) {
            int next = DB.getSQLValueEx(this.get_TrxName(), "SELECT ROUND((COALESCE(MAX(SeqNoSelection),0)+10)/10,0)*10 FROM AD_InfoColumn WHERE AD_InfoWindow_ID=? AND IsQueryCriteria='Y' AND IsActive='Y'", this.getAD_InfoWindow_ID());
            this.setSeqNoSelection(next);
        }
        if (!this.isQueryCriteria()) {
            if (this.isQueryAfterChange()) {
                this.setIsQueryAfterChange(false);
            }
            if (this.isMandatory()) {
                this.setIsMandatory(false);
            }
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        boolean isNeedValid;
        if (!success) {
            return success;
        }
        boolean bl = isNeedValid = this.getParent().isValidateEachColumn() && (newRecord || this.is_ValueChanged("SelectClause"));
        if (isNeedValid) {
            this.getParent().validate();
            this.getParent().saveEx(this.get_TrxName());
        }
        return super.afterSave(newRecord, success);
    }

    @Override
    protected boolean afterDelete(boolean success) {
        this.getParent().validate();
        this.getParent().saveEx(this.get_TrxName());
        return super.afterDelete(success);
    }

    @Override
    public int getInfoColumnID() {
        return this.get_ID();
    }

    @Override
    public MInfoColumn getAD_InfoColumn() {
        return this;
    }

    @Override
    public I_AD_Val_Rule getAD_Val_Rule() throws RuntimeException {
        return MValRule.getCopy(this.getCtx(), this.getAD_Val_Rule_ID(), this.get_TrxName());
    }

    @Override
    public PO markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        if (this.m_parent != null && !this.m_parent.is_Immutable()) {
            this.m_parent.markImmutable();
        }
        return this;
    }
}

