/*
 * Decompiled with CFR 0.152.
 */
package com.trekglobal.idempiere.rest.api.v1.resource.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.trekglobal.idempiere.rest.api.json.ResponseUtils;
import com.trekglobal.idempiere.rest.api.json.filter.ConvertedQuery;
import com.trekglobal.idempiere.rest.api.json.filter.IQueryConverter;
import com.trekglobal.idempiere.rest.api.model.MRestView;
import com.trekglobal.idempiere.rest.api.model.MRestViewColumn;
import com.trekglobal.idempiere.rest.api.model.MRestViewRelated;
import com.trekglobal.idempiere.rest.api.v1.resource.ViewResource;
import com.trekglobal.idempiere.rest.api.v1.resource.impl.ModelResourceImpl;
import com.trekglobal.idempiere.rest.api.v1.resource.impl.YAMLSchema;
import java.util.List;
import java.util.logging.Level;
import javax.ws.rs.core.Response;
import org.compiere.model.MColumn;
import org.compiere.model.MTable;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class ViewResourceImpl
implements ViewResource {
    private static final CLogger log = CLogger.getCLogger(ViewResourceImpl.class);

    private ModelResourceImpl restView() {
        return new ModelResourceImpl().restView();
    }

    @Override
    public Response getPO(String tableName, String id, String details, String select, String showsql) {
        return this.restView().getPO(tableName, id, details, select, showsql);
    }

    @Override
    public Response getPOProperty(String tableName, String id, String propertyName, String showsql) {
        return this.restView().getPOProperty(tableName, id, propertyName, showsql);
    }

    @Override
    public Response getPOs(String tableName, String details, String filter, String order, String select, int top, int skip, String validationRuleID, String context, String showsql) {
        return this.restView().getPOs(tableName, details, filter, order, select, top, skip, validationRuleID, context, showsql);
    }

    @Override
    public Response getModels(String filter) {
        IQueryConverter converter = IQueryConverter.getQueryConverter("DEFAULT");
        try {
            ConvertedQuery convertedStatement = converter.convertStatement("REST_View", filter);
            if (log.isLoggable(Level.INFO)) {
                log.info("Where Clause: " + convertedStatement.getWhereClause());
            }
            Query query = new Query(Env.getCtx(), "REST_View", convertedStatement.getWhereClause(), null);
            query.setOnlyActiveRecords(true).setApplyAccessFilter(true);
            query.setParameters(convertedStatement.getParameters());
            List views = query.setOrderBy("REST_View.Name").list();
            JsonArray array = new JsonArray();
            for (MRestView view : views) {
                MRestViewRelated[] relateds;
                int n;
                MRestViewColumn[] columns;
                JsonObject json = new JsonObject();
                json.addProperty("id", (Number)view.getREST_View_ID());
                if (!Util.isEmpty((String)view.getREST_View_UU())) {
                    json.addProperty("uid", view.getREST_View_UU());
                }
                json.addProperty("name", view.getName());
                MTable table = MTable.get((int)view.getAD_Table_ID());
                json.addProperty("tableName", table.getTableName().toLowerCase());
                if (!Util.isEmpty((String)view.getWhereClause())) {
                    json.addProperty("whereClause", view.getWhereClause());
                }
                if ((columns = view.getColumns()).length > 0) {
                    JsonArray columnArray = new JsonArray();
                    MRestViewColumn[] mRestViewColumnArray = columns;
                    n = columns.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MRestViewColumn column = mRestViewColumnArray[n2];
                        JsonObject columnJson = new JsonObject();
                        columnJson.addProperty("id", (Number)column.get_ID());
                        if (!Util.isEmpty((String)column.getREST_ViewColumn_UU())) {
                            columnJson.addProperty("uid", column.getREST_ViewColumn_UU());
                        }
                        columnJson.addProperty("name", column.getName());
                        MColumn tableColumn = MColumn.get((int)column.getAD_Column_ID());
                        columnJson.addProperty("columnName", tableColumn.getColumnName());
                        String helpText = null;
                        helpText = !Util.isEmpty((String)tableColumn.get_Translation("Help")) ? tableColumn.get_Translation("Help") : tableColumn.get_Translation("Description");
                        if (!Util.isEmpty((String)helpText)) {
                            columnJson.addProperty("help", helpText);
                        }
                        if (column.getREST_ReferenceView_ID() > 0) {
                            MRestView referenceView = MRestView.get(column.getREST_ReferenceView_ID());
                            JsonObject refJson = new JsonObject();
                            refJson.addProperty("id", (Number)referenceView.get_ID());
                            if (!Util.isEmpty((String)referenceView.getREST_View_UU())) {
                                refJson.addProperty("uid", referenceView.getREST_View_UU());
                            }
                            refJson.addProperty("name", referenceView.getName());
                            columnJson.add("referenceView", (JsonElement)refJson);
                        }
                        columnArray.add((JsonElement)columnJson);
                        ++n2;
                    }
                    json.add("columns", (JsonElement)columnArray);
                }
                if ((relateds = view.getRelatedViews()).length > 0) {
                    JsonArray relatedArray = new JsonArray();
                    MRestViewRelated[] mRestViewRelatedArray = relateds;
                    int n3 = relateds.length;
                    n = 0;
                    while (n < n3) {
                        MRestViewRelated related = mRestViewRelatedArray[n];
                        JsonObject relatedJson = new JsonObject();
                        relatedJson.addProperty("id", (Number)related.get_ID());
                        if (!Util.isEmpty((String)related.getREST_ViewRelated_UU())) {
                            relatedJson.addProperty("uid", related.getREST_ViewRelated_UU());
                        }
                        relatedJson.addProperty("name", related.getName());
                        MRestView referenceView = MRestView.get(related.getREST_RelatedRestView_ID());
                        JsonObject refJson = new JsonObject();
                        refJson.addProperty("id", (Number)referenceView.get_ID());
                        if (!Util.isEmpty((String)referenceView.getREST_View_UU())) {
                            refJson.addProperty("uid", referenceView.getREST_View_UU());
                        }
                        refJson.addProperty("name", referenceView.getName());
                        relatedJson.add("view", (JsonElement)refJson);
                        relatedJson.addProperty("autoExpand", Boolean.valueOf(related.isRestAutoExpand()));
                        relatedArray.add((JsonElement)relatedJson);
                        ++n;
                    }
                    json.add("relatedViews", (JsonElement)relatedArray);
                }
                array.add((JsonElement)json);
            }
            JsonObject json = new JsonObject();
            json.add("views", (JsonElement)array);
            return Response.ok((Object)json.toString()).build();
        }
        catch (Exception ex) {
            return ResponseUtils.getResponseErrorFromException(ex, "GET Error");
        }
    }

    @Override
    public Response create(String tableName, String jsonText) {
        return this.restView().create(tableName, jsonText);
    }

    @Override
    public Response update(String tableName, String id, String jsonText) {
        return this.restView().update(tableName, id, jsonText);
    }

    @Override
    public Response delete(String tableName, String id) {
        return this.restView().delete(tableName, id);
    }

    @Override
    public Response getAttachments(String tableName, String id) {
        return this.restView().getAttachments(tableName, id);
    }

    @Override
    public Response getAttachmentsAsZip(String tableName, String id, String asJson) {
        return this.restView().getAttachmentsAsZip(tableName, id, asJson);
    }

    @Override
    public Response createAttachmentsFromZip(String tableName, String id, String jsonText) {
        return this.restView().createAttachmentsFromZip(tableName, id, jsonText);
    }

    @Override
    public Response getAttachmentEntry(String tableName, String id, String fileName, String asJson) {
        return this.restView().getAttachmentEntry(tableName, id, fileName, asJson);
    }

    @Override
    public Response addAttachmentEntry(String tableName, String id, String jsonText) {
        return this.restView().addAttachmentEntry(tableName, id, jsonText);
    }

    @Override
    public Response deleteAttachments(String tableName, String id) {
        return this.restView().deleteAttachments(tableName, id);
    }

    @Override
    public Response deleteAttachmentEntry(String tableName, String id, String fileName) {
        return this.restView().deleteAttachmentEntry(tableName, id, fileName);
    }

    @Override
    public Response printModelRecord(String tableName, String id, String reportType) {
        return this.restView().printModelRecord(tableName, id, reportType);
    }

    @Override
    public Response getModelYAML(String tableName) {
        MRestView view = MRestView.get(tableName);
        if (view == null) {
            return ResponseUtils.getResponseError(Response.Status.NOT_FOUND, "Invalid view name", "No match found for view name: ", tableName);
        }
        StringBuilder header = new StringBuilder();
        header.append("openapi: 3.0.0\n");
        header.append("info:\n");
        header.append(" ".repeat(2)).append("title: views/").append(tableName).append("\n");
        header.append(" ".repeat(2)).append("version: 1.0.0\n");
        YAMLSchema.addServers(header);
        header.append("components:\n");
        YAMLSchema.addSecuritySchema(header);
        YAMLSchema.addPredefinedParameters(header);
        header.append(" ".repeat(2)).append("schemas:\n");
        StringBuilder body = new StringBuilder();
        this.buildYAMLForView(view, body);
        YAMLSchema.addErrorResponseReference(header);
        if (body.indexOf("#/components/schemas/Image") > 0) {
            YAMLSchema.addImageReference(header);
        }
        if (body.indexOf("#/components/schemas/Location") > 0) {
            YAMLSchema.addLocationReference(header, 4);
        }
        this.addRelatedViews(view, header);
        YAMLSchema.addSecurityHeader(body);
        body.append("paths:\n");
        YAMLSchema.addAuthRequest(body);
        YAMLSchema.addModelRequest(tableName, true, body);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)header.append(body.toString()).toString()).build();
    }

    private void addRelatedViews(MRestView view, StringBuilder header) {
        MRestViewRelated[] relatedViews;
        MRestViewRelated[] mRestViewRelatedArray = relatedViews = view.getRelatedViews();
        int n = relatedViews.length;
        int n2 = 0;
        while (n2 < n) {
            MRestViewRelated relatedView = mRestViewRelatedArray[n2];
            if (relatedView.isRestAutoExpand() && view.getREST_View_ID() != relatedView.getREST_View_ID()) {
                MRestView childView = MRestView.get(relatedView.getREST_RelatedRestView_ID());
                this.buildYAMLForView(childView, header);
                this.addRelatedViews(childView, header);
            }
            ++n2;
        }
    }

    private void buildYAMLForView(MRestView view, StringBuilder body) {
        MTable table = MTable.get((int)view.getAD_Table_ID());
        body.append(" ".repeat(4)).append(view.getName()).append(":\n");
        body.append(" ".repeat(6)).append("type: object\n");
        body.append(" ".repeat(6)).append("properties:\n");
        if (table.getKeyColumns() != null && table.getKeyColumns().length == 1 && table.getKeyColumns()[0].endsWith("_ID")) {
            body.append(" ".repeat(8)).append("id:\n");
            body.append(" ".repeat(10)).append("type: integer\n");
            body.append(" ".repeat(10)).append("description: record id\n");
            body.append(" ".repeat(10)).append("readOnly: true\n");
        }
        body.append(" ".repeat(8)).append("uid:\n");
        body.append(" ".repeat(10)).append("type: string\n");
        body.append(" ".repeat(10)).append("description: record uuid\n");
        body.append(" ".repeat(10)).append("readOnly: true\n");
        YAMLSchema.addViewProperties(view, body, 8);
    }
}

