/*
 * Decompiled with CFR 0.152.
 */
package com.trekglobal.idempiere.rest.api.v1.resource.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.trekglobal.idempiere.rest.api.json.IDempiereRestException;
import com.trekglobal.idempiere.rest.api.json.IPOSerializer;
import com.trekglobal.idempiere.rest.api.json.Process;
import com.trekglobal.idempiere.rest.api.json.RestUtils;
import com.trekglobal.idempiere.rest.api.json.TypeConverterUtils;
import com.trekglobal.idempiere.rest.api.json.filter.ConvertedQuery;
import com.trekglobal.idempiere.rest.api.json.filter.IQueryConverter;
import com.trekglobal.idempiere.rest.api.util.ErrorBuilder;
import com.trekglobal.idempiere.rest.api.v1.resource.ProcessResource;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.ws.rs.core.Response;
import org.adempiere.util.ServerContext;
import org.compiere.Adempiere;
import org.compiere.model.MAttachment;
import org.compiere.model.MClient;
import org.compiere.model.MNote;
import org.compiere.model.MPInstance;
import org.compiere.model.MPInstanceLog;
import org.compiere.model.MProcess;
import org.compiere.model.MProcessPara;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.model.MUser;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoUtil;
import org.compiere.process.ServerProcessCtl;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class ProcessResourceImpl
implements ProcessResource {
    private static final CLogger log = CLogger.getCLogger(ProcessResourceImpl.class);

    @Override
    public Response getProcesses(String filter) {
        IQueryConverter converter = IQueryConverter.getQueryConverter("DEFAULT");
        try {
            ConvertedQuery convertedStatement = converter.convertStatement("AD_Process", filter);
            if (log.isLoggable(Level.INFO)) {
                log.info("Where Clause: " + convertedStatement.getWhereClause());
            }
            JsonArray processArray = new JsonArray();
            StringBuilder where = new StringBuilder("AD_Form_ID IS NULL");
            if (!Util.isEmpty((String)filter, (boolean)true)) {
                where.append(" AND (").append(convertedStatement.getWhereClause()).append(")");
            }
            Query query = new Query(Env.getCtx(), "AD_Process", where.toString(), null);
            query.setApplyAccessFilter(true).setOnlyActiveRecords(true).setOrderBy("Value");
            query.setParameters(convertedStatement.getParameters());
            List processes = query.list();
            MRole role = MRole.getDefault();
            IPOSerializer serializer = IPOSerializer.getPOSerializer("AD_Process", MTable.getClass((String)"AD_Process"));
            for (MProcess process : processes) {
                if (role.getProcessAccess(process.getAD_Process_ID()) == null) continue;
                JsonObject jsonObject = serializer.toJson((PO)process, new String[]{"AD_Process_ID", "AD_Process_UU", "Value", "Name", "Description", "Help", "EntityType", "IsReport", "AD_ReportView_ID", "AD_PrintFormat_ID", "AD_Workflow_ID", "JasperReport"}, null);
                jsonObject.addProperty("slug", TypeConverterUtils.slugify(process.getValue()));
                processArray.add((JsonElement)jsonObject);
            }
            JsonObject json = new JsonObject();
            json.add("processes", (JsonElement)processArray);
            return Response.ok((Object)json.toString()).build();
        }
        catch (Exception ex) {
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            if (ex instanceof IDempiereRestException) {
                status = ((IDempiereRestException)((Object)ex)).getErrorResponseStatus();
            }
            log.log(Level.SEVERE, ex.getMessage(), (Throwable)ex);
            return Response.status((Response.Status)status).entity((Object)new ErrorBuilder().status(status).title("GET Error").append("Get process with exception: ").append(ex.getMessage()).build().toString()).build();
        }
    }

    @Override
    public Response getProcess(String processSlug) {
        Query query = new Query(Env.getCtx(), "AD_Process", "Slugify(Value)=?", null);
        query.setApplyAccessFilter(true).setOnlyActiveRecords(true);
        MProcess process = (MProcess)query.setParameters(new Object[]{processSlug}).first();
        if (process == null) {
            query.setApplyAccessFilter(false);
            process = (MProcess)query.setParameters(new Object[]{processSlug}).first();
            if (process != null) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)new ErrorBuilder().status(Response.Status.FORBIDDEN).title("Access denied").append("Access denied for process: ").append(processSlug).build().toString()).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorBuilder().status(Response.Status.NOT_FOUND).title("Invalid process name").append("No match found for process name: ").append(processSlug).build().toString()).build();
        }
        MRole role = MRole.getDefault();
        if (role.getProcessAccess(process.getAD_Process_ID()) == null) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)new ErrorBuilder().status(Response.Status.FORBIDDEN).title("Access denied").append("Access denied for process: ").append(processSlug).build().toString()).build();
        }
        IPOSerializer serializer = IPOSerializer.getPOSerializer("AD_Process", MTable.getClass((String)"AD_Process"));
        JsonObject jsonObject = serializer.toJson((PO)process, new String[]{"AD_Process_ID", "AD_Process_UU", "Value", "Name", "Description", "Help", "EntityType", "IsReport", "AD_ReportView_ID", "AD_PrintFormat_ID", "AD_Workflow_ID", "JasperReport"}, null);
        jsonObject.addProperty("slug", TypeConverterUtils.slugify(process.getValue()));
        JsonArray parameterArray = new JsonArray();
        MProcessPara[] parameters = process.getParameters();
        serializer = IPOSerializer.getPOSerializer("AD_Process_Para", MTable.getClass((String)"AD_Process_Para"));
        MProcessPara[] mProcessParaArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            MProcessPara parameter = mProcessParaArray[n2];
            JsonObject parameterJsonObject = serializer.toJson((PO)parameter, null, new String[]{"AD_Client_ID", "AD_Org_ID", "AD_Process_ID", "FieldLength", "IsCentrallyMaintained", "IsEncrypted", "AD_Element_ID", "ColumnName", "IsActive", "Created", "CreatedBy", "Updated", "UpdatedBy"});
            String propertyName = parameter.getColumnName();
            parameterJsonObject.addProperty("parameterName", propertyName);
            parameterArray.add((JsonElement)parameterJsonObject);
            ++n2;
        }
        jsonObject.add("parameters", (JsonElement)parameterArray);
        return Response.ok((Object)jsonObject.toString()).build();
    }

    @Override
    public Response runProcess(String processSlug, String jsonText) {
        Query query = new Query(Env.getCtx(), "AD_Process", "Slugify(Value)=?", null);
        query.setApplyAccessFilter(true).setOnlyActiveRecords(true);
        MProcess process = (MProcess)query.setParameters(new Object[]{processSlug}).first();
        if (process == null) {
            query.setApplyAccessFilter(false);
            process = (MProcess)query.setParameters(new Object[]{processSlug}).first();
            if (process != null) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)new ErrorBuilder().status(Response.Status.FORBIDDEN).title("Access denied").append("Access denied for process: ").append(processSlug).build().toString()).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorBuilder().status(Response.Status.NOT_FOUND).title("Invalid process name").append("No match found for process name: ").append(processSlug).build().toString()).build();
        }
        MRole role = MRole.getDefault();
        if (role.getProcessAccess(process.getAD_Process_ID()) == null || !role.getProcessAccess(process.getAD_Process_ID()).booleanValue()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)new ErrorBuilder().status(Response.Status.FORBIDDEN).title("Access denied").append("Access denied for process: ").append(processSlug).build().toString()).build();
        }
        Gson gson = new GsonBuilder().create();
        JsonObject jsonObject = (JsonObject)gson.fromJson(jsonText, JsonObject.class);
        MPInstance pInstance = Process.createPInstance(process, jsonObject, false);
        ProcessInfo processInfo = Process.createProcessInfo(process, pInstance, jsonObject);
        ServerProcessCtl.process((ProcessInfo)processInfo, null);
        JsonObject processInfoJson = Process.toJsonObject(processInfo, processSlug);
        return Response.ok((Object)processInfoJson.toString()).build();
    }

    @Override
    public Response getJobs() {
        List instances = new Query(Env.getCtx(), "AD_PInstance", "IsProcessing='Y' AND IsRunAsJob='Y' ", null).setOnlyActiveRecords(true).setClient_ID().setOrderBy("AD_PInstance_ID").list();
        JsonArray instanceArray = new JsonArray();
        for (MPInstance instance : instances) {
            JsonObject jsonObject = this.toJsonObject(instance);
            instanceArray.add((JsonElement)jsonObject);
        }
        JsonObject json = new JsonObject();
        json.add("jobs", (JsonElement)instanceArray);
        return Response.ok((Object)json.toString()).build();
    }

    @Override
    public Response getJob(int id) {
        MPInstance instance = (MPInstance)new Query(Env.getCtx(), "AD_PInstance", "IsRunAsJob='Y' AND AD_PInstance_ID=?", null).setClient_ID().setParameters(new Object[]{id}).first();
        if (instance != null) {
            JsonObject jsonObject = this.toJsonObject(instance);
            return Response.ok((Object)jsonObject.toString()).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorBuilder().status(Response.Status.NOT_FOUND).title("Job not found").append("No job found matching id ").append(id).build().toString()).build();
    }

    @Override
    public Response runJob(String processSlug, String jsonText) {
        Query query = new Query(Env.getCtx(), "AD_Process", "Slugify(Value)=?", null);
        query.setApplyAccessFilter(true).setOnlyActiveRecords(true);
        MProcess process = (MProcess)query.setParameters(new Object[]{processSlug}).first();
        if (process == null) {
            query.setApplyAccessFilter(false);
            process = (MProcess)query.setParameters(new Object[]{processSlug}).first();
            if (process != null) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)new ErrorBuilder().status(Response.Status.FORBIDDEN).title("Access denied").append("Access denied for process: ").append(processSlug).build().toString()).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorBuilder().status(Response.Status.NOT_FOUND).title("Invalid process name").append("No match found for process name: ").append(processSlug).build().toString()).build();
        }
        MRole role = MRole.getDefault();
        if (role.getProcessAccess(process.getAD_Process_ID()) == null || !role.getProcessAccess(process.getAD_Process_ID()).booleanValue()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)new ErrorBuilder().status(Response.Status.FORBIDDEN).title("Access denied").append("Access denied for process: ").append(processSlug).build().toString()).build();
        }
        Gson gson = new GsonBuilder().create();
        JsonObject jsonObject = (JsonObject)gson.fromJson(jsonText, JsonObject.class);
        MPInstance pInstance = Process.createPInstance(process, jsonObject, true);
        ProcessInfo processInfo = Process.createProcessInfo(process, pInstance, jsonObject);
        int AD_User_ID = Env.getAD_User_ID((Properties)Env.getCtx());
        MPInstance.publishChangedEvent((int)AD_User_ID);
        Adempiere.getThreadPoolExecutor().schedule(new BackgroundJobRunnable(Env.getCtx(), processInfo), 1000L, TimeUnit.MILLISECONDS);
        JsonObject instanceJson = this.toJsonObject(pInstance);
        return Response.ok((Object)instanceJson.toString()).build();
    }

    private JsonObject toJsonObject(MPInstance instance) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("id", (Number)instance.getAD_PInstance_ID());
        jsonObject.addProperty("client", MClient.get((Properties)Env.getCtx(), (int)instance.getAD_Client_ID()).getName());
        jsonObject.addProperty("user", MUser.get((Properties)Env.getCtx(), (int)instance.getCreatedBy()).getName());
        jsonObject.addProperty("process", TypeConverterUtils.slugify(MProcess.get((Properties)Env.getCtx(), (int)instance.getAD_Process_ID()).getValue()));
        jsonObject.addProperty("since", DisplayType.getDateFormat((int)16).format(instance.getCreated()));
        jsonObject.addProperty("processing", Boolean.valueOf(instance.isProcessing()));
        return jsonObject;
    }

    private class BackgroundJobRunnable
    implements Runnable {
        private Properties m_ctx = new Properties();
        private ProcessInfo m_pi;

        private BackgroundJobRunnable(Properties ctx, ProcessInfo pi) {
            Env.setContext((Properties)this.m_ctx, (String)"#AD_Client_ID", (String)ctx.getProperty("#AD_Client_ID"));
            Env.setContext((Properties)this.m_ctx, (String)"#AD_Org_ID", (String)ctx.getProperty("#AD_Org_ID"));
            Env.setContext((Properties)this.m_ctx, (String)"#AD_Role_ID", (String)ctx.getProperty("#AD_Role_ID"));
            Env.setContext((Properties)this.m_ctx, (String)"#M_Warehouse_ID", (String)ctx.getProperty("#M_Warehouse_ID"));
            Env.setContext((Properties)this.m_ctx, (String)"#AD_Language", (String)ctx.getProperty("#AD_Language"));
            Env.setContext((Properties)this.m_ctx, (String)"#AD_User_ID", (String)ctx.getProperty("#AD_User_ID"));
            Env.setContext((Properties)this.m_ctx, (String)"#AD_Session_ID", (String)ctx.getProperty("#AD_Session_ID"));
            Env.setContext((Properties)this.m_ctx, (String)"#Date", (String)ctx.getProperty("#Date"));
            RestUtils.setSessionContextVariables(this.m_ctx);
            this.m_pi = pi;
        }

        @Override
        public void run() {
            try {
                ServerContext.setCurrentInstance((Properties)this.m_ctx);
                this.doRun();
            }
            finally {
                ServerContext.dispose();
            }
        }

        private void doRun() {
            this.m_pi.setIsBatch(true);
            this.m_pi.setPrintPreview(true);
            MPInstance instance = new MPInstance(this.m_ctx, this.m_pi.getAD_PInstance_ID(), null);
            String notificationType = instance.getNotificationType();
            boolean sendEmail = notificationType.equals("E") || notificationType.equals("B");
            boolean createNotice = notificationType.equals("N") || notificationType.equals("B");
            int AD_Client_ID = Env.getAD_Client_ID((Properties)this.m_ctx);
            int AD_User_ID = Env.getAD_User_ID((Properties)this.m_ctx);
            try {
                try {
                    MProcess process = new MProcess(this.m_ctx, this.m_pi.getAD_Process_ID(), null);
                    if (process.isReport() && process.getJasperReport() != null && !Util.isEmpty((String)process.getJasperReport())) {
                        this.m_pi.setExport(true);
                        if ("HTML".equals(this.m_pi.getReportType())) {
                            this.m_pi.setExportFileExtension("html");
                        } else if ("CSV".equals(this.m_pi.getReportType())) {
                            this.m_pi.setExportFileExtension("csv");
                        } else if ("XLS".equals(this.m_pi.getReportType())) {
                            this.m_pi.setExportFileExtension("xls");
                        } else {
                            this.m_pi.setExportFileExtension("pdf");
                        }
                    }
                    ArrayList<File> files = new ArrayList<File>();
                    ServerProcessCtl.process((ProcessInfo)this.m_pi, null);
                    ProcessInfoUtil.setLogFromDB((ProcessInfo)this.m_pi);
                    if (!this.m_pi.isError()) {
                        boolean isReport;
                        boolean bl = isReport = process.isReport() || process.getAD_ReportView_ID() > 0 || process.getJasperReport() != null || process.getAD_PrintFormat_ID() > 0;
                        if (isReport && this.m_pi.getPDFReport() != null) {
                            files.add(this.m_pi.getPDFReport());
                        }
                        if (this.m_pi.isExport() && this.m_pi.getExportFile() != null) {
                            files.add(this.m_pi.getExportFile());
                        }
                    }
                    if (sendEmail) {
                        MClient client = MClient.get((Properties)this.m_ctx, (int)AD_Client_ID);
                        client.sendEMailAttachments(AD_User_ID, process.get_Translation("Name", Env.getAD_Language((Properties)Env.getCtx())), this.m_pi.getSummary() + " " + this.m_pi.getLogInfo(), files);
                    }
                    if (createNotice) {
                        String log;
                        MNote note = new MNote(this.m_ctx, "BackgroundJob", AD_User_ID, null);
                        note.setTextMsg(process.get_Translation("Name", Env.getAD_Language((Properties)Env.getCtx())) + "\n" + this.m_pi.getSummary());
                        note.setRecord(282, this.m_pi.getAD_PInstance_ID());
                        note.saveEx();
                        MAttachment attachment = null;
                        if (files.size() > 0) {
                            attachment = note.createAttachment();
                            for (File downloadFile : files) {
                                attachment.addEntry(downloadFile);
                            }
                        }
                        if ((log = this.m_pi.getLogInfo(true)) != null && log.trim().length() > 0) {
                            if (attachment == null) {
                                attachment = note.createAttachment();
                            }
                            attachment.addEntry("ProcessLog.html", log.getBytes("UTF-8"));
                        }
                        if (attachment != null) {
                            attachment.saveEx();
                        }
                        MPInstanceLog il = instance.addLog(null, 0, null, Msg.parseTranslation((Properties)this.m_ctx, (String)("@Created@ @AD_Note_ID@ " + note.getAD_Note_ID())), 389, note.getAD_Note_ID());
                        il.saveEx();
                    }
                }
                catch (Exception e) {
                    CLogger.getCLogger(this.getClass()).log(Level.SEVERE, e.getLocalizedMessage());
                    instance.setIsProcessing(false);
                    instance.saveEx();
                    MPInstance.publishChangedEvent((int)AD_User_ID);
                }
            }
            finally {
                instance.setIsProcessing(false);
                instance.saveEx();
                MPInstance.publishChangedEvent((int)AD_User_ID);
            }
        }
    }
}

