/*
 * Decompiled with CFR 0.152.
 */
package com.trekglobal.idempiere.rest.api.v1.resource.file;

import com.trekglobal.idempiere.rest.api.v1.resource.file.FileAccess;
import com.trekglobal.idempiere.rest.api.v1.resource.file.FileInfo;
import java.io.File;
import java.io.Serializable;
import java.util.concurrent.Callable;
import org.compiere.util.Util;

public class GetFileInfoCallable
implements Callable<FileInfo>,
Serializable {
    private static final long serialVersionUID = -87388045962116357L;
    private String parentFolderName;
    private String fileName;
    private int blockSize;

    public GetFileInfoCallable(String parentFolderName, String fileName, int blockSize) {
        this.parentFolderName = parentFolderName;
        this.fileName = fileName;
        this.blockSize = blockSize;
    }

    @Override
    public FileInfo call() throws Exception {
        File file;
        File parentFolder = null;
        if (!Util.isEmpty((String)this.parentFolderName, (boolean)true)) {
            parentFolder = new File(this.parentFolderName);
        }
        File file2 = file = parentFolder != null ? new File(parentFolder, this.fileName) : new File(this.fileName);
        if (file.exists() && file.isFile()) {
            if (!file.canRead() || !FileAccess.isAccessible(file)) {
                return null;
            }
            long length = file.length();
            int noOfBlocks = 1;
            if (this.blockSize > 0 && length > (long)this.blockSize) {
                int v = (int)((length - 1L) / (long)this.blockSize + 1L);
                if (v == 0) {
                    v = 1;
                }
                noOfBlocks = v;
            }
            FileInfo fileInfo = new FileInfo(this.parentFolderName, this.fileName, length, this.blockSize, noOfBlocks);
            return fileInfo;
        }
        return null;
    }
}

