/*
 * Decompiled with CFR 0.152.
 */
package com.trekglobal.idempiere.rest.api.json;

import com.trekglobal.idempiere.rest.api.json.IDempiereRestException;
import com.trekglobal.idempiere.rest.api.util.ErrorBuilder;
import java.util.logging.Level;
import javax.ws.rs.core.Response;
import org.compiere.util.CLogger;

public class ResponseUtils {
    private static final CLogger log = CLogger.getCLogger(ResponseUtils.class);

    public static Response getResponseErrorFromException(Exception ex, String title) {
        return ResponseUtils.getResponseErrorFromException(ex, title, "");
    }

    public static Response getResponseErrorFromException(Exception ex, String title, String detailText) {
        Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
        if (ex instanceof IDempiereRestException) {
            status = ((IDempiereRestException)((Object)ex)).getErrorResponseStatus();
            title = ((IDempiereRestException)((Object)ex)).getTitle();
        }
        log.log(Level.SEVERE, ex.getMessage(), (Throwable)ex);
        return ResponseUtils.getResponseError(status, title, detailText, ex.getMessage());
    }

    public static Response getResponseError(Response.Status status, String title, String text1, String text2) {
        return Response.status((Response.Status)status).entity((Object)new ErrorBuilder().status(status).title(title).append(text1).append(text2).build().toString()).build();
    }
}

