/*
 * Decompiled with CFR 0.152.
 */
package com.trekglobal.idempiere.rest.api.json;

import com.google.gson.JsonObject;
import com.trekglobal.idempiere.rest.api.json.IGridTabSerializerFactory;
import java.util.List;
import org.adempiere.base.Service;
import org.compiere.model.GridTab;

public interface IGridTabSerializer {
    default public JsonObject toJson(GridTab gridTab) {
        return this.toJson(gridTab, null, null);
    }

    public JsonObject toJson(GridTab var1, String[] var2, String[] var3);

    public void fromJson(JsonObject var1, GridTab var2);

    public static IGridTabSerializer getGridTabSerializer(String gridTabUID) {
        IGridTabSerializer serializer = null;
        List factories = Service.locator().list(IGridTabSerializerFactory.class).getServices();
        for (IGridTabSerializerFactory factory : factories) {
            serializer = factory.getGridTabSerializer(gridTabUID);
            if (serializer != null) break;
        }
        if (serializer == null) {
            for (IGridTabSerializerFactory factory : factories) {
                serializer = factory.getGridTabSerializer("*");
                if (serializer != null) break;
            }
        }
        return serializer;
    }
}

