/*
 * Decompiled with CFR 0.152.
 */
package com.trekglobal.idempiere.rest.api.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.trekglobal.idempiere.rest.api.json.ITypeConverter;
import java.util.Base64;
import java.util.Properties;
import org.compiere.model.GridField;
import org.compiere.model.MColumn;
import org.compiere.model.MImage;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class ImageTypeConverter
implements ITypeConverter<Object> {
    @Override
    public Object toJsonValue(MColumn column, Object value) {
        String label = Msg.getElement((Properties)Env.getCtx(), (String)column.getColumnName());
        return this.toJsonValue(label, value);
    }

    @Override
    public Object toJsonValue(GridField field, Object value) {
        return this.toJsonValue(field.getHeader(), value);
    }

    private Object toJsonValue(String label, Object value) {
        if (value != null) {
            String data;
            MImage img = MImage.get((int)((Integer)value));
            JsonObject ref = new JsonObject();
            ref.addProperty("propertyLabel", label);
            if (value instanceof Number) {
                ref.addProperty("id", (Number)((Number)value).intValue());
            }
            if (!Util.isEmpty((String)(data = Base64.getEncoder().encodeToString(img.getBinaryData())), (boolean)true)) {
                ref.addProperty("data", data);
            }
            ref.addProperty("model-name", "AD_Image".toLowerCase());
            return ref;
        }
        return null;
    }

    @Override
    public Object fromJsonValue(GridField field, JsonElement value) {
        return this.fromJson(value);
    }

    @Override
    public Object fromJsonValue(MColumn column, JsonElement value) {
        return this.fromJson(value);
    }

    public Object fromJson(JsonElement value) {
        if (value != null && value.isJsonObject()) {
            JsonObject ref = value.getAsJsonObject();
            JsonElement idField = ref.get("id");
            int AD_Image_ID = 0;
            if (idField != null) {
                JsonPrimitive primitive = (JsonPrimitive)idField;
                AD_Image_ID = primitive.isNumber() ? primitive.getAsInt() : 0;
            }
            JsonElement nameField = ref.get("file_name");
            String fileName = null;
            if (nameField != null) {
                JsonPrimitive primitive = (JsonPrimitive)nameField;
                fileName = primitive.getAsString();
            }
            JsonElement url = ref.get("url");
            String fileURL = null;
            if (url != null) {
                JsonPrimitive primitive = (JsonPrimitive)url;
                fileURL = primitive.getAsString();
            }
            MImage image = new MImage(Env.getCtx(), AD_Image_ID, null);
            JsonElement data = ref.get("data");
            if (data != null) {
                if (fileName != null) {
                    image.setName(fileName);
                }
                if (fileURL != null) {
                    image.setImageURL(fileURL);
                }
                byte[] imageBytes = Base64.getDecoder().decode(data.getAsString());
                image.setBinaryData(imageBytes);
                image.saveEx();
                return image.get_ID();
            }
        }
        return null;
    }
}

