/*
 * Decompiled with CFR 0.152.
 */
package com.trekglobal.idempiere.rest.api.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.trekglobal.idempiere.rest.api.json.ITypeConverter;
import com.trekglobal.idempiere.rest.api.json.RestUtils;
import com.trekglobal.idempiere.rest.api.model.MRestView;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.GridField;
import org.compiere.model.Lookup;
import org.compiere.model.MAccountLookup;
import org.compiere.model.MColumn;
import org.compiere.model.MLocationLookup;
import org.compiere.model.MLocatorLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MPAttributeLookup;
import org.compiere.model.MPaymentLookup;
import org.compiere.model.MProcessPara;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.model.MValRule;
import org.compiere.model.PO;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class LookupTypeConverter
implements ITypeConverter<Object> {
    @Override
    public Object toJsonValue(MColumn column, Object value) {
        return this.toJsonValue(column, value, (MRestView)null);
    }

    @Override
    public Object toJsonValue(MColumn column, Object value, MRestView referenceView) {
        String label = Msg.getElement((Properties)Env.getCtx(), (String)column.getColumnName());
        return this.toJsonValue(column.getAD_Reference_ID(), label, this.getColumnLookup(column), column.getReferenceTableName(), value, referenceView);
    }

    @Override
    public Object toJsonValue(GridField field, Object value) {
        return this.toJsonValue(field.getDisplayType(), field.getHeader(), field.getLookup(), this.getReferenceTableNameFromField(field), value, null);
    }

    @Override
    public Object fromJsonValue(MColumn column, JsonElement value) {
        return this.fromJsonValue(column.getAD_Reference_ID(), column.getReferenceTableName(), value);
    }

    @Override
    public Object fromJsonValue(GridField field, JsonElement value) {
        return this.fromJsonValue(field.getDisplayType(), this.getReferenceTableNameFromField(field), value);
    }

    private String getReferenceTableNameFromField(GridField field) {
        String refTableName = null;
        if (field.getVO().isProcess) {
            MProcessPara pp;
            MProcessPara mProcessPara = pp = field.getAD_Column_ID() > 0 ? MProcessPara.get((int)field.getAD_Column_ID()) : null;
            if (pp != null) {
                refTableName = pp.getReferenceTableName();
            }
        } else {
            MColumn column;
            MColumn mColumn = column = field.getAD_Column_ID() > 0 ? MColumn.get((Properties)Env.getCtx(), (int)field.getAD_Column_ID()) : null;
            if (column != null) {
                refTableName = column.getReferenceTableName();
            }
        }
        return refTableName;
    }

    private Object toJsonValue(int displayType, String label, Lookup lookup, String refTableName, Object value, MRestView referenceView) {
        if (lookup != null) {
            JsonObject ref = new JsonObject();
            if (referenceView == null) {
                ref.addProperty("propertyLabel", label);
            }
            if (value instanceof Number) {
                ref.addProperty("id", (Number)((Number)value).intValue());
            } else {
                ref.addProperty("id", value.toString());
            }
            String display = lookup.getDisplay(value);
            if (!Util.isEmpty((String)display, (boolean)true)) {
                ref.addProperty("identifier", display);
            }
            if (!Util.isEmpty((String)refTableName)) {
                if (referenceView != null) {
                    ref.addProperty("view-name", referenceView.getName());
                } else {
                    ref.addProperty("model-name", refTableName.toLowerCase());
                }
                if (RestUtils.isReturnUULookup(refTableName)) {
                    String uidColumn = PO.getUUIDColumnName((String)refTableName);
                    String keyColumn = RestUtils.getKeyColumnName(refTableName);
                    String uuid = DB.getSQLValueString(null, (String)("SELECT " + uidColumn + " FROM " + refTableName + " WHERE " + keyColumn + "=?"), (Object[])new Object[]{value});
                    if (!Util.isEmpty((String)uuid)) {
                        ref.addProperty("uuid", uuid);
                    }
                }
            }
            return ref;
        }
        return null;
    }

    private Lookup getColumnLookup(MColumn column) {
        int WindowNo = 0;
        Object lookup = null;
        int displayType = column.getAD_Reference_ID();
        try {
            String validationCode = null;
            if (column.getAD_Val_Rule_ID() > 0) {
                MValRule rule = MValRule.get((Properties)Env.getCtx(), (int)column.getAD_Val_Rule_ID());
                validationCode = rule.getCode();
            }
            lookup = displayType == 25 ? new MAccountLookup(Env.getCtx(), 0) : (displayType == 21 ? new MLocationLookup(Env.getCtx(), 0) : (displayType == 31 ? new MLocatorLookup(Env.getCtx(), 0) : (displayType == 35 ? new MPAttributeLookup(Env.getCtx(), 0) : (displayType == 200012 ? new MPaymentLookup(Env.getCtx(), 0, validationCode) : MLookupFactory.get((Properties)Env.getCtx(), (int)WindowNo, (int)column.getAD_Column_ID(), (int)column.getAD_Reference_ID(), (Language)Env.getLanguage((Properties)Env.getCtx()), (String)column.getColumnName(), (int)column.getAD_Reference_Value_ID(), (boolean)column.isParent(), (String)validationCode)))));
        }
        catch (Exception exception) {
            lookup = null;
        }
        return lookup;
    }

    private Object fromJsonValue(int displayType, String refTableName, JsonElement value) {
        if (value != null && value.isJsonObject()) {
            JsonElement columnName;
            int id;
            int id2;
            JsonObject ref = value.getAsJsonObject();
            JsonElement idField = ref.get("id");
            if (idField != null) {
                JsonPrimitive primitive = (JsonPrimitive)idField;
                if (primitive.isNumber()) {
                    return primitive.getAsInt();
                }
                return primitive.getAsString();
            }
            JsonElement identifier = ref.get("identifier");
            if (identifier != null && !Util.isEmpty((String)refTableName) && !identifier.isJsonNull() && (id2 = this.findId(refTableName, identifier)) >= 0) {
                return id2;
            }
            JsonElement uidField = ref.get("uid");
            if (uidField != null && !Util.isEmpty((String)refTableName) && !uidField.isJsonNull()) {
                String uidColumn = PO.getUUIDColumnName((String)refTableName);
                String keyColumn = RestUtils.getKeyColumnName(refTableName);
                id = DB.getSQLValue(null, (String)("SELECT " + keyColumn + " FROM " + refTableName + " WHERE " + uidColumn + "=?"), (String)uidField.getAsString());
                if (id > 0) {
                    return id;
                }
            }
            if ((columnName = ref.get("lookupColumn")) != null) {
                uidField = ref;
                JsonElement searchValue = ref.get("lookupValue");
                id = this.findIdbyColumn(refTableName, columnName.getAsString(), searchValue);
                if (id >= 0) {
                    return id;
                }
            }
            throw new AdempiereException("Could not convert value " + String.valueOf(value) + " for " + refTableName);
        }
        if (value != null && value.isJsonPrimitive()) {
            JsonPrimitive primitive = (JsonPrimitive)value;
            if (primitive.isNumber()) {
                return primitive.getAsInt();
            }
            return primitive.getAsString();
        }
        if (DisplayType.isText((int)displayType) || DisplayType.isList((int)displayType)) {
            return value != null && !(value instanceof JsonNull) ? value.getAsString() : null;
        }
        if (value != null) {
            throw new AdempiereException("Could not convert value " + String.valueOf(value) + " for " + refTableName);
        }
        return null;
    }

    private int findId(String tableName, JsonElement identifier) {
        MTable table = MTable.get((Properties)Env.getCtx(), (String)tableName);
        String[] identifiers = table.getIdentifierColumns();
        if (identifiers != null && identifiers.length > 0) {
            MColumn column = table.getColumn(identifiers[0]);
            return this.getFirstIdOnly(table, column, identifier);
        }
        return -1;
    }

    private int findIdbyColumn(String tableName, String columnName, JsonElement searchValue) {
        MTable table = MTable.get((Properties)Env.getCtx(), (String)tableName);
        MColumn column = table.getColumn(columnName);
        if (column == null) {
            throw new AdempiereException("Column not found -> " + tableName + "." + columnName);
        }
        return this.getFirstIdOnly(table, column, searchValue);
    }

    private int getFirstIdOnly(MTable table, MColumn column, JsonElement identifier) {
        int id = -1;
        String tableName = table.getTableName();
        StringBuilder builder = new StringBuilder().append("SELECT ").append(tableName).append("_ID FROM ").append(tableName).append(" WHERE ").append(column.getColumnName()).append("=?");
        String sql = MRole.getDefault().addAccessSQL(builder.toString(), tableName, true, false);
        try {
            Throwable throwable = null;
            Object var9_11 = null;
            try (CPreparedStatement stmt = DB.prepareStatement((String)sql, null);){
                Object param;
                if (DisplayType.isID((int)column.getAD_Reference_ID())) {
                    param = identifier.getAsInt();
                } else if (DisplayType.isNumeric((int)column.getAD_Reference_ID())) {
                    param = identifier.getAsBigDecimal();
                } else if (DisplayType.isDate((int)column.getAD_Reference_ID())) {
                    Date date;
                    SimpleDateFormat dateTimeFormat = DisplayType.getTimestampFormat_Default();
                    SimpleDateFormat dateFormat = DisplayType.getDateFormat_JDBC();
                    try {
                        date = column.getAD_Reference_ID() == 15 ? dateFormat.parse(identifier.getAsString()) : dateTimeFormat.parse(identifier.getAsString());
                    }
                    catch (ParseException parseException) {
                        try {
                            date = dateFormat.parse(identifier.getAsString());
                        }
                        catch (ParseException parseException2) {
                            throw new AdempiereException("Date wrongly formatted -> " + identifier.getAsString());
                        }
                    }
                    param = new Timestamp(date.getTime());
                } else {
                    param = identifier.getAsString();
                }
                stmt.setObject(1, param);
                ResultSet rs = stmt.executeQuery();
                if (rs.next()) {
                    id = rs.getInt(1);
                    if (rs.next()) {
                        throw new AdempiereException("More than one ID found for " + tableName + "." + column.getColumnName() + " = " + identifier.getAsString());
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException ex) {
            throw new AdempiereException("Error getting the first ID -> " + sql, (Throwable)ex);
        }
        return id;
    }
}

