/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.output.svg;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.krysalis.barcode4j.BarcodeDimension;
import org.krysalis.barcode4j.TextAlignment;
import org.krysalis.barcode4j.output.BarcodeCanvasSetupException;
import org.krysalis.barcode4j.output.svg.AbstractSVGGeneratingCanvasProvider;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;

public class SVGCanvasProvider
extends AbstractSVGGeneratingCanvasProvider {
    private DOMImplementation domImpl;
    private Document doc;
    private Element detailGroup;

    public SVGCanvasProvider(String namespacePrefix, int orientation) throws BarcodeCanvasSetupException {
        this(null, namespacePrefix, orientation);
    }

    public SVGCanvasProvider(DOMImplementation domImpl, String namespacePrefix, int orientation) throws BarcodeCanvasSetupException {
        super(namespacePrefix, orientation);
        this.domImpl = domImpl;
        this.init();
    }

    public SVGCanvasProvider(boolean useNamespace, int orientation) throws BarcodeCanvasSetupException {
        this(null, useNamespace, orientation);
    }

    public SVGCanvasProvider(DOMImplementation domImpl, boolean useNamespace, int orientation) throws BarcodeCanvasSetupException {
        super(useNamespace, orientation);
        this.domImpl = domImpl;
        this.init();
    }

    public SVGCanvasProvider(int orientation) throws BarcodeCanvasSetupException {
        super(orientation);
        this.init();
    }

    private void init() {
        this.doc = this.createDocument();
        Element svg = this.doc.getDocumentElement();
        this.detailGroup = this.createElement("g");
        svg.appendChild(this.detailGroup);
        this.detailGroup.setAttribute("fill", "black");
        this.detailGroup.setAttribute("stroke", "none");
    }

    private Element createElement(String localName) {
        Element el = this.isNamespaceEnabled() ? this.doc.createElementNS("http://www.w3.org/2000/svg", this.getQualifiedName(localName)) : this.doc.createElement(localName);
        return el;
    }

    private Document createDocument() {
        try {
            if (this.domImpl == null) {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setNamespaceAware(true);
                dbf.setValidating(false);
                DocumentBuilder db = dbf.newDocumentBuilder();
                this.domImpl = db.getDOMImplementation();
            }
            if (this.isNamespaceEnabled()) {
                Document doc = this.domImpl.createDocument("http://www.w3.org/2000/svg", this.getQualifiedName("svg"), null);
                return doc;
            }
            return this.domImpl.createDocument(null, "svg", null);
        }
        catch (ParserConfigurationException pce) {
            throw new RuntimeException(pce.getMessage());
        }
    }

    public Document getDOM() {
        return this.doc;
    }

    public DocumentFragment getDOMFragment() {
        DocumentFragment frag = this.doc.createDocumentFragment();
        frag.appendChild(this.doc.importNode(this.doc.getFirstChild(), true));
        return frag;
    }

    public void establishDimensions(BarcodeDimension dim) {
        String transform;
        super.establishDimensions(dim);
        int orientation = BarcodeDimension.normalizeOrientation(this.getOrientation());
        Element svg = this.doc.getDocumentElement();
        svg.setAttribute("width", this.addUnit(dim.getWidthPlusQuiet(orientation)));
        svg.setAttribute("height", this.addUnit(dim.getHeightPlusQuiet(orientation)));
        String w = this.getDecimalFormat().format(dim.getWidthPlusQuiet(orientation));
        String h = this.getDecimalFormat().format(dim.getHeightPlusQuiet(orientation));
        svg.setAttribute("viewBox", "0 0 " + w + " " + h);
        switch (orientation) {
            case 90: {
                transform = "rotate(-90) translate(-" + h + ")";
                break;
            }
            case 180: {
                transform = "rotate(-180) translate(-" + w + " -" + h + ")";
                break;
            }
            case 270: {
                transform = "rotate(-270) translate(0 -" + w + ")";
                break;
            }
            default: {
                transform = null;
            }
        }
        if (transform != null) {
            this.detailGroup.setAttribute("transform", transform);
        }
    }

    public void deviceFillRect(double x, double y, double w, double h) {
        Element el = this.createElement("rect");
        el.setAttribute("x", this.getDecimalFormat().format(x));
        el.setAttribute("y", this.getDecimalFormat().format(y));
        el.setAttribute("width", this.getDecimalFormat().format(w));
        el.setAttribute("height", this.getDecimalFormat().format(h));
        this.detailGroup.appendChild(el);
    }

    public void deviceText(String text, double x1, double x2, double y1, String fontName, double fontSize, TextAlignment textAlign) {
        double tx;
        String anchor;
        Element el = this.createElement("text");
        if (textAlign == TextAlignment.TA_LEFT) {
            anchor = "start";
            tx = x1;
        } else if (textAlign == TextAlignment.TA_RIGHT) {
            anchor = "end";
            tx = x2;
        } else {
            anchor = "middle";
            tx = x1 + (x2 - x1) / 2.0;
        }
        el.setAttribute("font-family", fontName);
        el.setAttribute("font-size", this.getDecimalFormat().format(fontSize));
        el.setAttribute("text-anchor", anchor);
        el.setAttribute("x", this.getDecimalFormat().format(tx));
        el.setAttribute("y", this.getDecimalFormat().format(y1));
        if (textAlign == TextAlignment.TA_JUSTIFY) {
            el.setAttribute("textLength", this.getDecimalFormat().format(x2 - x1));
        }
        el.appendChild(this.doc.createTextNode(text));
        this.detailGroup.appendChild(el);
    }
}

