/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.net.ssl.HttpsURLConnection;
import org.adempiere.base.Core;
import org.compiere.model.MBankAccountProcessor;
import org.compiere.model.MPaymentValidate;
import org.compiere.model.PaymentInterface;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public abstract class PaymentProcessor {
    protected CLogger log = CLogger.getCLogger(this.getClass());
    private static CLogger s_log = CLogger.getCLogger(PaymentProcessor.class);
    public static final String ENCODING = "UTF-8";
    private boolean m_encoded = false;
    public static final char AMP = '&';
    public static final char EQ = '=';
    protected MBankAccountProcessor p_mbap = null;
    protected PaymentInterface p_mp = null;
    private int m_timeout = 30;

    public void initialize(MBankAccountProcessor mbap, PaymentInterface mp) {
        this.p_mbap = mbap;
        this.p_mp = mp;
    }

    public static PaymentProcessor create(MBankAccountProcessor mbap, PaymentInterface mp) {
        return Core.getPaymentProcessor(mbap, mp);
    }

    public abstract boolean processCC() throws IllegalArgumentException;

    public abstract boolean isProcessedOK();

    public String validate() throws IllegalArgumentException {
        String msg = null;
        if ("C".equals(this.p_mp.getTenderType())) {
            msg = this.validateCreditCard();
        } else if ("K".equals(this.p_mp.getTenderType())) {
            msg = this.validateCheckNo();
        } else if ("T".equals(this.p_mp.getTenderType())) {
            msg = this.validateAccountNo();
        }
        return msg;
    }

    public String validateAccountNo() {
        return MPaymentValidate.validateAccountNo(this.p_mp.getAccountNo());
    }

    public String validateCheckNo() {
        return MPaymentValidate.validateCheckNo(this.p_mp.getCheckNo());
    }

    public String validateCreditCard() throws IllegalArgumentException {
        String msg = null;
        if (this.p_mp.getC_BP_BankAccount_ID() != 0 || this.p_mp.getCustomerPaymentProfileID() != null && this.p_mp.getCustomerPaymentProfileID().length() > 0) {
            return msg;
        }
        msg = MPaymentValidate.validateCreditCardNumber(this.p_mp.getCreditCardNumber(), this.p_mp.getCreditCardType());
        if (msg != null && msg.length() > 0) {
            throw new IllegalArgumentException(Msg.getMsg(Env.getCtx(), msg));
        }
        msg = MPaymentValidate.validateCreditCardExp(this.p_mp.getCreditCardExpMM(), this.p_mp.getCreditCardExpYY());
        if (msg != null && msg.length() > 0) {
            throw new IllegalArgumentException(Msg.getMsg(Env.getCtx(), msg));
        }
        if (this.p_mp.getCreditCardVV() != null && this.p_mp.getCreditCardVV().length() > 0 && (msg = MPaymentValidate.validateCreditCardVV(this.p_mp.getCreditCardVV(), this.p_mp.getCreditCardType())) != null && msg.length() > 0) {
            throw new IllegalArgumentException(Msg.getMsg(Env.getCtx(), msg));
        }
        return msg;
    }

    public void setTimeout(int newTimeout) {
        this.m_timeout = newTimeout;
    }

    public int getTimeout() {
        return this.m_timeout;
    }

    protected String createPair(String name, BigDecimal value, int maxLength) {
        if (value == null) {
            return this.createPair(name, "0", maxLength);
        }
        if (value.scale() < 2) {
            value = value.setScale(2, RoundingMode.HALF_UP);
        }
        return this.createPair(name, String.valueOf(value), maxLength);
    }

    protected String createPair(String name, int value, int maxLength) {
        if (value == 0) {
            return "";
        }
        return this.createPair(name, String.valueOf(value), maxLength);
    }

    protected String createPair(String name, String value, int maxLength) {
        if (name == null || name.length() == 0 || value == null || value.length() == 0) {
            return "";
        }
        if (value.length() > maxLength) {
            value = value.substring(0, maxLength);
        }
        StringBuilder retValue = new StringBuilder(name);
        if (this.m_encoded) {
            try {
                value = URLEncoder.encode(value, ENCODING);
            }
            catch (UnsupportedEncodingException e) {
                this.log.log(Level.SEVERE, value + " - " + e.toString());
            }
        } else if (value.indexOf(38) != -1 || value.indexOf(61) != -1) {
            retValue.append("[").append(value.length()).append("]");
        }
        retValue.append('=');
        retValue.append(value);
        return retValue.toString();
    }

    public void setEncoded(boolean doEncode) {
        this.m_encoded = doEncode;
    }

    public boolean isEncoded() {
        return this.m_encoded;
    }

    protected Properties getConnectPostProperties(String urlString, String parameter) {
        long start = System.currentTimeMillis();
        String result = this.connectPost(urlString, parameter);
        if (result == null) {
            return null;
        }
        Properties prop = new Properties();
        try {
            String info = URLDecoder.decode(result, ENCODING);
            StringTokenizer st = new StringTokenizer(info, "&");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                int index = token.indexOf(61);
                if (index == -1) {
                    prop.put(token, "");
                    continue;
                }
                String key = token.substring(0, index);
                String value = token.substring(index + 1);
                prop.put(key, value);
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, result, e);
        }
        long ms = System.currentTimeMillis() - start;
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(ms + "ms - " + prop.toString());
        }
        return prop;
    }

    protected String connectPost(String urlString, String parameter) {
        String response = null;
        try {
            URL url = new URL(urlString);
            HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
            connection.setDoOutput(true);
            connection.setUseCaches(false);
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(connection.getURL().toString());
            }
            DataOutputStream out = new DataOutputStream(connection.getOutputStream());
            out.write(parameter.getBytes());
            out.flush();
            out.close();
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            response = in.readLine();
            in.close();
            this.log.finest(response);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, urlString, e);
        }
        return response;
    }
}

