/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import com.google.api.client.auth.oauth2.AuthorizationCodeTokenRequest;
import com.google.api.client.auth.oauth2.ClientParametersAuthentication;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.auth.openidconnect.IdToken;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import org.compiere.model.MAuthorizationAccount;
import org.compiere.model.MAuthorizationProvider;
import org.compiere.model.MAuthorizationScopeProv;
import org.compiere.model.MPInstance;
import org.compiere.model.MPInstanceLog;
import org.compiere.model.MPInstancePara;
import org.compiere.model.MSysConfig;
import org.compiere.model.Query;
import org.compiere.model.X_AD_AuthorizationCredential;
import org.compiere.util.EMail;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MAuthorizationCredential
extends X_AD_AuthorizationCredential {
    private static final long serialVersionUID = -5410915257751308490L;

    public MAuthorizationCredential(Properties ctx, String AD_AuthorizationCredential_UU, String trxName) {
        super(ctx, AD_AuthorizationCredential_UU, trxName);
    }

    public MAuthorizationCredential(Properties ctx, int AD_AuthorizationCredential_ID, String trxName) {
        super(ctx, AD_AuthorizationCredential_ID, trxName);
    }

    public MAuthorizationCredential(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public String processToken(String code, MPInstance pinstance) {
        Object msg = null;
        try {
            if (pinstance == null) {
                msg = "Process instance is required";
                return msg;
            }
            MPInstancePara paramScope = null;
            MPInstancePara[] mPInstanceParaArray = pinstance.getParameters();
            int n = mPInstanceParaArray.length;
            int n2 = 0;
            while (n2 < n) {
                MPInstancePara param = mPInstanceParaArray[n2];
                if ("AD_AuthorizationScopes".equals(param.getParameterName())) {
                    paramScope = param;
                    break;
                }
                ++n2;
            }
            if (paramScope == null) {
                msg = "Process instance parameter for Scopes not found";
                return msg;
            }
            MPInstanceLog pilog = pinstance.addLog(null, 0, null, null, 200272, 0);
            msg = this.processToken(Env.getCtx(), code, paramScope.getP_String(), pilog);
            pilog.saveEx();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            msg = Msg.getMsg(this.getCtx(), "Error") + ex.getLocalizedMessage();
            return msg;
        }
        return msg;
    }

    public String processToken(Properties ctx, String code, String paramScope, MPInstanceLog pilog) {
        Object msg = null;
        try {
            String refreshToken;
            Object access_token;
            String clientId = this.getAuthorizationClientId();
            String clientSecret = this.getAuthorizationClientSecret();
            Timestamp ts = new Timestamp(System.currentTimeMillis());
            MAuthorizationProvider ap = new MAuthorizationProvider(ctx, this.getAD_AuthorizationProvider_ID(), this.get_TrxName());
            AuthorizationCodeTokenRequest request = new AuthorizationCodeTokenRequest((HttpTransport)new NetHttpTransport(), (JsonFactory)GsonFactory.getDefaultInstance(), new GenericUrl(ap.getTokenEndpoint()), code);
            request.setRedirectUri(this.getAuthorizationRedirectURL());
            request.setClientAuthentication((HttpExecuteInterceptor)new ClientParametersAuthentication(clientId, clientSecret));
            TokenResponse tokenResponse = request.execute();
            Object id_token = tokenResponse.get((Object)"id_token");
            String email = null;
            if (id_token != null && id_token instanceof String) {
                IdToken idtoken = IdToken.parse((JsonFactory)tokenResponse.getFactory(), (String)((String)tokenResponse.get((Object)"id_token")));
                email = (String)idtoken.getPayload().get((Object)"email");
            }
            if (email == null) {
                msg = Msg.parseTranslation(ctx, "@Error@ @OAuthProcessToken_CouldNotGetEMail@");
                return msg;
            }
            String preferred_username = null;
            if (ap.getAD_AuthorizationProvider_ID() == 200001 && MSysConfig.getBooleanValue("OAUTH2_USE_ID_TOKEN_PREF_USERNAME_ON_MS_PROVIDER", true) && id_token != null && id_token instanceof String) {
                IdToken idtoken = IdToken.parse((JsonFactory)tokenResponse.getFactory(), (String)((String)tokenResponse.get((Object)"id_token")));
                preferred_username = (String)idtoken.getPayload().get((Object)"preferred_username");
            }
            if (preferred_username == null && ap.getAD_AuthorizationProvider_ID() == 200001 && MSysConfig.getBooleanValue("OAUTH2_USE_ACCESS_TOKEN_UPN_ON_MICROSOFT_PROVIDER", true) && (access_token = tokenResponse.get((Object)"access_token")) != null && access_token instanceof String) {
                try {
                    IdToken accesstoken = IdToken.parse((JsonFactory)tokenResponse.getFactory(), (String)((String)tokenResponse.get((Object)"access_token")));
                    preferred_username = (String)accesstoken.getPayload().get((Object)"upn");
                }
                catch (Exception exception) {}
            }
            boolean newAccount = false;
            MAuthorizationAccount account = null;
            Query query = new Query(ctx, "AD_AuthorizationAccount", "AD_Client_ID=? AND AD_User_ID=? AND EMail=? AND AD_AuthorizationCredential_ID=?", this.get_TrxName());
            query.setParameters(Env.getAD_Client_ID(ctx), Env.getAD_User_ID(ctx), email, this.getAD_AuthorizationCredential_ID());
            account = (MAuthorizationAccount)query.setOnlyActiveRecords(true).first();
            if (account == null) {
                account = new MAuthorizationAccount(ctx, 0, this.get_TrxName());
                account.setEMail(email);
                if (preferred_username != null && !email.toLowerCase().equals(preferred_username.toLowerCase()) && EMail.validate(preferred_username)) {
                    account.setPreferred_UserName(preferred_username);
                }
                account.setAD_AuthorizationCredential_ID(this.getAD_AuthorizationCredential_ID());
                account.setAD_User_ID(Env.getAD_User_ID(ctx));
                newAccount = true;
            }
            account.setAD_AuthorizationScopes(paramScope);
            account.setAccessToken(tokenResponse.getAccessToken());
            account.setAccessTokenTimestamp(ts);
            account.setExpireInSeconds(BigDecimal.valueOf(tokenResponse.getExpiresInSeconds()));
            account.setIsAuthorized(true);
            account.setIsActive(true);
            if (tokenResponse.getRefreshToken() == null && account.getRefreshToken() == null && (refreshToken = account.findRefreshToken()) != null) {
                account.setRefreshToken(refreshToken);
            }
            if (tokenResponse.getRefreshToken() == null && account.getRefreshToken() == null) {
                MAuthorizationProvider provider = new MAuthorizationProvider(ctx, this.getAD_AuthorizationProvider_ID(), this.get_TrxName());
                String revokeEndPoint = provider.getRevokeEndpoint();
                if (revokeEndPoint != null) {
                    HttpRequestFactory factory = new NetHttpTransport().createRequestFactory();
                    GenericUrl url = new GenericUrl(revokeEndPoint + "?token=" + account.getAccessToken());
                    HttpRequest revokeRequest = factory.buildGetRequest(url);
                    revokeRequest.execute();
                }
                msg = Msg.parseTranslation(ctx, "@Error@ @OAuthProcessToken_NoRefreshToken@");
                return msg;
            }
            if (tokenResponse.getRefreshToken() != null) {
                account.setRefreshToken(tokenResponse.getRefreshToken());
            }
            account.saveEx();
            if (pilog != null) {
                String logmsg = Msg.parseTranslation(ctx, (newAccount ? "@Created@" : "@Updated@") + " @AD_AuthorizationAccount_ID@ for ") + account.getEMail();
                pilog.setP_Msg(logmsg);
                pilog.setRecord_ID(account.getAD_AuthorizationAccount_ID());
            }
            account.syncOthers();
            msg = newAccount ? Msg.getMsg(ctx, "Authorization_Access_OK", new Object[]{account.getEMail(), paramScope}) : Msg.getMsg(ctx, "Authorization_Access_Previous", new Object[]{account.getEMail(), paramScope});
        }
        catch (Exception ex) {
            ex.printStackTrace();
            msg = Msg.getMsg(ctx, "Error") + ex.getLocalizedMessage();
            return msg;
        }
        return msg;
    }

    public String getFullAuthorizationEndpoint(String scopes, String state) {
        String scopeUrl = this.findScopeUrl(scopes);
        if (scopeUrl == null) {
            throw new AdempiereException("Could not find scope " + scopes + " for provider " + this.getAD_AuthorizationProvider_ID());
        }
        MAuthorizationProvider provider = new MAuthorizationProvider(this.getCtx(), this.getAD_AuthorizationProvider_ID(), this.get_TrxName());
        String authEndPoint = provider.getAuthorizationEndpoint();
        StringBuilder url = new StringBuilder(authEndPoint).append("?");
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
        nameValuePairs.add(new BasicNameValuePair("scope", scopeUrl));
        nameValuePairs.add(new BasicNameValuePair("redirect_uri", this.getAuthorizationRedirectURL()));
        nameValuePairs.add(new BasicNameValuePair("access_type", "offline"));
        nameValuePairs.add(new BasicNameValuePair("response_type", "code"));
        nameValuePairs.add(new BasicNameValuePair("client_id", this.getAuthorizationClientId()));
        nameValuePairs.add(new BasicNameValuePair("state", state));
        url.append(URLEncodedUtils.format(nameValuePairs, (String)"UTF-8"));
        return url.toString();
    }

    private String findScopeUrl(String scopes) {
        String[] scopeList;
        StringBuilder urlBuilder = new StringBuilder();
        ArrayList<String> scopeURLs = new ArrayList<String>();
        String[] stringArray = scopeList = scopes.split("[,]");
        int n = scopeList.length;
        int n2 = 0;
        while (n2 < n) {
            String scope = stringArray[n2];
            scope = scope.trim();
            MAuthorizationScopeProv scpr = (MAuthorizationScopeProv)new Query(Env.getCtx(), "AD_AuthorizationScopeProv", "AD_AuthorizationProvider_ID=? AND AD_AuthorizationScope=?", this.get_TrxName()).setOnlyActiveRecords(true).setParameters(this.getAD_AuthorizationProvider_ID(), scope).first();
            if (scpr != null) {
                String[] urls;
                String[] stringArray2 = urls = scpr.getScopeURL().split("\\s+");
                int n3 = urls.length;
                int n4 = 0;
                while (n4 < n3) {
                    String url = stringArray2[n4];
                    if (!scopeURLs.contains(url = url.trim())) {
                        scopeURLs.add(url);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        for (String scopeURL : scopeURLs) {
            if (urlBuilder.length() > 0) {
                urlBuilder.append(" ");
            }
            urlBuilder.append(scopeURL);
        }
        return urlBuilder.length() > 0 ? urlBuilder.toString() : null;
    }

    @Override
    public String getAuthorizationRedirectURL() {
        return Env.parseContext(this.getCtx(), 0, super.getAuthorizationRedirectURL(), false, false);
    }
}

