/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import org.compiere.apps.IStatusBar;
import org.compiere.grid.ICreateFrom;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MOrder;
import org.compiere.model.MRMA;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;

public abstract class CreateFrom
implements ICreateFrom {
    protected transient CLogger log = CLogger.getCLogger(this.getClass());
    protected MOrder p_order = null;
    protected MRMA m_rma = null;
    private GridTab gridTab;
    private String title;
    private boolean initOK = false;
    protected boolean isSOTrx = false;
    private String m_trxName;

    public CreateFrom(GridTab gridTab) {
        this.gridTab = gridTab;
        GridField field = gridTab.getField("IsSOTrx");
        this.isSOTrx = field != null ? ((Boolean)field.getValue()).booleanValue() : "Y".equals(Env.getContext((Properties)Env.getCtx(), (int)gridTab.getWindowNo(), (String)"IsSOTrx"));
    }

    protected abstract boolean dynInit() throws Exception;

    public abstract void info(IMiniTable var1, IStatusBar var2);

    public abstract boolean save(IMiniTable var1, String var2);

    @Override
    public boolean isInitOK() {
        return this.initOK;
    }

    public void setInitOK(boolean initOK) {
        this.initOK = initOK;
    }

    protected ArrayList<KeyNamePair> loadOrderData(int C_BPartner_ID, boolean forInvoice, boolean sameWarehouseOnly) {
        return this.loadOrderData(C_BPartner_ID, forInvoice, sameWarehouseOnly, false);
    }

    protected ArrayList<KeyNamePair> loadOrderData(int C_BPartner_ID, boolean forInvoice, boolean sameWarehouseOnly, boolean forCreditMemo) {
        ArrayList<KeyNamePair> list;
        block11: {
            list = new ArrayList<KeyNamePair>();
            String isSOTrxParam = this.isSOTrx ? "Y" : "N";
            StringBuilder display = new StringBuilder("o.DocumentNo||' - ' ||").append(DB.TO_CHAR((String)"o.DateOrdered", (int)15, (String)Env.getAD_Language((Properties)Env.getCtx()))).append("||' - '||").append(DB.TO_CHAR((String)"o.GrandTotal", (int)12, (String)Env.getAD_Language((Properties)Env.getCtx())));
            String column = "ol.QtyDelivered";
            String colBP = "o.C_BPartner_ID";
            if (forInvoice) {
                column = "ol.QtyInvoiced";
                colBP = "o.Bill_BPartner_ID";
            }
            StringBuilder sql = new StringBuilder("SELECT o.C_Order_ID,").append((CharSequence)display).append(" FROM C_Order o WHERE ").append(colBP).append("=? AND o.IsSOTrx=? AND o.DocStatus IN ('CL','CO') AND o.C_Order_ID IN (SELECT ol.C_Order_ID FROM C_OrderLine ol WHERE ");
            if (forCreditMemo) {
                sql.append(column).append(">0 AND (CASE WHEN ol.QtyDelivered>=ol.QtyOrdered THEN ol.QtyDelivered-ol.QtyInvoiced!=0 ELSE 1=1 END)) ");
            } else {
                sql.append("ol.QtyOrdered-").append(column).append("!=0) ");
            }
            if (sameWarehouseOnly) {
                sql = sql.append(" AND o.M_Warehouse_ID=? ");
            }
            sql = forCreditMemo ? sql.append(" ORDER BY o.DateOrdered DESC,o.DocumentNo DESC") : sql.append(" ORDER BY o.DateOrdered,o.DocumentNo");
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql.toString(), (String)this.m_trxName);
                    pstmt.setInt(1, C_BPartner_ID);
                    pstmt.setString(2, isSOTrxParam);
                    if (sameWarehouseOnly) {
                        pstmt.setInt(3, this.getM_Warehouse_ID());
                    }
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new KeyNamePair(rs.getInt(1), rs.getString(2)));
                    }
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block11;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return list;
    }

    protected Vector<Vector<Object>> getOrderData(int C_Order_ID, boolean forInvoice) {
        return this.getOrderData(C_Order_ID, forInvoice, false);
    }

    protected Vector<Vector<Object>> getOrderData(int C_Order_ID, boolean forInvoice, boolean forCreditMemo) {
        Vector<Vector<Object>> data;
        block10: {
            if (this.log.isLoggable(Level.CONFIG)) {
                this.log.config("C_Order_ID=" + C_Order_ID);
            }
            this.p_order = new MOrder(Env.getCtx(), C_Order_ID, this.getTrxName());
            data = new Vector<Vector<Object>>();
            StringBuilder sql = new StringBuilder("SELECT ");
            sql.append(forCreditMemo ? "SUM(COALESCE(m.Qty,0))," : "l.QtyOrdered-SUM(COALESCE(m.Qty,0)),");
            sql.append("CASE WHEN l.QtyOrdered=0 THEN 0 ELSE l.QtyEntered/l.QtyOrdered END, l.C_UOM_ID,COALESCE(uom.UOMSymbol,uom.Name), COALESCE(l.M_Product_ID,0),COALESCE(p.Name,c.Name),po.VendorProductNo, l.C_OrderLine_ID,l.Line FROM C_OrderLine l LEFT OUTER JOIN M_Product_PO po ON (l.M_Product_ID = po.M_Product_ID AND l.C_BPartner_ID = po.C_BPartner_ID)  LEFT OUTER JOIN M_MatchPO m ON (l.C_OrderLine_ID=m.C_OrderLine_ID AND ");
            sql.append(forInvoice ? "m.C_InvoiceLine_ID" : "m.M_InOutLine_ID");
            sql.append(" IS NOT NULL AND COALESCE(m.Reversal_ID,0)=0)").append(" LEFT OUTER JOIN M_Product p ON (l.M_Product_ID=p.M_Product_ID) LEFT OUTER JOIN C_Charge c ON (l.C_Charge_ID=c.C_Charge_ID)");
            if (Env.isBaseLanguage((Properties)Env.getCtx(), (String)"C_UOM")) {
                sql.append(" LEFT OUTER JOIN C_UOM uom ON (l.C_UOM_ID=uom.C_UOM_ID)");
            } else {
                sql.append(" LEFT OUTER JOIN C_UOM_Trl uom ON (l.C_UOM_ID=uom.C_UOM_ID AND uom.AD_Language='").append(Env.getAD_Language((Properties)Env.getCtx())).append("')");
            }
            sql.append(" WHERE l.C_Order_ID=? GROUP BY l.QtyOrdered,CASE WHEN l.QtyOrdered=0 THEN 0 ELSE l.QtyEntered/l.QtyOrdered END, l.C_UOM_ID,COALESCE(uom.UOMSymbol,uom.Name),po.VendorProductNo, l.M_Product_ID,COALESCE(p.Name,c.Name), l.Line,l.C_OrderLine_ID ORDER BY l.Line");
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer(sql.toString());
            }
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql.toString(), (String)this.getTrxName());
                    pstmt.setInt(1, C_Order_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        Vector<Object> line = new Vector<Object>();
                        line.add(Boolean.FALSE);
                        BigDecimal qtyOrdered = rs.getBigDecimal(1);
                        BigDecimal multiplier = rs.getBigDecimal(2);
                        BigDecimal qtyEntered = qtyOrdered.multiply(multiplier);
                        line.add(qtyEntered);
                        KeyNamePair pp = new KeyNamePair(rs.getInt(3), rs.getString(4).trim());
                        line.add(pp);
                        pp = new KeyNamePair(rs.getInt(5), rs.getString(6));
                        line.add(pp);
                        line.add(rs.getString(7));
                        pp = new KeyNamePair(rs.getInt(8), rs.getString(9));
                        line.add(pp);
                        line.add(null);
                        line.add(null);
                        data.add(line);
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block10;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return data;
    }

    @Override
    public void showWindow() {
    }

    @Override
    public void closeWindow() {
    }

    public GridTab getGridTab() {
        return this.gridTab;
    }

    public int getM_Warehouse_ID() {
        return Env.getContextAsInt((Properties)Env.getCtx(), (int)this.gridTab.getWindowNo(), (String)"M_Warehouse_ID");
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTrxName() {
        return this.m_trxName;
    }

    public void setTrxName(String trxName) {
        this.m_trxName = trxName;
    }
}

