/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import org.compiere.apps.IStatusBar;
import org.compiere.apps.form.CreateFromForm;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.GridTab;
import org.compiere.model.MBankStatement;
import org.compiere.model.MBankStatementLine;
import org.compiere.model.MPayment;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public abstract class StatementCreateFromBatch
extends CreateFromForm {
    protected transient CLogger log = CLogger.getCLogger(this.getClass());

    @Override
    protected boolean dynInit() throws Exception {
        this.setTitle(Msg.getElement((Properties)Env.getCtx(), (String)"C_BankStatement_ID") + " .. " + Msg.getElement((Properties)Env.getCtx(), (String)"X_CreateFromBatch"));
        return true;
    }

    @Deprecated
    public String getSQLWhere(Object BPartner, String DocumentNo, Object DateFrom, Object DateTo, Object AmtFrom, Object AmtTo, Object DocType, Object TenderType, String AuthCode) {
        return this.getSQLWhere((Integer)BPartner, DocumentNo, (Timestamp)DateFrom, (Timestamp)DateTo, (BigDecimal)AmtFrom, (BigDecimal)AmtTo, (Integer)DocType, (String)TenderType, AuthCode);
    }

    public String getSQLWhere(Integer BPartner, String DocumentNo, Timestamp DateFrom, Timestamp DateTo, BigDecimal AmtFrom, BigDecimal AmtTo, Integer DocType, String TenderType, String AuthCode) {
        StringBuilder sql = new StringBuilder();
        sql.append("WHERE p.Processed='Y' AND p.IsReconciled='N'");
        sql.append(" AND p.DocStatus IN ('CO','CL') AND p.PayAmt<>0");
        sql.append(" AND p.C_BankAccount_ID = ?");
        sql.append(" AND NOT EXISTS (SELECT * FROM C_BankStatementLine l WHERE p.C_Payment_ID=l.C_Payment_ID AND l.StmtAmt <> 0)");
        if (DocType != null) {
            sql.append(" AND p.C_DocType_ID=?");
        }
        if (TenderType != null && TenderType.toString().length() > 0) {
            sql.append(" AND p.TenderType=?");
        }
        if (BPartner != null) {
            sql.append(" AND p.C_BPartner_ID=?");
        }
        if (DocumentNo.length() > 0) {
            sql.append(" AND UPPER(p.DocumentNo) LIKE ?");
        }
        if (AuthCode.length() > 0) {
            sql.append(" AND p.R_AuthCode LIKE ?");
        }
        if (AmtFrom != null || AmtTo != null) {
            if (AmtFrom == null && AmtTo != null) {
                sql.append(" AND p.PayAmt <= ?");
            } else if (AmtFrom != null && AmtTo == null) {
                sql.append(" AND p.PayAmt >= ?");
            } else if (AmtFrom != null && AmtTo != null) {
                sql.append(" AND p.PayAmt BETWEEN ? AND ?");
            }
        }
        if (DateFrom != null || DateTo != null) {
            if (DateFrom == null && DateTo != null) {
                sql.append(" AND TRUNC(p.DateTrx) <= ?");
            } else if (DateFrom != null && DateTo == null) {
                sql.append(" AND TRUNC(p.DateTrx) >= ?");
            } else if (DateFrom != null && DateTo != null) {
                sql.append(" AND TRUNC(p.DateTrx) BETWEEN ? AND ?");
            }
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(sql.toString());
        }
        return sql.toString();
    }

    @Deprecated
    void setParameters(PreparedStatement pstmt, Object BankAccount, Object BPartner, String DocumentNo, Object DateFrom, Object DateTo, Object AmtFrom, Object AmtTo, Object DocType, Object TenderType, String AuthCode, GridTab gridTab) throws SQLException {
        this.setParameters(pstmt, (Integer)BankAccount, (Integer)BPartner, DocumentNo, (Timestamp)DateFrom, (Timestamp)DateTo, (BigDecimal)AmtFrom, (BigDecimal)AmtTo, (Integer)DocType, (String)TenderType, AuthCode, gridTab);
    }

    protected void setParameters(PreparedStatement pstmt, Integer BankAccount, Integer BPartner, String DocumentNo, Timestamp DateFrom, Timestamp DateTo, BigDecimal AmtFrom, BigDecimal AmtTo, Integer DocType, String TenderType, String AuthCode, GridTab gridTab) throws SQLException {
        int index = 1;
        pstmt.setInt(index++, BankAccount != null ? BankAccount : (Integer)gridTab.getValue("C_BankAccount_ID"));
        if (DocType != null) {
            pstmt.setInt(index++, DocType);
        }
        if (TenderType != null && TenderType.toString().length() > 0) {
            pstmt.setString(index++, TenderType);
        }
        if (BPartner != null) {
            pstmt.setInt(index++, BPartner);
        }
        if (DocumentNo.length() > 0) {
            pstmt.setString(index++, this.getSQLText(DocumentNo));
        }
        if (AuthCode.length() > 0) {
            pstmt.setString(index++, this.getSQLText(AuthCode));
        }
        if (AmtFrom != null || AmtTo != null) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Amt From=" + String.valueOf(AmtFrom) + ", To=" + String.valueOf(AmtTo));
            }
            if (AmtFrom == null && AmtTo != null) {
                pstmt.setBigDecimal(index++, AmtTo);
            } else if (AmtFrom != null && AmtTo == null) {
                pstmt.setBigDecimal(index++, AmtFrom);
            } else if (AmtFrom != null && AmtTo != null) {
                pstmt.setBigDecimal(index++, AmtFrom);
                pstmt.setBigDecimal(index++, AmtTo);
            }
        }
        if (DateFrom != null || DateTo != null) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Date From=" + String.valueOf(DateFrom) + ", To=" + String.valueOf(DateTo));
            }
            if (DateFrom == null && DateTo != null) {
                pstmt.setTimestamp(index++, DateTo);
            } else if (DateFrom != null && DateTo == null) {
                pstmt.setTimestamp(index++, DateFrom);
            } else if (DateFrom != null && DateTo != null) {
                pstmt.setTimestamp(index++, DateFrom);
                pstmt.setTimestamp(index++, DateTo);
            }
        }
    }

    private String getSQLText(String text) {
        Object s = text.toUpperCase();
        if (!((String)s).endsWith("%")) {
            s = (String)s + "%";
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("String=" + (String)s);
        }
        return s;
    }

    @Deprecated
    protected Vector<Vector<Object>> getBankAccountData(Object BankAccount, Object BPartner, String DocumentNo, Object DateFrom, Object DateTo, Object AmtFrom, Object AmtTo, Object DocType, Object TenderType, String AuthCode, GridTab gridTab) {
        return this.getBankAccountData((Integer)BankAccount, (Integer)BPartner, DocumentNo, (Timestamp)DateFrom, (Timestamp)DateTo, (BigDecimal)AmtFrom, (BigDecimal)AmtTo, (Integer)DocType, (String)TenderType, AuthCode, gridTab);
    }

    protected Vector<Vector<Object>> getBankAccountData(Integer BankAccount, Integer BPartner, String DocumentNo, Timestamp DateFrom, Timestamp DateTo, BigDecimal AmtFrom, BigDecimal AmtTo, Integer DocType, String TenderType, String AuthCode, GridTab gridTab) {
        Vector<Vector<Object>> data;
        block7: {
            if (this.log.isLoggable(Level.CONFIG)) {
                this.log.config("C_BankAccount_ID=" + String.valueOf(BankAccount));
            }
            data = new Vector<Vector<Object>>();
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT py.C_DepositBatch_ID, db.DocumentNo, db.DateDeposit, db.C_BankAccount_ID, ba.AccountNo,");
            sql.append("SUM(currencyConvertPayment(p.C_Payment_ID,ba.C_Currency_ID)) AS amount,");
            sql.append("SUM(p.PayAmt) AS amountoriginal");
            sql.append(" FROM C_BankAccount ba");
            sql.append(" INNER JOIN C_Payment_v p ON (p.C_BankAccount_ID=ba.C_BankAccount_ID)");
            sql.append(" INNER JOIN C_Currency c ON (p.C_Currency_ID=c.C_Currency_ID)");
            sql.append(" INNER JOIN C_Payment py ON (py.C_Payment_ID=p.C_Payment_ID)");
            sql.append(" INNER JOIN C_DepositBatch db ON (py.C_DepositBatch_ID = db.C_DepositBatch_ID) ");
            sql.append(this.getSQLWhere(BPartner, DocumentNo, DateFrom, DateTo, AmtFrom, AmtTo, DocType, TenderType, AuthCode));
            sql.append(" AND py.C_DepositBatch_ID <> 0");
            sql.append(" AND db.DOCSTATUS IN ('CO','CL') AND db.Processed = 'Y'");
            sql.append(" AND NOT EXISTS (SELECT 1 FROM C_BankStatementLine l WHERE db.C_DepositBatch_ID=l.C_DepositBatch_ID AND l.StmtAmt <> 0)");
            sql.append(" GROUP BY py.C_DepositBatch_ID,db.DocumentNo,db.DateDeposit, db.C_BankAccount_ID,ba.AccountNo");
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql.toString(), null);
                    this.setParameters((PreparedStatement)pstmt, BankAccount, BPartner, DocumentNo, DateFrom, DateTo, AmtFrom, AmtTo, DocType, TenderType, AuthCode, gridTab);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        Vector<Comparable<Boolean>> line = new Vector<Comparable<Boolean>>(5);
                        line.add(Boolean.FALSE);
                        line.add(rs.getTimestamp(3));
                        KeyNamePair pp = new KeyNamePair(rs.getInt(1), rs.getString(2));
                        line.add((Comparable<Boolean>)pp);
                        line.add(rs.getBigDecimal(7));
                        line.add(rs.getBigDecimal(6));
                        pp = new KeyNamePair(rs.getInt(4), rs.getString(5));
                        line.add((Comparable<Boolean>)pp);
                        data.add(line);
                    }
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return data;
    }

    protected void configureMiniTable(IMiniTable miniTable) {
        miniTable.setColumnClass(0, Boolean.class, false);
        miniTable.setColumnClass(1, Timestamp.class, true);
        miniTable.setColumnClass(2, String.class, true);
        miniTable.setColumnClass(3, BigDecimal.class, true);
        miniTable.setColumnClass(4, BigDecimal.class, true);
        miniTable.setColumnClass(5, String.class, true);
        miniTable.autoSize();
    }

    @Override
    public boolean save(IMiniTable miniTable, String trxName, GridTab gridTab) {
        int C_BankStatement_ID = (Integer)gridTab.getValue("C_BankStatement_ID");
        MBankStatement bs = new MBankStatement(Env.getCtx(), C_BankStatement_ID, trxName);
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config(bs.toString());
        }
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT p.DateTrx,p.C_Payment_ID,p.DocumentNo, p.C_Currency_ID,c.ISO_Code, p.PayAmt,");
        sql.append("currencyConvertPayment(p.C_Payment_ID,ba.C_Currency_ID), bp.Name ");
        sql.append(" FROM C_BankAccount ba");
        sql.append(" INNER JOIN C_Payment_v p ON (p.C_BankAccount_ID=ba.C_BankAccount_ID)");
        sql.append(" INNER JOIN C_Currency c ON (p.C_Currency_ID=c.C_Currency_ID)");
        sql.append(" INNER JOIN C_Payment py ON (py.C_Payment_ID=p.C_Payment_ID)");
        sql.append(" INNER JOIN C_DepositBatch db ON (py.C_DepositBatch_ID = db.C_DepositBatch_ID)");
        sql.append(" LEFT OUTER JOIN C_BPartner bp ON (p.C_BPartner_ID=bp.C_BPartner_ID)");
        sql.append(" WHERE p.Processed='Y' AND p.IsReconciled='N'");
        sql.append(" AND py.C_DepositBatch_ID = ?");
        sql.append(" AND p.DocStatus IN ('CO','CL') AND p.PayAmt<>0");
        sql.append(" AND p.C_BankAccount_ID=?");
        sql.append(" AND NOT EXISTS (SELECT * FROM C_BankStatementLine l WHERE p.C_Payment_ID=l.C_Payment_ID AND l.StmtAmt <> 0)");
        int i = 0;
        while (i < miniTable.getRowCount()) {
            block11: {
                if (((Boolean)miniTable.getValueAt(i, 0)).booleanValue()) {
                    Timestamp trxDate = (Timestamp)miniTable.getValueAt(i, 1);
                    KeyNamePair pp = (KeyNamePair)miniTable.getValueAt(i, 2);
                    int C_DepositBatch_ID = pp.getKey();
                    pp = (KeyNamePair)miniTable.getValueAt(i, 5);
                    int C_BankAccount_ID = pp.getKey();
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine("Deposit Batch Date=" + String.valueOf(trxDate) + ", Batch=" + C_DepositBatch_ID + " , Bank Account" + C_BankAccount_ID);
                    }
                    CPreparedStatement pstmt = null;
                    ResultSet rs = null;
                    try {
                        try {
                            pstmt = DB.prepareStatement((String)sql.toString(), (String)trxName);
                            pstmt.setInt(1, C_DepositBatch_ID);
                            pstmt.setInt(2, C_BankAccount_ID);
                            rs = pstmt.executeQuery();
                            while (rs.next()) {
                                Timestamp DateTrx = rs.getTimestamp(1);
                                int C_Payment_ID = rs.getInt(2);
                                int C_Currency_ID = rs.getInt(4);
                                BigDecimal TrxAmt = rs.getBigDecimal(7);
                                if (this.log.isLoggable(Level.FINE)) {
                                    this.log.fine("Line Date=" + String.valueOf(trxDate) + ", Payment=" + C_Payment_ID + ", Currency=" + C_Currency_ID + ", Amt=" + String.valueOf(TrxAmt));
                                }
                                MBankStatementLine bsl = new MBankStatementLine(bs);
                                bsl.setStatementLineDate(DateTrx);
                                bsl.setPayment(new MPayment(Env.getCtx(), C_Payment_ID, trxName));
                                bsl.setTrxAmt(TrxAmt);
                                bsl.setStmtAmt(TrxAmt);
                                bsl.setC_Currency_ID(bs.getBankAccount().getC_Currency_ID());
                                if (bsl.save()) continue;
                                this.log.log(Level.SEVERE, "Line not created #" + i);
                            }
                        }
                        catch (SQLException e) {
                            this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                            DB.close(rs, (Statement)pstmt);
                            rs = null;
                            pstmt = null;
                            break block11;
                        }
                    }
                    catch (Throwable throwable) {
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                        throw throwable;
                    }
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                }
            }
            ++i;
        }
        return true;
    }

    protected Vector<String> getOISColumnNames() {
        Vector<String> columnNames = new Vector<String>(6);
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"Select"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"Date"));
        columnNames.add(Msg.getElement((Properties)Env.getCtx(), (String)"C_DepositBatch_ID"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"Amount"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"ConvertedAmount"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"C_BankAccount_ID"));
        return columnNames;
    }

    @Override
    public void info(IMiniTable miniTable, IStatusBar statusBar) {
        DecimalFormat format = DisplayType.getNumberFormat((int)12);
        BigDecimal total = Env.ZERO;
        int rows = miniTable.getRowCount();
        int count = 0;
        int i = 0;
        while (i < rows) {
            if (((Boolean)miniTable.getValueAt(i, 0)).booleanValue()) {
                total = total.add((BigDecimal)miniTable.getValueAt(i, 4));
                ++count;
            }
            ++i;
        }
        statusBar.setStatusLine(String.valueOf(count) + " - " + Msg.getMsg((Properties)Env.getCtx(), (String)"Sum") + "  " + format.format(total));
    }
}

