/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.minigrid.ColumnInfo;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrder;
import org.compiere.model.MRole;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.Trx;

public class Match {
    private static final CLogger log = CLogger.getCLogger(Match.class);
    private String[] m_matchOptions = new String[]{Msg.getElement((Properties)Env.getCtx(), (String)"C_Invoice_ID", (boolean)false), Msg.getElement((Properties)Env.getCtx(), (String)"M_InOut_ID", (boolean)false), Msg.getElement((Properties)Env.getCtx(), (String)"C_Order_ID", (boolean)false)};
    public static final int MATCH_INVOICE = 0;
    public static final int MATCH_SHIPMENT = 1;
    public static final int MATCH_ORDER = 2;
    public static final int MODE_NOTMATCHED = 0;
    public static final int MODE_MATCHED = 1;
    public static final int I_ID = 0;
    public static final int I_DocumentNo = 1;
    public static final int I_DocumentDate = 2;
    public static final int I_BPartner = 3;
    public static final int I_Line = 4;
    public static final int I_Product = 5;
    public static final int I_QTY = 6;
    public static final int I_MATCHED = 7;
    private StringBuffer m_sql = null;
    private String m_dateColumn = "";
    private String m_qtyColumn = "";
    private String m_groupBy = "";
    private String m_trxName = null;

    protected Vector<String> cmd_matchFrom(String selection) {
        Vector<String> vector = new Vector<String>(2);
        if (selection.equals(this.m_matchOptions[0])) {
            vector.add(this.m_matchOptions[1]);
        } else if (selection.equals(this.m_matchOptions[2])) {
            vector.add(this.m_matchOptions[1]);
        } else {
            vector.add(this.m_matchOptions[0]);
            vector.add(this.m_matchOptions[2]);
        }
        return vector;
    }

    public IMiniTable cmd_search(IMiniTable xMatchedTable, int display, String matchToString, Integer Product, Integer Vendor, Timestamp from, Timestamp to, boolean matched) {
        int matchToType = 0;
        if (matchToString.equals(this.m_matchOptions[1])) {
            matchToType = 1;
        } else if (matchToString.equals(this.m_matchOptions[2])) {
            matchToType = 2;
        }
        this.tableInit(display, matchToType, matched, null);
        if (Product != null) {
            this.m_sql.append(" AND lin.M_Product_ID=").append(Product);
        }
        if (Vendor != null) {
            this.m_sql.append(" AND hdr.C_BPartner_ID=").append(Vendor);
        }
        if (from != null && to != null) {
            this.m_sql.append(" AND ").append(this.m_dateColumn).append(" BETWEEN ").append(DB.TO_DATE((Timestamp)from)).append(" AND ").append(DB.TO_DATE((Timestamp)to));
        } else if (from != null) {
            this.m_sql.append(" AND ").append(this.m_dateColumn).append(" >= ").append(DB.TO_DATE((Timestamp)from));
        } else if (to != null) {
            this.m_sql.append(" AND ").append(this.m_dateColumn).append(" <= ").append(DB.TO_DATE((Timestamp)to));
        }
        this.tableLoad(xMatchedTable);
        return xMatchedTable;
    }

    public void cmd_process(IMiniTable xMatchedTable, IMiniTable xMatchedToTable, int matchMode, int matchFrom, String matchTo, BigDecimal m_xMatched) {
        int matchedRow = xMatchedTable.getSelectedRow();
        if (matchedRow < 0) {
            return;
        }
        KeyNamePair lineMatched = (KeyNamePair)xMatchedTable.getValueAt(matchedRow, 4);
        KeyNamePair Product = (KeyNamePair)xMatchedTable.getValueAt(matchedRow, 5);
        double totalQty = m_xMatched.doubleValue();
        int row = 0;
        while (row < xMatchedToTable.getRowCount()) {
            IDColumn id = (IDColumn)xMatchedToTable.getValueAt(row, 0);
            if (id != null && id.isSelected()) {
                KeyNamePair ProductCompare = (KeyNamePair)xMatchedToTable.getValueAt(row, 5);
                if (Product.getKey() == ProductCompare.getKey()) {
                    Trx innerTrx;
                    KeyNamePair lineMatchedTo = (KeyNamePair)xMatchedToTable.getValueAt(row, 4);
                    double qty = 0.0;
                    if (matchMode == 0) {
                        qty = (Double)xMatchedToTable.getValueAt(row, 6);
                    }
                    if ((qty -= ((Double)xMatchedToTable.getValueAt(row, 7)).doubleValue()) > totalQty) {
                        qty = totalQty;
                    }
                    totalQty -= qty;
                    boolean invoice = true;
                    if (matchFrom == 2 || matchTo.equals(this.m_matchOptions[2])) {
                        invoice = false;
                    }
                    int M_InOutLine_ID = 0;
                    int Line_ID = 0;
                    if (matchFrom == 1) {
                        M_InOutLine_ID = lineMatched.getKey();
                        Line_ID = lineMatchedTo.getKey();
                    } else {
                        M_InOutLine_ID = lineMatchedTo.getKey();
                        Line_ID = lineMatched.getKey();
                    }
                    String innerTrxName = this.m_trxName == null ? Trx.createTrxName((String)"Match") : null;
                    Trx trx = innerTrx = innerTrxName != null ? Trx.get((String)innerTrxName, (boolean)true) : null;
                    if (innerTrx != null) {
                        innerTrx.setDisplayName(this.getClass().getName() + "_cmd_process");
                    }
                    try {
                        try {
                            if (this.createMatchRecord(invoice, M_InOutLine_ID, Line_ID, BigDecimal.valueOf(qty), this.m_trxName != null ? this.m_trxName : innerTrxName)) {
                                if (innerTrx != null) {
                                    innerTrx.commit();
                                }
                            } else if (innerTrx != null) {
                                innerTrx.rollback();
                            } else {
                                Trx.get((String)this.m_trxName, (boolean)false).rollback();
                            }
                        }
                        catch (Exception ex) {
                            if (innerTrx != null) {
                                innerTrx.rollback();
                            }
                            throw new AdempiereException((Throwable)ex);
                        }
                    }
                    finally {
                        if (innerTrx != null) {
                            innerTrx.close();
                            innerTrx = null;
                        }
                    }
                }
            }
            ++row;
        }
    }

    public IMiniTable cmd_searchTo(IMiniTable xMatchedTable, IMiniTable xMatchedToTable, String displayString, int matchToType, boolean sameBPartner, boolean sameProduct, boolean sameQty, boolean matched) {
        int row = xMatchedTable.getSelectedRow();
        if (log.isLoggable(Level.CONFIG)) {
            log.config("Row=" + row);
        }
        int display = 0;
        if (displayString.equals(this.m_matchOptions[1])) {
            display = 1;
        } else if (displayString.equals(this.m_matchOptions[2])) {
            display = 2;
        }
        KeyNamePair lineMatched = (KeyNamePair)xMatchedTable.getValueAt(row, 4);
        this.tableInit(display, matchToType, matched, lineMatched);
        KeyNamePair BPartner = (KeyNamePair)xMatchedTable.getValueAt(row, 3);
        KeyNamePair Product = (KeyNamePair)xMatchedTable.getValueAt(row, 5);
        if (log.isLoggable(Level.FINE)) {
            log.fine("BPartner=" + String.valueOf(BPartner) + " - Product=" + String.valueOf(Product));
        }
        if (sameBPartner) {
            this.m_sql.append(" AND hdr.C_BPartner_ID=").append(BPartner.getKey());
        }
        if (sameProduct) {
            this.m_sql.append(" AND lin.M_Product_ID=").append(Product.getKey());
        }
        double docQty = (Double)xMatchedTable.getValueAt(row, 6);
        if (sameQty) {
            this.m_sql.append(" AND ").append(this.m_qtyColumn).append("=").append(docQty);
        }
        this.tableLoad(xMatchedToTable);
        return xMatchedToTable;
    }

    protected void tableInit(int display, int matchToType, boolean matched, KeyNamePair lineMatched) {
        if (log.isLoggable(Level.CONFIG)) {
            log.config("Display=" + this.m_matchOptions[display] + ", MatchTo=" + this.m_matchOptions[matchToType] + ", Matched=" + matched);
        }
        this.m_sql = new StringBuffer();
        int Line_ID = 0;
        if (matched && lineMatched != null) {
            Line_ID = lineMatched.getKey();
        }
        if (display == 0) {
            this.m_dateColumn = "hdr.DateInvoiced";
            this.m_qtyColumn = "lin.QtyInvoiced";
            this.m_sql.append("\tSELECT hdr.C_Invoice_ID, hdr.DocumentNo, hdr.DateInvoiced, bp.Name, hdr.C_BPartner_ID,\n\tlin.Line, lin.C_InvoiceLine_ID, p.Name, lin.M_Product_ID,\n\tCASE WHEN dt.DocBaseType='APC' THEN lin.QtyInvoiced * -1 ELSE lin.QtyInvoiced END,SUM(NVL(mi.Qty,0)), org.Name, hdr.AD_Org_ID\n\t FROM C_Invoice hdr\n\t INNER JOIN AD_Org org ON (hdr.AD_Org_ID=org.AD_Org_ID)\n\t INNER JOIN C_BPartner bp ON (hdr.C_BPartner_ID=bp.C_BPartner_ID)\n\t INNER JOIN C_InvoiceLine lin ON (hdr.C_Invoice_ID=lin.C_Invoice_ID)\n\t INNER JOIN M_Product p ON (lin.M_Product_ID=p.M_Product_ID)\n\t INNER JOIN C_DocType dt ON (hdr.C_DocType_ID=dt.C_DocType_ID AND dt.DocBaseType IN ('API','APC'))\n\t FULL JOIN M_MatchInv mi ON (lin.C_InvoiceLine_ID=mi.C_InvoiceLine_ID)\n\t WHERE hdr.DocStatus IN ('CO','CL')\n");
            if (lineMatched != null && Line_ID > 0) {
                this.m_sql.append(" AND mi.M_InOutLine_ID  = ").append(Line_ID);
            }
            this.m_groupBy = matched ? MInvoice.FULL_OR_PARTIALLY_MATCHED_TO_RECEIPT_GROUP_BY : MInvoice.NOT_FULLY_MATCHED_TO_RECEIPT_GROUP_BY;
        } else if (display == 2) {
            this.m_dateColumn = "hdr.DateOrdered";
            this.m_qtyColumn = "lin.QtyOrdered";
            if (matchToType == 1) {
                this.m_sql.append(matched ? MOrder.FULL_OR_PARTIALLY_MATCHED_TO_RECEIPT : MOrder.NOT_FULLY_MATCHED_TO_RECEIPT);
                if (lineMatched != null && Line_ID > 0) {
                    this.m_sql.append(" AND mo.M_InOutLine_ID = " + Line_ID);
                }
                this.m_groupBy = matched ? MOrder.FULL_OR_PARTIALLY_MATCHED_TO_RECEIPT_GROUP_BY : MOrder.NOT_FULLY_MATCHED_TO_RECEIPT_GROUP_BY;
            } else {
                this.m_sql.append(matched ? MOrder.FULL_OR_PARTIALLY_MATCHED_TO_INVOICE : MOrder.NOT_FULLY_MATCHED_TO_INVOICE);
                if (lineMatched != null && Line_ID > 0) {
                    this.m_sql.append(" AND mo.C_InvoiceLine_ID = " + Line_ID);
                }
                this.m_groupBy = matched ? MOrder.FULL_OR_PARTIALLY_MATCHED_TO_INVOICE_GROUP_BY : MOrder.NOT_FULLY_MATCHED_TO_INVOICE_GROUP_BY;
            }
        } else {
            this.m_dateColumn = "hdr.MovementDate";
            this.m_qtyColumn = "lin.MovementQty";
            if (matchToType == 2) {
                this.m_sql.append(matched ? MInOut.FULL_OR_PARTIALLY_MATCHED_TO_ORDER : MInOut.NOT_FULLY_MATCHED_TO_ORDER);
            } else {
                this.m_sql.append(matched ? MInOut.FULL_OR_PARTIALLY_MATCHED_TO_INVOICE : MInOut.NOT_FULLY_MATCHED_TO_INVOICE);
            }
            if (matchToType == 0 && lineMatched != null && Line_ID > 0) {
                this.m_sql.append(" AND m.C_InvoiceLine_ID  = ").append(Line_ID);
            }
            if (matchToType == 2 && lineMatched != null && Line_ID > 0) {
                this.m_sql.append(" AND m.C_OrderLine_ID  = ").append(Line_ID);
            }
            this.m_groupBy = matchToType == 2 ? (matched ? MInOut.FULL_OR_PARTIALLY_MATCHED_TO_ORDER_GROUP_BY : MInOut.NOT_FULLY_MATCHED_TO_ORDER_GROUP_BY) : (matched ? MInOut.FULL_OR_PARTIALLY_MATCHED_TO_INVOICE_GROUP_BY : MInOut.NOT_FULLY_MATCHED_TO_INVOICE_GROUP_BY);
        }
    }

    protected void tableLoad(IMiniTable table) {
        block6: {
            String sql = MRole.getDefault().addAccessSQL(this.m_sql.toString(), "hdr", true, false) + this.m_groupBy;
            if (log.isLoggable(Level.FINEST)) {
                log.finest(sql);
            }
            Statement stmt = null;
            ResultSet rs = null;
            try {
                try {
                    stmt = DB.createStatement((int)1003, (int)1007, (String)this.m_trxName);
                    rs = stmt.executeQuery(sql);
                    table.loadTable(rs);
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)stmt);
                    rs = null;
                    stmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, stmt);
                rs = null;
                stmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)stmt);
            rs = null;
            stmt = null;
        }
    }

    protected boolean createMatchRecord(boolean invoice, int M_InOutLine_ID, int Line_ID, BigDecimal qty, String trxName) {
        if (qty.compareTo(Env.ZERO) == 0) {
            return true;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("IsInvoice=" + invoice + ", M_InOutLine_ID=" + M_InOutLine_ID + ", Line_ID=" + Line_ID + ", Qty=" + String.valueOf(qty));
        }
        boolean success = false;
        MInOutLine sLine = new MInOutLine(Env.getCtx(), M_InOutLine_ID, trxName);
        success = invoice ? sLine.matchToInvoiceLine(Line_ID, qty) : sLine.matchToOrderLine(Line_ID, qty);
        return success;
    }

    public void setTrxName(String trxName) {
        this.m_trxName = trxName;
    }

    public String getTrxName() {
        return this.m_trxName;
    }

    public String getMatchTypeText(int matchType) {
        if (matchType >= 0 && matchType < this.m_matchOptions.length) {
            return this.m_matchOptions[matchType];
        }
        return null;
    }

    public ColumnInfo[] getColumnLayout() {
        ColumnInfo[] layout = new ColumnInfo[]{new ColumnInfo(" ", ".", IDColumn.class, false, false, ""), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"DocumentNo"), ".", String.class), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"Date"), ".", Timestamp.class), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"C_BPartner_ID"), ".", KeyNamePair.class, "."), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"Line"), ".", KeyNamePair.class, "."), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"M_Product_ID"), ".", KeyNamePair.class, "."), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"Qty"), ".", Double.class), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"Matched"), ".", Double.class)};
        return layout;
    }
}

