/*
 * Decompiled with CFR 0.152.
 */
package com.trekglobal.idempiere.rest.api.v1.resource.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.trekglobal.idempiere.rest.api.json.IDempiereRestException;
import com.trekglobal.idempiere.rest.api.json.IPOSerializer;
import com.trekglobal.idempiere.rest.api.json.TypeConverterUtils;
import com.trekglobal.idempiere.rest.api.json.filter.ConvertedQuery;
import com.trekglobal.idempiere.rest.api.json.filter.IQueryConverter;
import com.trekglobal.idempiere.rest.api.util.ErrorBuilder;
import com.trekglobal.idempiere.rest.api.v1.resource.FormResource;
import java.util.List;
import java.util.logging.Level;
import javax.ws.rs.core.Response;
import org.compiere.model.MForm;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class FormResourceImpl
implements FormResource {
    private static final CLogger log = CLogger.getCLogger(FormResourceImpl.class);

    @Override
    public Response getForms(String filter) {
        JsonArray formArray = new JsonArray();
        IQueryConverter converter = IQueryConverter.getQueryConverter("DEFAULT");
        try {
            ConvertedQuery convertedStatement = converter.convertStatement("AD_Form", filter);
            if (log.isLoggable(Level.INFO)) {
                log.info("Where Clause: " + convertedStatement.getWhereClause());
            }
            Query query = new Query(Env.getCtx(), "AD_Form", convertedStatement.getWhereClause(), null);
            query.setApplyAccessFilter(true).setOnlyActiveRecords(true).setOrderBy("Name");
            query.setParameters(convertedStatement.getParameters());
            query.setOrderBy(" AD_Form_ID");
            int rowCount = 0;
            List forms = query.list();
            MRole role = MRole.getDefault();
            IPOSerializer serializer = IPOSerializer.getPOSerializer("AD_Form", MTable.getClass((String)"AD_Form"));
            for (MForm form : forms) {
                if (role.getFormAccess(form.getAD_Form_ID()) == null) continue;
                JsonObject jsonObject = serializer.toJson((PO)form, new String[]{"AD_Form_ID", "AD_Form_UU", "Name", "Description", "Help", "Classname", "EntityType"}, null);
                jsonObject.addProperty("slug", TypeConverterUtils.slugify(form.getName()));
                formArray.add((JsonElement)jsonObject);
                ++rowCount;
            }
            JsonObject json = new JsonObject();
            json.add("forms", (JsonElement)formArray);
            return Response.ok((Object)json.toString()).header("X-Row-Count", (Object)rowCount).build();
        }
        catch (Exception ex) {
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            if (ex instanceof IDempiereRestException) {
                status = ((IDempiereRestException)((Object)ex)).getErrorResponseStatus();
            }
            log.log(Level.SEVERE, ex.getMessage(), (Throwable)ex);
            return Response.status((Response.Status)status).entity((Object)new ErrorBuilder().status(status).title("GET Error").append("Get forms with exception: ").append(ex.getMessage()).build().toString()).build();
        }
    }
}

