/*
 * Decompiled with CFR 0.152.
 */
package com.trekglobal.idempiere.rest.api.v1.resource.impl;

import com.google.gson.JsonObject;
import com.trekglobal.idempiere.rest.api.json.ResponseUtils;
import com.trekglobal.idempiere.rest.api.util.ClusterUtil;
import com.trekglobal.idempiere.rest.api.util.ErrorBuilder;
import com.trekglobal.idempiere.rest.api.v1.resource.FileResource;
import com.trekglobal.idempiere.rest.api.v1.resource.file.FileAccess;
import com.trekglobal.idempiere.rest.api.v1.resource.file.FileInfo;
import com.trekglobal.idempiere.rest.api.v1.resource.file.FileStreamingOutput;
import com.trekglobal.idempiere.rest.api.v1.resource.file.GetFileInfoCallable;
import com.trekglobal.idempiere.rest.api.v1.resource.file.RemoteFileStreamingOutput;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Base64;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import javax.activation.MimetypesFileTypeMap;
import javax.ws.rs.core.Response;
import org.compiere.model.MUser;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.MimeType;
import org.compiere.util.Util;
import org.idempiere.distributed.IClusterMember;
import org.idempiere.distributed.IClusterService;

public class FileResourceImpl
implements FileResource {
    protected static final int BLOCK_SIZE = 0x500000;
    private static final CLogger log = CLogger.getCLogger(FileResourceImpl.class);

    @Override
    public Response getFile(String fileName, long length, String nodeId, String asJson) {
        MUser user = MUser.get((Properties)Env.getCtx());
        if (!user.isAdministrator()) {
            return this.forbidden("Access denied", "Access denied for get file request");
        }
        if (Util.isEmpty((String)nodeId)) {
            return this.getLocalFile(fileName, true, length, asJson);
        }
        IClusterService service = ClusterUtil.getClusterService();
        if (service == null) {
            return this.getLocalFile(fileName, true, length, asJson);
        }
        IClusterMember local = service.getLocalMember();
        if (local != null && local.getId().equals(nodeId)) {
            return this.getLocalFile(fileName, true, length, asJson);
        }
        return this.getRemoteFile(fileName, true, length, nodeId, asJson);
    }

    public Response getFile(String fileName, String nodeId, String asJson) {
        if (Util.isEmpty((String)nodeId)) {
            return this.getLocalFile(fileName, false, 0L, asJson);
        }
        IClusterService service = ClusterUtil.getClusterService();
        if (service == null) {
            return this.getLocalFile(fileName, false, 0L, asJson);
        }
        IClusterMember local = service.getLocalMember();
        if (local != null && local.getId().equals(nodeId)) {
            return this.getLocalFile(fileName, false, 0L, asJson);
        }
        return this.getRemoteFile(fileName, false, 0L, nodeId, asJson);
    }

    private Response getLocalFile(String fileName, boolean verifyLength, long length, String asJson) {
        File file = new File(fileName);
        if (file.exists() && file.isFile()) {
            if (!file.canRead() || !FileAccess.isAccessible(file)) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)new ErrorBuilder().status(Response.Status.FORBIDDEN).title("File not readable").append("File not readable: ").append(fileName).build().toString()).build();
            }
            if (!verifyLength || file.length() == length) {
                try {
                    if (asJson == null) {
                        String contentType = null;
                        String lfn = fileName.toLowerCase();
                        contentType = lfn.endsWith(".html") || lfn.endsWith(".htm") ? "text/html" : (lfn.endsWith(".csv") || lfn.endsWith(".ssv") || lfn.endsWith(".log") ? "text/plain" : MimeType.getMimeType((String)file.getName()));
                        if (Util.isEmpty((String)contentType, (boolean)true)) {
                            contentType = "application/octet-stream";
                        }
                        FileStreamingOutput fso = new FileStreamingOutput(file);
                        return Response.ok((Object)fso, (String)contentType).build();
                    }
                    JsonObject json = new JsonObject();
                    byte[] binaryData = Files.readAllBytes(file.toPath());
                    String data = Base64.getEncoder().encodeToString(binaryData);
                    json.addProperty("data", data);
                    return Response.ok((Object)json.toString()).build();
                }
                catch (IOException ex) {
                    return ResponseUtils.getResponseErrorFromException(ex, "IO error");
                }
            }
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)new ErrorBuilder().status(Response.Status.FORBIDDEN).title("Access denied").append("Access denied for file: ").append(fileName).build().toString()).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorBuilder().status(Response.Status.NOT_FOUND).title("File not found").append("File not found: ").append(fileName).build().toString()).build();
    }

    private Response getRemoteFile(String fileName, boolean verifyLength, long length, String nodeId, String asJson) {
        IClusterService service = ClusterUtil.getClusterService();
        IClusterMember member = ClusterUtil.getClusterMember(nodeId);
        if (member == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorBuilder().status(Response.Status.NOT_FOUND).title("Invalid Node Id").append("No match found for node id: ").append(nodeId).build().toString()).build();
        }
        try {
            GetFileInfoCallable infoCallable = new GetFileInfoCallable(null, fileName, 0x500000);
            FileInfo fileInfo = (FileInfo)service.execute((Callable)infoCallable, member).get();
            if (fileInfo == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorBuilder().status(Response.Status.NOT_FOUND).title("Invalid File Name").append("File does not exists or not readable: ").append(fileName).build().toString()).build();
            }
            if (verifyLength && length != fileInfo.getLength()) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)new ErrorBuilder().status(Response.Status.FORBIDDEN).title("Access denied").append("Access denied for file: ").append(fileName).build().toString()).build();
            }
            RemoteFileStreamingOutput rfso = new RemoteFileStreamingOutput(fileInfo, member);
            if (asJson == null) {
                String contentType = null;
                String lfn = fileName.toLowerCase();
                if (lfn.endsWith(".html") || lfn.endsWith(".htm")) {
                    contentType = "text/html";
                } else if (lfn.endsWith(".csv") || lfn.endsWith(".ssv") || lfn.endsWith(".log")) {
                    contentType = "text/plain";
                } else {
                    MimetypesFileTypeMap map = new MimetypesFileTypeMap();
                    contentType = map.getContentType(fileInfo.getFileName());
                }
                if (Util.isEmpty((String)contentType, (boolean)true)) {
                    contentType = "application/octet-stream";
                }
                return Response.ok((Object)rfso, (String)contentType).build();
            }
            Throwable throwable = null;
            Object var13_16 = null;
            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                rfso.write(byteArrayOutputStream);
                JsonObject json = new JsonObject();
                byte[] binaryData = byteArrayOutputStream.toByteArray();
                String data = Base64.getEncoder().encodeToString(binaryData);
                json.addProperty("data", data);
                return Response.ok((Object)json.toString()).build();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, ex.getMessage(), (Throwable)ex);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new ErrorBuilder().status(Response.Status.INTERNAL_SERVER_ERROR).title("Server error").append("Server error with exception: ").append(ex.getMessage()).build().toString()).build();
        }
    }

    private Response forbidden(String title, String detail) {
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)new ErrorBuilder().status(Response.Status.FORBIDDEN).title(title).append(detail).build().toString()).build();
    }
}

