/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MMatchInv;
import org.compiere.model.MMatchPO;
import org.compiere.util.Env;

public class MatchPOAutoMatch {
    public static List<MMatchPO> getNotMatchedMatchPOList(Properties ctx, int C_OrderLine_ID, String trxName) {
        ArrayList<MMatchPO> notMatchedMatchPOList = new ArrayList<MMatchPO>();
        ArrayList<MMatchPO> creditMemoMatchPOList = new ArrayList<MMatchPO>();
        ArrayList<MMatchPO> notMatchedCreditMemoMatchPOList = new ArrayList<MMatchPO>();
        MMatchPO[] mpos = MMatchPO.getOrderLine(ctx, C_OrderLine_ID, trxName);
        MMatchPO[] mMatchPOArray = mpos;
        int n = mpos.length;
        int n2 = 0;
        while (n2 < n) {
            MMatchPO mpo = mMatchPOArray[n2];
            if (mpo.getReversal_ID() == 0 && mpo.getRef_MatchPO_ID() == 0) {
                String docStatus;
                if (mpo.getQty().signum() < 0 && mpo.getC_InvoiceLine_ID() > 0 && mpo.getM_InOutLine_ID() == 0 && ((docStatus = mpo.getC_InvoiceLine().getC_Invoice().getDocStatus()).equals("CO") || docStatus.equals("CL"))) {
                    creditMemoMatchPOList.add(mpo);
                } else {
                    notMatchedMatchPOList.add(mpo);
                }
            }
            ++n2;
        }
        if (!notMatchedMatchPOList.isEmpty()) {
            Collections.sort(notMatchedMatchPOList, new Comparator<MMatchPO>(){

                @Override
                public int compare(MMatchPO arg0, MMatchPO arg1) {
                    return arg0.getM_MatchPO_ID() > arg1.getM_MatchPO_ID() ? 1 : (arg0.getM_MatchPO_ID() == arg1.getM_MatchPO_ID() ? 0 : -1);
                }
            });
        }
        if (!creditMemoMatchPOList.isEmpty()) {
            BigDecimal totalNotMatchingCreditMemoQty = Env.ZERO;
            for (MMatchPO matchPOCreditMemo : creditMemoMatchPOList) {
                boolean found = false;
                int Ref_InvoiceLine_ID = matchPOCreditMemo.getC_InvoiceLine().getRef_InvoiceLine_ID();
                if (Ref_InvoiceLine_ID > 0) {
                    for (MMatchPO matchPO : notMatchedMatchPOList) {
                        if (matchPO.isPosted() || matchPO.getC_InvoiceLine_ID() != Ref_InvoiceLine_ID || matchPO.getM_InOutLine_ID() != 0 || matchPO.getQty().compareTo(matchPOCreditMemo.getQty().negate()) != 0) continue;
                        notMatchedMatchPOList.remove(matchPO);
                        found = true;
                        break;
                    }
                }
                if (found) continue;
                for (MMatchPO matchPO : notMatchedMatchPOList) {
                    if (matchPO.isPosted() || matchPO.getC_InvoiceLine_ID() <= 0 || matchPO.getM_InOutLine_ID() != 0 || matchPO.getQty().compareTo(matchPOCreditMemo.getQty().negate()) != 0) continue;
                    notMatchedMatchPOList.remove(matchPO);
                    found = true;
                    break;
                }
                if (found) continue;
                totalNotMatchingCreditMemoQty = totalNotMatchingCreditMemoQty.add(matchPOCreditMemo.getQty().negate());
                notMatchedCreditMemoMatchPOList.add(matchPOCreditMemo);
            }
            if (totalNotMatchingCreditMemoQty.signum() != 0) {
                BigDecimal totalInvoiceQty = Env.ZERO;
                for (MMatchPO matchPO : notMatchedMatchPOList) {
                    if (matchPO.isPosted() || matchPO.getC_InvoiceLine_ID() <= 0 || matchPO.getM_InOutLine_ID() != 0) continue;
                    totalInvoiceQty = totalInvoiceQty.add(matchPO.getQty());
                }
                if (totalNotMatchingCreditMemoQty.compareTo(totalInvoiceQty) == 0) {
                    notMatchedMatchPOList.clear();
                }
            }
        }
        return notMatchedMatchPOList;
    }

    public static void match(Properties ctx, int C_OrderLine_ID, MMatchPO currentPO, String trxName) {
        MMatchPO[] mpos;
        ArrayList<MMatchPO> notMatchedMatchPOList = new ArrayList<MMatchPO>();
        ArrayList<MMatchPO> creditMemoMatchPOList = new ArrayList<MMatchPO>();
        ArrayList<MMatchPO> matchedMatchPOList = new ArrayList<MMatchPO>();
        MMatchPO[] mMatchPOArray = mpos = MMatchPO.getOrderLine(ctx, C_OrderLine_ID, trxName);
        int n = mpos.length;
        int n2 = 0;
        while (n2 < n) {
            MMatchPO mpo = mMatchPOArray[n2];
            if (mpo.getReversal_ID() == 0 && mpo.getRef_MatchPO_ID() == 0) {
                if (mpo.getQty().signum() < 0) {
                    if (mpo.getC_InvoiceLine_ID() > 0 && mpo.getM_InOutLine_ID() == 0) {
                        String docStatus = mpo.getC_InvoiceLine().getC_Invoice().getDocStatus();
                        if (currentPO != null && mpo.getM_MatchPO_ID() == currentPO.getM_MatchPO_ID() || docStatus.equals("CO") || docStatus.equals("CL")) {
                            creditMemoMatchPOList.add(mpo);
                        }
                    }
                } else {
                    notMatchedMatchPOList.add(mpo);
                }
            }
            ++n2;
        }
        if (!notMatchedMatchPOList.isEmpty()) {
            Collections.sort(notMatchedMatchPOList, new Comparator<MMatchPO>(){

                @Override
                public int compare(MMatchPO arg0, MMatchPO arg1) {
                    return arg0.getM_MatchPO_ID() > arg1.getM_MatchPO_ID() ? 1 : (arg0.getM_MatchPO_ID() == arg1.getM_MatchPO_ID() ? 0 : -1);
                }
            });
        }
        if (!creditMemoMatchPOList.isEmpty()) {
            for (MMatchPO matchPOCreditMemo : creditMemoMatchPOList) {
                MMatchInv matchInv2;
                MMatchInv matchInv1;
                MMatchInv matchInv22;
                MMatchInv matchInv12;
                MMatchPO po;
                MInvoiceLine iLine;
                BigDecimal creditMemoQty = matchPOCreditMemo.getQty().negate();
                int Ref_InvoiceLine_ID = matchPOCreditMemo.getC_InvoiceLine().getRef_InvoiceLine_ID();
                if (Ref_InvoiceLine_ID > 0) {
                    for (MMatchPO matchPO : notMatchedMatchPOList) {
                        if (matchPO.isPosted() || matchPO.getC_InvoiceLine_ID() != Ref_InvoiceLine_ID || matchPO.getM_InOutLine_ID() != 0) continue;
                        if (matchPO.getQty().compareTo(creditMemoQty) > 0) {
                            matchPO.setQty(matchPO.getQty().subtract(creditMemoQty));
                            matchPO.saveEx(trxName);
                            iLine = new MInvoiceLine(ctx, matchPO.getC_InvoiceLine_ID(), trxName);
                            po = new MMatchPO(iLine, iLine.getC_Invoice().getDateInvoiced(), creditMemoQty);
                            po.setC_OrderLine_ID(C_OrderLine_ID);
                            po.setRef_MatchPO_ID(matchPOCreditMemo.getM_MatchPO_ID());
                            po.setPosted(true);
                            po.saveEx(trxName);
                            matchPOCreditMemo.setRef_MatchPO_ID(po.getM_MatchPO_ID());
                            matchPOCreditMemo.setPosted(true);
                            matchPOCreditMemo.saveEx(trxName);
                            matchInv12 = MMatchPO.createMatchInv(po, po.getC_InvoiceLine_ID(), po.getM_InOutLine_ID(), po.getQty(), po.getDateTrx(), trxName);
                            matchInv22 = MMatchPO.createMatchInv(matchPOCreditMemo, matchPOCreditMemo.getC_InvoiceLine_ID(), matchPOCreditMemo.getM_InOutLine_ID(), matchPOCreditMemo.getQty(), matchPOCreditMemo.getDateTrx(), trxName);
                            if (matchInv12 == null || matchInv22 == null) break;
                            matchInv12.setRef_MatchInv_ID(matchInv22.getM_MatchInv_ID());
                            matchInv12.saveEx(trxName);
                            matchInv22.setRef_MatchInv_ID(matchInv12.getM_MatchInv_ID());
                            matchInv22.saveEx(trxName);
                            matchedMatchPOList.add(po);
                            creditMemoQty = creditMemoQty.subtract(po.getQty());
                        } else if (matchPO.getQty().compareTo(creditMemoQty) == 0) {
                            matchPO.setRef_MatchPO_ID(matchPOCreditMemo.getM_MatchPO_ID());
                            matchPO.setPosted(true);
                            matchPO.saveEx(trxName);
                            matchPOCreditMemo.setRef_MatchPO_ID(matchPO.getM_MatchPO_ID());
                            matchPOCreditMemo.setPosted(true);
                            matchPOCreditMemo.saveEx(trxName);
                            matchInv1 = MMatchPO.createMatchInv(matchPO, matchPO.getC_InvoiceLine_ID(), matchPO.getM_InOutLine_ID(), matchPO.getQty(), matchPO.getDateTrx(), trxName);
                            matchInv2 = MMatchPO.createMatchInv(matchPOCreditMemo, matchPOCreditMemo.getC_InvoiceLine_ID(), matchPOCreditMemo.getM_InOutLine_ID(), matchPOCreditMemo.getQty(), matchPOCreditMemo.getDateTrx(), trxName);
                            if (matchInv1 == null || matchInv2 == null) break;
                            matchInv1.setRef_MatchInv_ID(matchInv2.getM_MatchInv_ID());
                            matchInv1.saveEx(trxName);
                            matchInv2.setRef_MatchInv_ID(matchInv1.getM_MatchInv_ID());
                            matchInv2.saveEx(trxName);
                            matchedMatchPOList.add(matchPO);
                            creditMemoQty = creditMemoQty.subtract(matchPO.getQty());
                        } else if (matchPO.getQty().compareTo(creditMemoQty) < 0) {
                            matchPOCreditMemo.setQty(matchPOCreditMemo.getQty().add(matchPO.getQty()));
                            matchPOCreditMemo.saveEx(trxName);
                            iLine = new MInvoiceLine(ctx, matchPOCreditMemo.getC_InvoiceLine_ID(), trxName);
                            po = new MMatchPO(iLine, iLine.getC_Invoice().getDateInvoiced(), matchPO.getQty().negate());
                            po.setC_OrderLine_ID(C_OrderLine_ID);
                            po.setRef_MatchPO_ID(matchPO.getM_MatchPO_ID());
                            po.setPosted(true);
                            po.saveEx(trxName);
                            matchPO.setRef_MatchPO_ID(po.getM_MatchPO_ID());
                            matchPO.setPosted(true);
                            matchPO.saveEx(trxName);
                            matchInv12 = MMatchPO.createMatchInv(po, po.getC_InvoiceLine_ID(), po.getM_InOutLine_ID(), po.getQty(), po.getDateTrx(), trxName);
                            matchInv22 = MMatchPO.createMatchInv(matchPO, matchPO.getC_InvoiceLine_ID(), matchPO.getM_InOutLine_ID(), matchPO.getQty(), matchPO.getDateTrx(), trxName);
                            if (matchInv12 == null || matchInv22 == null) break;
                            matchInv12.setRef_MatchInv_ID(matchInv22.getM_MatchInv_ID());
                            matchInv12.saveEx(trxName);
                            matchInv22.setRef_MatchInv_ID(matchInv12.getM_MatchInv_ID());
                            matchInv22.saveEx(trxName);
                            matchedMatchPOList.add(matchPO);
                            creditMemoQty = creditMemoQty.subtract(matchPO.getQty());
                        }
                        if (creditMemoQty.signum() == 0) break;
                    }
                    for (MMatchPO matchedMatchPO : matchedMatchPOList) {
                        notMatchedMatchPOList.remove(matchedMatchPO);
                    }
                }
                if (creditMemoQty.signum() == 0) continue;
                for (MMatchPO matchPO : notMatchedMatchPOList) {
                    if (matchPO.isPosted() || matchPO.getC_InvoiceLine_ID() <= 0 || matchPO.getM_InOutLine_ID() != 0) continue;
                    if (matchPO.getQty().compareTo(creditMemoQty) > 0) {
                        matchPO.setQty(matchPO.getQty().subtract(creditMemoQty));
                        matchPO.saveEx(trxName);
                        iLine = new MInvoiceLine(ctx, matchPO.getC_InvoiceLine_ID(), trxName);
                        po = new MMatchPO(iLine, iLine.getC_Invoice().getDateInvoiced(), creditMemoQty);
                        po.setC_OrderLine_ID(C_OrderLine_ID);
                        po.setRef_MatchPO_ID(matchPOCreditMemo.getM_MatchPO_ID());
                        po.setPosted(true);
                        po.saveEx(trxName);
                        matchPOCreditMemo.setRef_MatchPO_ID(po.getM_MatchPO_ID());
                        matchPOCreditMemo.setPosted(true);
                        matchPOCreditMemo.saveEx(trxName);
                        matchInv12 = MMatchPO.createMatchInv(po, po.getC_InvoiceLine_ID(), po.getM_InOutLine_ID(), po.getQty(), po.getDateTrx(), trxName);
                        matchInv22 = MMatchPO.createMatchInv(matchPOCreditMemo, matchPOCreditMemo.getC_InvoiceLine_ID(), matchPOCreditMemo.getM_InOutLine_ID(), matchPOCreditMemo.getQty(), matchPOCreditMemo.getDateTrx(), trxName);
                        if (matchInv12 == null || matchInv22 == null) break;
                        matchInv12.setRef_MatchInv_ID(matchInv22.getM_MatchInv_ID());
                        matchInv12.saveEx(trxName);
                        matchInv22.setRef_MatchInv_ID(matchInv12.getM_MatchInv_ID());
                        matchInv22.saveEx(trxName);
                        matchedMatchPOList.add(po);
                        creditMemoQty = creditMemoQty.subtract(po.getQty());
                    } else if (matchPO.getQty().compareTo(creditMemoQty) == 0) {
                        matchPO.setRef_MatchPO_ID(matchPOCreditMemo.getM_MatchPO_ID());
                        matchPO.setPosted(true);
                        matchPO.saveEx(trxName);
                        matchPOCreditMemo.setRef_MatchPO_ID(matchPO.getM_MatchPO_ID());
                        matchPOCreditMemo.setPosted(true);
                        matchPOCreditMemo.saveEx(trxName);
                        matchInv1 = MMatchPO.createMatchInv(matchPO, matchPO.getC_InvoiceLine_ID(), matchPO.getM_InOutLine_ID(), matchPO.getQty(), matchPO.getDateTrx(), trxName);
                        matchInv2 = MMatchPO.createMatchInv(matchPOCreditMemo, matchPOCreditMemo.getC_InvoiceLine_ID(), matchPOCreditMemo.getM_InOutLine_ID(), matchPOCreditMemo.getQty(), matchPOCreditMemo.getDateTrx(), trxName);
                        if (matchInv1 == null || matchInv2 == null) break;
                        matchInv1.setRef_MatchInv_ID(matchInv2.getM_MatchInv_ID());
                        matchInv1.saveEx(trxName);
                        matchInv2.setRef_MatchInv_ID(matchInv1.getM_MatchInv_ID());
                        matchInv2.saveEx(trxName);
                        matchedMatchPOList.add(matchPO);
                        creditMemoQty = creditMemoQty.subtract(matchPO.getQty());
                    } else if (matchPO.getQty().compareTo(creditMemoQty) < 0) {
                        matchPOCreditMemo.setQty(matchPOCreditMemo.getQty().add(matchPO.getQty()));
                        matchPOCreditMemo.saveEx(trxName);
                        iLine = new MInvoiceLine(ctx, matchPOCreditMemo.getC_InvoiceLine_ID(), trxName);
                        po = new MMatchPO(iLine, iLine.getC_Invoice().getDateInvoiced(), matchPO.getQty().negate());
                        po.setC_OrderLine_ID(C_OrderLine_ID);
                        po.setRef_MatchPO_ID(matchPO.getM_MatchPO_ID());
                        po.setPosted(true);
                        po.saveEx(trxName);
                        matchPO.setRef_MatchPO_ID(po.getM_MatchPO_ID());
                        matchPO.setPosted(true);
                        matchPO.saveEx(trxName);
                        matchInv12 = MMatchPO.createMatchInv(po, po.getC_InvoiceLine_ID(), po.getM_InOutLine_ID(), po.getQty(), po.getDateTrx(), trxName);
                        matchInv22 = MMatchPO.createMatchInv(matchPO, matchPO.getC_InvoiceLine_ID(), matchPO.getM_InOutLine_ID(), matchPO.getQty(), matchPO.getDateTrx(), trxName);
                        if (matchInv12 == null || matchInv22 == null) break;
                        matchInv12.setRef_MatchInv_ID(matchInv22.getM_MatchInv_ID());
                        matchInv12.saveEx(trxName);
                        matchInv22.setRef_MatchInv_ID(matchInv12.getM_MatchInv_ID());
                        matchInv22.saveEx(trxName);
                        matchedMatchPOList.add(matchPO);
                        creditMemoQty = creditMemoQty.subtract(matchPO.getQty());
                    }
                    if (creditMemoQty.signum() == 0) break;
                }
                for (MMatchPO matchedMatchPO : matchedMatchPOList) {
                    notMatchedMatchPOList.remove(matchedMatchPO);
                }
            }
        }
        if (currentPO != null) {
            for (MMatchPO matchPOCreditMemo : creditMemoMatchPOList) {
                if (matchPOCreditMemo.getM_MatchPO_ID() != currentPO.getM_MatchPO_ID() || matchPOCreditMemo.getReversal_ID() != 0 || matchPOCreditMemo.getRef_MatchPO_ID() != 0) continue;
                throw new RuntimeException("Failed to find the corresponding invoice matched po");
            }
        }
    }

    public static void unmatch(Properties ctx, int C_Invoice_ID, String trxName) {
        MMatchPO[] mpos;
        MMatchInv[] minvs;
        MMatchInv[] mMatchInvArray = minvs = MMatchInv.getInvoice(ctx, C_Invoice_ID, trxName);
        int n = minvs.length;
        int n2 = 0;
        while (n2 < n) {
            MMatchInv minv = mMatchInvArray[n2];
            if (minv.getReversal_ID() <= 0 && minv.getRef_MatchInv_ID() != 0) {
                MMatchInv refMatchInv = new MMatchInv(ctx, minv.getRef_MatchInv_ID(), trxName);
                refMatchInv.deleteEx(true);
                minv.deleteEx(true);
            }
            ++n2;
        }
        ArrayList<Integer> unmatchedOrderLineID = new ArrayList<Integer>();
        MMatchPO[] mMatchPOArray = mpos = MMatchPO.getInvoice(ctx, C_Invoice_ID, trxName);
        int n3 = mpos.length;
        int n4 = 0;
        while (n4 < n3) {
            int C_OrderLine_ID;
            MMatchPO mpo = mMatchPOArray[n4];
            if (mpo.getReversal_ID() <= 0 && mpo.getRef_MatchPO_ID() != 0 && !unmatchedOrderLineID.contains(C_OrderLine_ID = mpo.getC_OrderLine_ID())) {
                MMatchPO[] pos;
                unmatchedOrderLineID.add(C_OrderLine_ID);
                MMatchPO[] mMatchPOArray2 = pos = MMatchPO.getOrderLine(ctx, C_OrderLine_ID, trxName);
                int n5 = pos.length;
                int n6 = 0;
                while (n6 < n5) {
                    MMatchPO po = mMatchPOArray2[n6];
                    if (po.getReversal_ID() == 0 && po.getC_InvoiceLine_ID() > 0 && po.getRef_MatchPO_ID() > 0) {
                        if (po.getC_InvoiceLine().getC_Invoice_ID() == C_Invoice_ID) {
                            po.setRef_MatchPO_ID(0);
                            po.setPosted(false);
                            po.saveEx(trxName);
                        } else if (po.getRef_MatchPO().getC_InvoiceLine().getC_Invoice_ID() == C_Invoice_ID) {
                            po.setRef_MatchPO_ID(0);
                            po.setPosted(false);
                            po.saveEx(trxName);
                        }
                    }
                    ++n6;
                }
            }
            ++n4;
        }
    }
}

