/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.xalan;

import javax.xml.transform.TransformerException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.xalan.extensions.XSLProcessorContext;
import org.apache.xalan.templates.ElemExtensionCall;
import org.krysalis.barcode4j.BarcodeDimension;
import org.krysalis.barcode4j.BarcodeGenerator;
import org.krysalis.barcode4j.BarcodeUtil;
import org.krysalis.barcode4j.output.svg.SVGCanvasProvider;
import org.krysalis.barcode4j.tools.ConfigurationUtil;
import org.krysalis.barcode4j.xalan.ElemWrappingConfiguration;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class BarcodeExt {
    public DocumentFragment generate(NodeList nl, String message) throws SAXException {
        try {
            Configuration cfg = ConfigurationUtil.buildConfiguration(nl.item(0));
            BarcodeGenerator gen = BarcodeUtil.getInstance().createBarcodeGenerator(cfg);
            int orientation = cfg.getAttributeAsInteger("orientation", 0);
            orientation = BarcodeDimension.normalizeOrientation(orientation);
            SVGCanvasProvider svg = cfg.getAttributeAsBoolean("useNamespace", true) ? new SVGCanvasProvider(cfg.getAttribute("prefix", "svg"), orientation) : new SVGCanvasProvider(false, orientation);
            gen.generateBarcode(svg, message);
            return svg.getDOMFragment();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SAXException(e);
        }
    }

    public DocumentFragment barcode(XSLProcessorContext context, ElemExtensionCall elem) throws TransformerException {
        try {
            ElemWrappingConfiguration cfg = new ElemWrappingConfiguration((Element)elem);
            String message = ConfigurationUtil.getMessage((Configuration)cfg);
            BarcodeGenerator gen = BarcodeUtil.getInstance().createBarcodeGenerator((Configuration)cfg);
            int orientation = cfg.getAttributeAsInteger("orientation", 0);
            orientation = BarcodeDimension.normalizeOrientation(orientation);
            SVGCanvasProvider svg = cfg.getAttributeAsBoolean("useNamespace", true) ? new SVGCanvasProvider(cfg.getAttribute("prefix", "svg"), orientation) : new SVGCanvasProvider(false, orientation);
            gen.generateBarcode(svg, message);
            return svg.getDOMFragment();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new TransformerException(e);
        }
    }
}

