/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.Core;
import org.adempiere.exceptions.DBException;
import org.adempiere.exceptions.TaxCriteriaNotFoundException;
import org.adempiere.exceptions.TaxForChangeNotFoundException;
import org.adempiere.exceptions.TaxNoExemptFoundException;
import org.adempiere.exceptions.TaxNotFoundException;
import org.compiere.model.MCountryGroup;
import org.compiere.model.MLocation;
import org.compiere.model.MTax;
import org.compiere.model.MTaxPostal;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class Tax {
    private static CLogger log = CLogger.getCLogger(Tax.class);

    @Deprecated
    public static int get(Properties ctx, int M_Product_ID, int C_Charge_ID, Timestamp billDate, Timestamp shipDate, int AD_Org_ID, int M_Warehouse_ID, int billC_BPartner_Location_ID, int shipC_BPartner_Location_ID, boolean IsSOTrx) {
        return Tax.get(ctx, M_Product_ID, C_Charge_ID, billDate, shipDate, AD_Org_ID, M_Warehouse_ID, billC_BPartner_Location_ID, shipC_BPartner_Location_ID, -1, IsSOTrx, null);
    }

    public static int get(Properties ctx, int M_Product_ID, int C_Charge_ID, Timestamp billDate, Timestamp shipDate, int AD_Org_ID, int M_Warehouse_ID, int billC_BPartner_Location_ID, int shipC_BPartner_Location_ID, int dropshipC_BPartner_Location_ID, boolean IsSOTrx, String trxName) {
        return Tax.get(ctx, M_Product_ID, C_Charge_ID, billDate, shipDate, AD_Org_ID, M_Warehouse_ID, billC_BPartner_Location_ID, shipC_BPartner_Location_ID, dropshipC_BPartner_Location_ID, IsSOTrx, null, trxName);
    }

    public static int get(Properties ctx, int M_Product_ID, int C_Charge_ID, Timestamp billDate, Timestamp shipDate, int AD_Org_ID, int M_Warehouse_ID, int billC_BPartner_Location_ID, int shipC_BPartner_Location_ID, boolean IsSOTrx, String deliveryViaRule, String trxName) {
        return Tax.get(ctx, M_Product_ID, C_Charge_ID, billDate, shipDate, AD_Org_ID, M_Warehouse_ID, billC_BPartner_Location_ID, shipC_BPartner_Location_ID, -1, IsSOTrx, deliveryViaRule, trxName);
    }

    public static int get(Properties ctx, int M_Product_ID, int C_Charge_ID, Timestamp billDate, Timestamp shipDate, int AD_Org_ID, int M_Warehouse_ID, int billC_BPartner_Location_ID, int shipC_BPartner_Location_ID, int dropshipC_BPartner_Location_ID, boolean IsSOTrx, String deliveryViaRule, String trxName) {
        if (M_Product_ID != 0) {
            return Tax.getProduct(ctx, M_Product_ID, billDate, shipDate, AD_Org_ID, M_Warehouse_ID, billC_BPartner_Location_ID, shipC_BPartner_Location_ID, dropshipC_BPartner_Location_ID, IsSOTrx, deliveryViaRule, trxName);
        }
        if (C_Charge_ID != 0) {
            return Tax.getCharge(ctx, C_Charge_ID, billDate, shipDate, AD_Org_ID, M_Warehouse_ID, billC_BPartner_Location_ID, shipC_BPartner_Location_ID, dropshipC_BPartner_Location_ID, IsSOTrx, deliveryViaRule, trxName);
        }
        return Tax.getExemptTax(ctx, AD_Org_ID, trxName);
    }

    @Deprecated
    public static int getCharge(Properties ctx, int C_Charge_ID, Timestamp billDate, Timestamp shipDate, int AD_Org_ID, int M_Warehouse_ID, int billC_BPartner_Location_ID, int shipC_BPartner_Location_ID, boolean IsSOTrx) {
        return Tax.getCharge(ctx, C_Charge_ID, billDate, shipDate, AD_Org_ID, M_Warehouse_ID, billC_BPartner_Location_ID, shipC_BPartner_Location_ID, IsSOTrx, null);
    }

    public static int getCharge(Properties ctx, int C_Charge_ID, Timestamp billDate, Timestamp shipDate, int AD_Org_ID, int M_Warehouse_ID, int billC_BPartner_Location_ID, int shipC_BPartner_Location_ID, boolean IsSOTrx, String trxName) {
        return Tax.getCharge(ctx, C_Charge_ID, billDate, shipDate, AD_Org_ID, M_Warehouse_ID, billC_BPartner_Location_ID, shipC_BPartner_Location_ID, -1, IsSOTrx, null, trxName);
    }

    public static int getCharge(Properties ctx, int C_Charge_ID, Timestamp billDate, Timestamp shipDate, int AD_Org_ID, int M_Warehouse_ID, int billC_BPartner_Location_ID, int shipC_BPartner_Location_ID, int dropshipC_BPartner_Location_ID, boolean IsSOTrx, String deliveryViaRule, String trxName) {
        ResultSet rs;
        CPreparedStatement pstmt;
        int warehouseC_Location_ID;
        int billToC_Location_ID;
        int billFromC_Location_ID;
        int dropshipC_Location_ID;
        int shipToC_Location_ID;
        int shipFromC_Location_ID;
        int C_TaxCategory_ID;
        block10: {
            int n;
            C_TaxCategory_ID = 0;
            shipFromC_Location_ID = 0;
            shipToC_Location_ID = 0;
            dropshipC_Location_ID = 0;
            billFromC_Location_ID = 0;
            billToC_Location_ID = 0;
            warehouseC_Location_ID = 0;
            String IsTaxExempt = null;
            String IsSOTaxExempt = null;
            String IsPOTaxExempt = null;
            String sql = "SELECT c.C_TaxCategory_ID, o.C_Location_ID, il.C_Location_ID, b.IsTaxExempt, b.IsPOTaxExempt, w.C_Location_ID, sl.C_Location_ID, dsl.C_Location_ID FROM C_Charge c JOIN AD_OrgInfo o ON (o.AD_Org_ID=?) JOIN C_BPartner_Location il ON (il.C_BPartner_Location_ID=?) INNER JOIN C_BPartner b ON (il.C_BPartner_ID=b.C_BPartner_ID)  LEFT OUTER JOIN M_Warehouse w ON (w.M_Warehouse_ID=?) JOIN C_BPartner_Location sl ON (sl.C_BPartner_Location_ID=?) LEFT JOIN C_BPartner_Location dsl ON (dsl.C_BPartner_Location_ID=?)WHERE c.C_Charge_ID=?";
            pstmt = null;
            rs = null;
            try {
                pstmt = DB.prepareStatement(sql, trxName);
                pstmt.setInt(1, AD_Org_ID);
                pstmt.setInt(2, billC_BPartner_Location_ID);
                pstmt.setInt(3, M_Warehouse_ID);
                pstmt.setInt(4, shipC_BPartner_Location_ID);
                pstmt.setInt(5, dropshipC_BPartner_Location_ID);
                pstmt.setInt(6, C_Charge_ID);
                rs = pstmt.executeQuery();
                boolean found = false;
                if (rs.next()) {
                    C_TaxCategory_ID = rs.getInt(1);
                    billFromC_Location_ID = rs.getInt(2);
                    billToC_Location_ID = rs.getInt(3);
                    IsSOTaxExempt = rs.getString(4);
                    IsPOTaxExempt = rs.getString(5);
                    IsTaxExempt = IsSOTrx ? IsSOTaxExempt : IsPOTaxExempt;
                    shipFromC_Location_ID = rs.getInt(6);
                    shipToC_Location_ID = rs.getInt(7);
                    dropshipC_Location_ID = rs.getInt(8);
                    warehouseC_Location_ID = rs.getInt(6);
                    found = true;
                }
                DB.close(rs, pstmt);
                if (!found) {
                    throw new TaxForChangeNotFoundException(C_Charge_ID, AD_Org_ID, M_Warehouse_ID, billC_BPartner_Location_ID, shipC_BPartner_Location_ID, null);
                }
                if (!"Y".equals(IsTaxExempt)) break block10;
                n = Tax.getExemptTax(ctx, AD_Org_ID, trxName);
            }
            catch (SQLException e) {
                try {
                    throw new DBException(e, sql);
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            return n;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (!IsSOTrx) {
            int temp = billFromC_Location_ID;
            billFromC_Location_ID = billToC_Location_ID;
            billToC_Location_ID = temp;
            temp = shipFromC_Location_ID;
            shipFromC_Location_ID = shipToC_Location_ID;
            shipToC_Location_ID = temp;
        } else if ("P".equals(deliveryViaRule)) {
            billToC_Location_ID = warehouseC_Location_ID;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("getCharge - C_TaxCategory_ID=" + C_TaxCategory_ID + ", billFromC_Location_ID=" + billFromC_Location_ID + ", billToC_Location_ID=" + billToC_Location_ID + ", shipFromC_Location_ID=" + shipFromC_Location_ID + ", shipToC_Location_ID=" + shipToC_Location_ID + ", dropshipC_Location_ID=" + dropshipC_Location_ID);
        }
        return Core.getTaxLookup().get(ctx, C_TaxCategory_ID, IsSOTrx, shipDate, shipFromC_Location_ID, shipToC_Location_ID, dropshipC_Location_ID, billDate, billFromC_Location_ID, billToC_Location_ID, trxName);
    }

    @Deprecated
    public static int getProduct(Properties ctx, int M_Product_ID, Timestamp billDate, Timestamp shipDate, int AD_Org_ID, int M_Warehouse_ID, int billC_BPartner_Location_ID, int shipC_BPartner_Location_ID, boolean IsSOTrx) {
        return Tax.getProduct(ctx, M_Product_ID, billDate, shipDate, AD_Org_ID, M_Warehouse_ID, billC_BPartner_Location_ID, shipC_BPartner_Location_ID, IsSOTrx, null);
    }

    public static int getProduct(Properties ctx, int M_Product_ID, Timestamp billDate, Timestamp shipDate, int AD_Org_ID, int M_Warehouse_ID, int billC_BPartner_Location_ID, int shipC_BPartner_Location_ID, boolean IsSOTrx, String trxName) {
        return Tax.getProduct(ctx, M_Product_ID, billDate, shipDate, AD_Org_ID, M_Warehouse_ID, billC_BPartner_Location_ID, shipC_BPartner_Location_ID, -1, IsSOTrx, null, trxName);
    }

    public static int getProduct(Properties ctx, int M_Product_ID, Timestamp billDate, Timestamp shipDate, int AD_Org_ID, int M_Warehouse_ID, int billC_BPartner_Location_ID, int shipC_BPartner_Location_ID, int dropshipC_BPartner_Location_ID, boolean IsSOTrx, String deliveryViaRule, String trxName) {
        boolean found;
        ResultSet rs;
        CPreparedStatement pstmt;
        String sql;
        int billToC_Location_ID;
        int billFromC_Location_ID;
        int shipToC_Location_ID;
        int shipFromC_Location_ID;
        int C_TaxCategory_ID;
        String variable;
        block27: {
            String IsPOTaxExempt;
            String IsSOTaxExempt;
            String IsTaxExempt;
            block26: {
                int dropshipC_Location_ID;
                int warehouseC_Location_ID;
                block25: {
                    variable = "";
                    C_TaxCategory_ID = 0;
                    shipFromC_Location_ID = 0;
                    shipToC_Location_ID = 0;
                    billFromC_Location_ID = 0;
                    billToC_Location_ID = 0;
                    warehouseC_Location_ID = 0;
                    dropshipC_Location_ID = 0;
                    IsTaxExempt = null;
                    IsSOTaxExempt = null;
                    IsPOTaxExempt = null;
                    sql = null;
                    pstmt = null;
                    rs = null;
                    sql = "SELECT p.C_TaxCategory_ID, o.C_Location_ID, il.C_Location_ID, b.IsTaxExempt, b.IsPOTaxExempt,  w.C_Location_ID, sl.C_Location_ID, dsl.C_Location_ID FROM M_Product p JOIN AD_OrgInfo o ON (o.AD_Org_ID=?) JOIN C_BPartner_Location il ON (il.C_BPartner_Location_ID=?) INNER JOIN C_BPartner b ON (il.C_BPartner_ID=b.C_BPartner_ID) LEFT OUTER JOIN M_Warehouse w ON (w.M_Warehouse_ID=?) JOIN C_BPartner_Location sl ON (sl.C_BPartner_Location_ID=?) LEFT JOIN C_BPartner_Location dsl ON (dsl.C_BPartner_Location_ID=?) WHERE p.M_Product_ID=?";
                    pstmt = DB.prepareStatement(sql, trxName);
                    pstmt.setInt(1, AD_Org_ID);
                    pstmt.setInt(2, billC_BPartner_Location_ID);
                    pstmt.setInt(3, M_Warehouse_ID);
                    pstmt.setInt(4, shipC_BPartner_Location_ID);
                    pstmt.setInt(5, dropshipC_BPartner_Location_ID);
                    pstmt.setInt(6, M_Product_ID);
                    rs = pstmt.executeQuery();
                    found = false;
                    if (rs.next()) {
                        C_TaxCategory_ID = rs.getInt(1);
                        billFromC_Location_ID = rs.getInt(2);
                        billToC_Location_ID = rs.getInt(3);
                        IsSOTaxExempt = rs.getString(4);
                        IsPOTaxExempt = rs.getString(5);
                        IsTaxExempt = IsSOTrx ? IsSOTaxExempt : IsPOTaxExempt;
                        shipFromC_Location_ID = rs.getInt(6);
                        shipToC_Location_ID = rs.getInt(7);
                        dropshipC_Location_ID = rs.getInt(8);
                        warehouseC_Location_ID = rs.getInt(6);
                        found = true;
                    }
                    DB.close(rs, pstmt);
                    if (!found || !"Y".equals(IsTaxExempt)) break block25;
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("getProduct - Business Partner is Tax exempt");
                    }
                    int n = Tax.getExemptTax(ctx, AD_Org_ID, trxName);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    return n;
                }
                if (!found) break block26;
                if (!IsSOTrx) {
                    int temp = billFromC_Location_ID;
                    billFromC_Location_ID = billToC_Location_ID;
                    billToC_Location_ID = temp;
                    temp = shipFromC_Location_ID;
                    shipFromC_Location_ID = shipToC_Location_ID;
                    shipToC_Location_ID = temp;
                } else if ("P".equals(deliveryViaRule)) {
                    billToC_Location_ID = warehouseC_Location_ID;
                }
                if (log.isLoggable(Level.FINE)) {
                    log.fine("getProduct - C_TaxCategory_ID=" + C_TaxCategory_ID + ", billFromC_Location_ID=" + billFromC_Location_ID + ", billToC_Location_ID=" + billToC_Location_ID + ", shipFromC_Location_ID=" + shipFromC_Location_ID + ", shipToC_Location_ID=" + shipToC_Location_ID + ", dropshipC_Location_ID=" + dropshipC_Location_ID);
                }
                int n = Core.getTaxLookup().get(ctx, C_TaxCategory_ID, IsSOTrx, shipDate, shipFromC_Location_ID, shipToC_Location_ID, dropshipC_Location_ID, billDate, billFromC_Location_ID, billToC_Location_ID, trxName);
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                return n;
            }
            variable = "M_Product_ID";
            sql = "SELECT C_TaxCategory_ID FROM M_Product WHERE M_Product_ID=?";
            C_TaxCategory_ID = DB.getSQLValueEx(trxName, sql, M_Product_ID);
            boolean bl = found = C_TaxCategory_ID != -1;
            if (C_TaxCategory_ID <= 0) {
                throw new TaxCriteriaNotFoundException(variable, M_Product_ID);
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("getProduct - C_TaxCategory_ID=" + C_TaxCategory_ID);
            }
            variable = "AD_Org_ID";
            sql = "SELECT C_Location_ID FROM AD_OrgInfo WHERE AD_Org_ID=?";
            billFromC_Location_ID = DB.getSQLValueEx(trxName, sql, AD_Org_ID);
            boolean bl2 = found = billFromC_Location_ID != -1;
            if (billFromC_Location_ID <= 0) {
                throw new TaxCriteriaNotFoundException(variable, AD_Org_ID);
            }
            variable = "BillTo_ID";
            sql = "SELECT l.C_Location_ID, b.IsTaxExempt, b.IsPOTaxExempt  FROM C_BPartner_Location l INNER JOIN C_BPartner b ON (l.C_BPartner_ID=b.C_BPartner_ID)  WHERE C_BPartner_Location_ID=?";
            pstmt = DB.prepareStatement(sql, trxName);
            pstmt.setInt(1, billC_BPartner_Location_ID);
            rs = pstmt.executeQuery();
            found = false;
            if (rs.next()) {
                billToC_Location_ID = rs.getInt(1);
                IsSOTaxExempt = rs.getString(2);
                IsPOTaxExempt = rs.getString(3);
                IsTaxExempt = IsSOTrx ? IsSOTaxExempt : IsPOTaxExempt;
                found = true;
            }
            DB.close(rs, pstmt);
            if (billToC_Location_ID <= 0) {
                throw new TaxCriteriaNotFoundException(variable, billC_BPartner_Location_ID);
            }
            if (!"Y".equals(IsTaxExempt)) break block27;
            int n = Tax.getExemptTax(ctx, AD_Org_ID, trxName);
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            return n;
        }
        try {
            try {
                int temp;
                if (!IsSOTrx) {
                    temp = billFromC_Location_ID;
                    billFromC_Location_ID = billToC_Location_ID;
                    billToC_Location_ID = temp;
                }
                if (log.isLoggable(Level.FINE)) {
                    log.fine("getProduct - billFromC_Location_ID = " + billFromC_Location_ID);
                    log.fine("getProduct - billToC_Location_ID = " + billToC_Location_ID);
                }
                variable = "M_Warehouse_ID";
                sql = "SELECT C_Location_ID FROM M_Warehouse WHERE M_Warehouse_ID=?";
                shipFromC_Location_ID = DB.getSQLValueEx(trxName, sql, M_Warehouse_ID);
                boolean bl = found = shipFromC_Location_ID != -1;
                if (shipFromC_Location_ID <= 0) {
                    throw new TaxCriteriaNotFoundException(variable, M_Warehouse_ID);
                }
                variable = "C_BPartner_Location_ID";
                sql = "SELECT C_Location_ID FROM C_BPartner_Location WHERE C_BPartner_Location_ID=?";
                shipToC_Location_ID = DB.getSQLValueEx(trxName, sql, shipC_BPartner_Location_ID);
                boolean bl3 = found = shipToC_Location_ID != -1;
                if (shipToC_Location_ID <= 0) {
                    throw new TaxCriteriaNotFoundException(variable, shipC_BPartner_Location_ID);
                }
                if (!IsSOTrx) {
                    temp = shipFromC_Location_ID;
                    shipFromC_Location_ID = shipToC_Location_ID;
                    shipToC_Location_ID = temp;
                }
                if (log.isLoggable(Level.FINE)) {
                    log.fine("getProduct - shipFromC_Location_ID = " + shipFromC_Location_ID);
                }
                if (log.isLoggable(Level.FINE)) {
                    log.fine("getProduct - shipToC_Location_ID = " + shipToC_Location_ID);
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sql);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return Tax.get(ctx, C_TaxCategory_ID, IsSOTrx, shipDate, shipFromC_Location_ID, shipToC_Location_ID, billDate, billFromC_Location_ID, billToC_Location_ID, trxName);
    }

    public static int getExemptTax(Properties ctx, int AD_Org_ID, String trxName) {
        int C_Tax_ID = DB.getSQLValueEx(trxName, "SELECT t.C_Tax_ID FROM C_Tax t INNER JOIN AD_Org o ON (t.AD_Client_ID=o.AD_Client_ID) WHERE t.IsTaxExempt='Y' AND o.AD_Org_ID=? AND t.IsActive='Y' ORDER BY t.Rate DESC", AD_Org_ID);
        if (log.isLoggable(Level.FINE)) {
            log.fine("getExemptTax - TaxExempt=Y - C_Tax_ID=" + C_Tax_ID);
        }
        if (C_Tax_ID <= 0) {
            throw new TaxNoExemptFoundException(AD_Org_ID);
        }
        return C_Tax_ID;
    }

    public static int get(Properties ctx, int C_TaxCategory_ID, boolean IsSOTrx, Timestamp shipDate, int shipFromC_Location_ID, int shipToC_Location_ID, Timestamp billDate, int billFromC_Location_ID, int billToC_Location_ID, String trxName) {
        return Tax.get(ctx, C_TaxCategory_ID, IsSOTrx, shipDate, shipFromC_Location_ID, shipToC_Location_ID, -1, billDate, billFromC_Location_ID, billToC_Location_ID, trxName);
    }

    public static int get(Properties ctx, int C_TaxCategory_ID, boolean IsSOTrx, Timestamp shipDate, int shipFromC_Location_ID, int shipToC_Location_ID, int dropshipC_Location_ID, Timestamp billDate, int billFromC_Location_ID, int billToC_Location_ID, String trxName) {
        MTax tax;
        if (CLogMgt.isLevelFine()) {
            if (log.isLoggable(Level.INFO)) {
                log.info("get(Detail) - Category=" + C_TaxCategory_ID + ", SOTrx=" + IsSOTrx);
            }
            if (log.isLoggable(Level.CONFIG)) {
                log.config("get(Detail) - BillFrom=" + billFromC_Location_ID + ", BillTo=" + billToC_Location_ID + ", BillDate=" + String.valueOf(billDate));
            }
        }
        MTax[] taxes = MTax.getAll(ctx);
        MLocation lFrom = new MLocation(ctx, billFromC_Location_ID, trxName);
        MLocation lTo = new MLocation(ctx, billToC_Location_ID, trxName);
        if (log.isLoggable(Level.FINER)) {
            log.finer("From=" + String.valueOf(lFrom));
            log.finer("To=" + String.valueOf(lTo));
        }
        int i2 = 0;
        while (i2 < taxes.length) {
            tax = taxes[i2];
            if (log.isLoggable(Level.FINEST)) {
                log.finest(tax.toString());
            }
            if (!(tax.getC_TaxCategory_ID() != C_TaxCategory_ID || !tax.isActive() || tax.getParent_Tax_ID() != 0 || IsSOTrx && "P".equals(tax.getSOPOType()) || !IsSOTrx && "S".equals(tax.getSOPOType()))) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("From Country Group - " + (MCountryGroup.countryGroupContains(tax.getC_CountryGroupFrom_ID(), lFrom.getC_Country_ID()) || tax.getC_CountryGroupFrom_ID() == 0));
                }
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("From Country - " + (tax.getC_Country_ID() == lFrom.getC_Country_ID() || tax.getC_Country_ID() == 0));
                }
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("From Region - " + (tax.getC_Region_ID() == lFrom.getC_Region_ID() || tax.getC_Region_ID() == 0));
                }
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("To Country Group - " + (MCountryGroup.countryGroupContains(tax.getC_CountryGroupTo_ID(), lTo.getC_Country_ID()) || tax.getC_CountryGroupTo_ID() == 0));
                }
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("To Country - " + (tax.getTo_Country_ID() == lTo.getC_Country_ID() || tax.getTo_Country_ID() == 0));
                }
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("To Region - " + (tax.getTo_Region_ID() == lTo.getC_Region_ID() || tax.getTo_Region_ID() == 0));
                }
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Date valid - " + !tax.getValidFrom().after(billDate));
                }
                if (!(tax.getC_CountryGroupFrom_ID() != 0 && !MCountryGroup.countryGroupContains(tax.getC_CountryGroupFrom_ID(), lFrom.getC_Country_ID()) || tax.getC_Country_ID() != lFrom.getC_Country_ID() && tax.getC_Country_ID() != 0 || tax.getC_Region_ID() != lFrom.getC_Region_ID() && tax.getC_Region_ID() != 0 || tax.getC_CountryGroupTo_ID() != 0 && !MCountryGroup.countryGroupContains(tax.getC_CountryGroupTo_ID(), lTo.getC_Country_ID()) || tax.getTo_Country_ID() != lTo.getC_Country_ID() && tax.getTo_Country_ID() != 0 || tax.getTo_Region_ID() != lTo.getC_Region_ID() && tax.getTo_Region_ID() != 0 || tax.getValidFrom().after(billDate))) {
                    if (!tax.isPostal()) {
                        return tax.getC_Tax_ID();
                    }
                    MTaxPostal[] postals = tax.getPostals(false);
                    int j = 0;
                    while (j < postals.length) {
                        MTaxPostal postal = postals[j];
                        if (postal.isActive() && postal.getPostal().startsWith(lFrom.getPostal()) && (postal.getPostal_To() == null || postal.getPostal_To().startsWith(lTo.getPostal()))) {
                            return tax.getC_Tax_ID();
                        }
                        ++j;
                    }
                }
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < taxes.length) {
            tax = taxes[i2];
            if (!(!tax.isDefault() || !tax.isActive() || tax.getParent_Tax_ID() != 0 || IsSOTrx && "P".equals(tax.getSOPOType()) || !IsSOTrx && "S".equals(tax.getSOPOType()))) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("get (default) - " + String.valueOf(tax));
                }
                return tax.getC_Tax_ID();
            }
            ++i2;
        }
        throw new TaxNotFoundException(C_TaxCategory_ID, IsSOTrx, shipDate, shipFromC_Location_ID, shipToC_Location_ID, billDate, billFromC_Location_ID, billToC_Location_ID);
    }
}

