/*
 * Decompiled with CFR 0.152.
 */
package org.compiere;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.logging.Level;
import javax.swing.ImageIcon;
import javax.swing.event.EventListenerList;
import org.adempiere.base.Core;
import org.compiere.db.CConnection;
import org.compiere.model.MClient;
import org.compiere.model.MSysConfig;
import org.compiere.model.MSystem;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ServerStateChangeEvent;
import org.compiere.model.ServerStateChangeListener;
import org.compiere.model.SystemProperties;
import org.compiere.util.CLogFile;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Login;
import org.compiere.util.SecureEngine;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public final class Adempiere {
    @Deprecated
    public static final String ID = "$Id: Adempiere.java,v 1.8 2006/08/11 02:58:14 jjanke Exp $";
    public static String MAIN_VERSION = "Release 13";
    public static String DATE_VERSION = "2024-12-24";
    public static String DB_VERSION = "2024-12-24";
    public static final String NAME = "iDempiere\u00ae";
    public static final String URL = "www.idempiere.org";
    private static final String s_File16x16 = "images/iD16.gif";
    private static final String s_file32x32 = "images/iD32.gif";
    private static final String s_file100x30 = "images/iD10030.png";
    private static final String s_file48x15 = "images/iDempiere.png";
    private static final String s_file48x15HR = "images/iDempiereHR.png";
    private static final String s_fileHeaderLogo = "images/header-logo.png";
    private static String s_supportEmail = "";
    public static final String SUB_TITLE = "Smart Suite ERP, CRM and SCM";
    public static final String ADEMPIERE_R = "iDempiere\u00ae";
    public static final String COPYRIGHT = "\u00a9 1999-2025 iDempiere\u00ae";
    private static String s_ImplementationVersion = null;
    private static String s_ImplementationVendor = null;
    private static Image s_image16;
    private static Image s_image48x15;
    private static Image s_imageLogo;
    private static ImageIcon s_imageIcon32;
    private static ImageIcon s_imageIconLogo;
    private static Image s_headerLogo;
    private static final String ONLINE_HELP_URL = "http://wiki.idempiere.org";
    private static CLogger log;
    private static final ScheduledThreadPoolExecutor threadPoolExecutor;
    private static EventListenerList m_listenerList;

    static {
        log = null;
        threadPoolExecutor = Adempiere.createThreadPool();
        Trx.startTrxMonitor();
        m_listenerList = new EventListenerList();
        ClassLoader loader = Adempiere.class.getClassLoader();
        InputStream inputStream = loader.getResourceAsStream("org/adempiere/version.properties");
        if (inputStream != null) {
            Properties properties = new Properties();
            try {
                properties.load(inputStream);
                if (properties.containsKey("MAIN_VERSION")) {
                    MAIN_VERSION = properties.getProperty("MAIN_VERSION");
                }
                if (properties.containsKey("DATE_VERSION")) {
                    DATE_VERSION = properties.getProperty("DATE_VERSION");
                }
                if (properties.containsKey("DB_VERSION")) {
                    DB_VERSION = properties.getProperty("DB_VERSION");
                }
                if (properties.containsKey("IMPLEMENTATION_VERSION")) {
                    s_ImplementationVersion = properties.getProperty("IMPLEMENTATION_VERSION");
                }
                if (properties.containsKey("IMPLEMENTATION_VENDOR")) {
                    s_ImplementationVendor = properties.getProperty("IMPLEMENTATION_VENDOR");
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static String getName() {
        return "iDempiere\u00ae";
    }

    public static String getVersion() {
        String version = MSysConfig.getValue("APPLICATION_MAIN_VERSION", null);
        if (version != null) {
            return version;
        }
        IProduct product = Platform.getProduct();
        if (product != null) {
            Bundle bundle = product.getDefiningBundle();
            if (bundle != null) {
                return bundle.getVersion().toString();
            }
        } else {
            Bundle bundle = Platform.getBundle((String)"org.adempiere.base");
            if (bundle != null) {
                return bundle.getVersion().toString();
            }
        }
        return "Unknown";
    }

    public static boolean isVersionShown() {
        return MSysConfig.getBooleanValue("APPLICATION_MAIN_VERSION_SHOWN", true);
    }

    public static boolean isDBVersionShown() {
        boolean defaultVal = !MSystem.get(Env.getCtx()).getSystemStatus().equalsIgnoreCase("P");
        return MSysConfig.getBooleanValue("APPLICATION_DATABASE_VERSION_SHOWN", defaultVal);
    }

    public static boolean isVendorShown() {
        return MSysConfig.getBooleanValue("APPLICATION_IMPLEMENTATION_VENDOR_SHOWN", true);
    }

    public static boolean isJVMShown() {
        boolean defaultVal = !MSystem.get(Env.getCtx()).getSystemStatus().equalsIgnoreCase("P");
        return MSysConfig.getBooleanValue("APPLICATION_JVM_VERSION_SHOWN", defaultVal);
    }

    public static boolean isOSShown() {
        boolean defaultVal = !MSystem.get(Env.getCtx()).getSystemStatus().equalsIgnoreCase("P");
        return MSysConfig.getBooleanValue("APPLICATION_OS_INFO_SHOWN", defaultVal);
    }

    public static boolean isHostShown() {
        boolean defaultVal = !MSystem.get(Env.getCtx()).getSystemStatus().equalsIgnoreCase("P");
        return MSysConfig.getBooleanValue("APPLICATION_HOST_SHOWN", defaultVal);
    }

    public static String getDatabaseVersion() {
        return MSysConfig.getValue("APPLICATION_DATABASE_VERSION", DB.getSQLValueString(null, "select lastmigrationscriptapplied from ad_system", new Object[0]));
    }

    public static String getSum() {
        StringBuilder sb = new StringBuilder();
        sb.append("iDempiere\u00ae").append(" ").append(MAIN_VERSION).append(SUB_TITLE);
        return sb.toString();
    }

    public static String getSummary() {
        StringBuilder sb = new StringBuilder();
        sb.append("iDempiere\u00ae").append(" ").append(MAIN_VERSION).append("_").append(DATE_VERSION).append(" -").append(SUB_TITLE).append("- ").append(COPYRIGHT).append("; Implementation: ").append(Adempiere.getImplementationVersion()).append(" - ").append(Adempiere.getImplementationVendor());
        return sb.toString();
    }

    private static void setPackageInfo() {
        if (s_ImplementationVendor != null) {
            return;
        }
        Package adempierePackage = Adempiere.class.getClassLoader().getDefinedPackage("org.compiere");
        s_ImplementationVendor = adempierePackage.getImplementationVendor();
        s_ImplementationVersion = adempierePackage.getImplementationVersion();
        if (s_ImplementationVendor == null) {
            s_ImplementationVendor = "Supported by iDempiere community";
            s_ImplementationVersion = "iDempiere";
        }
    }

    public static String getImplementationVersion() {
        if (s_ImplementationVersion == null) {
            Adempiere.setPackageInfo();
        }
        return s_ImplementationVersion;
    }

    public static String getImplementationVendor() {
        String vendor;
        if (DB.isConnected() && (vendor = MSysConfig.getValue("APPLICATION_IMPLEMENTATION_VENDOR", null)) != null) {
            return vendor;
        }
        if (s_ImplementationVendor == null) {
            Adempiere.setPackageInfo();
        }
        return s_ImplementationVendor;
    }

    public static int getCheckSum() {
        return Adempiere.getSum().hashCode();
    }

    public static String getSummaryAscii() {
        String retValue = Adempiere.getSummary();
        retValue = Util.replace(retValue, "\u00ae", "(r)");
        retValue = Util.replace(retValue, "\u2122", "(tm)");
        retValue = Util.replace(retValue, "\u00a9", "(c)");
        retValue = Util.replace(retValue, Env.NL, " ");
        retValue = Util.replace(retValue, "\n", " ");
        return retValue;
    }

    public static String getJavaInfo() {
        return System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version");
    }

    public static String getOSInfo() {
        return System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("sun.os.patch.level");
    }

    public static String getURL() {
        return "http://www.idempiere.org";
    }

    public static String getOnlineHelpURL() {
        return ONLINE_HELP_URL;
    }

    public static String getSubtitle() {
        return SUB_TITLE;
    }

    public static Image getImage16() {
        if (s_image16 == null) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            URL url = Core.getResourceFinder().getResource(s_File16x16);
            if (url == null) {
                return null;
            }
            s_image16 = tk.getImage(url);
        }
        return s_image16;
    }

    public static Image getImageLogoSmall(boolean hr2) {
        if (s_image48x15 == null) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            URL url = null;
            url = hr2 ? Core.getResourceFinder().getResource(s_file48x15HR) : Core.getResourceFinder().getResource(s_file48x15);
            if (url == null) {
                return null;
            }
            s_image48x15 = tk.getImage(url);
        }
        return s_image48x15;
    }

    public static Image getHeaderLogo() {
        if (s_headerLogo == null) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            URL url = Core.getResourceFinder().getResource(s_fileHeaderLogo);
            if (url != null) {
                s_headerLogo = tk.getImage(url);
            }
        }
        return s_headerLogo;
    }

    public static Image getImageLogo() {
        if (s_imageLogo == null) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            URL url = Core.getResourceFinder().getResource(s_file100x30);
            if (url == null) {
                return null;
            }
            s_imageLogo = tk.getImage(url);
        }
        return s_imageLogo;
    }

    public static ImageIcon getImageIcon32() {
        if (s_imageIcon32 == null) {
            URL url = Core.getResourceFinder().getResource(s_file32x32);
            if (url == null) {
                return null;
            }
            s_imageIcon32 = new ImageIcon(url);
        }
        return s_imageIcon32;
    }

    public static ImageIcon getImageIconLogo() {
        if (s_imageIconLogo == null) {
            URL url = Core.getResourceFinder().getResource(s_file100x30);
            if (url == null) {
                return null;
            }
            s_imageIconLogo = new ImageIcon(url);
        }
        return s_imageIconLogo;
    }

    public static String getAdempiereHome() {
        Object retValue = Ini.getAdempiereHome();
        if (retValue == null) {
            retValue = File.separator + "idempiere";
        }
        return retValue;
    }

    public static String getSupportEMail() {
        return s_supportEmail;
    }

    public static void setSupportEMail(String email) {
        s_supportEmail = email;
    }

    public static synchronized boolean isStarted() {
        return log != null;
    }

    public static synchronized boolean startup(boolean isClient) {
        if (log != null) {
            return true;
        }
        if (isClient && !Login.isJavaOK(isClient)) {
            System.exit(1);
        }
        Ini.setClient(isClient);
        if (!isClient) {
            CLogMgt.initialize(isClient);
        }
        if ((log = CLogger.getCLogger(Adempiere.class)).isLoggable(Level.INFO)) {
            log.info(Adempiere.getSummaryAscii());
        }
        Ini.loadProperties(false);
        CLogMgt.setLevel(Ini.getProperty("TraceLevel"));
        if (isClient && Ini.isPropertyBool("TraceFile")) {
            CLogMgt.addHandler(new CLogFile(Ini.findAdempiereHome(), true, isClient));
        }
        Properties properties = Ini.getProperties();
        for (Object key : properties.keySet()) {
            String s;
            if (!(key instanceof String) || !(s = (String)key).endsWith(".TraceLevel")) continue;
            String level = properties.getProperty(s);
            s = s.substring(0, s.length() - ".TraceLevel".length());
            CLogMgt.setLevel(s, level);
        }
        if (isClient && CLogMgt.isLevelAll()) {
            log.log(Level.FINEST, System.getProperties().toString());
        }
        Adempiere.loadDBProvider();
        DB.setDBTarget(CConnection.get());
        Adempiere.createThreadPool();
        Adempiere.fireServerStateChanged(new ServerStateChangeEvent(new Object(), 0));
        if (isClient) {
            return false;
        }
        return Adempiere.startupEnvironment(isClient);
    }

    private static void loadDBProvider() {
        try {
            Adempiere.class.getClassLoader().loadClass("org.adempiere.db.oracle.config.ConfigOracle");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            Adempiere.class.getClassLoader().loadClass("org.adempiere.db.postgresql.config.ConfigPostgreSQL");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static ScheduledThreadPoolExecutor createThreadPool() {
        int max;
        int defaultMax = max = Runtime.getRuntime().availableProcessors() * 20;
        Properties properties = Ini.getProperties();
        String maxSize = properties.getProperty("MaxThreadPoolSize");
        if (maxSize != null) {
            try {
                max = Integer.parseInt(maxSize);
            }
            catch (Exception exception) {}
        }
        if (max <= 0) {
            max = defaultMax;
        }
        return new ScheduledThreadPoolExecutor(max);
    }

    public static boolean startupEnvironment(boolean isClient) {
        String className;
        Adempiere.startup(isClient);
        if (!DB.isConnected()) {
            log.severe("No Database");
            return false;
        }
        if (!DB.isBuildOK(Env.getCtx())) {
            if (isClient) {
                System.exit(1);
            }
            log = null;
            return false;
        }
        MSystem system = MSystem.get(Env.getCtx());
        if (system == null) {
            return false;
        }
        ModelValidationEngine.get();
        try {
            className = system.getEncryptionKey();
            if (!(className != null && className.length() != 0 || (className = SystemProperties.getAdempiereSecure()) == null || className.length() <= 0 || className.equals("org.compiere.util.Secure"))) {
                SecureEngine.init(className);
                system.setEncryptionKey(className);
                system.saveEx();
            }
            SecureEngine.init(className);
            if (isClient) {
                MClient.get(Env.getCtx(), 0);
            } else {
                MClient.getAll(Env.getCtx());
            }
        }
        catch (Exception e) {
            log.warning("Environment problems: " + e.toString());
        }
        className = null;
        try {
            className = "org.compiere.wf.DocWorkflowManager";
            Class.forName(className);
            className = "org.compiere.print.ArchiveEngine";
            Class.forName(className);
        }
        catch (Exception e) {
            log.warning("Not started: " + className + " - " + e.getMessage());
        }
        if (!isClient) {
            DB.updateMail();
        }
        return true;
    }

    public static URL getResource(String name) {
        return Core.getResourceFinder().getResource(name);
    }

    public static synchronized void stop() {
        threadPoolExecutor.shutdown();
        log = null;
    }

    public static ScheduledThreadPoolExecutor getThreadPoolExecutor() {
        return threadPoolExecutor;
    }

    public static synchronized void removeServerStateChangeListener(ServerStateChangeListener l) {
        m_listenerList.remove(ServerStateChangeListener.class, l);
    }

    public static synchronized void addServerStateChangeListener(ServerStateChangeListener l) {
        m_listenerList.add(ServerStateChangeListener.class, l);
    }

    private static synchronized void fireServerStateChanged(ServerStateChangeEvent e) {
        ServerStateChangeListener[] listeners = (ServerStateChangeListener[])m_listenerList.getListeners(ServerStateChangeListener.class);
        int i2 = 0;
        while (i2 < listeners.length) {
            listeners[i2].stateChange(e);
            ++i2;
        }
    }
}

