/*
 * Decompiled with CFR 0.152.
 */
package com.trekglobal.idempiere.rest.api.v1.resource.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.trekglobal.idempiere.rest.api.json.IDempiereRestException;
import com.trekglobal.idempiere.rest.api.json.IPOSerializer;
import com.trekglobal.idempiere.rest.api.json.TypeConverterUtils;
import com.trekglobal.idempiere.rest.api.json.filter.ConvertedQuery;
import com.trekglobal.idempiere.rest.api.json.filter.IQueryConverter;
import com.trekglobal.idempiere.rest.api.util.ErrorBuilder;
import com.trekglobal.idempiere.rest.api.v1.resource.TaskResource;
import java.util.List;
import java.util.logging.Level;
import javax.ws.rs.core.Response;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.model.MTask;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class TaskResourceImpl
implements TaskResource {
    private static final CLogger log = CLogger.getCLogger(TaskResourceImpl.class);

    @Override
    public Response getTasks(String filter) {
        IQueryConverter converter = IQueryConverter.getQueryConverter("DEFAULT");
        try {
            ConvertedQuery convertedStatement = converter.convertStatement("AD_Task", filter);
            if (log.isLoggable(Level.INFO)) {
                log.info("Where Clause: " + convertedStatement.getWhereClause());
            }
            JsonArray taskArray = new JsonArray();
            Query query = new Query(Env.getCtx(), "AD_Task", convertedStatement.getWhereClause(), null);
            query.setApplyAccessFilter(true).setOnlyActiveRecords(true).setOrderBy("Name");
            query.setParameters(convertedStatement.getParameters());
            List tasks = query.list();
            MRole role = MRole.getDefault();
            IPOSerializer serializer = IPOSerializer.getPOSerializer("AD_Task", MTable.getClass((String)"AD_Task"));
            for (MTask task : tasks) {
                if (role.getTaskAccess(task.getAD_Task_ID()) == null) continue;
                JsonObject jsonObject = serializer.toJson((PO)task, new String[]{"AD_Task_ID", "AD_Task_UU", "Name", "Description", "Help", "EntityType"}, null);
                jsonObject.addProperty("slug", TypeConverterUtils.slugify(task.getName()));
                taskArray.add((JsonElement)jsonObject);
            }
            JsonObject json = new JsonObject();
            json.add("tasks", (JsonElement)taskArray);
            return Response.ok((Object)json.toString()).build();
        }
        catch (Exception ex) {
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            if (ex instanceof IDempiereRestException) {
                status = ((IDempiereRestException)((Object)ex)).getErrorResponseStatus();
            }
            log.log(Level.SEVERE, ex.getMessage(), (Throwable)ex);
            return Response.status((Response.Status)status).entity((Object)new ErrorBuilder().status(status).title("GET Error").append("Get task with exception: ").append(ex.getMessage()).build().toString()).build();
        }
    }

    @Override
    public Response getTask(String taskSlug) {
        Query query = new Query(Env.getCtx(), "AD_Task", "Slugify(Name)=?", null);
        query.setApplyAccessFilter(true).setOnlyActiveRecords(true);
        MTask task = (MTask)query.setParameters(new Object[]{taskSlug}).first();
        if (task == null) {
            query.setApplyAccessFilter(false);
            task = (MTask)query.setParameters(new Object[]{taskSlug}).first();
            if (task != null) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)new ErrorBuilder().status(Response.Status.FORBIDDEN).title("Access denied").append("Access denied for task: ").append(taskSlug).build().toString()).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorBuilder().status(Response.Status.NOT_FOUND).title("Invalid task name").append("No match found for task name: ").append(taskSlug).build().toString()).build();
        }
        MRole role = MRole.getDefault();
        if (role.getTaskAccess(task.getAD_Task_ID()) == null) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)new ErrorBuilder().status(Response.Status.FORBIDDEN).title("Access denied").append("Access denied for task: ").append(taskSlug).build().toString()).build();
        }
        IPOSerializer serializer = IPOSerializer.getPOSerializer("AD_Task", MTable.getClass((String)"AD_Task"));
        JsonObject jsonObject = serializer.toJson((PO)task, new String[]{"AD_Task_ID", "AD_Task_UU", "Name", "Description", "Help", "EntityType"}, null);
        jsonObject.addProperty("slug", TypeConverterUtils.slugify(task.getName()));
        return Response.ok((Object)jsonObject.toString()).build();
    }

    @Override
    public Response runTask(String taskSlug, String jsonText) {
        Query query = new Query(Env.getCtx(), "AD_Task", "Slugify(Name)=?", null);
        query.setApplyAccessFilter(true).setOnlyActiveRecords(true);
        MTask task = (MTask)query.setParameters(new Object[]{taskSlug}).first();
        if (task == null) {
            query.setApplyAccessFilter(false);
            task = (MTask)query.setParameters(new Object[]{taskSlug}).first();
            if (task != null) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)new ErrorBuilder().status(Response.Status.FORBIDDEN).title("Access denied").append("Access denied for task: ").append(taskSlug).build().toString()).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorBuilder().status(Response.Status.NOT_FOUND).title("Invalid task name").append("No match found for task name: ").append(taskSlug).build().toString()).build();
        }
        MRole role = MRole.getDefault();
        if (role.getTaskAccess(task.getAD_Task_ID()) == null || !role.getTaskAccess(task.getAD_Task_ID()).booleanValue()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)new ErrorBuilder().status(Response.Status.FORBIDDEN).title("Access denied").append("Access denied for task: ").append(taskSlug).build().toString()).build();
        }
        task.execute();
        String stdOut = task.getExecutedTask().getOut().toString();
        String stdErr = task.getExecutedTask().getErr().toString();
        Integer exitValue = task.getExecutedTask().getExitValue();
        JsonObject json = new JsonObject();
        json.addProperty("exitValue", (Number)exitValue);
        json.addProperty("stdOut", stdOut);
        json.addProperty("stdErr", stdErr);
        return Response.ok((Object)json.toString()).build();
    }
}

